/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.util.CommonUtils;
import org.apache.commons.lang.StringUtils;

public class CheckPlanBatchModifyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MODIFY_FIELDS = "modifyfields";
    private static final String CLEAR_FIELDS = "clearfields";
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};
    private static final String[] CKDATE = new String[]{"ckone", "cktwo", "ckthree", "ckfour", "ckfive", "cksix", "ckseven", "ckeight", "cknine", "ckten", "ckeleven", "cktwelve", "ckthirteen", "ckfourteen", "ckfifteen", "cksixteen", "ckseventeen", "ckeighteen", "cknineteen", "cktwenty", "cktwentyone", "cktwentytwo", "cktwentythree", "cktwentyfour", "cktwentyfive", "cktwentysix", "cktwentyseven", "cktwentyeight", "cktwentynine", "ckthirty", "ckthirtyone"};
    private static final String[] CKDAY = new String[]{"cksun", "ckmon", "cktues", "ckwed", "ckthur", "ckfri", "cksat"};
    private Set<String> modifyComBoFields;
    private Set<String> clearComBoFields;
    private String pageType;
    private Map<String, Object> filedValueMap = new HashMap<String, Object>(16);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addF7Listener(this, "calorg", "costaccount");
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(tabselectevent -> {
            String key = tabselectevent.getTabKey();
            if ("tabdatepage".equals(key)) {
                this.getModel().setValue("combdorw", (Object)"d");
            } else if ("tabweekpage".equals(key)) {
                this.getModel().setValue("combdorw", (Object)"w");
            }
        });
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void initialize() {
        super.initialize();
        this.pageType = (String)this.getView().getFormShowParameter().getCustomParam("pagetype");
        if ("A".equals(this.pageType)) {
            this.modifyComBoFields = this.getComBoFields(MODIFY_FIELDS);
        } else {
            this.clearComBoFields = this.getComBoFields(CLEAR_FIELDS);
        }
    }

    public void afterBindData(EventObject e) {
        if ("A".equals(this.pageType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MODIFY_FIELDS});
            this.setFiledsVisible(MODIFY_FIELDS);
            this.adjustByRepeatMode();
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{CLEAR_FIELDS});
            this.setFiledsVisible(CLEAR_FIELDS);
            this.getView().setEnable(Boolean.FALSE, this.clearComBoFields.toArray(new String[this.clearComBoFields.size()]));
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button && "btnok".equals(((Button)evt.getSource()).getKey())) {
            String errorMsg;
            if ("A".equals(this.pageType)) {
                OperationResult saveResult;
                errorMsg = this.validateModifyFields();
                if (errorMsg == null && (saveResult = this.saveModifyFields()) != null) {
                    this.getView().showOperationResult(saveResult);
                    return;
                }
            } else {
                errorMsg = this.saveClearFields();
            }
            if (errorMsg != null) {
                this.getView().showTipNotification(errorMsg);
                return;
            }
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (MODIFY_FIELDS.equals(name)) {
            this.setFiledsVisible(MODIFY_FIELDS);
        } else if (CLEAR_FIELDS.equals(name)) {
            this.setFiledsVisible(CLEAR_FIELDS);
        } else if ("repeatmode".equals(name)) {
            this.adjustByRepeatMode();
        } else if ((name.startsWith("comnoby") || name.startsWith("comweekby")) && this.getPageCache().get("loadData") == null) {
            this.getModel().setValue("comno", this.getModel().getValue(name.replace("comweek", "comno")));
            this.getModel().setValue("comweek", this.getModel().getValue(name.replace("comno", "comweek")));
            Object commo = this.getModel().getValue("comno");
            Object comweek = this.getModel().getValue("comweek");
            if (name.endsWith("bymonth")) {
                if (commo != null && comweek != null && StringUtils.isNotBlank((String)commo.toString()) && StringUtils.isNotBlank((String)comweek.toString())) {
                    this.getModel().setValue("ckbyweek", (Object)Boolean.TRUE);
                } else {
                    this.getModel().setValue("ckbyweek", (Object)Boolean.FALSE);
                }
            }
        }
        this.setVisibleByMonth(name);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        QFilter q;
        DynamicObjectCollection calOrgs = (DynamicObjectCollection)this.getModel().getValue("calorg");
        if (calOrgs != null && !calOrgs.isEmpty()) {
            HashSet<Long> orgIds = new HashSet<Long>(16);
            for (DynamicObject calOrg : calOrgs) {
                orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", orgIds);
        } else {
            q = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        if (costAccounts != null && !costAccounts.isEmpty()) {
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            for (DynamicObject costAccount : costAccounts) {
                costAccountIds.add(costAccount.getDynamicObject("fbasedataid").getLong("id"));
            }
            DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)"", (String)"cal_bd_costaccount", (String)"id,calorg", (QFilter[])new QFilter("id", "in", costAccountIds).toArray(), null);
            HashSet<Long> orgIds = new HashSet<Long>(16);
            for (Row account : accountDataSet) {
                orgIds.add(account.getLong("calorg"));
            }
            QFilter q = new QFilter("id", "in", orgIds);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void setFiledsVisible(String propertyName) {
        String selectFields = (String)this.getModel().getValue(propertyName);
        HashSet<String> comBoFields = new HashSet<String>(16);
        if (MODIFY_FIELDS.equals(propertyName)) {
            comBoFields.addAll(this.modifyComBoFields);
        } else {
            comBoFields.addAll(this.clearComBoFields);
        }
        this.getView().setVisible(Boolean.FALSE, comBoFields.toArray(new String[comBoFields.size()]));
        HashSet<Object> selectFieldsSet = new HashSet(16);
        if (selectFields != null) {
            selectFieldsSet = new HashSet<String>(Arrays.asList(CommonUtils.trimComma((String)selectFields).split(",")));
            this.getView().setVisible(Boolean.TRUE, selectFieldsSet.toArray(new String[0]));
        }
        if (comBoFields.remove("rangedate")) {
            comBoFields.add("startDate");
            comBoFields.add("endDate");
        }
        for (String field : comBoFields) {
            if (selectFieldsSet.contains(field)) continue;
            if ("repeatmode".equals(field)) {
                this.getModel().setValue(field, (Object)"n");
                continue;
            }
            if ("cyclenum".equals(field)) {
                this.getModel().setValue(field, (Object)1);
                continue;
            }
            this.getModel().setValue(field, null);
        }
    }

    private String validateModifyFields() {
        String selectFields = (String)this.getModel().getValue(MODIFY_FIELDS);
        if (selectFields == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckPlanBatchModifyPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        selectFields = selectFields.replaceAll("rangedate", "startDate,endDate");
        String[] selectFieldsArr = CommonUtils.trimComma((String)selectFields).split(",");
        StringBuilder nullFields = new StringBuilder();
        this.filedValueMap = new HashMap<String, Object>(16);
        for (String field : selectFieldsArr) {
            IDataEntityProperty fieldProPerty = this.getModel().getProperty(field);
            Object fieldValue = this.getModel().getValue(field);
            boolean isNullField = false;
            if (fieldValue == null) {
                isNullField = true;
            }
            if (fieldProPerty instanceof ComboProp && "".equals(fieldValue)) {
                isNullField = true;
            }
            if (fieldProPerty instanceof DynamicCollectionProperty && fieldValue != null && ((DynamicObjectCollection)fieldValue).isEmpty()) {
                isNullField = true;
            }
            if (isNullField) {
                nullFields.append(fieldProPerty.getDisplayName());
                nullFields.append("\uff0c");
                continue;
            }
            this.filedValueMap.put(field, fieldValue);
        }
        if (nullFields.length() > 0) {
            String fieldNames = CommonUtils.trimComma((String)nullFields.toString());
            return String.format(ResManager.loadKDString((String)"\u5f53\u201c\u4fee\u6539\u5b57\u6bb5\u201d\u4e3a\u201c%1$s\u201d\u65f6\uff0c\u201c%2$s\u201d\u5b57\u6bb5\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CheckPlanBatchModifyPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), fieldNames, fieldNames);
        }
        return null;
    }

    private OperationResult saveModifyFields() {
        String selectFields = (String)this.getModel().getValue(MODIFY_FIELDS);
        selectFields = selectFields.replaceAll("rangedate", "startDate,endDate");
        Object[] ids = ((JSONArray)this.getView().getFormShowParameter().getCustomParam("ids")).toArray();
        DynamicObject[] billInfos = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_datacheck_plan"));
        HashSet<String> aliasNameSet = new HashSet<String>(16);
        HashMap insertParamMap = new HashMap(16);
        for (Map.Entry<String, Object> entry : this.filedValueMap.entrySet()) {
            String fieldKey = entry.getKey();
            Object fieldValue = entry.getValue();
            IDataEntityProperty fieldProPerty = this.getModel().getProperty(fieldKey);
            if (!(fieldProPerty instanceof DynamicCollectionProperty)) {
                for (DynamicObject billInfo : billInfos) {
                    billInfo.set(fieldKey, fieldValue);
                }
                continue;
            }
            String string = MetadataServiceHelper.getDataEntityType((String)"cal_datacheck_plan").getProperty(fieldKey).getAlias();
            aliasNameSet.add(string);
            ArrayList<Object[]> insertList = new ArrayList<Object[]>(16);
            DynamicObjectCollection valueDymCol = (DynamicObjectCollection)fieldValue;
            for (DynamicObject valueDym : valueDymCol) {
                long[] pkidArr = DB.genLongIds((String)string, (int)ids.length);
                int i = 0;
                for (Object id : ids) {
                    long fpkid = pkidArr[i];
                    long fid = (Long)id;
                    long fbasedataid = valueDym.getLong("fbasedataid_id");
                    insertList.add(new Object[]{fpkid, fid, fbasedataid});
                    ++i;
                }
            }
            insertParamMap.put(string, insertList);
        }
        if (selectFields.contains("repeatmode")) {
            this.setSchedule(billInfos);
        }
        try (TXHandle t = TX.requiresNew();){
            OperateOption option = OperateOption.create();
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cal_datacheck_plan", (DynamicObject[])billInfos, (OperateOption)option);
            if (!result.isSuccess()) {
                OperationResult operationResult = result;
                return operationResult;
            }
            try {
                if (!aliasNameSet.isEmpty()) {
                    for (String string : aliasNameSet) {
                        String deleteSql = "DELETE FROM " + string + " WHERE fid in (" + StringUtils.join((Object[])ids, (String)",") + ")";
                        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleteSql);
                    }
                }
                if (!insertParamMap.isEmpty()) {
                    for (Map.Entry entry : insertParamMap.entrySet()) {
                        String insertSql = "INSERT INTO " + (String)entry.getKey() + " (fpkid, fid, fbasedataid)VALUES(?,?,?)";
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)insertSql, (List)((List)entry.getValue()));
                    }
                }
            }
            catch (Exception e) {
                t.setRollback(true);
                throw e;
            }
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"CheckPlanBatchModifyPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        return null;
    }

    private String saveClearFields() {
        DynamicObject[] billInfos;
        String selectFields = (String)this.getModel().getValue(CLEAR_FIELDS);
        if (selectFields == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckPlanBatchModifyPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        selectFields = selectFields.replaceAll("rangedate", "startDate,endDate");
        String[] selectFieldsArr = CommonUtils.trimComma((String)selectFields).split(",");
        HashMap<String, Object> filedValueMap = new HashMap<String, Object>(16);
        for (String field : selectFieldsArr) {
            Object fieldValue = this.getModel().getValue(field);
            filedValueMap.put(field, fieldValue);
        }
        Object[] ids = ((JSONArray)this.getView().getFormShowParameter().getCustomParam("ids")).toArray();
        for (DynamicObject billInfo : billInfos = BusinessDataServiceHelper.load((String)"cal_datacheck_plan", (String)CommonUtils.trimComma((String)selectFields), (QFilter[])new QFilter("id", "in", (Object)ids).toArray())) {
            for (Map.Entry entry : filedValueMap.entrySet()) {
                billInfo.set((String)entry.getKey(), entry.getValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])billInfos);
        this.getView().showMessage(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f", (String)"CheckPlanBatchModifyPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        return null;
    }

    private void setSchedule(DynamicObject[] billInfos) {
        for (DynamicObject billInfo : billInfos) {
            for (String month : CKMONTH) {
                billInfo.set(month, this.getModel().getValue(month));
            }
            for (String date : CKDATE) {
                billInfo.set(date, this.getModel().getValue(date));
            }
            for (String day : CKDAY) {
                billInfo.set(day, this.getModel().getValue(day));
            }
            billInfo.set("combdorw", this.getModel().getValue("combdorw"));
            billInfo.set("comno", this.getModel().getValue("comno"));
            billInfo.set("comweek", this.getModel().getValue("comweek"));
        }
    }

    private Set<String> getComBoFields(String fieldNames) {
        HashSet<String> ComBoValueSet = new HashSet<String>(16);
        ComboProp comBo = (ComboProp)this.getModel().getProperty(fieldNames);
        List items = comBo.getComboItems();
        for (ValueMapItem item : items) {
            String value = item.getValue();
            ComBoValueSet.add(value);
        }
        return ComBoValueSet;
    }

    private void setVisibleByMonth(String name) {
        boolean isMonth = false;
        for (String propMonth : CKMONTH) {
            if (!name.equals(propMonth)) continue;
            isMonth = true;
            break;
        }
        if (isMonth) {
            boolean changeMonth = false;
            for (String month : CKMONTH) {
                boolean b = Boolean.parseBoolean(this.getModel().getValue(month).toString());
                if (!b) continue;
                changeMonth = b;
                break;
            }
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comnobymonth"});
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comweekbymonth"});
            if (!changeMonth) {
                this.getModel().setValue("ckbyweek", (Object)Boolean.FALSE);
            }
        }
    }

    private void adjustByRepeatMode() {
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"flexpweek", "flexpworday", "flexpmonths", "flexpbyweek"});
        FieldEdit txtCycleNum = (FieldEdit)formView.getControl("cyclenum");
        txtCycleNum.setEnable("", true, -1);
        repeatMode = repeatMode.trim();
        this.getModel().setValue("cyclenum", (Object)1);
        switch (repeatMode) {
            case "w": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpweek"});
                txtCycleNum.setEnable("", false, -1);
                break;
            }
            case "m": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpworday"});
                break;
            }
            case "y": {
                txtCycleNum.setEnable("", true, -1);
                formView.setVisible(Boolean.TRUE, new String[]{"flexpmonths"});
                break;
            }
            case "n": {
                txtCycleNum.setEnable("", false, -1);
            }
            case "": {
                txtCycleNum.setEnable("", false, -1);
            }
        }
    }
}

