/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.MustInputDimHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CostAdjustBatchModifyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private Map<Long, Set<String>> divideDimsMap = new HashMap<Long, Set<String>>(16);
    private Map<Long, Set<String>> orgAndDiffDimsMap = new HashMap<Long, Set<String>>(16);
    private static final String ModifyFields = "modifyfields";
    private String dimInfoStr = "";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addF7Listener(this, "storageorgunit", "warehouse", "owner", "location");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billStatus = (String)this.getView().getFormShowParameter().getCustomParam("billstatus");
        this.initSelectFields(billStatus);
        this.setDefaultSelect(billStatus);
        this.setOwnerDefault(billStatus);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String[] selectFields = CommonUtils.trimComma((String)((String)this.getModel().getValue(ModifyFields))).split(",");
        this.getView().setVisible(Boolean.TRUE, selectFields);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if (ModifyFields.equals(propertyName)) {
            String[] allFields = this.getView().getPageCache().get("allFields").split(",");
            HashSet<String> allFieldsSet = new HashSet<String>(16);
            for (String fields : allFields) {
                allFieldsSet.add(fields);
            }
            String selectFieldsString = (String)this.getModel().getValue(ModifyFields);
            if (selectFieldsString == null) {
                this.getView().setVisible(Boolean.FALSE, allFieldsSet.toArray(new String[0]));
                return;
            }
            String[] selectFields = CommonUtils.trimComma((String)selectFieldsString).split(",");
            HashSet<String> selectFieldsSet = new HashSet<String>(16);
            for (String fields : selectFields) {
                selectFieldsSet.add(fields);
            }
            allFieldsSet.removeAll(selectFieldsSet);
            this.getView().setVisible(Boolean.TRUE, selectFieldsSet.toArray(new String[0]));
            this.getView().setVisible(Boolean.FALSE, allFieldsSet.toArray(new String[0]));
        } else if ("storageorgunit".equals(propertyName)) {
            this.getModel().setValue("warehouse", null);
        } else if ("warehouse".equals(propertyName)) {
            this.getModel().setValue("location", null);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button && "btnok".equals(((Button)evt.getSource()).getKey())) {
            String selectFieldsString = (String)this.getModel().getValue(ModifyFields);
            if (selectFieldsString == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5\u3002", (String)"CostAdjustBatchModifyPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectFieldsString.contains("cstype") && !selectFieldsString.contains("custsupplier")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u5b57\u6bb5\u52fe\u9009\u5f80\u6765\u7c7b\u578b\u65f6\u5fc5\u987b\u52fe\u9009\u5f80\u6765\u5355\u4f4d", (String)"CostAdjustBatchModifyPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectFieldsString.contains("custsupplier") && !selectFieldsString.contains("cstype")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u5b57\u6bb5\u52fe\u9009\u5f80\u6765\u5355\u4f4d\u65f6\u5fc5\u987b\u52fe\u9009\u5f80\u6765\u7c7b\u578b", (String)"CostAdjustBatchModifyPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectFieldsString.contains("warehouse") && !selectFieldsString.contains("storageorgunit")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u5b57\u6bb5\u52fe\u9009\u4ed3\u5e93\u65f6\u5fc5\u987b\u52fe\u9009\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CostAdjustBatchModifyPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectFieldsString.contains("location") && !selectFieldsString.contains("warehouse")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u5b57\u6bb5\u52fe\u9009\u4ed3\u4f4d\u65f6\u5fc5\u987b\u52fe\u9009\u4ed3\u5e93", (String)"CostAdjustBatchModifyPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectFieldsString.contains("storageorgunit") && !selectFieldsString.contains("warehouse")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u5b57\u6bb5\u52fe\u9009\u5e93\u5b58\u7ec4\u7ec7\u65f6\u5fc5\u987b\u52fe\u9009\u4ed3\u5e93", (String)"CostAdjustBatchModifyPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.chenckNullFields(selectFieldsString);
        }
    }

    private void chenckNullFields(String selectFieldsString) {
        String[] selectFields = CommonUtils.trimComma((String)selectFieldsString).split(",");
        StringBuilder nullFieldName = new StringBuilder();
        HashMap<String, String> nullFieldMap = new HashMap<String, String>(16);
        for (String field : selectFields) {
            Object filedObject = this.getModel().getValue(field);
            if (filedObject != null && !"".equals(filedObject)) continue;
            String index = this.getModel().getDataEntityType().getProperty(field).getName();
            String name = this.getModel().getDataEntityType().getProperty(field).getDisplayName().toString();
            nullFieldMap.put(index, name);
        }
        if (nullFieldMap.size() > 0) {
            for (Map.Entry entry : nullFieldMap.entrySet()) {
                String name = (String)entry.getValue();
                nullFieldName.append(name);
                nullFieldName.append(',');
            }
            if (CommonUtils.trimComma((String)nullFieldName.toString()).length() != 0) {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("callbackId", (IFormPlugin)this);
                String string = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u6279\u91cf\u6e05\u7a7a\uff1f", (String)"CostAdjustBatchModifyPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]), CommonUtils.trimComma((String)nullFieldName.toString()));
                this.getView().showConfirm(string, MessageBoxOptions.YesNo, callBackListener);
                return;
            }
        }
        this.doModifyBills();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        Object[] ids = ((JSONArray)this.getView().getFormShowParameter().getCustomParam("ids")).toArray();
        String fromentity = (String)this.getView().getFormShowParameter().getCustomParam("caldifffromentity");
        DynamicObject billInfo = null;
        billInfo = StringUtils.isEmpty((CharSequence)fromentity) ? BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"cal_costadjustbill", (String)"costaccount,calorg") : BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)fromentity, (String)"costaccount,calorg");
        DynamicObject costAccount = billInfo.getDynamicObject("costaccount");
        DynamicObject calOrg = billInfo.getDynamicObject("calorg");
        if ("owner".equals(key)) {
            this.beforeF7Select4Owner(e, costAccount);
        } else if ("storageorgunit".equals(key)) {
            this.beforeF7Select4Storageorg(e, calOrg);
        } else if ("warehouse".equals(key)) {
            this.beforeF7Select4WareHouse(e);
        } else if ("location".equals(key)) {
            this.beforeF7Select4Location(e);
        }
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e, DynamicObject costAccount) {
        Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costAccount.getLong("id"));
        if (ownerIsArray.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"CostAdjustBatchModifyPlugin_9", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", (Object)ownerIsArray);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e, DynamicObject calOrg) {
        List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
        QFilter q = new QFilter("id", "in", (Object)list);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4WareHouse(BeforeF7SelectEvent e) {
        DynamicObject storageorgUnit = (DynamicObject)this.getModel().getValue("storageorgunit");
        HashSet<Long> set = new HashSet<Long>();
        if (storageorgUnit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CostAdjustBatchModifyPlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Long[] warehouseIds = SCMHelper.getAllWarehouseIDs((String)storageorgUnit.getString("number"));
        if (warehouseIds != null) {
            Long[] longArray = warehouseIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long id = longArray[i];
                set.add(id);
            }
        }
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (set.size() > 0) {
            q = new QFilter("id", "in", set);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouse == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4ed3\u5e93", (String)"CostAdjustBatchModifyPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        HashSet<Long> set = new HashSet<Long>();
        set.add(warehouse.getLong("id"));
        q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void initSelectFields(String billStatus) {
        ArrayList<String> list = new ArrayList<String>();
        List<ComboItem> items = this.getBatchModifyComBo(list, billStatus);
        ComboEdit co = (ComboEdit)this.getView().getControl(ModifyFields);
        co.setComboItems(items);
        co.selectedStore(items);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        if (e.getCallBackId().equals("callbackId")) {
            if (MessageBoxResult.No.equals((Object)result)) {
                return;
            }
            this.doModifyBills();
        }
    }

    private void doModifyBills() {
        String fieldNames = CommonUtils.trimComma((String)((String)this.getModel().getValue(ModifyFields)));
        String[] selectFields = fieldNames.split(",");
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>(16);
        StringBuilder adjustSelectFields = new StringBuilder();
        for (String field : selectFields) {
            Object fieldValue = this.getModel().getValue(field);
            fieldsMap.put(field, fieldValue);
            adjustSelectFields.append(field);
            adjustSelectFields.append(',');
        }
        if (fieldNames.contains("warehouse") && !fieldNames.contains("location")) {
            adjustSelectFields.append("location");
            adjustSelectFields.append(',');
        }
        if (fieldNames.contains("warehouse")) {
            adjustSelectFields.append("accounttype");
            adjustSelectFields.append(',');
        }
        String adjustSelectString = adjustSelectFields.substring(0, adjustSelectFields.length() - 1);
        Object[] ids = ((JSONArray)this.getView().getFormShowParameter().getCustomParam("ids")).toArray();
        String fromentity = (String)this.getView().getFormShowParameter().getCustomParam("caldifffromentity");
        DynamicObject[] billInfos = null;
        boolean isAdjBill = StringUtils.isEmpty((CharSequence)fromentity);
        billInfos = isAdjBill ? BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)(CommonUtils.trimComma((String)adjustSelectString) + ",entryentity,isupdatecost,billno,costaccount,calorg"), (QFilter[])new QFilter("id", "in", (Object)ids).toArray()) : BusinessDataServiceHelper.load((String)fromentity, (String)(CommonUtils.trimComma((String)adjustSelectString) + ",entryentity,isupdatecost,billno,costaccount,calorg"), (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        boolean isOnlyNullField = (Boolean)this.getModel().getValue("isonlynullfield");
        StringBuilder errorMsgBuilder = new StringBuilder();
        HashSet<DynamicObject> errorBillInfo = new HashSet<DynamicObject>(16);
        HashSet<Long> accountIdSet = new HashSet<Long>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (DynamicObject billInfo : billInfos) {
            accountIdSet.add(billInfo.getLong("costaccount.id"));
            orgIdSet.add(billInfo.getLong("calorg.id"));
        }
        if (isAdjBill) {
            this.dimInfoStr = ResManager.loadKDString((String)"\u5212\u5206\u4f9d\u636e", (String)"CostAdjustBatchModifyPlugin_17", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.divideDimsMap = MustInputDimHelper.getAccountDivideDims(accountIdSet);
        } else {
            this.dimInfoStr = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u7ef4\u5ea6", (String)"CostAdjustBatchModifyPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.orgAndDiffDimsMap = MustInputDimHelper.getOrgAndDiffDims(orgIdSet);
        }
        for (DynamicObject billInfo : billInfos) {
            Set<String> divideDims = null;
            divideDims = isAdjBill ? this.divideDimsMap.get(billInfo.getLong("costaccount.id")) : this.orgAndDiffDimsMap.get(billInfo.getLong("calorg.id"));
            if (divideDims == null) {
                divideDims = new HashSet<String>(16);
            }
            MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
            if (!StringUtils.isEmpty((CharSequence)fromentity)) {
                billEntity = MetadataServiceHelper.getDataEntityType((String)fromentity);
            }
            boolean isUpdateCost = billInfo.getBoolean("isupdatecost");
            String billno = billInfo.getString("billno");
            for (Map.Entry fieldMapEntry : fieldsMap.entrySet()) {
                String fieldname = (String)fieldMapEntry.getKey();
                IDataEntityProperty billFieldProperty = billEntity.findProperty((String)fieldMapEntry.getKey());
                if (billFieldProperty.getParent() instanceof EntryType) continue;
                if (isOnlyNullField) {
                    if (billInfo.get(fieldname) != null && !"".equals(billInfo.get(fieldname))) continue;
                    billInfo.set(fieldname, fieldMapEntry.getValue());
                    continue;
                }
                billInfo.set(fieldname, fieldMapEntry.getValue());
            }
            DynamicObjectCollection entrys = billInfo.getDynamicObjectCollection("entryentity");
            block4: for (DynamicObject entry : entrys) {
                DynamicObject oldStrongeUnit = null;
                DynamicObject oldWareHouse = null;
                DynamicObject oldLocation = null;
                if (adjustSelectString.contains("storageorgunit")) {
                    oldStrongeUnit = entry.getDynamicObject("storageorgunit");
                }
                if (adjustSelectString.contains("warehouse")) {
                    oldWareHouse = entry.getDynamicObject("warehouse");
                    oldLocation = entry.getDynamicObject("location");
                }
                for (Map.Entry fieldMapEntry : fieldsMap.entrySet()) {
                    Object wareHouse;
                    String fieldname = (String)fieldMapEntry.getKey();
                    IDataEntityProperty billFieldProperty = billEntity.findProperty((String)fieldMapEntry.getKey());
                    if (!(billFieldProperty.getParent() instanceof EntryType)) continue;
                    if ("warehouse".equals(fieldname) && fieldMapEntry.getValue() == null && isUpdateCost && divideDims.contains("warehouse")) {
                        if (!StringUtils.isEmpty((CharSequence)errorMsgBuilder.toString())) {
                            errorMsgBuilder.append("\n");
                        }
                        String errormsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%1$s\u3011\u4fee\u6539\u5931\u8d25\uff0c\u8d26\u7c3f\u4e0b\u7684%2$s\u5305\u542b\u4ed3\u5e93\uff0c\u4ed3\u5e93\u5fc5\u5f55\uff0c\u4f46\u672a\u5f55\u5165\u503c\u3002", (String)"CostAdjustBatchModifyPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]), billno, this.dimInfoStr);
                        errorMsgBuilder.append(errormsg);
                        errorBillInfo.add(billInfo);
                        continue block4;
                    }
                    if ("location".equals(fieldname) && (wareHouse = fieldsMap.get("warehouse")) != null && fieldMapEntry.getValue() == null) {
                        Boolean isOpenLocation = ((DynamicObject)wareHouse).getBoolean("isopenlocation");
                        if (isUpdateCost && divideDims.contains("location") && isOpenLocation.booleanValue()) {
                            if (!StringUtils.isEmpty((CharSequence)errorMsgBuilder.toString())) {
                                errorMsgBuilder.append("\n");
                            }
                            String errormsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%1$s\u3011\u4fee\u6539\u5931\u8d25\uff0c\u8d26\u7c3f\u4e0b\u7684%2$s\u5305\u542b\u4ed3\u4f4d\u4e14\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\uff0c\u4ed3\u4f4d\u5fc5\u5f55\uff0c\u4f46\u672a\u5f55\u5165\u503c\u3002", (String)"CostAdjustBatchModifyPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]), billno, this.dimInfoStr);
                            errorMsgBuilder.append(errormsg);
                            errorBillInfo.add(billInfo);
                            continue block4;
                        }
                    }
                    if (isOnlyNullField) {
                        if (fieldNames.contains("warehouse") && fieldNames.contains("location") && oldWareHouse != null && "location".equals(fieldname)) continue;
                        if (oldWareHouse == null && "warehouse".equals(fieldname) && fieldMapEntry.getValue() != null) {
                            entry.set("accounttype", null);
                        }
                        if (oldLocation == null && "oldLocation".equals(fieldname) && fieldMapEntry.getValue() != null) {
                            entry.set("accounttype", null);
                        }
                        if (entry.get(fieldname) != null && !"".equals(entry.get(fieldname))) continue;
                        entry.set(fieldname, fieldMapEntry.getValue());
                        continue;
                    }
                    entry.set(fieldname, fieldMapEntry.getValue());
                    if ("storageorgunit".equals(fieldname) && oldStrongeUnit != fieldMapEntry.getValue()) {
                        entry.set("accounttype", null);
                    }
                    if ("warehouse".equals(fieldname) && oldWareHouse != fieldMapEntry.getValue()) {
                        entry.set("accounttype", null);
                    }
                    if ("location".equals(fieldname) && oldLocation != fieldMapEntry.getValue()) {
                        entry.set("accounttype", null);
                    }
                    if (!fieldNames.contains("warehouse") || fieldNames.contains("location")) continue;
                    entry.set("location", null);
                }
            }
        }
        if (!errorBillInfo.isEmpty()) {
            HashSet<DynamicObject> successBills = new HashSet<DynamicObject>(16);
            for (DynamicObject bill : billInfos) {
                successBills.add(bill);
            }
            successBills.removeAll(errorBillInfo);
            String msg = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f%1$s\u6761\uff0c\u4fee\u6539\u5931\u8d25%2$s\u6761", (String)"CostAdjustBatchModifyPlugin_16", (String)"fi-cal-formplugin", (Object[])new Object[0]), successBills.size(), errorBillInfo.size());
            if (!successBills.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])successBills.toArray(new DynamicObject[0]));
            }
            String errorMsg = errorMsgBuilder.toString();
            this.getView().showTipNotification(msg + "\n" + errorMsg);
        } else {
            SaveServiceHelper.save((DynamicObject[])billInfos);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"CostAdjustBatchModifyPlugin_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.getView().returnDataToParent((Object)"btnok");
    }

    private List<ComboItem> getBatchModifyComBo(List<String> list, String billStatus) {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_batchmodify");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        StringBuilder allFields = new StringBuilder();
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            String proName;
            if (pro instanceof LongProp || ModifyFields.equals(proName = pro.getName()) || "isonlynullfield".equals(proName) || "A".equals(billStatus) && ("adminorg".equals(proName) || "cstype".equals(proName) || "custsupplier".equals(proName)) || !"A".equals(billStatus) && ("storageorgunit".equals(proName) || "warehouse".equals(proName) || "owner".equals(proName) || "location".equals(proName))) continue;
            ComboItem item = new ComboItem(pro.getDisplayName(), proName);
            allFields.append(proName);
            allFields.append(',');
            items.add(item);
        }
        this.getView().getPageCache().put("allFields", CommonUtils.trimComma((String)allFields.toString()));
        return items;
    }

    private void setDefaultSelect(String billStatus) {
        String defaultSelect = "A".equals(billStatus) ? ",storageorgunit,warehouse,owner,productline" : ",adminorg,cstype,custsupplier,productline";
        this.getModel().setValue(ModifyFields, (Object)defaultSelect);
    }

    private void setOwnerDefault(String billStatus) {
        if ("A".equals(billStatus)) {
            Object[] ids = ((JSONArray)this.getView().getFormShowParameter().getCustomParam("ids")).toArray();
            String fromentity = (String)this.getView().getFormShowParameter().getCustomParam("caldifffromentity");
            if (StringUtils.isEmpty((CharSequence)fromentity)) {
                DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"cal_costadjustbill", (String)"costaccount,calorg");
                DynamicObject calOrg = billInfo.getDynamicObject("calorg");
                this.getModel().setValue("owner", calOrg.getPkValue());
            } else {
                DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)fromentity, (String)"costaccount,calorg");
                DynamicObject calOrg = billInfo.getDynamicObject("calorg");
                this.getModel().setValue("owner", calOrg.getPkValue());
            }
        }
    }
}

