/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ExcebalanceSetting
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_CLOSE = "btn_close";
    private static final String BIZTYPE = "biztype";
    private static final String BILLTYPE = "billtype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_CLOSE});
        this.addClickListeners(new String[]{BIZTYPE});
        BasedataEdit f7 = (BasedataEdit)this.getControl(BILLTYPE);
        if (f7 != null) {
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String biztype = (String)this.getView().getFormShowParameter().getCustomParam(BIZTYPE);
        String billtype = this.getView().getFormShowParameter().getCustomParam(BILLTYPE).toString();
        this.getModel().setValue(BIZTYPE, (Object)biztype);
        this.getModel().setValue(BILLTYPE, (Object)billtype);
        this.getPageCache().put(BIZTYPE, biztype);
        this.getPageCache().put(BILLTYPE, billtype);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        HashMap<String, String> map = new HashMap<String, String>();
        if (BTN_SAVE.equals(key)) {
            map.put(BIZTYPE, (String)this.getModel().getValue(BIZTYPE));
            map.put(BILLTYPE, String.valueOf(((DynamicObject)this.getModel().getValue(BILLTYPE)).getLong("id")));
        } else {
            map.put(BIZTYPE, this.getPageCache().get(BIZTYPE));
            map.put(BILLTYPE, this.getPageCache().get(BILLTYPE));
        }
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String biztype = (String)this.getModel().getValue(BIZTYPE);
        if (BILLTYPE.equals(key)) {
            if (biztype.equals("A")) {
                QFilter q = new QFilter("number", "in", (Object)new String[]{"im_OtherInBill_STD_BT_S", "im_ProductInbill_STD_BT_S", "im_PurInBill_STD_BT_S"});
                showParameter.getListFilterParameter().setFilter(q);
            } else if (biztype.equals("B")) {
                QFilter q = new QFilter("number", "in", (Object)new String[]{"im_MaterialReqOutBill_STD_BT_S", "im_SalOutBill_STD_BT_S", "im_OtherOutBill_Asset_BT_S", "im_OtherOutBill_STD_BT_S"});
                showParameter.getListFilterParameter().setFilter(q);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (BIZTYPE.equals(key)) {
            String biztype = (String)this.getModel().getValue(BIZTYPE);
            if (biztype.equals("A")) {
                QFilter q = new QFilter("number", "=", (Object)"im_PurInBill_STD_BT_S");
                DynamicObject billtype = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id", (QFilter[])q.toArray());
                this.getModel().setValue(BILLTYPE, (Object)billtype.getLong("id"));
            } else if (biztype.equals("B")) {
                QFilter q = new QFilter("number", "=", (Object)"im_SalOutBill_STD_BT_S");
                DynamicObject billtype = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id", (QFilter[])q.toArray());
                this.getModel().setValue(BILLTYPE, (Object)billtype.getLong("id"));
            }
        }
        super.propertyChanged(e);
    }
}

