/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.GroupFieldsUniqueValidateResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.BillTreeBuildParameter;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.EntityParseHelper;

public class FieldMapConfigPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_KEY = "entryentity";
    private static final String BILLFIELDNAME = "billfieldname";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BILLFIELDNAME});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        this.doClick(source.getKey());
    }

    private void doClick(String key) {
        if (BILLFIELDNAME.equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY_KEY);
            MainEntityType billEntityType = this.getBillEntityType(row);
            String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
            MainEntityType balanceEntityType = EntityMetadataCache.getDataEntityType((String)balanceEntity);
            if (billEntityType == null) {
                return;
            }
            String calFieldValue = (String)this.getModel().getValue("calfield");
            if (StringUtils.isEmpty((String)calFieldValue)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"FieldMapConfigPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            IDataEntityProperty calProperty = balanceEntityType.findProperty(calFieldValue);
            if (calProperty == null && !"bookdate".equals(calFieldValue)) {
                return;
            }
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(billEntityType, null, calProperty);
            parameter.setIncludePKField(true);
            TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter[])new BillTreeBuildParameter[]{parameter});
            this.showSelectFieldForm(srcBillNode, BILLFIELDNAME);
        }
    }

    private MainEntityType getBillEntityType(int row) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype", row);
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"FieldMapConfigPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String billEntityTypeNumber = billType.getString("number");
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntityTypeNumber);
        return billEntityType;
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (BILLFIELDNAME.equals(sourceFldKey) && returnData != null) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY_KEY);
            MainEntityType mainType = this.getBillEntityType(row);
            this.receiveSelectField(mainType, (String)returnData, ENTRY_KEY, BILLFIELDNAME);
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName, String entityKey, String descFldKey) {
        if (StringUtils.isBlank((String)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        this.getModel().setValue("billfield", (Object)returnPropName, row);
        this.getModel().setValue(descFldKey, (Object)fieldCaption, row);
    }

    public void afterBindData(EventObject e) {
        LocaleString displayName;
        String name;
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String dividebasis = setting.getString("dividebasiscols");
        String caldimension = setting.getString("caldimensioncols");
        HashSet<String> dimField = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)dividebasis)) {
            String[] divs;
            for (String string : divs = dividebasis.split(",")) {
                dimField.add(string);
            }
        }
        if (StringUtils.isNotEmpty((String)caldimension)) {
            String[] calDims;
            for (String string : calDims = caldimension.split(",")) {
                dimField.add(string);
            }
        }
        dimField.add("material");
        ArrayList<ComboItem> calFields = new ArrayList<ComboItem>(16);
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            if (!(pro instanceof BasedataProp) && !(pro instanceof TextProp)) continue;
            name = pro.getName();
            displayName = pro.getDisplayName();
            if (!dimField.contains(name)) continue;
            calFields.add(new ComboItem(displayName, name));
        }
        for (IDataEntityProperty pro : ((EntityType)entitytype.getAllEntities().get("entry")).getProperties()) {
            if (!(pro instanceof BasedataProp) && !(pro instanceof TextProp)) continue;
            name = pro.getName();
            displayName = pro.getDisplayName();
            if (!dimField.contains(name)) continue;
            calFields.add(new ComboItem(displayName, name));
        }
        calFields.add(new ComboItem(((IDataEntityProperty)entitytype.getProperties().get((Object)"bookdate")).getDisplayName(), "bookdate"));
        ((ComboEdit)this.getControl("calfield")).setComboItems(calFields);
        this.transformLanguage();
    }

    private void transformLanguage() {
        int count = this.getModel().getEntryRowCount(ENTRY_KEY);
        for (int i = 0; i < count; ++i) {
            String fullCaption;
            if (this.getModel().getValue("billtype", i) == null) continue;
            String billType = ((DynamicObject)this.getModel().getValue("billtype", i)).getString("id");
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billType);
            String field = (String)this.getModel().getValue("billfield", i);
            if (!StringUtils.isNotEmpty((String)field) || entityType == null || !StringUtils.isNotEmpty((String)(fullCaption = EntityParseHelper.buildPropFullCaption((EntityType)entityType, (String)field)))) continue;
            this.getModel().setValue(BILLFIELDNAME, (Object)fullCaption, i);
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if ("billtype".equals(propertyName)) {
            this.getModel().setValue(BILLFIELDNAME, (Object)"");
        } else if (BILLFIELDNAME.equals(propertyName) && "".equals(this.getModel().getValue(BILLFIELDNAME))) {
            this.getModel().setValue("billfield", (Object)"");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            this.replaceUniqueValidateInfo(e);
        }
    }

    private void replaceUniqueValidateInfo(AfterDoOperationEventArgs e) {
        String calFieldValue = (String)this.getModel().getValue("calfield");
        if (e.getOperationResult().isSuccess() || StringUtils.isEmpty((String)calFieldValue)) {
            return;
        }
        ValidateResultCollection validateResult = e.getOperationResult().getValidateResult();
        List results = validateResult.getValidateErrors();
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        for (ValidateResult result : results) {
            if (!(result instanceof GroupFieldsUniqueValidateResult)) continue;
            List errorInfos = result.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : errorInfos) {
                String format = "\u201c%s\u201d";
                IDataEntityProperty property = entitytype.findProperty(calFieldValue);
                String msg = errorInfo.getMessage().replace("\u201c\u201d", String.format(format, property.getDisplayName().getLocaleValue()));
                errorInfo.setMessage(msg);
            }
        }
    }
}

