/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class NotCalAgeListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar"});
        this.addClickListeners(new String[]{"btndel", "btnrefresh", "clicknew", "clickdelete"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        evt.getSource();
        if (evt.getSource() instanceof Label) {
            Label lable = (Label)evt.getSource();
            String key = lable.getKey();
            if ("clicknew".equals(key)) {
                this.newData();
            } else if ("clickdelete".equals(key)) {
                this.delData();
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String key = e.getItemKey();
        if (key.equals("btnreturndata")) {
            this.returnData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.refreshData();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        HyperLinkClickEvent hyperLinkClickEvent = e.getHyperLinkClickEvent();
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        IListView view = (IListView)list.getView();
        String formId = view.getFormShowParameter().getFormId();
        if ("cal_notcalage_f7".equals(formId)) {
            e.setCancel(true);
            long id = (Long)((IListView)this.getView()).getFocusRowPkId();
            this.showEditView(id);
        }
    }

    private void refreshData() {
        IListView listView = (IListView)this.getView();
        BillList list = (BillList)this.getControl("billlistap");
        listView.refresh();
        list.clearSelection();
    }

    private void delData() {
        IListView listView = (IListView)this.getView();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selRows = listView.getSelectedRows();
        if (selRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"NotCalAgeListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (ListSelectedRow selRow : selRows) {
            Long id = (Long)selRow.getPrimaryKeyValue();
            ids.add(id);
        }
        OperateOption option = OperateOption.create();
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"cal_notcalage", (Object[])ids.toArray(new Long[0]), (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a", (String)"NotCalAgeListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            if (errors.isEmpty()) {
                msg.append(result.getMessage()).append('\n');
            }
            throw new KDBizException(msg.toString());
        }
        listView.refresh();
        list.clearSelection();
    }

    private void newData() {
        this.showEditView(null);
    }

    private void showEditView(Long id) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("cal_notcalage");
        OperationStatus status = OperationStatus.ADDNEW;
        if (id != null) {
            status = OperationStatus.EDIT;
            showParameter.setPkId((Object)id);
        }
        showParameter.setStatus(status);
        OpenStyle openStyle = showParameter.getOpenStyle();
        StyleCss css = new StyleCss();
        css.setHeight("80%");
        css.setWidth("70%");
        openStyle.setInlineStyleCss(css);
        openStyle.setShowType(ShowType.Modal);
        showParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeform"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void returnData() {
        IListView listView = (IListView)this.getView();
        if (!listView.getCurrentListAllRowCollection().isEmpty() && !listView.getSelectedRows().isEmpty()) {
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            this.getView().returnDataToParent((Object)selectedRows);
        }
        this.getView().close();
    }
}

