/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class NotCalAgePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BILLTYPE = "billtype";
    private static final String BIZTYPE = "biztype";
    private static final String INVSCHEME = "invscheme";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, BIZTYPE, INVSCHEME);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        if (BIZTYPE.equals(key)) {
            this.beforeF7BiztypeEntry(e, rowIndex);
        } else if (INVSCHEME.equals(key)) {
            this.beforeF7InvschemeEntry(e, rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        if (BILLTYPE.equals(key)) {
            this.billTypeEntryChanged(rowIndex);
        } else if (BIZTYPE.equals(key)) {
            this.bizTypeEntryChanged(rowIndex);
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void beforeF7BiztypeEntry(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject billTypeEntity = (DynamicObject)this.getModel().getValue(BILLTYPE, rowIndex);
        if (billTypeEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("billentity.billform", "=", (Object)billTypeEntity.getString("billformid.number"));
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"bd_biztype", (String)"id", (QFilter[])qFilter.toArray());
        ArrayList<Object> idList = new ArrayList<Object>(bizTypes.size());
        for (DynamicObject bizType : bizTypes) {
            idList.add(bizType.get("id"));
        }
        QFilter idf = new QFilter("id", "in", idList);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(idf.toArray()));
    }

    private void beforeF7InvschemeEntry(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject billTypeEntity = (DynamicObject)this.getModel().getValue(BILLTYPE, rowIndex);
        if (billTypeEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        DynamicObject bizTypeEntity = (DynamicObject)this.getModel().getValue(BIZTYPE, rowIndex);
        if (null == bizTypeEntity) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u5f55\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("billform", "=", (Object)billTypeEntity.getString("billformid.number"));
        qFilter.and("bitypeentry.biztype", "=", bizTypeEntity.getPkValue());
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter.toArray()));
    }

    private void billTypeEntryChanged(int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(BIZTYPE, null, rowIndex);
        this.getModel().setValue(INVSCHEME, null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(BIZTYPE, rowIndex);
        this.getView().updateView(INVSCHEME, rowIndex);
    }

    private void bizTypeEntryChanged(int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(INVSCHEME, null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(INVSCHEME, rowIndex);
    }
}

