/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class QueryBalancePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String HEAD_MATERIAL = "head_material";
    private static final String HEAD_COSTACCOUNT = "head_costaccount";
    private static final String HEAD_CALORG = "head_calorg";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("head_storageorgunit".equals(key)) {
            this.getModel().beginInit();
            this.getModel().setValue("head_warehouse", null);
            this.getModel().setValue("head_location", null);
            this.getView().updateView("head_warehouse");
            this.getView().updateView("head_location");
            this.getModel().endInit();
        } else if ("head_warehouse".equals(key)) {
            this.getModel().beginInit();
            this.getModel().setValue("head_location", null);
            this.getView().updateView("head_location");
            this.getModel().endInit();
        }
        this.refreshEntry();
        super.propertyChanged(e);
    }

    private void refreshEntry() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(HEAD_COSTACCOUNT);
        Object costAccountId = costAccount.getPkValue();
        QFilter q = new QFilter("costaccount", "=", costAccountId);
        DynamicObjectCollection material = (DynamicObjectCollection)this.getModel().getValue(HEAD_MATERIAL);
        if (material == null) {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        } else {
            HashSet<Object> ids = new HashSet<Object>();
            for (DynamicObject dynamicObject : material) {
                ids.add(dynamicObject.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("material", "in", ids);
        }
        String lot = (String)this.getModel().getValue("head_lot");
        if (StringUtils.isNotEmpty((String)lot)) {
            q.and("lot", "=", (Object)lot);
        }
        this.getFledFilter("head_storageorgunit", q, "storageorgunit");
        this.getFledFilter("head_warehouse", q, "warehouse");
        this.getFledFilter("head_location", q, "location");
        this.getFledFilter("head_invtype", q, "invtype");
        this.getFledFilter("head_invstatus", q, "invstatus");
        this.getFledFilter("head_project", q, "project");
        Set dimField = CalBalanceModelHelper.getDimField();
        DataSet balanceDataSet = this.queryBalanceDataSet(q, dimField);
        this.batchCreateRows(balanceDataSet, dimField);
    }

    private void getFledFilter(String string, QFilter q, String Field2) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(string);
        if (dynamicObject != null) {
            Object id = dynamicObject.getPkValue();
            q.and(Field2, "=", id);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object calorg = this.getView().getFormShowParameter().getCustomParam("calorg");
        String calOrgid = calorg == null ? null : calorg.toString();
        Object costaccount = this.getView().getFormShowParameter().getCustomParam("costaccount");
        String costaccountid = costaccount == null ? null : costaccount.toString();
        String material = (String)this.getView().getFormShowParameter().getCustomParam("material");
        this.getModel().setValue(HEAD_CALORG, (Object)calOrgid);
        this.getModel().setValue(HEAD_COSTACCOUNT, (Object)costaccountid);
        if (StringUtils.isNotEmpty((String)material)) {
            String[] matIds = material.split(",");
            Long[] matIdArray = new Long[matIds.length];
            for (int index = 0; index < matIds.length; ++index) {
                matIdArray[index] = Long.valueOf(matIds[index]);
            }
            this.getModel().setValue(HEAD_MATERIAL, (Object)matIdArray);
        }
        if (StringUtils.isEmpty((String)material)) {
            return;
        }
        Set dimField = CalBalanceModelHelper.getDimField();
        QFilter q = QFilter.of((String)("material in (" + material + ")"), (Object[])new Object[0]);
        q.and("costaccount", "=", (Object)Long.valueOf(costaccountid));
        DataSet balanceDataSet = this.queryBalanceDataSet(q, dimField);
        this.batchCreateRows(balanceDataSet, dimField);
    }

    private void batchCreateRows(DataSet balanceDataSet, Set<String> dim) {
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        HashSet<String> dimField = new HashSet<String>();
        dimField.addAll(dim);
        dimField.add("baldetailid");
        dimField.add("balanceid");
        dimField.add("costelement");
        dimField.add("costsubelement");
        dimField.add("baseqty");
        dimField.add("unitcost");
        dimField.add("cost");
        dimField.add("baseunit");
        String[] dimFields = dimField.toArray(new String[0]);
        int size = dimFields.length;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String string : dimFields) {
            vs.addField(string, new Object[0]);
        }
        for (Row row : balanceDataSet) {
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                values[i] = row.get(dimFields[i]);
            }
            vs.addRow(values);
        }
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            model.batchCreateNewEntryRow(KEY_ENTRYENTITY, vs);
            model.endInit();
            this.getView().updateView(KEY_ENTRYENTITY);
        }
        this.getModel().endInit();
    }

    private DataSet queryBalanceDataSet(QFilter q, Set<String> dim) {
        DataSet balanceDataSet = null;
        if (this.isNewBalance) {
            q.and("endperiod", "=", (Object)999999);
            HashSet<String> dimField = new HashSet<String>();
            dimField.addAll(dim);
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            if (!balCompress) {
                q.and("baseqty_bal", "!=", (Object)0);
                balanceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)("id as balanceid,0L as baldetailid,baseqty_bal as baseqty,actualcost_bal as cost,baseunit,costelement,costsubelement,actualcost_bal / baseqty_bal as unitcost," + String.join((CharSequence)",", dimField)), (QFilter[])q.toArray(), null);
            } else {
                String selectFields = "id as balanceid,0L as baldetailid,baseqty_bal as baseqty,actualcost_bal as cost,baseunit,costelement,costsubelement,actualcost_bal / baseqty_bal as unitcost," + String.join((CharSequence)",", dimField);
                ArrayList<QFilter> ql = new ArrayList<QFilter>();
                ql.add(q);
                balanceDataSet = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)false, null, ql).where(new QFilter("baseqty_bal", "!=", (Object)0).toString()).select(selectFields);
            }
        } else {
            q.and("endperiod", "=", (Object)999999);
            q.and("periodendqty", "!=", (Object)0);
            HashSet<String> dimField = new HashSet<String>();
            dimField.addAll(dim);
            balanceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)("id as balanceid,periodendqty as baseqty,baseunit," + String.join((CharSequence)",", dimField)), (QFilter[])q.toArray(), null);
            DataSet copy = balanceDataSet.copy();
            HashSet<Object> balanceIdSet = new HashSet<Object>();
            for (Row row : copy) {
                balanceIdSet.add(row.get("balanceid"));
            }
            QFilter qd = new QFilter("balid", "in", balanceIdSet);
            DataSet detailDataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance_detail", (String)"id as baldetailid,balid,costelement,costsubelement,case when periodendactualcost == null then 0 else periodendactualcost end as cost", (QFilter[])qd.toArray(), null);
            dimField.add("balanceid");
            dimField.add("baseqty");
            dimField.add("baseunit");
            balanceDataSet = balanceDataSet.join(detailDataset, JoinType.INNER).on("balanceid", "balid").select(dimField.toArray(new String[dimField.size()]), "baldetailid,costelement,costsubelement,cost".split(",")).finish().select(String.join((CharSequence)",", dimField) + ",baldetailid,costelement,costsubelement,cost,cost/baseqty as unitcost");
        }
        return balanceDataSet;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btnclose"});
        BasedataEdit storageorgunit = (BasedataEdit)this.getControl("head_storageorgunit");
        storageorgunit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warehouse = (BasedataEdit)this.getControl("head_warehouse");
        warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit location = (BasedataEdit)this.getControl("head_location");
        location.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        Map<String, Set<Long>> resultMap = null;
        if ("btnok".equals(key)) {
            resultMap = this.getSelectData();
        }
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }

    private Map<String, Set<Long>> getSelectData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selectRowIndex = grid.getEntryState().getSelectedRows();
        HashSet<Long> balanceIds = new HashSet<Long>();
        HashSet<Long> balDetailIds = new HashSet<Long>();
        for (int i : selectRowIndex) {
            Long balanceId = (Long)this.getModel().getValue("balanceid", i);
            Long balDetailId = (Long)this.getModel().getValue("baldetailid", i);
            if (balanceId == 0L && balDetailId == 0L) continue;
            balanceIds.add(balanceId);
            balDetailIds.add(balDetailId);
        }
        HashMap<String, HashSet<Long>> resultMap = null;
        if (!balanceIds.isEmpty() && !balDetailIds.isEmpty()) {
            resultMap = new HashMap<String, HashSet<Long>>();
            Object materialId = null;
            resultMap.put("balanceid", balanceIds);
            resultMap.put("baldetailid", balDetailIds);
        }
        return resultMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("head_storageorgunit".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("head_warehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if ("head_location".equals(key)) {
            this.beforeF7Select4Location(e);
        }
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("head_warehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouse != null) {
            Long warehouseId = warehouse.getLong("id");
            Long[] warehouseIds = SCMHelper.getAllLocationIDs((Object[])new Long[]{warehouseId});
            HashSet<Long> set = new HashSet<Long>(Arrays.asList(warehouseIds));
            q = new QFilter("id", "in", set);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        DynamicObject storageorgunit = (DynamicObject)this.getModel().getValue("head_storageorgunit");
        if (storageorgunit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CostAdjustBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String storageorgunitNumber = storageorgunit.getString("number");
        Long[] warehouseIds = SCMHelper.getAllWarehouseIDs((String)storageorgunitNumber);
        HashSet<Long> set = new HashSet<Long>(Arrays.asList(warehouseIds));
        QFilter q = new QFilter("id", "in", set);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue(HEAD_CALORG);
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }
}

