/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class QueueSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BILL_TYPE = "billtype";
    private static final String FILTERGRID = "filtergrid";
    private static final String COSTACCOUNT = "costaccount";

    public void afterCreateNewData(EventObject e) {
        this.billTypeChenged();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    private void addListener() {
        BasedataEdit billTypeF7 = (BasedataEdit)this.getControl(BILL_TYPE);
        billTypeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billTypeF71 = (BasedataEdit)this.getControl("bizplugin");
        billTypeF71.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (BILL_TYPE.equals(key)) {
            QFilter qf = new QFilter("number", "not in", (Object)new String[]{"cal_incalbill", "cal_outcalbill"});
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(qf);
        } else if ("bizplugin".equals(key)) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().clear();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (BILL_TYPE.equals(key)) {
            this.billTypeChenged();
        } else if (COSTACCOUNT.equals(key)) {
            DynamicObject costAccountInfo = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
            if (costAccountInfo == null) {
                this.getModel().setValue("calorg", null);
            } else {
                DynamicObject calOrg = costAccountInfo.getDynamicObject("calorg");
                this.getModel().setValue("calorg", (Object)calOrg);
            }
        }
    }

    private void billTypeChenged() {
        String typeName = this.getCurrencyBillType();
        this.chengeFilterByBillType(typeName);
    }

    private String getCurrencyBillType() {
        DynamicObject billType = this.getModel().getDataEntity().getDynamicObject(BILL_TYPE);
        if (billType == null) {
            return null;
        }
        return billType.getString("number");
    }

    private void chengeFilterByBillType(String typeName) {
        if (typeName == null) {
            return;
        }
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)typeName);
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entity);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID);
        filterGrid.setEntityNumber(entity.getName());
        filterGrid.setFilterColumns(cols);
        this.getView().updateView(FILTERGRID);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            this.beforeSave();
        }
    }

    private void beforeSave() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        this.getModel().getDataEntity().set("filterstr_tag", (Object)filterString);
    }

    public void afterBindData(EventObject e) {
        String typeName = this.getCurrencyBillType();
        this.chengeFilterByBillType(typeName);
        String filter = (String)this.getModel().getDataEntity().get("filterstr_tag");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID);
            filterGrid.SetValue(filterCondition);
        }
    }
}

