/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.fi.cal.common.helper.CalDiffGroupBillHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ReGroupDiffBillParam;

public class ReGroupDiffBillPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addF7Listener(this, "costaccount");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.getModel().setValue("costaccount", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = RequestContext.get().getCurrUserId();
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_regroupdiffbill");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)new Long[]{costAccount.getLong("id")});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button && "btnok".equals(((Button)evt.getSource()).getKey())) {
            CalDiffGroupBillHelper diffHelper = new CalDiffGroupBillHelper();
            if (!diffHelper.getIsgroupdiff()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540e\u53f0\u5408\u5e76\u5dee\u5f02\u5355\u53c2\u6570\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u91cd\u65b0\u5408\u5e76\u3002", (String)"ReGroupDiffBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
            if (calOrg == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ReGroupDiffBillPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccount");
            HashSet<Long> costAccountIds = new HashSet<Long>(costAccounts.size());
            if (costAccounts.size() > 0) {
                for (DynamicObject costAccount : costAccounts) {
                    costAccountIds.add(costAccount.getDynamicObject("fbasedataid").getLong("id"));
                }
            }
            DynamicObjectCollection materials = (DynamicObjectCollection)this.getModel().getValue("material");
            HashSet<Long> materialIds = new HashSet<Long>(materials.size());
            if (materials.size() > 0) {
                for (DynamicObject materialId : materials) {
                    materialIds.add(materialId.getDynamicObject("fbasedataid").getLong("id"));
                }
            }
            DynamicObject bizEntityObject = (DynamicObject)this.getModel().getValue("bizentityobject");
            ReGroupDiffBillParam groupDiffBillParam = new ReGroupDiffBillParam();
            groupDiffBillParam.setCalOrgId(Long.valueOf(calOrg.getLong("id")));
            groupDiffBillParam.setCalOrgName(calOrg.getString("name"));
            groupDiffBillParam.setCostAccount(costAccountIds);
            groupDiffBillParam.setMaterial(materialIds);
            if (bizEntityObject != null) {
                groupDiffBillParam.setBizEntityObject(bizEntityObject.getString("number"));
            }
            HashMap<String, String> jobParams = new HashMap<String, String>();
            jobParams.put("params", SerializationUtils.toJsonString((Object)groupDiffBillParam));
            JobInfo job = new JobInfo();
            String OpName = String.format(ResManager.loadKDString((String)"\u91cd\u65b0\u5408\u5e76\u5dee\u5f02\u5355\u3010%1$s\u3011\uff0c\u64cd\u4f5c\u4eba\uff1a\u3010%2$s\u3011", (String)"ReGroupDiffBillPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId(), RequestContext.get().getUserName());
            job.setName(OpName);
            job.setTaskDefineId("2ZRAJIJMNP0A");
            job.setJobType(JobType.REALTIME);
            job.setParams(jobParams);
            job.setRunByLang(Lang.get());
            job.setAppId("cal");
            job.setTaskClassname("kd.fi.cal.formplugin.setting.ReGroupDiffBillTask");
            job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
            JobClient.dispatch((JobInfo)job);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u540e\u53f0\u4efb\u52a1\u8fdb\u884c\u91cd\u65b0\u5408\u5e76\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u5355\u636e\u6570\u636e\u3002", (String)"ReGroupDiffBillPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = this.getModel().getDataEntity(true).getDynamicObject("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "in", (Object)calOrg.getLong("id"));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }
}

