/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;

public class SyncBizBillSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("stoptype", (Object)"cal");
        this.setVisableAndDefaultCalorg();
    }

    private void setVisableAndDefaultCalorg() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"calorg", "storageorgunit", "accounttype", "warehouse", "mulmaterial", "bookdate"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"mulstorageorgunit"});
        long userId = Long.parseLong(RequestContext.get().getUserId());
        long orgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)orgId, (String)"cal_syncbizbillset", (String)"47150e89000000ac");
        this.getModel().setValue("calorg", (Object)calOrgId);
    }

    private void setVisableDefaultInvorg() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"mulstorageorgunit", "bookdate"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"calorg", "storageorgunit", "accounttype", "warehouse", "mulmaterial"});
        long userId = Long.parseLong(RequestContext.get().getUserId());
        long orgId = RequestContext.get().getOrgId();
        Long invOrgId = OrgHelper.getInvOrgByUserOrg((Long)userId, (Long)orgId, (String)"cal_syncbizbillset", (String)"47150e89000000ac");
        if (invOrgId == null) {
            this.getModel().setValue("mulstorageorgunit", null);
        } else {
            this.getModel().setValue("mulstorageorgunit", (Object)new Object[]{invOrgId});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("storageorgunit".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("warehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if ("mulstorageorgunit".equals(key)) {
            this.beforeF7Select4MulInvOrg(e);
        }
    }

    private void beforeF7Select4MulInvOrg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_syncbizbillset", (String)"47150e89000000ac");
        if (list != null) {
            List invlist = OrgHelper.getStorageOrgUnitByAllCalOrg((Long)userId, (String)"cal_syncbizbillset", (String)"47150e89000000ac");
            if (invlist != null) {
                QFilter q = new QFilter("id", "in", (Object)invlist);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            } else {
                QFilter q = new QFilter("id", "=", (Object)-1L);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.calorgChanged();
        } else if ("stoptype".equals(key)) {
            this.stopTypeChanged(e);
        } else if ("storageorgunit".equals(key)) {
            this.getModel().setValue("warehouse", null);
        }
    }

    private void stopTypeChanged(PropertyChangedArgs e) {
        String stoptype = (String)this.getModel().getValue("stoptype");
        this.getModel().setValue("calorg", null);
        if ("cal".equals(stoptype)) {
            this.setVisableAndDefaultCalorg();
        } else if ("inv".equals(stoptype)) {
            this.setVisableDefaultInvorg();
        }
    }

    private void calorgChanged() {
        this.getModel().setValue("storageorgunit", null);
        this.getModel().setValue("mulstorageorgunit", null);
        this.getModel().setValue("accounttype", null);
        this.getModel().setValue("mulmaterial", null);
        this.getModel().setValue("bookdate", null);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        DynamicObject storageorgunit = (DynamicObject)this.getModel().getValue("storageorgunit");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (storageorgunit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"SyncBizBillSettingPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Long[] warehouseIds = SCMHelper.getAllWarehouseIDs((Object[])new Object[]{storageorgunit.getPkValue()});
        HashSet<Long> set = new HashSet<Long>(Arrays.asList(warehouseIds));
        q = new QFilter("id", "in", set);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SyncBizBillSettingPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
        q = new QFilter("id", "in", (Object)list);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_syncbizbillset", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.addF7Listener(this, "calorg", "storageorgunit", "warehouse", "material", "mulstorageorgunit");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        String stoptype = (String)this.getModel().getValue("stoptype");
        if ("btnok".equals(key)) {
            if ("cal".equals(stoptype)) {
                this.calOrgModify();
            } else if ("inv".equals(stoptype)) {
                this.invOrgModify();
            }
        }
        this.getView().close();
    }

    private void invOrgModify() {
        DynamicObjectCollection mulstorageorgunit = (DynamicObjectCollection)this.getModel().getValue("mulstorageorgunit");
        if (mulstorageorgunit == null || mulstorageorgunit.size() < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"SyncBizBillSettingPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Set<Long> mulInvOrgIds = this.getMulIdSet("mulstorageorgunit");
        Date bookDate = (Date)this.getModel().getValue("bookdate");
        if (bookDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(bookDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            bookDate = calendar.getTime();
        }
        Boolean isstopsync = (Boolean)this.getView().getFormShowParameter().getCustomParam("isstopsync");
        new StopSyncSettingModifyHelper().modifySetting4Invorg(mulInvOrgIds, bookDate, isstopsync);
        if (isstopsync.booleanValue()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u670d\u52a1\u5df2\u505c\u6b62\u3002", (String)"SyncBizBillSettingPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u670d\u52a1\u5df2\u542f\u52a8\u3002", (String)"SyncBizBillSettingPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void calOrgModify() {
        Boolean isstopsync;
        if (this.getModel().getValue("calorg") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SyncBizBillSettingPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Long calOrg = this.getBasedataId("calorg");
        HashSet<Long> calOrgs = new HashSet<Long>();
        calOrgs.add(calOrg);
        Long storageorgunit = this.getBasedataId("storageorgunit");
        String accountType = (String)this.getModel().getValue("accounttype");
        accountType = accountType == null ? "" : accountType;
        Long warehouse = this.getBasedataId("warehouse");
        Set<Long> materialIdSet = this.getMulIdSet("mulmaterial");
        Date bookDate = (Date)this.getModel().getValue("bookdate");
        if (bookDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(bookDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            bookDate = calendar.getTime();
        }
        if ((isstopsync = (Boolean)this.getView().getFormShowParameter().getCustomParam("isstopsync")) != null && !"0".equals(String.valueOf(calOrg))) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgs, storageorgunit, accountType, warehouse, materialIdSet, bookDate, isstopsync.booleanValue(), TimeServiceHelper.now());
            if (isstopsync.booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u670d\u52a1\u5df2\u505c\u6b62\u3002", (String)"SyncBizBillSettingPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u670d\u52a1\u5df2\u542f\u52a8\u3002", (String)"SyncBizBillSettingPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Long getBasedataId(String string) {
        DynamicObject dy = (DynamicObject)this.getModel().getValue(string);
        if (dy != null) {
            return dy.getLong("id");
        }
        return 0L;
    }

    private Set<Long> getMulIdSet(String field) {
        DynamicObjectCollection dyc = (DynamicObjectCollection)this.getModel().getValue(field);
        HashSet<Long> set = new HashSet<Long>(16);
        for (DynamicObject dy : dyc) {
            set.add(dy.getDynamicObject("fbasedataid").getLong("id"));
        }
        return set;
    }
}

