/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.BillTreeBuildParameter;
import kd.fi.cal.common.helper.EntityParseHelper;

public class WriteOffGroupSettingPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    public static final String MAINFIELDNAME = "mainfieldname";
    public static final String MAINFIELDENTRY = "mfieldentry";
    public static final String BILLTYPE = "billtype";
    public static final String ENTRYENTITY = "entryentity";
    public static final String SRCBILLTYPE = "srcbilltype";
    public static final String DESTBILLTYPE = "destbilltype";
    public static final String SUBCALELEMENT = "subcalelement";
    public static final String WFTYPE = "wftype";

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (SUBCALELEMENT.equals(key)) {
            this.setCostFields();
        } else if (SRCBILLTYPE.equals(key)) {
            this.addMainFieldEntryRow(key);
            this.setBillTypeIds(SRCBILLTYPE, "sbilltypeids");
        } else if (DESTBILLTYPE.equals(key)) {
            this.addMainFieldEntryRow(key);
            this.setBillTypeIds(DESTBILLTYPE, "dbilltypeids");
        }
    }

    private void setBillTypeIds(String billtype, String dbilltypeids) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObjectCollection billTypes = (DynamicObjectCollection)this.getModel().getValue(billtype, rowIndex);
        HashSet<String> ids = new HashSet<String>(16);
        for (DynamicObject costSubElement : billTypes) {
            ids.add(costSubElement.getDynamicObject("fbasedataid").getString("id"));
        }
        this.getModel().setValue(dbilltypeids, (Object)String.join((CharSequence)",", ids), rowIndex);
    }

    private void setCostFields() {
        DynamicObjectCollection costSubElements = (DynamicObjectCollection)this.getModel().getValue(SUBCALELEMENT);
        HashSet<String> ids = new HashSet<String>(16);
        for (DynamicObject costSubElement : costSubElements) {
            ids.add(costSubElement.getDynamicObject("fbasedataid").getString("id"));
        }
        this.getModel().setValue("costfields", (Object)String.join((CharSequence)",", ids));
    }

    private void addMainFieldEntryRow(String key) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObjectCollection billtypes = (DynamicObjectCollection)this.getModel().getValue(key, rowIndex);
        HashSet<String> billTypeIds = new HashSet<String>(16);
        for (DynamicObject billtype : billtypes) {
            billTypeIds.add(billtype.getDynamicObject("fbasedataid").getString("id"));
        }
        DynamicObjectCollection mainFieldEntry = this.getModel().getEntryEntity(MAINFIELDENTRY);
        HashSet<String> mBillTypeIds = new HashSet<String>(16);
        for (DynamicObject mainField : mainFieldEntry) {
            DynamicObject billType = mainField.getDynamicObject(BILLTYPE);
            if (billType == null) continue;
            mBillTypeIds.add(billType.getString("id"));
        }
        int mainFieldEntrySize = mainFieldEntry.size();
        billTypeIds.removeAll(mBillTypeIds);
        for (String billTypeId : billTypeIds) {
            this.getModel().insertEntryRow(MAINFIELDENTRY, mainFieldEntrySize);
            this.getModel().setValue(BILLTYPE, (Object)billTypeId, mainFieldEntrySize);
            ++mainFieldEntrySize;
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (MAINFIELDNAME.equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(MAINFIELDENTRY);
            DynamicObject billtype = (DynamicObject)this.getModel().getValue(BILLTYPE, rowIndex);
            if (billtype == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"WriteOffGroupSettingPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            String entityNumber = billtype.getString("number");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainEntityType);
            parameter.setIncludePKField(true);
            TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter[])new BillTreeBuildParameter[]{parameter});
            this.showSelectFieldForm(srcBillNode, key);
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (MAINFIELDNAME.equals(sourceFldKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(MAINFIELDENTRY);
            DynamicObject currentEntity = (DynamicObject)this.getModel().getValue(BILLTYPE, rowIndex);
            String entityNumber = currentEntity.getString("number");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            this.receiveSelectField(mainEntityType, (String)returnData, "mainfield", MAINFIELDNAME);
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName, String field, String fieldName) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        int row = this.getModel().getEntryCurrentRowIndex(MAINFIELDENTRY);
        this.getModel().setValue(field, (Object)returnPropName, row);
        this.getModel().setValue(fieldName, (Object)fieldCaption, row);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(MAINFIELDNAME);
        this.addF7Listener(this, SRCBILLTYPE, DESTBILLTYPE);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void addClickListeners(String ... keys) {
        String[] var2 = keys;
        int var3 = keys.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String key = var2[var4];
            Control c = this.getControl(key);
            if (!(c instanceof ISuportClick)) continue;
            ((ISuportClick)c).addClickListener((ClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (SRCBILLTYPE.equals(key) || DESTBILLTYPE.equals(key)) {
            this.beforeF7Select4SDBillType(beforeF7SelectEvent);
        }
    }

    private void beforeF7Select4SDBillType(BeforeF7SelectEvent beforeF7SelectEvent) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObject wftype = (DynamicObject)this.getModel().getValue(WFTYPE, rowIndex);
        if (wftype == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u9500\u7c7b\u522b\u3002", (String)"WriteOffGroupSettingPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        QFilter wfTypeFilter = new QFilter("id", "=", wftype.getPkValue());
        DynamicObjectCollection infos = QueryServiceHelper.query((String)"msmod_writeofftype", (String)"writeoffbillentry.writeoffbilltype", (QFilter[])wfTypeFilter.toArray());
        HashSet<String> billtypeIds = new HashSet<String>();
        for (DynamicObject info : infos) {
            billtypeIds.add(info.getString("writeoffbillentry.writeoffbilltype"));
        }
        QFilter billTypeFilter = new QFilter("id", "=", (Object)-1L);
        if (!billtypeIds.isEmpty()) {
            billTypeFilter = new QFilter("id", "in", billtypeIds);
        }
        ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setFilter(billTypeFilter);
    }
}

