/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting.accountparams;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.formplugin.setting.accountparams.ShowAccountParamsModifyViewHelper;

public class CalAccountParamsListPlugin
extends AbstractListPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billList;
        ListSelectedRowCollection selectedRows;
        Object[] ids;
        Set<String> costAccountIds;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if ("batchmodify".equals(key) && ((costAccountIds = this.getCostAccountIds(ids = (selectedRows = (billList = (BillList)this.getControl("billlistap")).getSelectedRows()).getPrimaryKeyValues())) == null || ids.length > costAccountIds.size())) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CalAccountParamsListPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            if ("batchadd".equals(operateKey)) {
                this.batchAdd(operateKey);
            } else if ("batchmodify".equals(operateKey)) {
                this.batchModify(operateKey);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (fieldName.equals("costaccount_name")) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            Set<String> costAccountIds = this.getCostAccountIds(new Object[]{primaryKeyValue});
            if (costAccountIds == null || costAccountIds.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CalAccountParamsListPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            String caption = ResManager.loadKDString((String)"\u8d26\u7c3f\u7ea7\u53c2\u6570", (String)"CalAccountParamsListPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            ShowAccountParamsModifyViewHelper.showModifyView("batchmodify", caption, String.join((CharSequence)",", costAccountIds), (AbstractFormPlugin)this);
        }
    }

    private Set<String> getCostAccountIds(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"cal_accountparams", (String)"costaccount", (QFilter[])new QFilter("id", "in", (Object)objects).toArray());
        HashSet<String> costAccountIds = new HashSet<String>(16);
        for (DynamicObject dynamicObject : col) {
            costAccountIds.add(dynamicObject.getString("costaccount"));
        }
        return costAccountIds;
    }

    private void batchModify(String key) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        Set<String> costAccountIds = this.getCostAccountIds(ids);
        if (costAccountIds != null && !costAccountIds.isEmpty()) {
            String caption = ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539", (String)"CalAccountParamsListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            ShowAccountParamsModifyViewHelper.showModifyView(key, caption, String.join((CharSequence)",", costAccountIds), (AbstractFormPlugin)this);
        }
    }

    private void batchAdd(String key) {
        String caption = ResManager.loadKDString((String)"\u65b0\u589e", (String)"CalAccountParamsListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        ShowAccountParamsModifyViewHelper.showModifyView(key, caption, null, (AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && StringUtils.isNotEmpty((String)returnData.toString())) {
            this.getView().showSuccessNotification(returnData.toString());
            ((IListView)this.getView()).refresh();
        }
    }
}

