/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting.accountparams;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.log.CalLogInfo;
import kd.fi.cal.common.log.CalLogUtils;
import kd.fi.cal.common.util.CommonUtils;

public class CalAccountParamsModifyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final Long CAL_PARAM_SETTING_PK = 753692010191415296L;

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("costaccount".equals(key)) {
            DynamicObjectCollection col = QueryServiceHelper.query((String)"cal_accountparams", (String)"costaccount", null);
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : col) {
                costAccountIds.add(dynamicObject.getLong("costaccount"));
            }
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and("id", "not in", costAccountIds);
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        BasedataEdit f7Control = (BasedataEdit)this.getView().getControl("costaccount");
        f7Control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object costaccountids;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object key = formShowParameter.getCustomParams().get("key");
        if ("batchmodify".equals(key)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costaccount"});
        }
        if ((costaccountids = formShowParameter.getCustomParams().get("costaccountids")) != null && StringUtils.isNotEmpty((String)costaccountids.toString())) {
            this.setCostAccountValue(costaccountids.toString());
        }
    }

    private void setCostAccountValue(String costaccountids) {
        DynamicObject info;
        String[] idStrArr = costaccountids.split(",");
        HashSet<Long> costaccountIdSet = new HashSet<Long>(16);
        for (String s : idStrArr) {
            if (!StringUtils.isNotEmpty((String)s)) continue;
            costaccountIdSet.add(Long.valueOf(s));
        }
        this.getModel().setValue("costaccount", (Object)costaccountIdSet.toArray());
        if (costaccountIdSet.size() == 1 && (info = QueryServiceHelper.queryOne((String)"cal_accountparams", (String)"costaccount,endinitcheck,endaccountcheck,endcalinvcheck", (QFilter[])new QFilter("costaccount", "in", costaccountIdSet).toArray())) != null) {
            this.getModel().setValue("endinitcheck", (Object)info.getString("endinitcheck"));
            this.getModel().setValue("endaccountcheck", (Object)info.getString("endaccountcheck"));
            this.getModel().setValue("endcalinvcheck", (Object)info.getString("endcalinvcheck"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if ("btnok".equals(key)) {
            boolean hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"/KIUHEXROK3D", (String)"cal_accountparams", (String)"47156aff000000ac");
            if (!hasPermission) {
                String failMsg = ResManager.loadKDString((String)"\u65e0\u201c\u8d26\u7c3f\u7ea7\u53c2\u6570\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"CalSystemCtrlEditUIPlugin_69", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(failMsg);
            }
            String msg = null;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String parentKey = formShowParameter.getCustomParams().get("key").toString();
            if ("batchmodify".equals(parentKey)) {
                this.batchModify();
                msg = ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"CalAccountParamsModifyPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            } else if ("batchadd".equals(parentKey)) {
                this.batchAdd();
                msg = ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"CalAccountParamsModifyPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            }
            this.getView().returnDataToParent(msg);
            this.getView().close();
        }
    }

    private void batchAdd() {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        String endinitcheck = (String)this.getModel().getValue("endinitcheck");
        String endaccountcheck = (String)this.getModel().getValue("endaccountcheck");
        String endcalinvcheck = (String)this.getModel().getValue("endcalinvcheck");
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        HashMap<Object, String> costAccountNameMap = new HashMap<Object, String>(16);
        for (Object costAccount : costAccounts) {
            DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"cal_accountparams");
            info.set("pid", (Object)CAL_PARAM_SETTING_PK);
            DynamicObject fbasedataid = costAccount.getDynamicObject("fbasedataid");
            Long costAccountId = fbasedataid.getLong("id");
            info.set("costaccount", (Object)costAccountId);
            info.set("endinitcheck", (Object)endinitcheck);
            info.set("endaccountcheck", (Object)endaccountcheck);
            info.set("endcalinvcheck", (Object)endcalinvcheck);
            map.put(costAccountId, info);
            costAccountNameMap.put(costAccountId, fbasedataid.getString("name"));
        }
        DynamicObjectCollection infos = QueryServiceHelper.query((String)"cal_accountparams", (String)"costaccount", (QFilter[])new QFilter("costaccount", "in", map.keySet()).toArray());
        for (DynamicObject info : infos) {
            map.remove(info.getLong("costaccount"));
        }
        if (!map.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])map.values().toArray(new DynamicObject[0]));
            String msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a%1$s\uff0c%2$s\uff1a%3$s\uff0c%4$s\uff1a%5$s\uff0c\u8d26\u7c3f\u7ea7\u53c2\u6570\u65b0\u589e\u6210\u529f\u3002", (String)"CalAccountParamsModifyPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            String caption = ResManager.loadKDString((String)"\u65b0\u589e", (String)"CalAccountParamsListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.writeLog(endinitcheck, endaccountcheck, endcalinvcheck, map.keySet(), costAccountNameMap, msg, caption);
        }
    }

    private void batchModify() {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        String endinitcheck = (String)this.getModel().getValue("endinitcheck");
        String endaccountcheck = (String)this.getModel().getValue("endaccountcheck");
        String endcalinvcheck = (String)this.getModel().getValue("endcalinvcheck");
        ArrayList<Long> costAccountIds = new ArrayList<Long>(16);
        HashMap<Object, String> costAccountNameMap = new HashMap<Object, String>(16);
        for (DynamicObject costAccount : costAccounts) {
            DynamicObject fbasedataid = costAccount.getDynamicObject("fbasedataid");
            Long costAccountId = fbasedataid.getLong("id");
            costAccountIds.add(costAccountId);
            costAccountNameMap.put(costAccountId, fbasedataid.getString("name"));
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("update t_cal_costaccparamsentry set fendinitcheck = '" + endinitcheck + "'", new Object[0]);
        builder.append(", fendaccountcheck = '" + endaccountcheck + "'", new Object[0]);
        builder.append(", fendcalinvcheck = '" + endcalinvcheck + "'", new Object[0]);
        builder.append(" where ", new Object[0]);
        builder.appendIn("fcostaccountid", costAccountIds);
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)builder);
        String msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a%1$s\uff0c%2$s\uff1a%3$s\uff0c%4$s\uff1a%5$s\uff0c%6$s\uff0c%7$s\uff0c\u8d26\u7c3f\u7ea7\u53c2\u6570\u4fee\u6539\u6210\u529f\u3002", (String)"CalAccountParamsModifyPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        String caption = ResManager.loadKDString((String)"\u4fee\u6539", (String)"CalAccountParamsListPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        this.writeLog(endinitcheck, endaccountcheck, endcalinvcheck, costAccountIds, costAccountNameMap, msg, caption);
    }

    private void writeLog(String endinitcheck, String endaccountcheck, String endcalinvcheck, Collection set, Map<Object, String> costAccountNameMap, String msg, String operationName) {
        HashSet<String> costAccountNames = new HashSet<String>(16);
        for (Object aLong : set) {
            costAccountNames.add("\u3010" + costAccountNameMap.get(aLong) + "\u3011");
            if (costAccountNames.size() < 5) continue;
            break;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_accountparams");
        Map allFields = dataEntityType.getAllFields();
        ComboProp endinitcheck1 = (ComboProp)allFields.get("endinitcheck");
        LocaleString displayName = endinitcheck1.getDisplayName();
        String itemByName = endinitcheck1.getItemByName(endinitcheck);
        ComboProp endaccountcheck2 = (ComboProp)allFields.get("endaccountcheck");
        LocaleString displayName2 = endaccountcheck2.getDisplayName();
        String itemByName2 = endaccountcheck2.getItemByName(endaccountcheck);
        ComboProp endcalinvcheck3 = (ComboProp)allFields.get("endcalinvcheck");
        LocaleString displayName3 = endcalinvcheck3.getDisplayName();
        String itemByName3 = endcalinvcheck3.getItemByName(endcalinvcheck);
        String costAccountIdStr = String.join((CharSequence)"\u3001", costAccountNames);
        if (set.size() > 5) {
            String str = ResManager.loadKDString((String)"\u7b49", (String)"CalAccountParamsListPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            costAccountIdStr = costAccountIdStr + str;
        }
        String format = String.format(msg, costAccountIdStr, displayName, itemByName, displayName2, itemByName2, displayName3, itemByName3);
        CalLogInfo calLogInfo = CalLogUtils.buildCalAppLog((String)"cal_accountparams", (String)operationName, (String)format, (long)RequestContext.get().getOrgId());
        CalLogUtils.addLog((CalLogInfo)calLogInfo);
    }
}

