/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting.costprice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.MaterielProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BillFilterPlugin
extends AbstractFormPlugin {
    public static final String FormId_BillFilterEdit = "cal_billfilter";
    public static final String CacheKey_BillFilter = "xxxx";
    public static final String BillFilter_entityNumber = "entityNumber";
    public static final String CustParamKey_FilterJson = "sdfasdfasdfasd";
    public static final String BillFilterStr = "billfilterstr";
    public static final String KEY_FILTER_VALUE = "filtervalue";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    private static final String Key_filtergridap = "filtergridap";
    private Map<String, Object> returnMap = new HashMap<String, Object>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityObject = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        if (StringUtils.isBlank((CharSequence)entityObject)) {
            return;
        }
        this.initFilterCondition(entityObject);
        String filterJson = (String)this.getView().getFormShowParameter().getCustomParam(BillFilterStr);
        if (!StringUtils.isBlank((CharSequence)filterJson)) {
            this.setDataFilter(filterJson);
        }
    }

    private void initFilterCondition(String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        this.removeInvalidColumns(filterColumns, entityType);
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(fc);
        this.getView().updateView(Key_filtergridap);
    }

    private void removeInvalidColumns(List<Map<String, Object>> filterColumns, MainEntityType entityType) {
        String filtertype = (String)this.getView().getFormShowParameter().getCustomParam("filtertype");
        HashSet<Map<String, Object>> removeSet = new HashSet<Map<String, Object>>(16);
        if ("billnofilter".equals(filtertype)) {
            for (Map<String, Object> map : filterColumns) {
                List compareTypeList = (List)map.get("compareTypes");
                ArrayList<CompareTypeDto> newcompareTypeList = new ArrayList<CompareTypeDto>(16);
                for (CompareTypeDto compareTypeDto : compareTypeList) {
                    String id = compareTypeDto.getId();
                    if (!"67".equals(id) && !"17".equals(id)) continue;
                    newcompareTypeList.add(compareTypeDto);
                }
                map.put("compareTypes", newcompareTypeList);
                String fieldName = (String)map.get("fieldName");
                if ("billno".equals(fieldName) || fieldName.contains("bizentityobject") || fieldName.contains("biztype") || fieldName.contains("invscheme") || fieldName.contains("billtype")) continue;
                removeSet.add(map);
            }
        } else {
            Object mateialField = entityType.getAllFields().get("material");
            if (mateialField == null || !(mateialField instanceof MaterielProp)) {
                return;
            }
            MaterielProp materielProp = (MaterielProp)mateialField;
            if ("bd_materialinventoryinfo".equals(materielProp.getBaseEntityId())) {
                for (Map<String, Object> map : filterColumns) {
                    if (!"material.number".equals(map.get("fieldName")) && !"material.name".equals(map.get("fieldName"))) continue;
                    removeSet.add(map);
                }
            }
        }
        filterColumns.removeAll(removeSet);
    }

    private void setDataFilter(String dataFilter) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)dataFilter, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(Key_filtergridap);
        filterGrid.SetValue(filterCondition);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            this.returnDataToParent();
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        this.returnMap.put("filter", filterString);
        Integer rowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowIndex");
        if (rowIndex != null) {
            this.returnMap.put("rowIndex", rowIndex);
        }
        this.getView().returnDataToParent(this.returnMap);
        this.getView().close();
    }
}

