/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting.costprice;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CostPricePlugin
extends AbstractFormPlugin {
    private static final String BILLFILTER = "billfilterdesc";
    private static final String PRICELIB = "pricelib";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter params = (BaseShowParameter)e.getSource();
        params.setPkId((Object)752057291171328000L);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PRICELIB, BILLFILTER});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("name", (Object)ResManager.loadKDString((String)"\u6210\u672c\u4ef7\u7c7b\u522b", (String)"CostPricePlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        this.getModel().setValue(PRICELIB, (Object)ResManager.loadKDString((String)"\u5355\u4ef7\u7c7b\u522b", (String)"CostPricePlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        this.getModel().setDataChanged(false);
        this.initPrice();
    }

    private void initPrice() {
        QFilter qpricelib = new QFilter("id", "=", (Object)747819409392815104L);
        DynamicObjectCollection prices = QueryServiceHelper.query((String)"cal_pricelib", (String)"entry.pricenum,entry.pricename,entry.entityobject.id", (QFilter[])qpricelib.toArray());
        ArrayList<ComboItem> priceLibItems = new ArrayList<ComboItem>();
        for (DynamicObject price : prices) {
            priceLibItems.add(new ComboItem(new LocaleString(price.getString("entry.pricename")), price.getString("entry.pricenum")));
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("entry");
        List list = grid.getControls();
        for (Control control : list) {
            if (!"prices".equals(control.getKey())) continue;
            ((ComboEdit)control).setComboItems(priceLibItems);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (!(source instanceof TextEdit)) {
            return;
        }
        TextEdit textEdit = (TextEdit)source;
        String key = textEdit.getFieldKey();
        if ("pricenum".equals(key)) {
            int rowIndex = e.getRowIndex();
            String oldvalue = (String)this.getModel().getValue("pricenum", rowIndex);
            String newvalue = (String)e.getValue();
            if (StringUtils.isNotEmpty((String)oldvalue)) {
                QFilter qFilter = new QFilter("entry.costprice", "=", (Object)oldvalue);
                HashSet<String> schemeNums = new HashSet<String>(16);
                try (DataSet priceSchemeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_pricescheme", (String)"number", (QFilter[])qFilter.toArray(), null);){
                    for (Row row : priceSchemeDataSet) {
                        String schemeNum = row.getString("number");
                        if (!StringUtils.isNotEmpty((String)schemeNum)) continue;
                        schemeNums.add(schemeNum);
                    }
                }
                if (!schemeNums.isEmpty()) {
                    e.setCancel(true);
                    this.getView().updateView("pricenum", rowIndex);
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\uff1a{0}\u5f15\u7528\u4e86\u8be5\u6210\u672c\u4ef7\u7c7b\u522b\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u3002", (String)"CostPricePlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", schemeNums));
                    this.getView().showTipNotification(msg);
                }
            }
            if (StringUtils.isNotEmpty((String)newvalue)) {
                DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
                for (DynamicObject dynamicObject : entry) {
                    int seq = dynamicObject.getInt("seq") - 1;
                    String pricenum = dynamicObject.getString("pricenum");
                    if (rowIndex == seq) {
                        return;
                    }
                    if (!newvalue.equals(pricenum)) continue;
                    e.setCancel(true);
                    this.getView().updateView("pricenum", rowIndex);
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u4ef7\u7c7b\u522b\u4e0e\u7b2c{0}\u884c\u7684\u6210\u672c\u4ef7\u7c7b\u522b\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostPricePlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), seq + 1);
                    this.getView().showTipNotification(msg);
                }
            }
        } else if (PRICELIB.equals(key)) {
            e.setCancel(true);
            this.getView().updateView(PRICELIB);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PRICELIB.equals(key)) {
            this.doPriceLibClick(evt);
        } else if (BILLFILTER.equals(key)) {
            this.doBillFilterClick(evt);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("deleteentry".equals(key)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entry");
            int[] selectRowIndex = grid.getEntryState().getSelectedRows();
            HashSet<String> pricenums = new HashSet<String>(16);
            for (int i : selectRowIndex) {
                String pricenum = (String)this.getModel().getValue("pricenum", i);
                if (!StringUtils.isNotEmpty((String)pricenum)) continue;
                pricenums.add(pricenum);
            }
            if (pricenums.isEmpty()) {
                return;
            }
            QFilter qFilter = new QFilter("entry.costprice", "in", pricenums);
            HashSet<String> schemeNums = new HashSet<String>(16);
            try (DataSet priceSchemeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_pricescheme", (String)"number", (QFilter[])qFilter.toArray(), null);){
                for (Row row : priceSchemeDataSet) {
                    String schemeNum = row.getString("number");
                    if (!StringUtils.isNotEmpty((String)schemeNum)) continue;
                    schemeNums.add(schemeNum);
                }
            }
            if (!schemeNums.isEmpty()) {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\uff1a{0}\u5f15\u7528\u4e86\u8be5\u6210\u672c\u4ef7\u7c7b\u522b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CostPricePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", schemeNums));
                throw new KDBizException(msg);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null && BILLFILTER.equals(key)) {
            int rowIndex = (Integer)returnData.get("rowIndex");
            this.getModel().setValue("billfilter_tag", (Object)((String)returnData.get("filter")), rowIndex);
        }
    }

    private void doBillFilterClick(EventObject evt) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobject", rowIndex);
        if (entityObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"CostPricePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String entityObjectId = (String)entityObject.getPkValue();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_billfilter");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String filterstr = (String)this.getModel().getValue("billfilter_tag", rowIndex);
        showParameter.getCustomParams().put("entityNumber", entityObjectId);
        showParameter.getCustomParams().put("billfilterstr", filterstr);
        showParameter.getCustomParams().put("rowIndex", rowIndex);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BILLFILTER));
        this.getView().showForm(showParameter);
    }

    private void doPriceLibClick(EventObject evt) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("cal_pricelib");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callbackid_mycallback"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPkId((Object)747819409392815104L);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("entityobject".equals(key)) {
            this.entityObjectChanged(e);
        }
    }

    private void entityObjectChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String costPriceNum = (String)this.getModel().getValue("pricenum", rowIndex);
        QFilter priceSchemeFilter = new QFilter("entry.costprice", "=", (Object)costPriceNum);
        DynamicObjectCollection priceSchemes = QueryServiceHelper.query((String)"cal_pricescheme", (String)"number", (QFilter[])priceSchemeFilter.toArray());
        HashSet<String> priceSchemeNums = new HashSet<String>(16);
        for (DynamicObject dynamicObject : priceSchemes) {
            priceSchemeNums.add(dynamicObject.getString("number"));
        }
        if (!priceSchemeNums.isEmpty()) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\uff1a{0}\u5f15\u7528\u4e86\u8be5\u6210\u672c\u4ef7\u7c7b\u522b\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"CostPricePlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", priceSchemeNums));
            throw new KDBizException(msg);
        }
    }
}

