/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting.costprice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.constant.PriceObjectConstants;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class CostPriceSchemePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final long PRICELIB_PAGEID = 747819409392815104L;
    private static final long COSTPRICE_PAGEID = 752057291171328000L;
    private static final String BILLFILTER = "billfilterdesc";
    private static final String PRICELIB = "pricelib";
    public static final String KEY_COSTPRICE = "costprice";
    public static final String KEY_ENTRY = "entry";
    private static final String MUL_SUBELEMENT = "mulsubelement";
    private static final String PRICE_OBJECT = "priceobject";
    private static final String ENTITY_OBJECT = "entityobject";
    private static final String[] F7_NAMES = new String[]{"mulsubelement", "entityobject"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PRICELIB, BILLFILTER});
        this.addF7Listener(this, F7_NAMES);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPrice();
        this.setSublementPriceVisible(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (PRICE_OBJECT.equals(key)) {
            this.priceObjectChanged();
        } else if (KEY_COSTPRICE.equals(key)) {
            this.costPriceChanged();
        }
    }

    private void costPriceChanged() {
        int rowindex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
        String costPrice = (String)this.getModel().getValue(KEY_COSTPRICE, rowindex);
        if (StringUtils.isEmpty((String)costPrice)) {
            return;
        }
        String priceObject = (String)this.getModel().getValue(PRICE_OBJECT);
        this.setDestSrcPriceByCostPrice(priceObject, rowindex, costPrice);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
    }

    private void priceObjectChanged() {
        String priceObject = (String)this.getModel().getValue(PRICE_OBJECT);
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY);
        for (int rowindex = 0; rowindex < rowCount; ++rowindex) {
            String costPrice = (String)this.getModel().getValue(KEY_COSTPRICE, rowindex);
            this.setDestSrcPriceByCostPrice(priceObject, rowindex, costPrice);
        }
        this.setEntityObjectByPriceObject(priceObject);
        this.setSublementPriceVisible(false);
    }

    private void initPrice() {
        QFilter qcostprice = new QFilter("id", "=", (Object)752057291171328000L);
        DynamicObjectCollection costprices = QueryServiceHelper.query((String)"cal_costprice", (String)"entry.pricenum,entry.pricename,entry.entityobject.id", (QFilter[])qcostprice.toArray());
        ArrayList<ComboItem> costPriceItems = new ArrayList<ComboItem>();
        for (DynamicObject price : costprices) {
            costPriceItems.add(new ComboItem(new LocaleString(price.getString("entry.pricename")), price.getString("entry.pricenum")));
        }
        QFilter qpricelib = new QFilter("id", "=", (Object)747819409392815104L);
        DynamicObjectCollection prices = QueryServiceHelper.query((String)"cal_pricelib", (String)"entry.pricenum,entry.pricename,entry.entityobject.id", (QFilter[])qpricelib.toArray());
        ArrayList<ComboItem> priceLibItems = new ArrayList<ComboItem>();
        for (DynamicObject price : prices) {
            priceLibItems.add(new ComboItem(new LocaleString(price.getString("entry.pricename")), price.getString("entry.pricenum")));
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
        List list = grid.getControls();
        for (Control control : list) {
            if (KEY_COSTPRICE.equals(control.getKey())) {
                ((ComboEdit)control).setComboItems(costPriceItems);
                continue;
            }
            if ("srcprice".equals(control.getKey())) {
                ((ComboEdit)control).setComboItems(priceLibItems);
                continue;
            }
            if (!"destprice".equals(control.getKey())) continue;
            ((ComboEdit)control).setComboItems(priceLibItems);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PRICELIB.equals(key)) {
            this.doPriceLibClick(evt);
        } else if (BILLFILTER.equals(key)) {
            this.doBillFilterClick(evt);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (BILLFILTER.equals(key) && returnData != null) {
            this.getModel().setValue("billfilter_tag", (Object)((String)returnData.get("filter")));
        }
    }

    private void doBillFilterClick(EventObject evt) {
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue(ENTITY_OBJECT);
        if (entityObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9002\u7528\u5bf9\u8c61\u3002", (String)"CostPriceSchemePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String entityObjectId = String.valueOf(entityObject.getPkValue());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_billfilter");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String filterstr = (String)this.getModel().getValue("billfilter_tag");
        showParameter.getCustomParams().put("entityNumber", entityObjectId);
        showParameter.getCustomParams().put("billfilterstr", filterstr);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BILLFILTER));
        this.getView().showForm(showParameter);
    }

    private void doPriceLibClick(EventObject evt) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("cal_pricelib");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPkId((Object)747819409392815104L);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addF7Listener(BeforeF7SelectListener form, String[] f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "mulsubelement": {
                this.mulSubelementF7Select(e);
                break;
            }
            case "entityobject": {
                this.entityobjectF7Select(e);
                break;
            }
        }
    }

    private void mulSubelementF7Select(BeforeF7SelectEvent e) {
        QFilter costtypeq = new QFilter("syncflag", "=", (Object)"1");
        costtypeq.and("enable", "=", (Object)"1");
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(costtypeq);
    }

    private void entityobjectF7Select(BeforeF7SelectEvent e) {
        String priceObject = (String)this.getModel().getValue(PRICE_OBJECT);
        if (!StringUtils.isEmpty((String)priceObject)) {
            if ("A".equals(priceObject)) {
                QFilter costtypeq = new QFilter("id", "=", (Object)"cal_in_calculate");
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(costtypeq);
            } else if ("B".equals(priceObject)) {
                QFilter costtypeq = new QFilter("id", "=", (Object)"cal_in_expbillcost");
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(costtypeq);
            } else if ("D".equals(priceObject) || "E".equals(priceObject) || "H".equals(priceObject) || "I".equals(priceObject) || "K".equals(priceObject) || "L".equals(priceObject)) {
                QFilter costtypeq = new QFilter("id", "=", (Object)"cal_out_calculate");
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(costtypeq);
            } else if ("C".equals(priceObject)) {
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                DynamicObjectCollection billRules = QueryServiceHelper.query((String)"cal_calbillrule", (String)"sourcebill.id", (QFilter[])new QFilter[]{filter}, null);
                HashSet<String> sourcebillIdSet = new HashSet<String>(16);
                for (DynamicObject billRule : billRules) {
                    String sourcebillId = billRule.getString("sourcebill.id");
                    sourcebillIdSet.add(sourcebillId);
                }
                if (!sourcebillIdSet.isEmpty()) {
                    QFilter costtypeq = new QFilter("id", "in", sourcebillIdSet);
                    ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(costtypeq);
                }
            }
        }
    }

    private void setSrcPriceByPriceObject(int rowindex, String costPrice) {
        if ("YS-ZXRK-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-001", rowindex);
            this.getView().updateView("srcprice", rowindex);
        } else if ("YS-QCJQPJ-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-002", rowindex);
            this.getView().updateView("srcprice", rowindex);
        } else if ("YS-DQJQPJ-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-121", rowindex);
            this.getView().updateView("srcprice", rowindex);
        } else if ("YS-JSDJ-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-019", rowindex);
            this.getView().updateView("srcprice", rowindex);
        } else if ("YS-WQZXCK-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-001", rowindex);
            this.getView().updateView("srcprice", rowindex);
        } else if ("YS-SGLR-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-001", rowindex);
            this.getView().updateView("srcprice", rowindex);
        } else {
            this.getModel().setValue("srcprice", (Object)"ys-cal-001", rowindex);
            this.getView().updateView("srcprice", rowindex);
        }
    }

    private void setDestSrcPriceByCostPrice(String priceObject, int rowindex, String costPrice) {
        if (!PriceObjectConstants.checkInPriceObject((String)priceObject)) {
            this.getModel().setValue("destprice", (Object)"ys-cal-018", rowindex);
            this.getView().updateView("destprice", rowindex);
            this.setSrcPriceByPriceObject(rowindex, costPrice);
        } else if ("YS-SGLR-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("srcprice", rowindex);
            this.getModel().setValue("destprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("destprice", rowindex);
        } else if ("YS-QCJQPJ-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-008", rowindex);
            this.getView().updateView("srcprice", rowindex);
            this.getModel().setValue("destprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("destprice", rowindex);
        } else if ("YS-ZXRK-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("srcprice", rowindex);
            this.getModel().setValue("destprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("destprice", rowindex);
        } else if ("YS-WQZXCK-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("srcprice", rowindex);
            this.getModel().setValue("destprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("destprice", rowindex);
        } else if ("YS-DQJQPJ-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-013", rowindex);
            this.getView().updateView("srcprice", rowindex);
            this.getModel().setValue("destprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("destprice", rowindex);
        } else if ("YS-JSDJ-001".equals(costPrice)) {
            this.getModel().setValue("srcprice", (Object)"ys-cal-019", rowindex);
            this.getView().updateView("srcprice", rowindex);
            this.getModel().setValue("destprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("destprice", rowindex);
        } else {
            this.getModel().setValue("srcprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("srcprice", rowindex);
            this.getModel().setValue("destprice", (Object)"ys-cal-003", rowindex);
            this.getView().updateView("destprice", rowindex);
        }
    }

    private void setEntityObjectByPriceObject(String priceObject) {
        switch (priceObject) {
            case "A": {
                this.getModel().setValue(ENTITY_OBJECT, (Object)"cal_in_calculate");
                break;
            }
            case "B": {
                this.getModel().setValue(ENTITY_OBJECT, (Object)"cal_in_expbillcost");
                break;
            }
            case "D": {
                this.getModel().setValue(ENTITY_OBJECT, (Object)"cal_out_calculate");
                break;
            }
            case "E": {
                this.getModel().setValue(ENTITY_OBJECT, (Object)"cal_out_calculate");
                break;
            }
            case "H": {
                this.getModel().setValue(ENTITY_OBJECT, (Object)"cal_out_calculate");
                break;
            }
            case "I": {
                this.getModel().setValue(ENTITY_OBJECT, (Object)"cal_out_calculate");
                break;
            }
            case "K": {
                this.getModel().setValue(ENTITY_OBJECT, (Object)"cal_out_calculate");
                break;
            }
            case "L": {
                this.getModel().setValue(ENTITY_OBJECT, (Object)"cal_out_calculate");
                break;
            }
            case "C": {
                this.getModel().setValue(ENTITY_OBJECT, null);
                break;
            }
            case "G": {
                this.getModel().setValue(ENTITY_OBJECT, null);
                break;
            }
            case "J": {
                this.getModel().setValue(ENTITY_OBJECT, null);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setSublementPriceVisible(true);
    }

    private void setSublementPriceVisible(boolean updateprice) {
        Boolean isShowSublement = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.COST_SHCEME_SHOW_SUBLEMENT);
        if (isShowSublement != null && isShowSublement.booleanValue()) {
            String priceObject = (String)this.getModel().getValue(PRICE_OBJECT);
            if (!StringUtils.isEmpty((String)priceObject) && !PriceObjectConstants.checkInPriceObject((String)priceObject)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{MUL_SUBELEMENT});
                this.getModel().setValue(MUL_SUBELEMENT, null);
            } else if (!StringUtils.isEmpty((String)priceObject) && "C".equals(priceObject)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{MUL_SUBELEMENT});
                this.getModel().setValue(MUL_SUBELEMENT, null);
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{MUL_SUBELEMENT});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{MUL_SUBELEMENT});
        }
        if (updateprice) {
            Boolean isShowCostPrice = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.COST_SHCEME_SHOW_COSTPRICE);
            if (isShowCostPrice != null && isShowCostPrice.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"srcprice"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"destprice"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"srcprice"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"destprice"});
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        for (RowDataEntity row : e.getRowDataEntities()) {
            String priceObject = (String)this.getModel().getValue(PRICE_OBJECT);
            this.setDestSrcPriceByCostPrice(priceObject, row.getRowIndex(), null);
        }
    }
}

