/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting.costprice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ImportCostPriceSetPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean isDefaultScheme;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("isdefaultscheme".equals(key) && (isDefaultScheme = ((Boolean)this.getModel().getValue("isdefaultscheme")).booleanValue())) {
            this.getModel().setValue("costprice", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("isdefaultscheme", (Object)false);
    }

    public void beforeClick(BeforeClickEvent evt) {
        String costPrice;
        boolean isDefaultScheme;
        super.beforeClick(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if ("btnok".equals(key) && !(isDefaultScheme = ((Boolean)this.getModel().getValue("isdefaultscheme")).booleanValue()) && (costPrice = (String)this.getModel().getValue("costPrice")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u89c4\u5219\uff0c\u6216\u8005\u91c7\u7528\u9ed8\u8ba4\u7684\u53d6\u4ef7\u914d\u7f6e\u3002", (String)"ImportCostPriceSetPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        String costPriceNumber = "";
        HashMap<String, Object> param = new HashMap<String, Object>();
        if ("btnok".equals(key)) {
            boolean async = (Boolean)this.getModel().getValue("asyncgetprice");
            boolean isDefaultScheme = (Boolean)this.getModel().getValue("isdefaultscheme");
            if (!isDefaultScheme) {
                costPriceNumber = (String)this.getModel().getValue("costprice");
            }
            param.put("costprice", costPriceNumber);
            param.put("async", async);
        }
        this.getView().returnDataToParent(param);
        this.getView().close();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String qStr = (String)this.getView().getFormShowParameter().getCustomParam("costpricefilter");
        QFilter q = QFilter.of((String)qStr, (Object[])new Object[0]);
        q.and("enable", "=", (Object)"1");
        this.initCostPrice(q);
    }

    private void initCostPrice(QFilter q) {
        DynamicObjectCollection costPrices = QueryServiceHelper.query((String)"cal_pricescheme", (String)"entry.costprice", (QFilter[])q.toArray());
        ArrayList<String> cps = new ArrayList<String>();
        for (DynamicObject cp : costPrices) {
            cps.add(cp.getString("entry.costprice"));
        }
        QFilter qcostprice = new QFilter("id", "=", (Object)752057291171328000L);
        qcostprice.and("entry.pricenum", "in", cps);
        DynamicObjectCollection costprices = QueryServiceHelper.query((String)"cal_costprice", (String)"entry.pricenum,entry.pricename,entry.entityobject.id", (QFilter[])qcostprice.toArray());
        ArrayList<ComboItem> costPriceItems = new ArrayList<ComboItem>();
        for (DynamicObject price : costprices) {
            costPriceItems.add(new ComboItem(new LocaleString(price.getString("entry.pricename")), price.getString("entry.pricenum")));
        }
        Control control = this.getView().getControl("costprice");
        ((ComboEdit)control).setComboItems(costPriceItems);
    }
}

