/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting.costprice;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.BillTreeBuildParameter;
import kd.fi.cal.common.helper.EntityParseHelper;

public class PriceLibPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(PriceLibPlugin.class);
    private static final String PRICE = "pricetranexpr";
    private static final String op = "[\\+\\-\\*\\/\\(\\)\\s]";

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        if (PRICE.equals(key) && returnData != null) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)((String)returnData), CRFormula.class);
            this.getModel().setValue("priceexp_tag", (Object)formula.getExpression(), rowIndex);
            this.getModel().setValue(PRICE, (Object)formula.getExprDesc(), rowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try {
            int count = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < count; ++i) {
                String[] fields;
                DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobject", i);
                if (entityObject == null) continue;
                String entityNumber = entityObject.getString("number");
                boolean isDetail = (Boolean)this.getModel().getValue("isdetail", i);
                if (isDetail && ("cal_costrecord".equals(entityNumber) || "cal_costrecord_subentity".equals(entityNumber))) {
                    entityNumber = "cal_costrecord_detail";
                }
                if (isDetail && "cal_balance".equals(entityNumber)) {
                    entityNumber = "cal_balance_detail";
                }
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                Map allFields = entityType.getAllFields();
                String priceExp = (String)this.getModel().getValue("priceexp_tag", i);
                for (String field : fields = priceExp.split(op)) {
                    IDataEntityProperty property;
                    if (!StringUtils.isNotEmpty((String)field) || (property = (IDataEntityProperty)allFields.get(field)) == null) continue;
                    String fullCaption = property.getDisplayName().getLocaleValue();
                    if (StringUtils.isNotEmpty((String)fullCaption)) {
                        String reg = "^aa(?=[\\)*\\+\\-\\*\\/\\s*])|(?<=[(\\+\\-\\*\\/\\s*])aa(?=[\\)*\\+\\-\\*\\/\\s*])|(?<=[\\+\\-\\*\\/\\s*])aa$|^aa$";
                        priceExp = priceExp.replaceAll(reg.replace("aa", field), fullCaption);
                    }
                    this.getModel().setValue(PRICE, (Object)priceExp, i);
                }
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PRICE.equals(key)) {
            this.doAmountFormulaClick(evt);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("deleteentry".equals(key)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entry");
            int[] selectRowIndex = grid.getEntryState().getSelectedRows();
            HashSet<String> pricenums = new HashSet<String>(16);
            for (int i : selectRowIndex) {
                String pricenum = (String)this.getModel().getValue("pricenum", i);
                if (!StringUtils.isNotEmpty((String)pricenum)) continue;
                pricenums.add(pricenum);
            }
            if (pricenums.isEmpty()) {
                return;
            }
            QFilter qFilter = new QFilter("entry.srcprice", "in", pricenums);
            qFilter.or("entry.destprice", "in", pricenums);
            HashSet<String> schemeNums = new HashSet<String>(16);
            try (DataSet priceSchemeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_pricescheme", (String)"number,entry.srcprice,entry.destprice", (QFilter[])qFilter.toArray(), null);){
                for (Row row : priceSchemeDataSet) {
                    String schemeNum = row.getString("number");
                    if (!StringUtils.isNotEmpty((String)schemeNum)) continue;
                    schemeNums.add(schemeNum);
                }
            }
            if (!schemeNums.isEmpty()) {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\uff1a{0}\u5f15\u7528\u4e86\u8be5\u5355\u4ef7\u7c7b\u522b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PriceLibPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", schemeNums));
                throw new KDBizException(msg);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (!(source instanceof TextEdit)) {
            return;
        }
        TextEdit textEdit = (TextEdit)source;
        String key = textEdit.getFieldKey();
        if ("pricenum".equals(key)) {
            int rowIndex = e.getRowIndex();
            String oldvalue = (String)this.getModel().getValue("pricenum", rowIndex);
            String newvalue = (String)e.getValue();
            if (StringUtils.isNotEmpty((String)oldvalue)) {
                QFilter qFilter = new QFilter("entry.srcprice", "=", (Object)oldvalue);
                qFilter.or("entry.destprice", "=", (Object)oldvalue);
                HashSet<String> schemeNums = new HashSet<String>(16);
                try (DataSet priceSchemeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_pricescheme", (String)"number,entry.srcprice,entry.destprice", (QFilter[])qFilter.toArray(), null);){
                    for (Row row : priceSchemeDataSet) {
                        String schemeNum = row.getString("number");
                        if (!StringUtils.isNotEmpty((String)schemeNum)) continue;
                        schemeNums.add(schemeNum);
                    }
                }
                if (!schemeNums.isEmpty()) {
                    e.setCancel(true);
                    this.getView().updateView("pricenum", rowIndex);
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\uff1a{0}\u5f15\u7528\u4e86\u8be5\u5355\u4ef7\u7c7b\u522b\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u3002", (String)"PriceLibPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", schemeNums));
                    this.getView().showTipNotification(msg);
                }
            }
            if (StringUtils.isNotEmpty((String)newvalue)) {
                DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
                for (DynamicObject dynamicObject : entry) {
                    int seq = dynamicObject.getInt("seq") - 1;
                    String pricenum = dynamicObject.getString("pricenum");
                    if (rowIndex == seq) {
                        return;
                    }
                    if (!newvalue.equals(pricenum)) continue;
                    e.setCancel(true);
                    this.getView().updateView("pricenum", rowIndex);
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u5355\u4ef7\u7c7b\u522b\u4e0e\u7b2c{0}\u884c\u7684\u5355\u4ef7\u7c7b\u522b\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PriceLibPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), seq + 1);
                    this.getView().showTipNotification(msg);
                }
            }
        }
    }

    private void doAmountFormulaClick(EventObject evt) {
        String entityNumber;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_expression");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobject", rowIndex);
        if (entityObject != null) {
            entityNumber = entityObject.getString("number");
            boolean isDetail = (Boolean)this.getModel().getValue("isdetail");
            if (isDetail && ("cal_costrecord".equals(entityNumber) || "cal_costrecord_subentity".equals(entityNumber))) {
                entityNumber = "cal_costrecord_detail";
            }
            if (isDetail && "cal_balance".equals(entityNumber)) {
                entityNumber = "cal_balance_detail";
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"PriceLibPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(true);
        TreeNode nodes = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter[])new BillTreeBuildParameter[]{parameter});
        String nodesJson = SerializationUtils.toJsonString((Object)nodes);
        CRFormula amount = new CRFormula();
        amount.setExpression((String)this.getModel().getValue("priceexp_tag", rowIndex));
        amount.setExprTran((String)this.getModel().getValue(PRICE, rowIndex));
        String amountstr = SerializationUtils.toJsonString((Object)amount);
        showParameter.getCustomParams().put("formula", amountstr);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, PRICE);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PRICE});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("entityobject".equals(key)) {
            this.entityObjectChanged(e);
        }
    }

    private void entityObjectChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String priceNum = (String)this.getModel().getValue("pricenum", rowIndex);
        QFilter priceSchemeFilter = new QFilter("entry.srcprice", "=", (Object)priceNum);
        priceSchemeFilter.or("entry.destprice", "=", (Object)priceNum);
        DynamicObjectCollection priceSchemes = QueryServiceHelper.query((String)"cal_pricescheme", (String)"number", (QFilter[])priceSchemeFilter.toArray());
        HashSet<String> priceSchemeNums = new HashSet<String>(16);
        for (DynamicObject dynamicObject : priceSchemes) {
            priceSchemeNums.add(dynamicObject.getString("number"));
        }
        if (!priceSchemeNums.isEmpty()) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\uff1a{0}\u5f15\u7528\u4e86\u8be5\u5355\u4ef7\u7c7b\u522b\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"PriceLibPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", priceSchemeNums));
            throw new KDBizException(msg);
        }
    }
}

