/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.std;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;

public class RepairStandardCostPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("calrange".equals(key)) {
            this.beforeF7Select4Calrange(e);
        } else if ("storageorgunit".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("materialfrom".equals(key)) {
            this.beforeF7Select4Mulmaterial(e);
        }
    }

    private void beforeF7Select4Calrange(BeforeF7SelectEvent e) {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costaccount != null) {
            q = new QFilter("costaccount", "=", costaccount.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_repairstandardcost", (String)"4730fc9f000025ae");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Mulmaterial(BeforeF7SelectEvent e) {
        QFilter q = new QFilter("status", "=", (Object)"C");
        q.and("enable", "=", (Object)Boolean.TRUE);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("materialfrom".equals(key)) {
            this.materialChanged();
        } else if ("calorg".equals(key)) {
            this.calOrgChanged();
        }
    }

    private void calOrgChanged() {
        this.getModel().setValue("storageorgunit", null);
        this.getModel().setValue("calrange", null);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getModel().setValue("costaccount", null);
        } else {
            QFilter q = new QFilter("calorg", "=", calOrg.getPkValue());
            q.and("enable", "=", (Object)Character.valueOf('1'));
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem,calpolicy,calpolicy.currency,dividebasis,ismainaccount,enable", (QFilter[])q.toArray());
            DynamicObject mainCostAccount = null;
            if (costAccounts == null || costAccounts.isEmpty()) {
                this.getModel().setValue("costaccount", null);
                return;
            }
            mainCostAccount = (DynamicObject)costAccounts.get(0);
            for (DynamicObject costAccount : costAccounts) {
                if (!costAccount.getBoolean("ismainaccount")) continue;
                mainCostAccount = costAccount;
                break;
            }
            if (mainCostAccount != null) {
                this.getModel().setValue("costaccount", (Object)mainCostAccount.getLong("id"));
            } else {
                this.getModel().setValue("costaccount", null);
            }
        }
    }

    private void materialChanged() {
        DynamicObjectCollection coll = (DynamicObjectCollection)this.getModel().getValue("materialfrom");
        if (coll != null && coll.size() > 0 && coll.size() <= 1) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialto"});
            this.getModel().setValue("materialto", (Object)((DynamicObject)coll.get(0)).getDynamicObject("fbasedataid"));
        } else {
            this.getModel().setValue("materialto", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialto"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "costaccount", "calorg", "calrange", "storageorgunit", "materialfrom");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void costAccountChanged() {
        this.getModel().setValue("calrange", null);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("period", null);
            return;
        }
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        this.getModel().setValue("period", period == null ? period : period.getPkValue());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_repairstandardcost", (String)"4730fc9f000025ae");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            this.calOrgChanged();
        }
    }
}

