/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.std;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.log.CalLogInfo;
import kd.fi.cal.common.log.CalLogUtils;

public class StdCostDiffReCalPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("owner".equals(key)) {
            this.beforeF7Select4Owner(e);
        } else if ("storageorgunit".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("warehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if ("materialfrom".equals(key)) {
            this.beforeF7Select4Mulmaterial(e);
        }
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        DynamicObjectCollection sous = (DynamicObjectCollection)this.getModel().getValue("storageorgunit");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (sous != null && sous.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : sous) {
                Long[] warehouseIds;
                Long[] longArray = warehouseIds = SCMHelper.getAllWarehouseIDs((String)info.getDynamicObject("fbasedataid").getString("number"));
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long id = longArray[i];
                    set.add(id);
                }
            }
            q = new QFilter("id", "in", set);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_balance_recal", (String)"4730fc9f000025ae");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Mulmaterial(BeforeF7SelectEvent e) {
        QFilter q = new QFilter("status", "=", (Object)"C");
        q.and("enable", "=", (Object)Boolean.TRUE);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("materialfrom".equals(key)) {
            this.materialChanged();
        } else if ("calorg".equals(key)) {
            this.calOrgChanged();
        } else if ("storageorgunit".equals(key)) {
            this.storageOrgChanged();
        }
    }

    private void storageOrgChanged() {
        this.getModel().setValue("warehouse", null);
    }

    private void calOrgChanged() {
        this.getModel().setValue("storageorgunit", null);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getModel().setValue("costaccount", null);
        } else {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                this.getModel().setValue("costaccount", null);
            }
        }
    }

    private void materialChanged() {
        DynamicObjectCollection coll = (DynamicObjectCollection)this.getModel().getValue("materialfrom");
        if (coll != null && coll.size() <= 1) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialto"});
        } else {
            this.getModel().setValue("materialto", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialto"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "costaccount", "calorg", "owner", "storageorgunit", "warehouse", "materialfrom");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("period", null);
            return;
        }
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        this.getModel().setValue("period", period == null ? period : period.getPkValue());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_purrpricediff_recal", (String)"4730fc9f000025ae");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"owner", "storageorgunit", "warehouse"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("recal".equals(key) && e.getOperationResult().isSuccess()) {
            DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
            StringBuilder description = new StringBuilder();
            this.buildLogDescription(description);
            description.append(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u4f59\u989d\u91cd\u7b97\u6210\u529f\u3002", (String)"BalanceReCalPlugin_9", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            CalLogUtils.addLog((CalLogInfo)CalLogUtils.buildCalAppLog((String)"cal_balance_recal", (String)ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u4f59\u989d\u91cd\u7b97", (String)"BalanceReCalPlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0]), (String)description.toString(), (long)calOrg.getLong("id")));
        }
    }

    private StringBuilder buildLogDescription(StringBuilder description) {
        DynamicObjectCollection materialFroms;
        int maxSize = 10;
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        description.append(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"BalanceReCalPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(costAccount.getString("name")).append('\u3011');
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        description.append(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4", (String)"HomePlugin_30", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(period.getString("name")).append('\u3011');
        if (((DynamicObjectCollection)this.getModel().getValue("owner")).size() > 0) {
            description.append(ResManager.loadKDString((String)"\u8d27\u4e3b", (String)"BalanceReCalPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("owner", "name", maxSize)).append('\u3011');
        }
        if (((DynamicObjectCollection)this.getModel().getValue("storageorgunit")).size() > 0) {
            description.append(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7", (String)"BalanceReCalPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("storageorgunit", "name", maxSize)).append('\u3011');
        }
        if (((DynamicObjectCollection)this.getModel().getValue("warehouse")).size() > 0) {
            if (((DynamicObjectCollection)this.getModel().getValue("storageorgunit")).size() > 0) {
                description.append(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7", (String)"BalanceReCalPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("storageorgunit", "name", maxSize)).append('\u3011');
            }
            description.append(ResManager.loadKDString((String)"\u4ed3\u5e93", (String)"BalanceReCalPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("warehouse", "name", maxSize)).append('\u3011');
        }
        if ((materialFroms = (DynamicObjectCollection)this.getModel().getValue("materialfrom")).size() > 1) {
            description.append(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"BalanceReCalPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("materialfrom", "number", maxSize)).append('\u3011');
            description.append(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"BalanceReCalPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("materialfrom", "name", maxSize)).append('\u3011');
        } else {
            DynamicObject materialTo;
            boolean hasMaterial = false;
            QFilter q = new QFilter("1", "=", (Object)1);
            if (materialFroms.size() == 1) {
                q.and(new QFilter("number", ">=", (Object)((DynamicObject)materialFroms.get(0)).getDynamicObject("fbasedataid").getString("number")));
                hasMaterial = true;
            }
            if ((materialTo = (DynamicObject)this.getModel().getValue("materialto")) != null) {
                q.and("number", "<=", (Object)materialTo.getString("number"));
                hasMaterial = true;
            }
            if (hasMaterial) {
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,number,name", (QFilter[])q.toArray(), null);){
                    String names = "";
                    StringBuilder nameBuilder = new StringBuilder(32);
                    String numbers = "";
                    StringBuilder numbersBuilder = new StringBuilder(32);
                    int i = 0;
                    for (Row row : dataSet) {
                        if (i >= maxSize) break;
                        nameBuilder.append(row.getString("name"));
                        nameBuilder.append(',');
                        numbersBuilder.append(row.getString("number"));
                        numbersBuilder.append(',');
                        ++i;
                    }
                    if (nameBuilder.length() > 0) {
                        names = nameBuilder.substring(0, nameBuilder.length() - 1);
                    }
                    if (numbersBuilder.length() > 0) {
                        numbers = numbersBuilder.substring(0, numbersBuilder.length() - 1);
                    }
                    if (i >= maxSize) {
                        names = names + "\u3002\u3002\u3002";
                        numbers = numbers + "\u3002\u3002\u3002";
                    }
                    description.append(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"BalanceReCalPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(numbers).append('\u3011');
                    description.append(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"BalanceReCalPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(names).append('\u3011');
                }
            }
        }
        return description;
    }

    private String getNames(String col, String field, int maxSize) {
        DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(col);
        String names = "";
        StringBuilder nameBuilder = new StringBuilder(32);
        int i = 0;
        for (DynamicObject info : colls) {
            if (i >= maxSize) break;
            nameBuilder.append(info.getDynamicObject("fbasedataid").getString(field));
            nameBuilder.append(',');
            ++i;
        }
        names = nameBuilder.substring(0, nameBuilder.length() - 1);
        if (i >= maxSize) {
            names = names + "\u3002\u3002\u3002";
        }
        return names;
    }
}

