/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.stocktype;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;

public class StockTypeUpdateHelper {
    private IAppCache CACHE = AppCache.get((String)"cal");
    public static final String MATCALINFO = "#matcalinfo#";
    private String pageOpTime;
    private Set<Object> calorgIds = null;
    private List<Long> enableCalorgIds = new ArrayList<Long>(4);
    private Set<Object> materialIds = null;
    private Set<Object> entityIds = null;
    private boolean containspre = false;
    private boolean containsinit = false;
    private List<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>(4);
    private List<String> batchstrs = new ArrayList<String>(4);

    public StockTypeUpdateHelper(Set<Object> calorgIds, Set<Object> materialIds, Set<Object> entityIds, boolean containspre, boolean containsinit, String pageOpTime) {
        this.calorgIds = calorgIds;
        this.materialIds = materialIds;
        this.entityIds = entityIds;
        this.containspre = containspre;
        this.containsinit = containsinit;
        this.pageOpTime = pageOpTime;
    }

    public void construactTaskParams() {
        this.initParam();
        if (this.enableCalorgIds == null || this.enableCalorgIds.isEmpty()) {
            return;
        }
        this.cacheAllMaterialCalInfo();
        int size = this.paramsList.size();
        int i = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Map<String, Object> map : this.paramsList) {
            Set materialIds = (Set)map.get("materialIds");
            String begindate = (String)map.get("begindate");
            String enddate = (String)map.get("enddate");
            String batchStr = String.format("[%s]-[%s/%s]-[%s]-[%s~%s]-[%s]", map.get("costAccountNum"), ++i, size, map.get("periodEq"), begindate == null ? null : sdf.format(Long.parseLong(begindate)), enddate == null ? null : sdf.format(Long.parseLong(enddate)), materialIds == null ? 0 : materialIds.size());
            this.batchstrs.add(batchStr);
            map.put("BATCHSTR", batchStr);
        }
    }

    private void cacheAllMaterialCalInfo() {
        Long[] allorgIdArr;
        OrmInput input;
        ArrayList<String> splitFilters = new ArrayList<String>(4);
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        QFilter filter = new QFilter("status", "=", (Object)"C");
        QFilter materialFilter = new QFilter("masterid", "in", this.materialIds);
        QFilter publicFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
        splitFilters.add(publicFilter.toString());
        if (this.materialIds != null && !this.materialIds.isEmpty()) {
            input = new OrmInput(this.getClass().getName(), "bd_materialcalinfo", "createorg,masterid,ctrlstrategy,group", new QFilter[]{filter, publicFilter, materialFilter});
            inputs.add(input);
        } else {
            input = new OrmInput(this.getClass().getName(), "bd_materialcalinfo", "createorg,masterid,ctrlstrategy,group", new QFilter[]{filter, publicFilter});
            inputs.add(input);
        }
        HashSet<Long> allorgIds = new HashSet<Long>(4);
        allorgIds.addAll(this.enableCalorgIds);
        Map ownersByCalorgIds = AccountingSysHelper.getOwnersByCalorgIds(new HashSet<Long>(this.enableCalorgIds));
        for (Set set : ownersByCalorgIds.values()) {
            allorgIds.addAll(set);
        }
        for (Long l : this.enableCalorgIds) {
            allorgIds.addAll(OrgHelper.getStorageOrgUnitByCalOrg((Long)l));
        }
        for (Long calorgId : allorgIdArr = allorgIds.toArray(new Long[0])) {
            QFilter privateFilter = new QFilter("ctrlstrategy", "=", (Object)"7");
            privateFilter.and("createorg", "=", (Object)calorgId);
            splitFilters.add(privateFilter.toString());
            if (this.materialIds != null && !this.materialIds.isEmpty()) {
                OrmInput input2 = new OrmInput(this.getClass().getName(), "bd_materialcalinfo", "createorg,masterid,ctrlstrategy,group", new QFilter[]{filter, privateFilter, materialFilter});
                inputs.add(input2);
                continue;
            }
            OrmInput input2 = new OrmInput(this.getClass().getName(), "bd_materialcalinfo", "createorg,masterid,ctrlstrategy,group", new QFilter[]{filter, privateFilter});
            inputs.add(input2);
        }
        DataSet dataSet = Algo.create((String)this.getClass().getName()).createDataSet(inputs.toArray(new Input[0]));
        DataSet[] dataSets = dataSet.splitByFilter(splitFilters.toArray(new String[0]), false);
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.STOCKTYPE_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
        for (int i = 0; i < dataSets.length; ++i) {
            DataSet dataSet2 = dataSets[i];
            CachedDataSet cache = dataSet2.cache(cacheHint);
            String cacheId = cache.getCacheId();
            if (i == 0) {
                this.CACHE.put(this.pageOpTime + MATCALINFO, (Object)cacheId);
                continue;
            }
            Long orgId = allorgIdArr[i - 1];
            this.CACHE.put(this.pageOpTime + MATCALINFO + orgId, (Object)cacheId);
        }
    }

    private void initParam() {
        QFilter capFilter = new QFilter("entry.costaccount.enable", "=", (Object)"1");
        if (this.calorgIds != null) {
            capFilter.and("org", "in", this.calorgIds);
        }
        HashSet<Long> allPeriodTypeIds = new HashSet<Long>(4);
        HashMap<Long, Long> costAccount2PeriodTypeMap = new HashMap<Long, Long>(4);
        HashMap<Long, Long> costAccount2OrgMap = new HashMap<Long, Long>(4);
        HashMap<Long, String> costAccount2NumMap = new HashMap<Long, String>(4);
        HashMap<Long, Long> costAccount2CurPeriodMap = new HashMap<Long, Long>(4);
        HashMap<Long, Long> costAccount2EnablePeriodMap = new HashMap<Long, Long>(4);
        Date minDate = null;
        Date maxDate = TimeServiceHelper.now();
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_sysctrlentity", (String)"org,entry.costaccount,entry.costaccount.number,entry.calpolicy.periodtype,entry.startperiod.periodyear,entry.startperiod.periodnumber,entry.currentperiod.periodyear,entry.currentperiod.periodnumber,entry.startperiod,entry.currentperiod,entry.startperiod.begindate,entry.currentperiod.enddate,entry.isenabled", (QFilter[])capFilter.toArray(), null);
        Object object = null;
        try {
            for (Row row : ds) {
                Long calorgId = row.getLong("org");
                Long costaccoutId = row.getLong("entry.costaccount");
                String costAccountNum = row.getString("entry.costaccount.number");
                Long periodtypeId = row.getLong("entry.calpolicy.periodtype");
                Long startperiod = row.getLong("entry.startperiod");
                Long currentperiod = row.getLong("entry.currentperiod");
                Date startBookdate = row.getDate("entry.startperiod.begindate");
                Date endBookdate = row.getDate("entry.currentperiod.enddate");
                if (startBookdate != null && (minDate == null || startBookdate.before(minDate))) {
                    minDate = startBookdate;
                }
                if (endBookdate != null && endBookdate.after(maxDate)) {
                    maxDate = endBookdate;
                }
                allPeriodTypeIds.add(periodtypeId);
                this.enableCalorgIds.add(calorgId);
                costAccount2OrgMap.put(costaccoutId, calorgId);
                costAccount2NumMap.put(costaccoutId, costAccountNum);
                costAccount2PeriodTypeMap.put(costaccoutId, periodtypeId);
                costAccount2CurPeriodMap.put(costaccoutId, currentperiod);
                costAccount2EnablePeriodMap.put(costaccoutId, startperiod);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Map<Long, List<DynamicObject>> periodtype2PeriodMap = this.getPeriodData(minDate, maxDate, allPeriodTypeIds);
        for (Map.Entry entry : costAccount2NumMap.entrySet()) {
            Long costAccountId = (Long)entry.getKey();
            String costAccountNum = (String)entry.getValue();
            Long periodType = (Long)costAccount2PeriodTypeMap.get(costAccountId);
            List<DynamicObject> periodList = periodtype2PeriodMap.get(periodType);
            Long enablePeriod = (Long)costAccount2EnablePeriodMap.get(costAccountId);
            Long curPeriod = (Long)costAccount2CurPeriodMap.get(costAccountId);
            Long calorg = (Long)costAccount2OrgMap.get(costAccountId);
            if (this.containspre) {
                this.addTaskContainsPre(enablePeriod, costAccountId, costAccountNum, periodList, calorg);
                continue;
            }
            this.addTaskNotContainsPre(enablePeriod, curPeriod, costAccountId, costAccountNum, periodList, calorg);
        }
    }

    private void addTaskNotContainsPre(Long enablePeriod, Long curPeriod, Long costAccountId, String costAccountNum, List<DynamicObject> periodList, Long calorg) {
        Date now = TimeServiceHelper.now();
        for (DynamicObject period : periodList) {
            Long periodId = period.getLong("id");
            Date begindate = period.getDate("begindate");
            Date enddate = period.getDate("enddate");
            int year = period.getInt("periodyear");
            int number = period.getInt("periodnumber");
            if (periodId.compareTo(enablePeriod) < 0) continue;
            if (begindate.after(now)) break;
            Integer periodnum = year * 100 + number;
            if (this.containsinit && periodId.equals(enablePeriod)) {
                this.addParams(costAccountId, costAccountNum, null, null, null, begindate, curPeriod, calorg, null, null);
            }
            if (this.containsinit && periodId.compareTo(curPeriod) < 0) {
                this.addParams(costAccountId, costAccountNum, null, null, begindate, enddate, curPeriod, calorg, periodId, null);
                continue;
            }
            if (periodId.compareTo(curPeriod) >= 0) {
                this.addParams(costAccountId, costAccountNum, periodnum, null, begindate, enddate, null, calorg, periodId, null);
            }
            if (enddate.compareTo(now) < 0 || begindate.compareTo(now) > 0) continue;
            this.addParams(costAccountId, costAccountNum, null, periodnum, enddate, null, null, calorg, null, periodId);
        }
    }

    private void addTaskContainsPre(Long enablePeriod, Long costAccountId, String costAccountNum, List<DynamicObject> periodList, Long calorg) {
        Date now = TimeServiceHelper.now();
        for (DynamicObject period : periodList) {
            Long periodId = period.getLong("id");
            Date begindate = period.getDate("begindate");
            Date enddate = period.getDate("enddate");
            int year = period.getInt("periodyear");
            int number = period.getInt("periodnumber");
            if (periodId.compareTo(enablePeriod) < 0) continue;
            if (begindate.after(now)) break;
            Integer periodnum = year * 100 + number;
            if (periodId.equals(enablePeriod)) {
                this.addParams(costAccountId, costAccountNum, 0, null, null, begindate, null, calorg, null, null);
            }
            this.addParams(costAccountId, costAccountNum, periodnum, null, begindate, enddate, null, calorg, periodId, null);
            if (!enddate.after(now) || !begindate.before(now)) continue;
            this.addParams(costAccountId, costAccountNum, null, periodnum, enddate, null, null, calorg, null, periodId);
        }
    }

    private void addParams(Long costAccountId, String costAccountNum, Integer periodEq, Integer periodLa, Date begindate, Date enddate, Long curPeriod, Long calorg, Long periodIdEq, Long periodIdLa) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("calorg", calorg);
        map.put("costAccountId", costAccountId);
        map.put("costAccountNum", costAccountNum);
        map.put("periodEq", periodEq);
        map.put("periodLa", periodLa);
        map.put("begindate", begindate == null ? null : begindate.getTime() + "");
        map.put("enddate", enddate == null ? null : enddate.getTime() + "");
        map.put("curPeriod", curPeriod == null ? null : curPeriod.toString());
        map.put("periodIdEq", periodIdEq == null ? null : periodIdEq.toString());
        map.put("periodIdLa", periodIdLa == null ? null : periodIdLa.toString());
        map.put("material", this.materialIds);
        map.put("entityIds", this.entityIds);
        map.put("pageOpTime", this.pageOpTime);
        this.paramsList.add(map);
    }

    private Map<Long, List<DynamicObject>> getPeriodData(Date minDate, Date maxDate, Set<Long> allPeriodTypeIds) {
        QFilter f = new QFilter("begindate", ">=", (Object)minDate);
        QFilter g = new QFilter("begindate", "<=", (Object)maxDate);
        QFilter t = new QFilter("periodtype", "in", allPeriodTypeIds);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,name,number,periodtype,begindate,enddate,periodyear,periodnumber", (QFilter[])new QFilter[]{f, g, t, q}, (String)"id asc");
        HashMap<Long, List<DynamicObject>> resultMap = new HashMap<Long, List<DynamicObject>>(4);
        for (DynamicObject period : periods) {
            Long periodtype = period.getLong("periodtype");
            List periodList = resultMap.computeIfAbsent(periodtype, k -> new ArrayList(4));
            periodList.add(period);
        }
        return resultMap;
    }

    public List<String> getBatchstrs() {
        return this.batchstrs;
    }

    public void dispatchBatchTask() {
        if (this.batchstrs.isEmpty()) {
            this.construactTaskParams();
        }
        for (Map<String, Object> map : this.paramsList) {
            String content;
            JobInfo job = new JobInfo();
            String opName = content = String.format(ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u91cd\u53d6", (String)"StockTypeUpdateHelper_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), new Object[0]);
            String batchStr = (String)map.get("BATCHSTR");
            job.setName(opName + "-" + batchStr);
            job.setJobType(JobType.REALTIME);
            job.setParams(map);
            job.setAppId("cal");
            job.setTaskClassname("kd.fi.cal.formplugin.stocktype.StockTypeUpdateTask");
            job.setRunByLang(Lang.get());
            String string = JobClient.dispatch((JobInfo)job);
        }
    }
}

