/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.stocktype;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.cal.formplugin.domain.MulTaskCache;
import kd.fi.cal.formplugin.stocktype.StockTypeUpdateHelper;
import org.apache.commons.lang3.StringUtils;

public class StockTypeUpdatePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getProgressBar().start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getProgressBar().addProgressListener((ProgresssListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String key = event.getOperateKey();
        if ("update".equals(key)) {
            if (!event.getOperationResult().isSuccess()) {
                return;
            }
            this.getModel().setValue("resultinfo", null);
            this.dispatchBatchTask();
        }
    }

    public void onProgress(ProgressEvent e) {
        String curOptime = new MulTaskCache().getPageOpTime(this.getView().getPageId());
        if (StringUtils.isBlank((CharSequence)curOptime)) {
            return;
        }
        MulTaskCache reCalCache = new MulTaskCache(curOptime);
        String curMsg = reCalCache.getAndRemoveBatchMsg();
        int percent = reCalCache.getPercent();
        if (percent >= 100) {
            percent = 99;
            reCalCache.clearBatch();
        }
        e.setProgress(percent);
        e.setText("");
        String resultInfo = (String)this.getModel().getValue("resultinfo");
        resultInfo = resultInfo == null ? "" : resultInfo;
        resultInfo = resultInfo + curMsg;
        this.getModel().setValue("resultinfo", (Object)resultInfo);
    }

    private void dispatchBatchTask() {
        DynamicObjectCollection calorgs = (DynamicObjectCollection)this.getModel().getValue("calorg");
        DynamicObjectCollection materials = (DynamicObjectCollection)this.getModel().getValue("material");
        DynamicObjectCollection entitys = (DynamicObjectCollection)this.getModel().getValue("entity");
        Set<Object> calOrgIds = this.getBaseDateIds(calorgs);
        Set<Object> materialIds = this.getBaseDateIds(materials);
        Set<Object> entityIds = this.getBaseDateIds(entitys);
        boolean containspre = (Boolean)this.getModel().getValue("containspre");
        boolean containsinit = (Boolean)this.getModel().getValue("containsinit");
        this.getModel().setValue("resultinfo", (Object)("calOrgIds:[" + calOrgIds + "]materialIds:[" + materialIds + "]entityIds:[" + entityIds + "]containspre:[" + containspre + "]containsinit:[" + containsinit + "]\r\n"));
        MulTaskCache mulTaskCache = new MulTaskCache(this.getView().getPageId());
        mulTaskCache.clearBatch();
        mulTaskCache.setPageOpTime(this.getView().getPageId());
        String pageOpTime = mulTaskCache.getPageOpTime(this.getView().getPageId());
        StockTypeUpdateHelper helper = new StockTypeUpdateHelper(calOrgIds, materialIds, entityIds, containspre, containsinit, pageOpTime);
        helper.construactTaskParams();
        MulTaskCache recalCache = new MulTaskCache(pageOpTime);
        recalCache.addBatch(helper.getBatchstrs());
        helper.dispatchBatchTask();
    }

    private Set<Object> getBaseDateIds(DynamicObjectCollection infos) {
        if (infos == null || infos.isEmpty()) {
            return null;
        }
        HashSet<Object> ids = new HashSet<Object>(4);
        for (DynamicObject info : infos) {
            ids.add(info.getDynamicObject("fbasedataid").get("id"));
        }
        return ids;
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getView().getControl("progressap");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getProgressBar().stop();
        new MulTaskCache(this.getView().getPageId()).clearBatch();
    }
}

