/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.stocktype;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.formplugin.domain.MulTaskCache;

public class StockTypeUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(StockTypeUpdateTask.class);
    private static final List allEntityIds = Arrays.asList("cal_costrecord_subentity", "cal_costadjust_subentity", "cal_costdiffgroupbill", "cal_initbill", "cal_price_provbill", "cal_price_revbill", "cal_standcost_bal", "cal_stdcostdiffbill");
    private IAppCache CACHE = AppCache.get((String)"cal");
    private String pageOpTime = null;
    private Long costAccountId = null;
    private Long calorg = null;
    private Integer periodEq = null;
    private Integer periodLa = null;
    private Date begindate = null;
    private Date enddate = null;
    private Long curPeriod = null;
    private Long periodIdEq = null;
    private Long periodIdLa = null;
    private Set<Object> materialIds = null;
    private List<String> needHandleEntitys = new ArrayList<String>(4);
    private Set<Long> allOwners = new HashSet<Long>(4);
    private List<Long> storageOrgUnits = new ArrayList<Long>(4);
    private Map<String, List<Object[]>> entity2DBParams = new HashMap<String, List<Object[]>>(4);
    private int updateSize = 0;

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        String batchStr = (String)paramMap.get("BATCHSTR");
        this.pageOpTime = (String)paramMap.get("pageOpTime");
        MulTaskCache recalCache = new MulTaskCache(this.pageOpTime);
        this.initParams(paramMap);
        try {
            int entryCount = 0;
            for (String entityId : this.needHandleEntitys) {
                this.updateSize = 0;
                entryCount += this.doTask(entityId);
            }
            recalCache.setBatchMsg(batchStr, batchStr + String.format("-sucess-entryCount[%s]", entryCount));
        }
        catch (Throwable e) {
            recalCache.setBatchMsg(batchStr, batchStr + "-error\uff1a\r\n" + ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e)));
            throw e;
        }
    }

    private int doTask(String entityId) {
        DataSet billDS = this.getBillDS(entityId);
        if (billDS == null) {
            return 0;
        }
        billDS = this.joinAndCollectDBParams(billDS, entityId, "storageorgunit", this.storageOrgUnits);
        billDS = this.joinAndCollectDBParams(billDS, entityId, "owner", this.allOwners);
        billDS = this.joinAndCollectDBParams(billDS, entityId, "calorg", Collections.singleton(this.calorg));
        this.joinAndCollectDBParams(billDS, entityId, null, null);
        this.saveToDB();
        return this.updateSize;
    }

    private DataSet joinAndCollectDBParams(DataSet billDS, String entityId, String onField, Collection<Long> orgIds) {
        DataSet materialCalInfo = null;
        if (orgIds == null || orgIds.isEmpty()) {
            materialCalInfo = this.getMaterialCalInfoFromCache(null);
        } else {
            for (Long orgId : orgIds) {
                DataSet infos = this.getMaterialCalInfoFromCache(orgId);
                if (materialCalInfo == null) {
                    materialCalInfo = infos;
                    continue;
                }
                materialCalInfo = materialCalInfo.union(infos);
            }
        }
        JoinDataSet joinDataSet = billDS.join(materialCalInfo, JoinType.LEFT).on("material", "masterid");
        if (onField != null) {
            joinDataSet.on(onField, "createorg");
        }
        DataSet dataSet = joinDataSet.select(new String[]{"id", "calorg", "owner", "storageorgunit", "material", "oristocktype"}, new String[]{"group"}).finish();
        DataSet[] resultDSs = dataSet.splitByFilter(new String[]{"group <> null"}, true);
        this.collectDBParams(entityId, resultDSs[0]);
        return resultDSs[1];
    }

    private void saveToDB() {
        for (Map.Entry<String, List<Object[]>> entry : this.entity2DBParams.entrySet()) {
            String entity = entry.getKey();
            List<Object[]> params = entry.getValue();
            ShardingHintContext ctx = this.getShardingHintContext(entity);
            Throwable throwable = null;
            try {
                if (ctx != null) {
                    ctx.set();
                }
                Lists.partition(params, (int)5000).forEach(list -> DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getDBUpdateSql(entity), (List)list));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
            }
        }
    }

    private String getDBUpdateSql(String entity) {
        switch (entity) {
            case "cal_bal": {
                return "update t_cal_bal set fstocktypeid = ? where fid = ?";
            }
            case "cal_balance": {
                return "update t_cal_balance set fstocktypeid = ? where fid = ?";
            }
            case "cal_standcost_bal": {
                return "update t_cal_standcost_bal set fstocktypeid = ? where fid = ?";
            }
            case "cal_costdiffgroupbill": {
                return "update t_cal_diffgroupbill set fstocktypeid = ? where fid = ?";
            }
            case "cal_costadjust_subentity": {
                return "update t_cal_costadjustbillentry set fstocktypeid = ? where fentryid = ?";
            }
            case "cal_stdcostdiffbill": {
                return "update t_cal_stdcostdiffentry set fstocktypeid = ? where fentryid = ?";
            }
            case "cal_initbill": {
                return "update t_cal_initbillentry set fstocktypeid = ? where fentryid = ?";
            }
            case "cal_costrecord_subentity": {
                return "update t_cal_calcostrecordentry set fstocktypeid = ? where fentryid = ?";
            }
            case "cal_price_provbill": {
                return "update t_cal_price_proventry set fstocktypeid = ? where fentryid = ?";
            }
            case "cal_price_revbill": {
                return "update t_cal_pricerevbillentry set fstocktypeid = ? where fentryid = ?";
            }
        }
        return null;
    }

    private ShardingHintContext getShardingHintContext(String entity) {
        ArrayList<ShardingHintContext.ShardingHintCondition> costaccountidFilter = new ArrayList<ShardingHintContext.ShardingHintCondition>(8);
        ArrayList<ShardingHintContext.ShardingHintCondition> costaccountFilter = new ArrayList<ShardingHintContext.ShardingHintCondition>(8);
        costaccountidFilter.add(new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId));
        costaccountFilter.add(new ShardingHintContext.ShardingHintCondition("fcostaccount", FilterType.eq, (Object)this.costAccountId));
        if (this.begindate != null) {
            costaccountidFilter.add(new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)this.begindate));
            costaccountFilter.add(new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)this.begindate));
        }
        if (this.enddate != null) {
            costaccountidFilter.add(new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)this.enddate));
            costaccountFilter.add(new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)this.enddate));
        }
        switch (entity) {
            case "cal_bal": {
                if (this.periodEq != null) {
                    return ShardingHintContext.create((String)"t_cal_bal", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId), new ShardingHintContext.ShardingHintCondition("fperiod", FilterType.eq, (Object)this.periodEq)});
                }
                return ShardingHintContext.create((String)"t_cal_bal", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId), new ShardingHintContext.ShardingHintCondition("fperiod", FilterType.gt, (Object)this.periodLa)});
            }
            case "cal_balance": {
                if (this.periodEq != null) {
                    return ShardingHintContext.create((String)"t_cal_balance", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId), new ShardingHintContext.ShardingHintCondition("fperiod", FilterType.eq, (Object)this.periodEq)});
                }
                return ShardingHintContext.create((String)"t_cal_balance", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId), new ShardingHintContext.ShardingHintCondition("fperiod", FilterType.gt, (Object)this.periodLa)});
            }
            case "cal_standcost_bal": {
                if (this.periodEq != null) {
                    return ShardingHintContext.create((String)"t_cal_standcost_bal", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId), new ShardingHintContext.ShardingHintCondition("fperiod", FilterType.eq, (Object)this.periodEq)});
                }
                return ShardingHintContext.create((String)"t_cal_standcost_bal", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId), new ShardingHintContext.ShardingHintCondition("fperiod", FilterType.gt, (Object)this.periodLa)});
            }
            case "cal_costdiffgroupbill": {
                return ShardingHintContext.create((String)"t_cal_diffgroupbill", (ShardingHintContext.ShardingHintCondition[])costaccountidFilter.toArray(new ShardingHintContext.ShardingHintCondition[0]));
            }
            case "cal_costadjust_subentity": {
                return ShardingHintContext.create((String)"t_cal_costadjustbill", (ShardingHintContext.ShardingHintCondition[])costaccountFilter.toArray(new ShardingHintContext.ShardingHintCondition[0]));
            }
            case "cal_stdcostdiffbill": {
                return ShardingHintContext.create((String)"t_cal_stdcostdiff", (ShardingHintContext.ShardingHintCondition[])costaccountFilter.toArray(new ShardingHintContext.ShardingHintCondition[0]));
            }
            case "cal_initbill": {
                return ShardingHintContext.create((String)"t_cal_initbill", (ShardingHintContext.ShardingHintCondition[])costaccountidFilter.toArray(new ShardingHintContext.ShardingHintCondition[0]));
            }
            case "cal_costrecord_subentity": {
                return ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])costaccountidFilter.toArray(new ShardingHintContext.ShardingHintCondition[0]));
            }
            case "cal_price_provbill": {
                return ShardingHintContext.create((String)"t_cal_price_provbill", (ShardingHintContext.ShardingHintCondition[])costaccountidFilter.toArray(new ShardingHintContext.ShardingHintCondition[0]));
            }
            case "cal_price_revbill": {
                return ShardingHintContext.create((String)"t_cal_price_revbill", (ShardingHintContext.ShardingHintCondition[])costaccountidFilter.toArray(new ShardingHintContext.ShardingHintCondition[0]));
            }
        }
        return null;
    }

    private void collectDBParams(String entity, DataSet resultDS) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(4);
        for (Row row : resultDS) {
            Long id = row.getLong("id");
            Long oristocktype = row.getLong("oristocktype");
            Long group = row.getLong("group");
            if (group == null || group.compareTo(oristocktype) == 0) continue;
            ++this.updateSize;
            params.add(new Object[]{group, id});
        }
        if (!params.isEmpty()) {
            this.entity2DBParams.put(entity, params);
        }
    }

    private DataSet getBillDS(String entityId) {
        List<QFilter> filters = this.getBillFilters(entityId);
        logger.info("\u5b58\u8d27\u7c7b\u522b\u91cd\u53d6\u67e5\u8be2" + entityId + "\u6761\u4ef6\uff1a" + filters);
        if (filters == null) {
            return null;
        }
        String selectFields = this.getBillSelectFields(entityId);
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        for (QFilter filter : filters) {
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), entityId, selectFields, new QFilter[]{filter});
            inputs.add(input);
        }
        DataSet billDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(inputs.toArray(new Input[0]));
        return billDataSet;
    }

    private String getBillSelectFields(String entityId) {
        switch (entityId) {
            case "cal_bal": 
            case "cal_balance": 
            case "cal_standcost_bal": 
            case "cal_costdiffgroupbill": {
                return "id,calorg,owner,storageorgunit,material,stocktype as oristocktype";
            }
            case "cal_costadjust_subentity": 
            case "cal_stdcostdiffbill": 
            case "cal_initbill": {
                return "calorg,entryentity.owner as owner,entryentity.storageorgunit as storageorgunit,entryentity.id as id,entryentity.material as material,entryentity.stocktype as oristocktype";
            }
            case "cal_costrecord_subentity": {
                return "calorg,entry.owner as owner,storageorgunit,entry.id as id,entry.material as material,entry.stocktype as oristocktype";
            }
            case "cal_price_provbill": 
            case "cal_price_revbill": {
                return "org as calorg,entry.owner as owner,entry.storageorgunit as storageorgunit,entry.id as id,entry.material as material,entry.stocktype as oristocktype";
            }
        }
        return null;
    }

    private List<QFilter> getBillFilters(String entityId) {
        if ("cal_balance".equals(entityId) || "cal_bal".equals(entityId) || "cal_standcost_bal".equals(entityId)) {
            if (this.periodEq == null && this.periodLa == null) {
                return null;
            }
            QFilter filter = new QFilter("costaccount", "=", (Object)this.costAccountId);
            if (this.periodEq != null) {
                filter.and("period", "=", (Object)this.periodEq);
            } else if (this.periodLa != null) {
                filter.and("period", ">", (Object)this.periodLa);
            }
            if (this.materialIds != null && !this.materialIds.isEmpty()) {
                filter.and("material", "in", this.materialIds);
            }
            return Collections.singletonList(filter);
        }
        if ("cal_costdiffgroupbill".equals(entityId)) {
            if (this.periodIdEq == null && this.periodLa == null) {
                return null;
            }
            QFilter filter = new QFilter("costaccount", "=", (Object)this.costAccountId);
            if (this.periodIdEq != null) {
                filter.and("period", "=", (Object)this.periodIdEq);
            } else if (this.periodIdLa != null) {
                filter.and("period", ">", (Object)this.periodLa);
            }
            return Collections.singletonList(filter);
        }
        if (this.curPeriod != null && !"cal_costrecord_subentity".equals(entityId)) {
            return null;
        }
        if (this.begindate != null && "cal_initbill".equals(entityId)) {
            return null;
        }
        QFilter filter = new QFilter("costaccount", "=", (Object)this.costAccountId);
        if (this.curPeriod != null && "cal_costrecord_subentity".equals(entityId)) {
            filter.and("period", ">=", (Object)this.curPeriod);
            filter.and("isinitbill", "=", (Object)Boolean.TRUE);
        }
        if (this.materialIds != null && !this.materialIds.isEmpty()) {
            filter.and(StockTypeUpdateTask.getBillEntryKey(entityId) + ".material", "in", this.materialIds);
        }
        if (this.begindate != null && this.enddate != null) {
            List bookdateFilters = DateUtils.getDateSplitFilters((Date)this.begindate, (Date)this.enddate, (String)"bookdate");
            for (QFilter bookdateFilter : bookdateFilters) {
                bookdateFilter.and(filter);
            }
            return bookdateFilters;
        }
        if (this.begindate != null) {
            filter.and("bookdate", ">=", (Object)this.begindate);
        }
        if (this.enddate != null) {
            filter.and("bookdate", "<=", (Object)this.enddate);
        }
        return Collections.singletonList(filter);
    }

    public static String getBillEntryKey(String entity) {
        if ("cal_costadjust_subentity".equals(entity) || "cal_costadjustbill".equals(entity) || "cal_stdcostdiffbill".equals(entity) || "cal_initbill".equals(entity)) {
            return "entryentity";
        }
        if ("cal_bal".equals(entity) || "cal_balance".equals(entity) || "cal_costdiffgroupbill".equals(entity)) {
            return "";
        }
        return "entry";
    }

    private DataSet getMaterialCalInfoFromCache(Long calorg) {
        String cachekey = this.pageOpTime + "#matcalinfo#";
        if (calorg != null) {
            cachekey = cachekey + calorg;
        }
        String cacheId = (String)this.CACHE.get(cachekey, String.class);
        DataSet infoDS = null;
        try {
            infoDS = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), false);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (infoDS == null) {
            QFilter filter = new QFilter("status", "=", (Object)"C");
            if (calorg != null) {
                filter.and("ctrlstrategy", "=", (Object)"7");
                filter.and("createorg", "=", (Object)calorg);
            } else {
                filter.and("ctrlstrategy", "=", (Object)"5");
            }
            QFilter materialFilter = new QFilter("masterid", "in", this.materialIds);
            infoDS = this.materialIds != null && !this.materialIds.isEmpty() ? QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialcalinfo", (String)"createorg,masterid,ctrlstrategy,group", (QFilter[])new QFilter[]{filter, materialFilter}, null) : QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialcalinfo", (String)"createorg,masterid,ctrlstrategy,group", (QFilter[])new QFilter[]{filter}, null);
            CacheHint cacheHint = new CacheHint();
            cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.STOCKTYPE_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
            CachedDataSet cache = infoDS.cache(cacheHint);
            cacheId = cache.getCacheId();
            this.CACHE.put(cachekey, (Object)cacheId);
            infoDS = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), false);
        }
        return infoDS;
    }

    private void initParams(Map<String, Object> paramMap) {
        Long[] owners;
        this.calorg = Long.parseLong(paramMap.get("calorg").toString());
        this.costAccountId = (Long)paramMap.get("costAccountId");
        this.periodEq = (Integer)paramMap.get("periodEq");
        this.periodLa = (Integer)paramMap.get("periodLa");
        String begindate = (String)paramMap.get("begindate");
        this.begindate = begindate == null ? null : new Date(Long.parseLong(begindate));
        String enddate = (String)paramMap.get("enddate");
        this.enddate = enddate == null ? null : new Date(Long.parseLong(enddate));
        String curPeriod = (String)paramMap.get("curPeriod");
        this.curPeriod = curPeriod == null ? null : Long.valueOf(Long.parseLong(curPeriod));
        String periodIdEq = (String)paramMap.get("periodIdEq");
        this.periodIdEq = periodIdEq == null ? null : Long.valueOf(Long.parseLong(periodIdEq));
        String periodIdLa = (String)paramMap.get("periodIdLa");
        this.periodIdLa = periodIdLa == null ? null : Long.valueOf(Long.parseLong(periodIdLa));
        Object materialIds = paramMap.get("materialIds");
        if (materialIds instanceof JSONArray) {
            JSONArray materialIdArr = (JSONArray)materialIds;
            this.materialIds = new HashSet<Object>(4);
            for (Object id : materialIdArr) {
                this.materialIds.add((Long)id);
            }
        } else {
            this.materialIds = (Set)materialIds;
        }
        HashSet<String> entityIds = null;
        Object entityIds1 = paramMap.get("entityIds");
        if (entityIds1 instanceof JSONArray) {
            JSONArray entityIdArr = (JSONArray)entityIds1;
            entityIds = new HashSet<String>(4);
            Long[] longArray = entityIdArr.iterator();
            while (longArray.hasNext()) {
                Object o = longArray.next();
                entityIds.add((String)o);
            }
        } else {
            entityIds = (HashSet<String>)entityIds1;
        }
        if (entityIds == null || entityIds.isEmpty()) {
            this.needHandleEntitys.addAll(allEntityIds);
            if (CalBalanceModelHelper.isNewBalance()) {
                this.needHandleEntitys.add("cal_bal");
            } else {
                this.needHandleEntitys.add("cal_balance");
            }
        } else {
            for (String entityId : entityIds) {
                if (entityId.equals("cal_balance") || entityId.equals("cal_bal")) {
                    if (CalBalanceModelHelper.isNewBalance()) {
                        this.needHandleEntitys.add("cal_bal");
                        continue;
                    }
                    this.needHandleEntitys.add("cal_balance");
                    continue;
                }
                if (entityId.equals("cal_costadjustbill")) {
                    this.needHandleEntitys.add("cal_costadjust_subentity");
                    continue;
                }
                if (!allEntityIds.contains(entityId)) continue;
                this.needHandleEntitys.add(entityId);
            }
        }
        for (Long owner : owners = AccountingSysHelper.getOwners((Long)this.costAccountId)) {
            this.allOwners.add(owner);
        }
        this.storageOrgUnits = OrgHelper.getStorageOrgUnitByCalOrg((Long)this.calorg);
    }
}

