/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.summary;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.lang.Lang;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.business.helper.ExceCostHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.enums.SumTypeEnum;
import kd.fi.cal.common.function.MatchCalRangeDataXFunction;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.DynamicObjectUtils;
import kd.fi.cal.formplugin.calculate.in.MatFromToFilter;
import kd.fi.cal.formplugin.queryscheme.SchemeSettingPlugin;
import kd.fi.cal.formplugin.summary.ExceCostDetailFieldFunction;
import kd.fi.cal.formplugin.summary.ExceCostDetailGroupFunction;
import kd.fi.cal.formplugin.summary.ExceCostSummaryFilterFunction;
import kd.fi.cal.formplugin.summary.ExceCostSummaryGroupFunction;
import kd.fi.cal.formplugin.summary.ExceCostSummaryReduceFunction;

public class ExceCostSummaryBillPlugin
extends SchemeSettingPlugin
implements BeforeF7SelectListener,
ClickListener,
HyperLinkClickListener,
ProgresssListener {
    private static final String EXPORT_BILL = "08Q=15+7DA21";
    private static final String DELETE_BILL = "08Q=4ALTPZ/E";
    private static final String QUERY = "query";
    private static final String REFRESH = "refresh";
    private static final String EXPORTBILL = "exportbill";
    private static final String DELETEBILL = "deletebill";
    private static final String CALORG = "calorgfilter";
    private static final String COSTACCOUNT = "costaccountfilter";
    private static final String PERIOD = "periodfilter";
    private static final String STORAGEORG = "storageorgunitfilter";
    private static final String WAREHOUSE = "warehousefilter";
    private static final String LOCATION = "locationfilter";
    private static final String MATERIALFROM = "materialfrom";
    private static final String MATERIALTO = "materialto";
    private static final String CURRENCY = "currencyfilter";
    private static final String ISEXCEDATA = "isexcedata";
    private static final String QUANTITY = "quantityfilter";
    private static final String AMOUNT = "amountfilter";
    private static final String AFTERAMOUNT = "afteramount";
    private static final String SUMTYPE = "sumType";
    private static final String QFILTER = "qfilter";
    private static final String EXPORTFLAG = "exportflag";
    private static final String ISEXPORTBILL = "isexportbill";
    private static final String AMT_PRECISION = "amtPrecision";
    private static final String LOT = "lotfilter";
    private static final String PROJECT = "projectfilter";
    private static final String CONFIGUREDCODE = "configuredcodefilter";
    private static final String CALRANGE = "calrangefilter";
    private static final String NOTEMPTY_GROUPFIELD = "calrangeid";
    private static final String PARTITIONSIZE = "partitionsize";
    private static final String[] fields2 = new String[]{"balanceid", "costadjustbillid", "costadjustbillno", "exportflag", "margin"};
    private static final int BATCHSIZE = 1000;
    private static final Log logger = LogFactory.getLog(ExceCostSummaryBillPlugin.class);
    private static final String[] special = new String[]{"material", "ownertype"};
    private static final String BAR_KEY = "processbar_key";
    public static final String CAL_BALANCE = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, CALORG, COSTACCOUNT, PERIOD, STORAGEORG, WAREHOUSE, LOCATION, "billtype", MATERIALFROM, MATERIALTO, CALRANGE);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("costadjustbillno".equals(fieldName)) {
            int rowIndex = evt.getRowIndex();
            String costadjustbillids = (String)this.getModel().getValue("costadjustbillids", rowIndex);
            String costadjustbillids_tag = (String)this.getModel().getValue("costadjustbillids_tag", rowIndex);
            costadjustbillids = !StringUtils.isEmpty((String)costadjustbillids_tag) ? costadjustbillids_tag : costadjustbillids;
            HashSet<Long> ids = new HashSet<Long>(16);
            Long singleId = null;
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            for (String s : costadjustbillids.split(",")) {
                Long id;
                if (StringUtils.isEmpty((String)s)) continue;
                singleId = id = Long.valueOf(Long.parseLong(s));
                if (id == 0L) continue;
                linkQueryPkIdCollection.addLinkQueryPkId((Object)id);
                ids.add(id);
            }
            if (ids.isEmpty()) {
                return;
            }
            if (ids.size() == 1 && singleId != null) {
                BillShowParameter param = new BillShowParameter();
                param.setFormId("cal_costadjust_subentity");
                param.setPkId((Object)singleId);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)param);
            } else {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", ids));
                showParameter.setBillFormId("cal_costadjust_subentity");
                showParameter.setAppId("cal");
                showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long orgId = RequestContext.get().getOrgId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        this.getPageCache().put("userId", String.valueOf(userId));
        this.getPageCache().put("orgId", String.valueOf(orgId));
        List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_excebalancesumlist", (String)"47150e89000000ac");
        if (calorgList != null && calorgList.size() > 0) {
            if (calorgList.contains(orgId)) {
                this.getModel().setValue(CALORG, (Object)orgId);
                this.getModel().setValue("mainorg", (Object)orgId);
            } else {
                this.getModel().setValue(CALORG, calorgList.get(0));
                this.getModel().setValue("mainorg", calorgList.get(0));
            }
            this.getView().updateView(CALORG);
            this.getView().updateView("mainorg");
        }
        if (calorgList == null) {
            this.getModel().setValue(CALORG, (Object)orgId);
            this.getModel().setValue("mainorg", (Object)orgId);
        }
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)orgId, (String)"cal_excebalancesumlist");
        this.setCostAccountByCalOrg(calOrgId);
        ((Container)this.getControl("flexpanelap1")).setCollapse(false);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
    }

    @Override
    protected void afterSelScheme() {
        super.afterSelScheme();
        this.costAccountChange();
        this.periodChange();
    }

    @Override
    protected void afterAddScheme() {
        super.afterAddScheme();
    }

    private void setCostAccountByCalOrg(Long calOrg) {
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg);
        if (costAccount != null) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", (Object)costAccount.getLong("calpolicy")).toArray());
            this.getModel().setValue(COSTACCOUNT, (Object)costAccount.getLong("id"));
            if (coll != null && coll.size() > 0) {
                this.getModel().setValue(CURRENCY, ((DynamicObject)coll.get(0)).get("currency"));
            }
            if (costAccount.get("calsystem") != null) {
                this.getModel().setValue("calsystem", costAccount.get("calsystem"));
            }
            if (costAccount.get("calpolicy") != null) {
                this.getModel().setValue("calpolicy", costAccount.get("calpolicy"));
            }
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            long periodid = 0L;
            if (period != null) {
                periodid = period.getLong("id");
                this.getModel().setValue(PERIOD, period.getPkValue());
            }
            this.getPageCache().put("defaultperiodid", String.valueOf(periodid));
            Long policyID = costAccount.getLong("calpolicy");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
            DynamicObject currency = obj.getDynamicObject("currency");
            Long currencyid = currency.getLong("id");
            this.getPageCache().put(CURRENCY, currencyid.toString());
            this.getPageCache().put(AMT_PRECISION, String.valueOf(currency.getInt("amtprecision")));
            this.periodChange();
        } else {
            this.getModel().setValue(COSTACCOUNT, null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (CALORG.equals(propertyName)) {
            this.calOrgChanged();
            this.getModel().setValue(CALRANGE, null);
        } else if (COSTACCOUNT.equals(propertyName)) {
            this.costAccountChange();
            this.getModel().setValue(CALRANGE, null);
        } else if (PERIOD.equals(propertyName)) {
            this.periodChange();
        } else if (MATERIALFROM.equals(propertyName)) {
            this.materialFromChange();
        } else if (ISEXCEDATA.equals(propertyName)) {
            this.qtyAndAmtChange();
        } else if (AFTERAMOUNT.equals(propertyName)) {
            this.afterAmountChange(rowIndex);
        } else if ("biztype".equals(propertyName)) {
            this.biztypeChange(e);
        } else if (STORAGEORG.equals(propertyName)) {
            this.storageOrgChanged();
        } else if (WAREHOUSE.equals(propertyName)) {
            this.warehouseChanged();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof AmountEdit) {
            String value = (String)e.getValue();
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            String key = ((AmountEdit)source).getKey();
            if ("amtfrom".equals(key)) {
                BigDecimal amtFrom = new BigDecimal((String)e.getValue());
                BigDecimal amtTo = (BigDecimal)this.getModel().getValue("amtto");
                this.amtFromToChanged(e, key, amtFrom, amtTo);
            } else if ("amtto".equals(key)) {
                BigDecimal amtFrom = (BigDecimal)this.getModel().getValue("amtfrom");
                BigDecimal amtTo = new BigDecimal((String)e.getValue());
                this.amtFromToChanged(e, key, amtFrom, amtTo);
            }
        } else if (source instanceof DecimalEdit) {
            String value = (String)e.getValue();
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            String key = ((DecimalEdit)source).getKey();
            if ("qtyfrom".equals(key)) {
                BigDecimal qtyFrom = new BigDecimal((String)e.getValue());
                BigDecimal qtyTo = (BigDecimal)this.getModel().getValue("qtyto");
                this.qtyFromToChanged(e, key, qtyFrom, qtyTo);
            } else if ("qtyto".equals(key)) {
                BigDecimal qtyFrom = (BigDecimal)this.getModel().getValue("qtyfrom");
                BigDecimal qtyTo = new BigDecimal((String)e.getValue());
                this.qtyFromToChanged(e, key, qtyFrom, qtyTo);
            }
        }
    }

    private void amtFromToChanged(BeforeFieldPostBackEvent e, String key, BigDecimal amtFrom, BigDecimal amtTo) {
        if (amtFrom != null && amtTo != null && amtFrom.compareTo(amtTo) > 0) {
            e.setCancel(true);
            this.getView().updateView(key);
            String msg = ResManager.loadKDString((String)"\u91d1\u989d\u4ece\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u91d1\u989d\u81f3\u3002", (String)"ExceCostSummaryBillPlugin_29", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        }
    }

    private void qtyFromToChanged(BeforeFieldPostBackEvent e, String key, BigDecimal qtyFrom, BigDecimal qtyTo) {
        if (qtyFrom != null && qtyTo != null && qtyFrom.compareTo(qtyTo) > 0) {
            e.setCancel(true);
            this.getView().updateView(key);
            String msg = ResManager.loadKDString((String)"\u201c\u6570\u91cf\u4ece\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u6570\u91cf\u81f3\u201d\u3002", (String)"ExceCostSummaryBillPlugin_40", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        }
    }

    private void warehouseChanged() {
        this.getModel().setValue(LOCATION, null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue(WAREHOUSE, null);
    }

    private void biztypeChange(PropertyChangedArgs e) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (newValue == null || "".equals((String)newValue)) {
            this.getModel().setValue("biztype", oldValue, rowIndex);
        }
        String biztype = (String)this.getModel().getValue("biztype");
        QFilter q = null;
        q = biztype.equals("A") ? new QFilter("number", "=", (Object)"im_PurInBill_STD_BT_S") : new QFilter("number", "=", (Object)"im_SalOutBill_STD_BT_S");
        Long billtypeId = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id", (QFilter[])q.toArray()).getLong("id");
        this.getModel().setValue("billtype", (Object)billtypeId, rowIndex);
    }

    private void calOrgChanged() {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue(CALORG);
        this.getModel().setValue(STORAGEORG, null);
        if (calOrg != null) {
            this.getModel().setValue("mainorg", (Object)calOrg);
            this.setCostAccountByCalOrg((Long)calOrg.getPkValue());
        } else {
            this.getModel().setValue(COSTACCOUNT, null);
            this.getModel().setValue(CURRENCY, null);
            this.getModel().setValue(PERIOD, null);
        }
    }

    private void afterAmountChange(int rowIndex) {
        BigDecimal afterAmount = (BigDecimal)this.getModel().getValue(AFTERAMOUNT, rowIndex);
        BigDecimal periodendactualcost = (BigDecimal)this.getModel().getValue("periodendactualcost", rowIndex);
        this.getModel().setValue("margin", (Object)afterAmount.subtract(periodendactualcost), rowIndex);
    }

    private void periodChange() {
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObject period = entity.getDynamicObject(PERIOD);
        if (period == null) {
            this.getModel().setValue(PERIOD, null);
            return;
        }
        String defaultperiodid = this.getPageCache().get("defaultperiodid");
        long periodid = period.getLong("id");
        if (!StringUtils.isEmpty((String)defaultperiodid) && Long.parseLong(defaultperiodid) != periodid) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EXPORTBILL});
            this.getView().setEnable(Boolean.FALSE, new String[]{DELETEBILL});
            this.getPageCache().put("isDefaultperiodid", "0");
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{EXPORTBILL});
            this.getView().setEnable(Boolean.TRUE, new String[]{DELETEBILL});
            this.getPageCache().put("isDefaultperiodid", "1");
        }
    }

    private void costAccountChange() {
        DynamicObject costAccountInfo = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT);
        if (costAccountInfo == null) {
            this.getModel().setValue("calsystem", null);
            this.getModel().setValue("calpolicy", null);
            this.getModel().setValue(PERIOD, null);
            this.getModel().setValue(CURRENCY, null);
            return;
        }
        String policyID = costAccountInfo.getString("calpolicy.id");
        this.loadCurrencyData(policyID);
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountInfo.getLong("id"));
        if (period == null) {
            this.getModel().setValue(PERIOD, null);
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue(PERIOD, period.getPkValue());
        this.getModel().endInit();
        this.getView().updateView(PERIOD);
        long periodid = period.getLong("id");
        this.getPageCache().put("defaultperiodid", String.valueOf(periodid));
    }

    private void qtyAndAmtChange() {
        this.getModel().setValue(QUANTITY, (Object)"");
        this.getModel().setValue(AMOUNT, (Object)"");
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        String sumType = (String)this.getModel().getValue("sumtype");
        switch (operateKey) {
            case "query": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
                this.doQuery();
                ((Container)this.getControl("flexpanelap1")).setCollapse(true);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap"});
                if (SumTypeEnum.DETAILED.getValue().equals(sumType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{NOTEMPTY_GROUPFIELD});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{NOTEMPTY_GROUPFIELD});
                break;
            }
            case "refresh": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
                this.doRefresh();
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap"});
                if (SumTypeEnum.DETAILED.getValue().equals(sumType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{NOTEMPTY_GROUPFIELD});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{NOTEMPTY_GROUPFIELD});
                break;
            }
            case "exportbill": {
                if (ExceCostHelper.newPlugin()) break;
                this.doExportBillOperation();
                break;
            }
            case "deletebill": {
                this.doDeleteBillOperation();
            }
        }
    }

    private void doQuery() {
        this.tryRefreshPeriod();
        this.chkInputBeforeQuery();
        DynamicObject entity = this.getModel().getDataEntity();
        QFilter[] filter = this.buildBalanceFilter(entity, Boolean.TRUE);
        this.getPageCache().put(QFILTER, filter[0].toSerializedString());
        this.loadBalanceDataByFilter(filter, entity.getDynamicObject(COSTACCOUNT).getLong("id"));
    }

    private void tryRefreshPeriod() {
        DynamicObject costAccountInfo = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT);
        DynamicObject periodObject = this.getModel().getDataEntity().getDynamicObject(PERIOD);
        if (costAccountInfo != null) {
            String policyID = costAccountInfo.getString("calpolicy.id");
            this.loadCurrencyData(policyID);
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountInfo.getLong("id"));
            if (period != null && periodObject != null && period.getLong("id") != periodObject.getLong("id")) {
                this.getModel().setValue(PERIOD, periodObject.getPkValue());
                this.getPageCache().put("defaultperiodid", String.valueOf(period.getPkValue()));
                this.periodChange();
            }
        }
    }

    private void doRefresh() {
        this.tryRefreshPeriod();
        String filter = this.getPageCache().get(QFILTER);
        if (null != filter) {
            QFilter qfilter = QFilter.fromSerializedString((String)filter);
            QFilter[] filters = new QFilter[]{qfilter, null, null};
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            this.loadBalanceDataByFilter(filters, costAccount == null ? 0L : costAccount.getLong("id"));
        }
    }

    private void chkExportBillPermission(Long orgId, Long userId, String flag, String opName) {
        int checkPermission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"/KIUHEXROK3D", (String)"cal_excebalancesumlist", (String)flag);
        if (checkPermission <= 0) {
            String content = String.format(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709%1$s\u64cd\u4f5c\u7684\u6743\u9650\u3002", (String)"ExceCostSummaryBillPlugin_32", (String)"fi-cal-formplugin", (Object[])new Object[0]), opName);
            throw new KDBizException(content);
        }
    }

    private void doExportBillOperation() {
        StringBuilder sb;
        int i;
        StringBuilder sb2;
        DynamicObject costAccountInfo;
        DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(CALORG);
        long calOrgId = calOrg.getLong("id");
        EntryGrid billEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = billEntryGrid.getSelectRows();
        Integer maxnumberentries = (Integer)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calOrgId, (Long)0L, (String)"maxnumberentries");
        if (selectRows.length < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExceCostSummaryBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (selectRows.length > maxnumberentries) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u6761\u6570\u4e0d\u80fd\u8d85\u8fc7\u53c2\u6570\u8bbe\u7f6e\u7684\u5206\u5f55\u6570\u3002", (String)"ExceCostSummaryBillPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.checkCalingBill();
        DynamicObject org = (DynamicObject)this.getModel().getValue(CALORG);
        Long orgId = (Long)org.getPkValue();
        Long userId = Long.valueOf(this.getPageCache().get("userId"));
        this.chkExportBillPermission(orgId, userId, EXPORT_BILL, ResManager.loadKDString((String)"\u51fa\u5355", (String)"ExceCostSummaryBillPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        String currency = this.getPageCache().get(CURRENCY);
        if ((null == currency || "".equals(currency)) && (costAccountInfo = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT)) != null) {
            String policyID = costAccountInfo.getString("calpolicy.id");
            this.loadCurrencyData(policyID);
        }
        boolean costElementByCostAccount = false;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DynamicObject accountDyc = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        HashMap<String, String> allElementMap = new HashMap<String, String>();
        ArrayList<Long[]> costAllSubElements = new ArrayList<Long[]>();
        if (isNewBalance && accountDyc != null) {
            costElementByCostAccount = this.getAllElementInfo(accountDyc, allElementMap, costAllSubElements);
        }
        StringBuilder errorMsg = new StringBuilder(ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff1a", (String)"ExceCostSummaryBillPlugin_26", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        String sumType = this.getPageCache().get(SUMTYPE);
        HashMap<String, DynamicObject> costAdjustBillMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Integer> costAdjustBillSeqMap = new HashMap<String, Integer>(16);
        HashSet<Object> balanceids = new HashSet<Object>(16);
        ArrayList<DynamicObject> balanceCostAdjustBillList = new ArrayList<DynamicObject>(16);
        HashMap<Long, Integer> balanceIdAndChosenIndex = new HashMap<Long, Integer>(16);
        HashMap chosenIndexAndBalanceIds = new HashMap(16);
        HashMap<Integer, String> chosenIndexAndBillBizType = new HashMap<Integer, String>(16);
        HashSet<Long> allBalanceIdsForChosen = new HashSet<Long>(16);
        DynamicObjectCollection total = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        int[] rowStatus = new int[total.size()];
        HashSet<Integer> billtype_empty_index = new HashSet<Integer>();
        HashSet<Integer> afteramt_index_error = new HashSet<Integer>();
        HashSet<String> subElement_disabled_error = new HashSet<String>();
        HashSet<Long> subElement_delete_error = new HashSet<Long>();
        for (int i2 : selectRows) {
            Object billtype;
            rowStatus[i2] = 1;
            String balanceidsTag = ((DynamicObject)total.get(i2)).getString("balanceids_tag");
            if (costElementByCostAccount) {
                List list = (List)JSONObject.parseObject((String)balanceidsTag, List.class);
                for (Object s : list) {
                    List balid_eid_sid_qty_amts = (List)JSONObject.parseObject((String)s.toString(), List.class);
                    for (String cur : balid_eid_sid_qty_amts) {
                        String[] balid_eid_sid_qty_amt = cur.split("#");
                        Long balanceId = StringUtils.isEmpty((String)balid_eid_sid_qty_amt[0]) ? 0L : Long.parseLong(balid_eid_sid_qty_amt[0]);
                        if (balanceId == 0L) continue;
                        allBalanceIdsForChosen.add(balanceId);
                    }
                }
            } else {
                String[] balanceIds = balanceidsTag.split(",");
                for (String balanceIdStr : balanceIds) {
                    Long balanceId = StringUtils.isEmpty((String)balanceIdStr) ? 0L : Long.parseLong(balanceIdStr);
                    if (balanceId == 0L) continue;
                    allBalanceIdsForChosen.add(balanceId);
                }
            }
            if ((billtype = ((DynamicObject)total.get(i2)).get("billtype")) == null) {
                billtype_empty_index.add(i2);
            }
            BigDecimal periodendqty = ((DynamicObject)total.get(i2)).getBigDecimal("periodendqty");
            BigDecimal afteramount = ((DynamicObject)total.get(i2)).getBigDecimal(AFTERAMOUNT);
            if (periodendqty == null || BigDecimal.ZERO.compareTo(periodendqty) != 0 || afteramount == null || BigDecimal.ZERO.compareTo(afteramount) == 0) continue;
            afteramt_index_error.add(i2);
        }
        if (!allBalanceIdsForChosen.isEmpty()) {
            DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT);
            DynamicObject periodObject = this.getModel().getDataEntity().getDynamicObject(PERIOD);
            QFilter balFilter = new QFilter("id", "in", allBalanceIdsForChosen);
            DataSet balanceDataSet = ExceCostHelper.buildBalanceData((QFilter)balFilter, (boolean)costElementByCostAccount);
            Set balDimFields = ExceCostHelper.getBalDimFields((String)sumType, (boolean)false);
            DataSet costAdjust_matched = ExceCostHelper.createCostAdjust_matched_BALEND((boolean)costElementByCostAccount, (Set)balDimFields, (QFilter[])new QFilter[0], (Long)((Long)costaccount.getPkValue()), (Long)((Long)periodObject.getPkValue()), (boolean)false);
            JoinDataSet joinDataSet = balanceDataSet.join(costAdjust_matched);
            for (String balDimField : balDimFields) {
                joinDataSet.on(balDimField, balDimField);
            }
            DataSet dataSet = joinDataSet.select(balanceDataSet.getRowMeta().getFieldNames(), new String[]{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak", "margin"}).finish();
            DataSet detailDatasetX = dataSet.groupBy((String[])ArrayUtils.concatAll((Object[])balanceDataSet.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak"}})).sum("margin").finish();
            if (!detailDatasetX.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff0c\u6570\u636e\u5df2\u51fa\u5355\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExceExportBillTask_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
        if (!billtype_empty_index.isEmpty()) {
            sb2 = new StringBuilder();
            for (Integer index : billtype_empty_index) {
                sb2.append(index + 1).append("\u3001");
            }
            String errIndex = sb2.length() > 1 ? sb2.substring(0, sb2.length() - 1) : sb2.toString();
            String msg_detail = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355", (String)"ExceCostSummaryBillPlugin_38", (String)"fi-cal-formplugin", (Object[])new Object[0]), errIndex);
            throw new KDBizException(msg_detail);
        }
        if (!afteramt_index_error.isEmpty()) {
            sb2 = new StringBuilder();
            for (Integer index : afteramt_index_error) {
                sb2.append(index + 1).append("\u3001");
            }
            String errIndex = sb2.length() > 1 ? sb2.substring(0, sb2.length() - 1) : sb2.toString();
            String msg_detail = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u91cf=0\uff0c\u8c03\u6574\u540e\u7684\u91d1\u989d\u4e0d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355\u8c03\u6574", (String)"ExceCostSummaryBillPlugin_39", (String)"fi-cal-formplugin", (Object[])new Object[0]), errIndex);
            throw new KDBizException(msg_detail);
        }
        DataSet detailDataSet = null;
        if (SumTypeEnum.HUAFENYIJU.getValue().equals(sumType)) {
            for (int i3 : selectRows) {
                String balanceids_tag;
                String[] balanceIds;
                DynamicObjectCollection entryentitys = (DynamicObjectCollection)this.getModel().getValue("entryentity");
                DynamicObject row = (DynamicObject)entryentitys.get(i3);
                HashSet<Long> ids = new HashSet<Long>(16);
                String balanceIdsStr = row.getString("balanceids_tag");
                boolean all_costelement_amt_zero = true;
                if (costElementByCostAccount) {
                    HashSet<String> allBalanceIds = new HashSet<String>();
                    List list = (List)JSONObject.parseObject((String)balanceIdsStr, List.class);
                    for (Object o : list) {
                        List balid_eid_sid_qty_amts = (List)JSONObject.parseObject((String)o.toString(), List.class);
                        for (String str : balid_eid_sid_qty_amts) {
                            String[] balid_eid_sid_qty_amt = str.split("#");
                            allBalanceIds.add(balid_eid_sid_qty_amt[0]);
                            if (BigDecimal.ZERO.compareTo(new BigDecimal(balid_eid_sid_qty_amt[4])) == 0) continue;
                        }
                    }
                    balanceIds = allBalanceIds.toArray(new String[0]);
                } else {
                    balanceIds = balanceIdsStr.split(",");
                    String[] periodendactualcost = row.getBigDecimal("periodendactualcost");
                    if (BigDecimal.ZERO.compareTo((BigDecimal)periodendactualcost) != 0) {
                        all_costelement_amt_zero = false;
                    }
                }
                for (String balanceIdStr : balanceIds) {
                    Long balanceId = StringUtils.isEmpty((String)balanceIdStr) ? 0L : Long.parseLong(balanceIdStr);
                    if (balanceId == 0L) continue;
                    ids.add(balanceId);
                    balanceIdAndChosenIndex.put(balanceId, i3);
                }
                chosenIndexAndBalanceIds.put(i3, ids);
                String bizType = row.getString("biztype");
                String billType = String.valueOf(row.getDynamicObject("billtype").get("id"));
                chosenIndexAndBillBizType.put(i3, bizType + "#" + billType);
                BigDecimal afteramount = row.getBigDecimal(AFTERAMOUNT);
                BigDecimal periodendqtyTotal = row.getBigDecimal("periodendqty");
                BigDecimal periodendactualcost = row.getBigDecimal("periodendactualcost");
                if (costElementByCostAccount && BigDecimal.ZERO.compareTo(periodendqtyTotal) == 0 && BigDecimal.ZERO.compareTo(periodendactualcost) == 0 && !StringUtils.isEmpty((String)(balanceids_tag = row.getString("balanceids_tag")))) {
                    List group = (List)JSONObject.parseObject((String)balanceids_tag, List.class);
                    boolean breakFlag = false;
                    block11: for (List list : group) {
                        if (breakFlag) break;
                        for (String s : list) {
                            String[] split = s.split("#");
                            if (StringUtils.isEmpty((String)split[3]) || BigDecimal.ZERO.compareTo(new BigDecimal(split[3])) == 0) continue;
                            rowStatus[i3] = -3;
                            breakFlag = true;
                            continue block11;
                        }
                    }
                }
                if (costElementByCostAccount && BigDecimal.ZERO.compareTo(afteramount) != 0 && BigDecimal.ZERO.compareTo(periodendactualcost) != 0 && BigDecimal.ZERO.compareTo(periodendqtyTotal) == 0 && rowStatus[i3] == 1) {
                    rowStatus[i3] = -1;
                }
                if (costElementByCostAccount && all_costelement_amt_zero && BigDecimal.ZERO.compareTo(periodendactualcost) == 0 && BigDecimal.ZERO.compareTo(periodendqtyTotal) != 0 && BigDecimal.ZERO.compareTo(afteramount) == 0 && rowStatus[i3] == 1) {
                    rowStatus[i3] = -2;
                }
                if (!costElementByCostAccount && BigDecimal.ZERO.compareTo(periodendactualcost) == 0 && BigDecimal.ZERO.compareTo(periodendqtyTotal) != 0 && BigDecimal.ZERO.compareTo(afteramount) == 0 && rowStatus[i3] == 1) {
                    rowStatus[i3] = -2;
                }
                if (afteramount.compareTo(BigDecimal.ZERO) != 0 || periodendqtyTotal.compareTo(BigDecimal.ZERO) == 0 || rowStatus[i3] != 1 || costElementByCostAccount) continue;
                rowStatus[i3] = 2;
            }
            HashSet allBalanceIds_entry = new HashSet(16);
            for (Map.Entry entry : chosenIndexAndBalanceIds.entrySet()) {
                int index = (Integer)entry.getKey();
                if (rowStatus[index] != 2) continue;
                allBalanceIds_entry.addAll((Collection)chosenIndexAndBalanceIds.get(index));
            }
            HashSet specialIds = new HashSet(16);
            HashSet allBalanceIds = new HashSet(16);
            allBalanceIds.addAll(allBalanceIds_entry);
            if (!allBalanceIds.isEmpty()) {
                QFilter qfilter = new QFilter("id", "in", allBalanceIds);
                DataSet dys = ExceCostHelper.getCalBal_balanceDataSet((boolean)costElementByCostAccount, (QFilter)qfilter, (boolean)isNewBalance);
                if (dys == null) {
                    throw new KDBizException("cal_bal is Empty");
                }
                for (Object dy : dys) {
                    HashSet<Integer> cur_chosenIndexs = new HashSet<Integer>();
                    if (costElementByCostAccount) {
                        String cur_balanceids = dy.getString("balanceids");
                        for (String s : cur_balanceids.split(",")) {
                            if (StringUtils.isEmpty((String)s)) continue;
                            Integer chosenIndex = (Integer)balanceIdAndChosenIndex.get(Long.parseLong(s));
                            cur_chosenIndexs.add(chosenIndex);
                        }
                    } else {
                        long balanceId = dy.getLong("id");
                        Integer chosenIndex = (Integer)balanceIdAndChosenIndex.get(balanceId);
                        cur_chosenIndexs.add(chosenIndex);
                    }
                    String periodEndQtyField = "periodendqty";
                    String periodEndActualCostField = "periodendactualcost";
                    if (isNewBalance) {
                        periodEndQtyField = "baseqty_bal";
                        periodEndActualCostField = "actualcost_bal";
                    }
                    if (costElementByCostAccount) {
                        periodEndQtyField = "periodendqty";
                        periodEndActualCostField = "periodendactualcost";
                    }
                    BigDecimal periodendqty = dy.getBigDecimal(periodEndQtyField);
                    BigDecimal periodendactualcost = dy.getBigDecimal(periodEndActualCostField);
                    Boolean isExce3 = periodendqty.compareTo(BigDecimal.ZERO) < 0 && periodendactualcost.compareTo(BigDecimal.ZERO) > 0;
                    Boolean isExce4 = periodendqty.compareTo(BigDecimal.ZERO) > 0 && periodendactualcost.compareTo(BigDecimal.ZERO) < 0;
                    if (!isExce3.booleanValue() && !isExce4.booleanValue()) continue;
                    for (Integer chosenIndex : cur_chosenIndexs) {
                        if (rowStatus[chosenIndex] == 2) {
                            rowStatus[chosenIndex.intValue()] = 3;
                        }
                        if (rowStatus[chosenIndex] != 3) continue;
                        specialIds.addAll((Collection)chosenIndexAndBalanceIds.get(chosenIndex));
                    }
                }
            }
            if (!specialIds.isEmpty()) {
                DynamicObject entity = this.getModel().getDataEntity();
                QFilter[] filters = this.buildBalanceFilter(entity, Boolean.FALSE);
                filters[0].and("id", "in", specialIds);
                DynamicObject costAccountInfo2 = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT);
                detailDataSet = this.getBalanceAndCostAdjust(filters, SumTypeEnum.DETAILED.getValue(), null, costAccountInfo2, Boolean.FALSE, costElementByCostAccount);
                for (Row row : detailDataSet.copy()) {
                    Integer index;
                    Long balanceId = row.getLong("id");
                    BigDecimal qty = row.getBigDecimal("periodendqty");
                    BigDecimal money = row.getBigDecimal("periodendactualcost");
                    if (BigDecimal.ZERO.compareTo(qty) != 0 || BigDecimal.ZERO.compareTo(money) == 0 || rowStatus[index = (Integer)balanceIdAndChosenIndex.get(balanceId)] != 3) continue;
                    rowStatus[index.intValue()] = 4;
                }
            }
        }
        HashSet errorBalanceIds = new HashSet(16);
        for (int i4 = 0; i4 < rowStatus.length; ++i4) {
            if (rowStatus[i4] != 4) continue;
            Set balanceIds = (Set)chosenIndexAndBalanceIds.get(i4);
            errorBalanceIds.addAll(balanceIds);
        }
        HashSet<Integer> errorIndex_detail = new HashSet<Integer>();
        HashSet<Integer> errorIndex_amtZero = new HashSet<Integer>();
        HashSet<Integer> errorIndex_qtyZero = new HashSet<Integer>();
        for (i = 0; i < rowStatus.length; ++i) {
            if (rowStatus[i] == 4) continue;
            if (rowStatus[i] > 0 && rowStatus[i] != 4) {
                DynamicObject entryentity = (DynamicObject)total.get(i);
                logger.info("excecostsummary-normal-export : {}", (Object)i);
                this.calculateAdjust(errorMsg, sumType, costAdjustBillMap, costAdjustBillSeqMap, balanceids, balanceCostAdjustBillList, entryentity, i, Boolean.TRUE, costElementByCostAccount, costAllSubElements, null, subElement_disabled_error, subElement_delete_error, allElementMap);
            }
            if (rowStatus[i] == -1) {
                errorIndex_detail.add(i);
            }
            if (rowStatus[i] == -2) {
                errorIndex_amtZero.add(i);
            }
            if (rowStatus[i] != -3) continue;
            errorIndex_qtyZero.add(i);
        }
        if (!errorBalanceIds.isEmpty() && detailDataSet != null) {
            detailDataSet = detailDataSet.filter(new QFilter("id", "in", errorBalanceIds).toString());
            DynamicObjectCollection rows = ORM.create().toPlainDynamicObjectCollection(detailDataSet);
            for (int j = 0; j < rows.size(); ++j) {
                DynamicObject entryentity = (DynamicObject)rows.get(j);
                BigDecimal periodendactualcost1 = entryentity.getBigDecimal("periodendactualcost");
                BigDecimal margin = BigDecimal.ZERO.subtract(periodendactualcost1 == null ? BigDecimal.ZERO : periodendactualcost1);
                entryentity.set("margin", (Object)margin);
                if (BigDecimal.ZERO.compareTo(margin) == 0) continue;
                String[] bizBillType = ((String)chosenIndexAndBillBizType.get(balanceIdAndChosenIndex.get(entryentity.getLong("id")))).split("#");
                this.calculateAdjust(errorMsg, SumTypeEnum.DETAILED.getValue(), costAdjustBillMap, costAdjustBillSeqMap, balanceids, balanceCostAdjustBillList, entryentity, i + 1000 + j, Boolean.FALSE, costElementByCostAccount, costAllSubElements, bizBillType, subElement_disabled_error, subElement_delete_error, allElementMap);
            }
        }
        if (!subElement_delete_error.isEmpty() || !subElement_disabled_error.isEmpty()) {
            StringBuilder sb_delete = new StringBuilder();
            for (Long subElementId : subElement_delete_error) {
                sb_delete.append(subElementId).append(",");
            }
            String delete_errMsg = sb_delete.length() > 1 ? sb_delete.substring(0, sb_delete.length() - 1) : sb_delete.toString();
            String delete_detail = String.format(ResManager.loadKDString((String)"%1$s\u5b50\u8981\u7d20\u5df2\u88ab\u5220\u9664\uff0c\u51fa\u5355\u5931\u8d25\uff01", (String)"ExceCostSummaryBillPlugin_41", (String)"fi-cal-formplugin", (Object[])new Object[0]), delete_errMsg);
            StringBuilder sb_disable = new StringBuilder();
            for (String name_number : subElement_disabled_error) {
                sb_disable.append(name_number).append(",");
            }
            String disable_errMsg = sb_disable.length() > 1 ? sb_disable.substring(0, sb_disable.length() - 1) : sb_disable.toString();
            String disable_detail = String.format(ResManager.loadKDString((String)"%1$s\u5b50\u8981\u7d20\u5df2\u88ab\u7981\u7528\uff0c\u51fa\u5355\u5931\u8d25\uff01", (String)"ExceCostSummaryBillPlugin_42", (String)"fi-cal-formplugin", (Object[])new Object[0]), disable_errMsg);
            if (!subElement_delete_error.isEmpty()) {
                throw new KDBizException(delete_detail);
            }
            if (!subElement_disabled_error.isEmpty()) {
                throw new KDBizException(disable_detail);
            }
        }
        if (!errorIndex_amtZero.isEmpty() && SumTypeEnum.HUAFENYIJU.getValue().equals(sumType)) {
            sb = new StringBuilder();
            Iterator delete_errMsg = errorIndex_amtZero.iterator();
            while (delete_errMsg.hasNext()) {
                int selectRow = (Integer)delete_errMsg.next();
                sb.append(selectRow + 1).append("\u3001");
            }
            String infoMsg = sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5dee\u989d=0\u4e0d\u5141\u8bb8\u51fa\u5355\u3002  ", (String)"ExceCostSummaryBillPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), infoMsg);
            throw new KDBizException(msg);
        }
        if (!errorIndex_qtyZero.isEmpty() && SumTypeEnum.HUAFENYIJU.getValue().equals(sumType)) {
            sb = new StringBuilder();
            Object infoMsg = errorIndex_amtZero.iterator();
            while (infoMsg.hasNext()) {
                int selectRow = (Integer)infoMsg.next();
                sb.append(selectRow + 1).append("\u3001");
            }
            infoMsg = sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
            String msg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u6570\u91cf\u4e0d\u4e3a0\u5dee\u989d=0\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355\uff01", (String)"ExceCostSummaryBillPlugin_53", (String)"fi-cal-formplugin", (Object[])new Object[0]), infoMsg);
            throw new KDBizException(msg);
        }
        this.doExportBillJob(balanceids, costAdjustBillMap.values(), balanceCostAdjustBillList, userId, calOrgId, errorIndex_detail, costElementByCostAccount);
    }

    private boolean getAllElementInfo(DynamicObject accountDyc, Map<String, String> allElementMap, List<Long[]> costAllSubElements) {
        boolean costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)((Long)accountDyc.getPkValue()));
        HashSet dupSet = new HashSet();
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement", (String)"id,number,name,enable", (QFilter[])q.toArray(), null);
             DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"id,element,subelement", null, null);
             DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("id", "subelement").select(new String[]{"id as subelement", "number", "name", "enable"}, new String[]{"element"}).finish();){
            for (Row row : joinDataSet) {
                allElementMap.put(row.getLong("subelement") + "|" + row.getLong("element"), row.getString("name") + " " + row.getString("number"));
                if (!row.getBoolean("enable").booleanValue() || dupSet.contains(row.getLong("subelement") + "|" + row.getLong("element"))) continue;
                costAllSubElements.add(new Long[]{row.getLong("subelement"), row.getLong("element")});
            }
        }
        return costElementByCostAccount;
    }

    private void checkCalingBill() {
        DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(CALORG);
        DynamicObject accountDyc = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT);
        if (calOrg == null || accountDyc == null) {
            return;
        }
        long calOrgId = calOrg.getLong("id");
        long accountId = accountDyc.getLong("id");
        QFilter filter = this.getBaseFilter(calOrgId, accountId);
        filter.and(new QFilter("calstatus", "=", (Object)"C"));
        filter.and(new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue()));
        boolean isCaling = QueryServiceHelper.exists((String)"cal_costadjustbill", (QFilter[])filter.toArray());
        if (isCaling) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6838\u7b97\u5904\u7406\u72b6\u6001\u4e3a\u5904\u7406\u4e2d\u7684\u6210\u672c\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355\u6216\u5220\u5355\u3002", (String)"ExceCostSummaryBillPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void calculateAdjust(StringBuilder errorMsg, String sumType, Map<String, DynamicObject> costAdjustBillMap, Map<String, Integer> costAdjustBillSeqMap, Set<Object> balanceids, List<DynamicObject> balanceCostAdjustBillList, DynamicObject entryentity, int i, boolean normal, boolean costElementByCostAccount, List<Long[]> costAllSubElements, String[] bizBillType, Set<String> subElement_disabled_error, Set<Long> subElement_delete_error, Map<String, String> dupSet) {
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        BigDecimal afteramount = normal ? entryentity.getBigDecimal(AFTERAMOUNT) : BigDecimal.ZERO;
        BigDecimal marginTotal = entryentity.getBigDecimal("margin");
        BigDecimal periodendqtyTotal = entryentity.getBigDecimal("periodendqty");
        Boolean isExce1 = periodendqtyTotal.compareTo(BigDecimal.ZERO) < 0 && afteramount.compareTo(BigDecimal.ZERO) > 0;
        Boolean isExce2 = periodendqtyTotal.compareTo(BigDecimal.ZERO) > 0 && afteramount.compareTo(BigDecimal.ZERO) < 0;
        if (marginTotal.compareTo(BigDecimal.ZERO) == 0 && SumTypeEnum.DETAILED.getValue().equals(sumType) && !costElementByCostAccount) {
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5dee\u989d=0\u4e0d\u5141\u8bb8\u51fa\u5355\u3002  ", (String)"ExceCostSummaryBillPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
            throw new KDBizException(msg);
        }
        if (marginTotal.compareTo(BigDecimal.ZERO) == 0 && SumTypeEnum.DETAILED.getValue().equals(sumType) && costElementByCostAccount && BigDecimal.ZERO.compareTo(periodendqtyTotal) != 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5dee\u989d=0\u4e0d\u5141\u8bb8\u51fa\u5355\u3002  ", (String)"ExceCostSummaryBillPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
            throw new KDBizException(msg);
        }
        if (isExce1.booleanValue() || isExce2.booleanValue()) {
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u91cf\u4e0e\u8c03\u6574\u540e\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\u4e0d\u5141\u8bb8\u51fa\u5355\u3002", (String)"ExceCostSummaryBillPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
            throw new KDBizException(msg);
        }
        String biztype = normal ? entryentity.getString("biztype") : bizBillType[0];
        String fieldKey = "billtype";
        Long billtype = normal ? (Long)this.getBaseDataValue(entryentity, fieldKey) : Long.parseLong(bizBillType[1]);
        String billKey = biztype + "_" + billtype;
        DynamicObject costAdjustBill = costAdjustBillMap.get(billKey);
        Integer seq = costAdjustBillSeqMap.get(billKey);
        if (costAdjustBill == null) {
            seq = 1;
            costAdjustBill = this.createCostAdjustHead(biztype, billtype, costElementByCostAccount);
            costAdjustBillMap.put(billKey, costAdjustBill);
            costAdjustBillSeqMap.put(billKey, seq);
        }
        HashMap<Long, Long> balanceId_subElementId = new HashMap<Long, Long>();
        HashMap<Long, Long> balanceId_elementId = new HashMap<Long, Long>();
        HashMap<Long, BigDecimal> balanceId_subamt = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> balanceId_detail_calsubamt = new HashMap<Long, BigDecimal>();
        if (SumTypeEnum.DETAILED.getValue().equals(sumType) && !costElementByCostAccount) {
            Long balanceId = normal ? entryentity.getLong("balanceid") : entryentity.getLong("id");
            balanceids.add(balanceId);
            QFilter qf = new QFilter("id", "=", (Object)balanceId);
            String fields = ExceCostHelper.getBalanceFields((boolean)false, (boolean)false, (boolean)false);
            String balName = "cal_balance";
            boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
            if (isNewBalance) {
                balName = "cal_bal";
            }
            DynamicObject[] dys = BusinessDataServiceHelper.load((String)balName, (String)fields, (QFilter[])new QFilter[]{qf});
            costAdjustBill = this.createCostAdjustEntry(costAdjustBill, entryentity, dys[0], null, biztype, seq, sumType, false, null, null, null, null, costAllSubElements, null, null, dupSet);
            seq = seq + 1;
            costAdjustBillSeqMap.put(billKey, seq);
            marginTotal = biztype.equals("B") ? marginTotal.multiply(new BigDecimal(-1)) : marginTotal;
        } else {
            String balanceidstr;
            BigDecimal margin;
            List<Map<String, Object>> list;
            QFilter normalQfilter;
            DataSet balanceDataSet2;
            String[] margin2;
            ArrayList<Long> entryBalIds = new ArrayList<Long>(16);
            String periodEndQtyField = "periodendqty";
            String periodEndActualCostField = "periodendactualcost";
            boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
            if (isNewBalance) {
                if (costElementByCostAccount) {
                    periodEndQtyField = "periodendqty";
                    periodEndActualCostField = "periodendactualcost";
                } else {
                    periodEndQtyField = "baseqty_bal";
                    periodEndActualCostField = "actualcost_bal";
                }
            }
            ArrayList<List> group_balid_eid_sid_qty_amts = new ArrayList<List>();
            DataSet balanceDataSet1 = null;
            DataSet balanceDataSet_qty_amt_zero = null;
            DataSet balanceDataSet_rest = null;
            if (costElementByCostAccount) {
                String balanceids_tag = entryentity.getString("balanceids_tag");
                List list2 = (List)JSONObject.parseObject((String)balanceids_tag, List.class);
                for (Object o : list2) {
                    Iterator id_eid_sid_qty_amts = (List)JSONObject.parseObject((String)o.toString(), List.class);
                    group_balid_eid_sid_qty_amts.add((List)((Object)id_eid_sid_qty_amts));
                }
                for (List id_eid_sid_qty_amts : group_balid_eid_sid_qty_amts) {
                    for (String string : id_eid_sid_qty_amts) {
                        String[] stringArray = string.split("#");
                        entryBalIds.add(Long.valueOf(stringArray[0]));
                        if (balCompress) {
                            if (BigDecimal.ZERO.compareTo(new BigDecimal(stringArray[4])) == 0) continue;
                            balanceId_elementId.put(Long.parseLong(stringArray[0]), Long.parseLong(stringArray[1]));
                            balanceId_subElementId.put(Long.parseLong(stringArray[0]), Long.parseLong(stringArray[2]));
                            balanceId_subamt.put(Long.parseLong(stringArray[0]), new BigDecimal(stringArray[4]));
                            continue;
                        }
                        balanceId_elementId.put(Long.parseLong(stringArray[0]), Long.parseLong(stringArray[1]));
                        balanceId_subElementId.put(Long.parseLong(stringArray[0]), Long.parseLong(stringArray[2]));
                        balanceId_subamt.put(Long.parseLong(stringArray[0]), new BigDecimal(stringArray[4]));
                    }
                }
                if (balCompress) {
                    Long[] defaultMaterialElements = CostElementHelper.getDefaultMaterialElements();
                    String defaultKey = defaultMaterialElements[1] + "#" + defaultMaterialElements[0];
                    for (List list3 : group_balid_eid_sid_qty_amts) {
                        void var47_80;
                        String[] id_eid_sid_qty_amt;
                        BigDecimal bigDecimal = BigDecimal.ZERO;
                        BigDecimal cur_group_qtysum = BigDecimal.ZERO;
                        boolean cur_group_allamt_zero = true;
                        boolean cur_group_allqty_not_zero = true;
                        for (String str : list3) {
                            id_eid_sid_qty_amt = str.split("#");
                            BigDecimal bigDecimal2 = var47_80.add(new BigDecimal(id_eid_sid_qty_amt[4]));
                            if (BigDecimal.ZERO.compareTo(new BigDecimal(id_eid_sid_qty_amt[4])) != 0) {
                                cur_group_allamt_zero = false;
                            }
                            if (BigDecimal.ZERO.compareTo(new BigDecimal(id_eid_sid_qty_amt[3])) == 0) {
                                cur_group_allqty_not_zero = false;
                            }
                            cur_group_qtysum = cur_group_qtysum.add(new BigDecimal(id_eid_sid_qty_amt[3]));
                        }
                        if (BigDecimal.ZERO.compareTo(cur_group_qtysum) == 0 || !cur_group_allqty_not_zero || !cur_group_allamt_zero || BigDecimal.ZERO.compareTo((BigDecimal)var47_80) != 0) continue;
                        for (String str : list3) {
                            id_eid_sid_qty_amt = str.split("#");
                            String eid_sid_key = id_eid_sid_qty_amt[1] + "#" + id_eid_sid_qty_amt[2];
                            if (!defaultKey.equals(eid_sid_key)) continue;
                            balanceId_elementId.put(Long.parseLong(id_eid_sid_qty_amt[0]), Long.parseLong(id_eid_sid_qty_amt[1]));
                            balanceId_subElementId.put(Long.parseLong(id_eid_sid_qty_amt[0]), Long.parseLong(id_eid_sid_qty_amt[2]));
                            balanceId_subamt.put(Long.parseLong(id_eid_sid_qty_amt[0]), new BigDecimal(id_eid_sid_qty_amt[4]));
                        }
                    }
                }
                balanceids.addAll(entryBalIds);
                for (List group_list : group_balid_eid_sid_qty_amts) {
                    ArrayList<Long> cur_balIds = new ArrayList<Long>(16);
                    for (String string : group_list) {
                        String[] balId_eid_sid_qty_amt = string.split("#");
                        cur_balIds.add(Long.valueOf(balId_eid_sid_qty_amt[0]));
                    }
                    QFilter qFilter = new QFilter("id", "in", cur_balIds);
                    new ExceCostHelper();
                    DataSet dataSet = ExceCostHelper.buildBalanceData((QFilter)qFilter, (boolean)true);
                    DataSet[] qty_amt_dataSet = dataSet.splitByFilter(new String[]{new QFilter(periodEndQtyField, "=", (Object)0).and(new QFilter(periodEndActualCostField, "!=", (Object)0)).toString(), new QFilter(periodEndQtyField, "=", (Object)0).and(new QFilter(periodEndActualCostField, "=", (Object)0)).toString()}, true);
                    DataSet dataSet2 = qty_amt_dataSet[0];
                    DataSet curDataSet_qty_amt_zero = qty_amt_dataSet[1];
                    DataSet curDataSet_rest = qty_amt_dataSet[2];
                    balanceDataSet1 = balanceDataSet1 == null ? dataSet2 : balanceDataSet1.union(dataSet2);
                    balanceDataSet_qty_amt_zero = balanceDataSet_qty_amt_zero == null ? curDataSet_qty_amt_zero : balanceDataSet_qty_amt_zero.union(curDataSet_qty_amt_zero);
                    if (balanceDataSet_rest == null) {
                        balanceDataSet_rest = curDataSet_rest;
                        continue;
                    }
                    balanceDataSet_rest = balanceDataSet_rest.union(curDataSet_rest);
                }
                if ((balanceDataSet_rest == null || balanceDataSet_rest.copy().isEmpty()) && (balanceDataSet1 == null || balanceDataSet1.copy().isEmpty()) && balanceDataSet_qty_amt_zero != null) {
                    Row row1 = null;
                    while (balanceDataSet_qty_amt_zero.hasNext()) {
                        row1 = balanceDataSet_qty_amt_zero.next();
                        if (costElementByCostAccount) {
                            String[] split2;
                            String balanceidsStr = row1.getString("balanceids");
                            for (String s : split2 = balanceidsStr.split(",")) {
                                if (StringUtils.isEmpty((String)s)) continue;
                                balanceids.add(Long.parseLong(s));
                            }
                        } else {
                            balanceids.add(row1.getLong("id"));
                        }
                        margin2 = BigDecimal.ZERO.subtract(row1.getBigDecimal("periodendactualcost"));
                        marginTotal = marginTotal.subtract((BigDecimal)margin2);
                        margin2 = biztype.equals("B") ? margin2.multiply(new BigDecimal(-1)) : margin2;
                        costAdjustBill = this.createGroupCostAdjustEntry(costAdjustBill, row1, (BigDecimal)margin2, biztype.equals("B"), seq, sumType, true, balanceId_elementId, balanceId_subElementId, balanceId_subamt, balanceId_detail_calsubamt, costAllSubElements, subElement_disabled_error, subElement_delete_error, dupSet);
                        seq = seq + 1;
                        costAdjustBillSeqMap.put(billKey, seq);
                    }
                }
            } else {
                List<String> currentEntryBalIds = Arrays.asList(entryentity.getString("balanceids_tag").substring(1).split(","));
                for (String balId : currentEntryBalIds) {
                    entryBalIds.add(Long.valueOf(balId));
                }
                balanceids.addAll(entryBalIds);
                QFilter qFilters1 = new QFilter("id", "in", entryBalIds);
                QFilter priorityQfilter = qFilters1.and(new QFilter(periodEndQtyField, "=", (Object)0)).and(new QFilter(periodEndActualCostField, "!=", (Object)0));
                balanceDataSet1 = ExceCostHelper.buildBalanceData((QFilter)priorityQfilter, (boolean)false);
            }
            Row row1 = null;
            while (balanceDataSet1 != null && balanceDataSet1.hasNext()) {
                row1 = balanceDataSet1.next();
                if (costElementByCostAccount) {
                    void var46_69;
                    String[] split;
                    String balanceidsStr = row1.getString("balanceids");
                    margin2 = split = balanceidsStr.split(",");
                    int split2 = margin2.length;
                    boolean bl = false;
                    while (var46_69 < split2) {
                        String string = margin2[var46_69];
                        if (!StringUtils.isEmpty((String)string)) {
                            balanceids.add(Long.parseLong(string));
                        }
                        ++var46_69;
                    }
                } else {
                    balanceids.add(row1.getLong("id"));
                }
                BigDecimal margin3 = BigDecimal.ZERO.subtract(row1.getBigDecimal("periodendactualcost"));
                marginTotal = marginTotal.subtract(margin3);
                margin3 = biztype.equals("B") ? margin3.multiply(new BigDecimal(-1)) : margin3;
                costAdjustBill = this.createGroupCostAdjustEntry(costAdjustBill, row1, margin3, biztype.equals("B"), seq, sumType, costElementByCostAccount, balanceId_elementId, balanceId_subElementId, balanceId_subamt, balanceId_detail_calsubamt, costAllSubElements, subElement_disabled_error, subElement_delete_error, dupSet);
                seq = seq + 1;
                costAdjustBillSeqMap.put(billKey, seq);
            }
            if (periodendqtyTotal.compareTo(BigDecimal.ZERO) != 0) {
                HashSet<Object> equalZero = new HashSet<Object>(16);
                balanceDataSet2 = null;
                if (costElementByCostAccount) {
                    for (List group_list : group_balid_eid_sid_qty_amts) {
                        ArrayList<Long> arrayList = new ArrayList<Long>(16);
                        for (String s : group_list) {
                            String[] balId_eid_sid_qty_amt = s.split("#");
                            arrayList.add(Long.valueOf(balId_eid_sid_qty_amt[0]));
                        }
                        QFilter qFilter = new QFilter("id", "in", arrayList);
                        DataSet cur = ExceCostHelper.buildBalanceData((QFilter)qFilter, (boolean)true).orderBy(new String[]{"periodendactualcost"});
                        cur = cur.filter(new QFilter(periodEndQtyField, "!=", (Object)0).toString());
                        if (balanceDataSet2 == null) {
                            balanceDataSet2 = cur;
                            continue;
                        }
                        balanceDataSet2 = balanceDataSet2.union(cur);
                    }
                    if (balanceDataSet2 != null) {
                        balanceDataSet2 = balanceDataSet2.orderBy(new String[]{"periodendactualcost"});
                    }
                } else {
                    normalQfilter = new QFilter("id", "in", entryBalIds);
                    normalQfilter.and(new QFilter(periodEndQtyField, "!=", (Object)0));
                    balanceDataSet2 = ExceCostHelper.buildBalanceData((QFilter)normalQfilter, (boolean)false).orderBy(new String[]{"periodendactualcost"});
                }
                list = new ArrayList(16);
                BigDecimal costDiff = BigDecimal.ZERO;
                while (balanceDataSet2 != null && balanceDataSet2.hasNext()) {
                    list = this.addMapRow(balanceDataSet2, list, costElementByCostAccount);
                }
                if (!list.isEmpty()) {
                    int n = Integer.parseInt(this.getPageCache().get(AMT_PRECISION));
                    BigDecimal bigDecimal = afteramount.divide(periodendqtyTotal, 10, 4);
                    for (int j = 0; j < list.size() - 1; ++j) {
                        Map<String, Object> map = list.get(j);
                        BigDecimal periodendqty = (BigDecimal)map.get("periodendqty");
                        BigDecimal periodendactualcost = (BigDecimal)map.get("periodendactualcost");
                        String[] entryId = (String[])map.get("id");
                        BigDecimal peerMargin = bigDecimal.multiply(periodendqty).setScale(n, RoundingMode.HALF_UP);
                        margin = peerMargin.subtract(periodendactualcost);
                        margin = biztype.equals("B") ? margin.multiply(new BigDecimal(-1)) : margin;
                        costDiff = costDiff.add(margin);
                        if (BigDecimal.ZERO.compareTo(margin) != 0) {
                            costAdjustBill = this.createGroupCostAdjustEntryDivide(costAdjustBill, map, margin, biztype.equals("B"), seq, sumType, costElementByCostAccount, balanceId_elementId, balanceId_subElementId, balanceId_subamt, balanceId_detail_calsubamt, costAllSubElements, subElement_disabled_error, subElement_delete_error, dupSet);
                            seq = seq + 1;
                            costAdjustBillSeqMap.put(billKey, seq);
                            continue;
                        }
                        if (costElementByCostAccount) {
                            String balanceidstr2;
                            String string = balanceidstr2 = map.get("balanceids") == null ? "" : (String)map.get("balanceids");
                            if (StringUtils.isEmpty((String)balanceidstr2)) continue;
                            for (String s : balanceidstr2.split(",")) {
                                if (StringUtils.isEmpty((String)s)) continue;
                                equalZero.add(Long.parseLong(s));
                            }
                            continue;
                        }
                        equalZero.add(entryId);
                    }
                    marginTotal = biztype.equals("B") ? marginTotal.multiply(new BigDecimal(-1)) : marginTotal;
                    BigDecimal lastMargin = marginTotal.subtract(costDiff);
                    Map<String, Object> map = list.get(list.size() - 1);
                    Long entryId = (Long)map.get("id");
                    if (BigDecimal.ZERO.compareTo(lastMargin) != 0) {
                        costAdjustBill = this.createGroupCostAdjustEntryDivide(costAdjustBill, list.get(list.size() - 1), lastMargin, biztype.equals("B"), seq, sumType, costElementByCostAccount, balanceId_elementId, balanceId_subElementId, balanceId_subamt, balanceId_detail_calsubamt, costAllSubElements, subElement_disabled_error, subElement_delete_error, dupSet);
                        seq = seq + 1;
                        costAdjustBillSeqMap.put(billKey, seq);
                    } else if (costElementByCostAccount) {
                        String string = balanceidstr = map.get("balanceids") == null ? "" : (String)map.get("balanceids");
                        if (!StringUtils.isEmpty((String)balanceidstr)) {
                            for (String s : balanceidstr.split(",")) {
                                if (StringUtils.isEmpty((String)s)) continue;
                                equalZero.add(Long.parseLong(s));
                            }
                        }
                    } else {
                        equalZero.add(entryId);
                    }
                    if (equalZero.size() != 0) {
                        balanceids.removeAll(equalZero);
                    }
                }
            } else {
                HashSet<Long> zero = new HashSet<Long>(16);
                balanceDataSet2 = null;
                if (costElementByCostAccount) {
                    for (List group_list : group_balid_eid_sid_qty_amts) {
                        ArrayList<Long> arrayList = new ArrayList<Long>(16);
                        for (String s : group_list) {
                            String[] balId_eid_sid_qty_amt = s.split("#");
                            arrayList.add(Long.valueOf(balId_eid_sid_qty_amt[0]));
                        }
                        QFilter qFilter = new QFilter("id", "in", arrayList);
                        DataSet cur = ExceCostHelper.buildBalanceData((QFilter)qFilter, (boolean)true).orderBy(new String[]{"periodendactualcost"});
                        cur = cur.filter(new QFilter(periodEndQtyField, "!=", (Object)0).toString());
                        if (balanceDataSet2 == null) {
                            balanceDataSet2 = cur;
                            continue;
                        }
                        balanceDataSet2 = balanceDataSet2.union(cur);
                    }
                    if (balanceDataSet2 != null) {
                        balanceDataSet2 = balanceDataSet2.orderBy(new String[]{"periodendactualcost"});
                    }
                } else {
                    normalQfilter = new QFilter("id", "in", entryBalIds);
                    normalQfilter.and(new QFilter(periodEndQtyField, "!=", (Object)0));
                    balanceDataSet2 = ExceCostHelper.buildBalanceData((QFilter)normalQfilter, (boolean)false).orderBy(new String[]{"periodendactualcost"});
                }
                list = new ArrayList<Map<String, Object>>(16);
                BigDecimal costDiff = BigDecimal.ZERO;
                while (balanceDataSet2 != null && balanceDataSet2.hasNext()) {
                    list = this.addMapRow(balanceDataSet2, list, costElementByCostAccount);
                }
                for (Map map : list) {
                    if (((BigDecimal)map.get("periodendqty")).compareTo(BigDecimal.ZERO) <= 0) continue;
                    periodendqtyTotal = periodendqtyTotal.add(((BigDecimal)map.get("periodendqty")).abs());
                }
                if (!list.isEmpty()) {
                    void var46_75;
                    boolean bl = false;
                    while (var46_75 < list.size() - 1) {
                        Map<String, Object> map = list.get((int)var46_75);
                        BigDecimal periodendqty = (BigDecimal)map.get("periodendqty");
                        Long balanceId = (Long)map.get("id");
                        int amtPrecision = Integer.parseInt(this.getPageCache().get(AMT_PRECISION));
                        BigDecimal price = marginTotal.abs().divide(periodendqtyTotal, 10, RoundingMode.HALF_UP);
                        BigDecimal periodEndAmt = (BigDecimal)map.get("periodendactualcost");
                        BigDecimal afterAdjAmt = price.multiply(periodendqty).setScale(amtPrecision, RoundingMode.HALF_UP);
                        costDiff = costDiff.add(afterAdjAmt);
                        margin = periodEndAmt.subtract(afterAdjAmt);
                        BigDecimal bigDecimal = margin = biztype.equals("B") ? margin : margin.multiply(new BigDecimal(-1));
                        if (BigDecimal.ZERO.compareTo(margin) != 0) {
                            costAdjustBill = this.createGroupCostAdjustEntryDivide(costAdjustBill, map, margin, biztype.equals("B"), seq, sumType, costElementByCostAccount, balanceId_elementId, balanceId_subElementId, balanceId_subamt, balanceId_detail_calsubamt, costAllSubElements, subElement_disabled_error, subElement_delete_error, dupSet);
                            seq = seq + 1;
                            costAdjustBillSeqMap.put(billKey, seq);
                        } else if (costElementByCostAccount) {
                            String balanceidstr3;
                            String string = balanceidstr3 = map.get("balanceids") == null ? "" : (String)map.get("balanceids");
                            if (!StringUtils.isEmpty((String)balanceidstr3)) {
                                for (String s : balanceidstr3.split(",")) {
                                    if (StringUtils.isEmpty((String)s)) continue;
                                    zero.add(Long.parseLong(s));
                                }
                            }
                        } else {
                            zero.add(balanceId);
                        }
                        ++var46_75;
                    }
                    Map<String, Object> map = list.get(list.size() - 1);
                    Long l = (Long)map.get("id");
                    BigDecimal periodEndAmt = (BigDecimal)map.get("periodendactualcost");
                    BigDecimal lastCostDiff = BigDecimal.ZERO.subtract(costDiff);
                    BigDecimal lastMargin = periodEndAmt.subtract(lastCostDiff);
                    BigDecimal bigDecimal = lastMargin = biztype.equals("B") ? lastMargin : lastMargin.multiply(new BigDecimal(-1));
                    if (BigDecimal.ZERO.compareTo(lastMargin) != 0) {
                        costAdjustBill = this.createGroupCostAdjustEntryDivide(costAdjustBill, list.get(list.size() - 1), lastMargin, biztype.equals("B"), seq, sumType, costElementByCostAccount, balanceId_elementId, balanceId_subElementId, balanceId_subamt, balanceId_detail_calsubamt, costAllSubElements, subElement_disabled_error, subElement_delete_error, dupSet);
                        seq = seq + 1;
                        costAdjustBillSeqMap.put(billKey, seq);
                    } else if (costElementByCostAccount) {
                        String string = balanceidstr = map.get("balanceids") == null ? "" : (String)map.get("balanceids");
                        if (!StringUtils.isEmpty((String)balanceidstr)) {
                            for (String s : balanceidstr.split(",")) {
                                if (StringUtils.isEmpty((String)s)) continue;
                                zero.add(Long.parseLong(s));
                            }
                        }
                    } else {
                        zero.add(l);
                    }
                    if (zero.size() != 0) {
                        balanceids.removeAll(zero);
                    }
                }
            }
        }
    }

    private Object getBaseDataValue(DynamicObject entryentity, String fieldKey) {
        Object baseDataId = entryentity.get(fieldKey);
        if (baseDataId instanceof DynamicObject) {
            baseDataId = ((DynamicObject)baseDataId).getLong("id");
        }
        return baseDataId;
    }

    private void doExportBillJob(Set<Object> balanceids, Collection<DynamicObject> collection, List<DynamicObject> balanceCostAdjustBillList, Long userId, Long calorgId, Set<Integer> errorIndex_detail, boolean costElementByCostAccount) {
        String content;
        String[] costAdj_entry_detail;
        String costAdj;
        String msg_detail = null;
        if (!errorIndex_detail.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Integer index : errorIndex_detail) {
                sb.append(index + 1).append("\u3001");
            }
            String errIndex = sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
            msg_detail = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5b58\u5728\u4f59\u989d\u660e\u7ec6\u6570\u91cf\u4e0d\u7b49\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355", (String)"ExceCostSummaryBillPlugin_37", (String)"fi-cal-formplugin", (Object[])new Object[0]), errIndex);
        }
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        ArrayList<Object> balanceids_arr = new ArrayList<Object>(balanceids);
        jobParams.put("balanceids", balanceids_arr);
        if (costElementByCostAccount) {
            costAdj = "cal_costadjust_subentity";
            costAdj_entry_detail = new String[]{"subentryentity"};
        } else {
            costAdj = "cal_costadjustbill";
            costAdj_entry_detail = new String[]{"entryentity"};
        }
        HashSet costAdjustHeadField = new HashSet(EntityMetadataCache.getDataEntityType((String)costAdj).getAllFields().keySet());
        List billFieldValueMaps = DynamicObjectUtils.dycsToMaps((DynamicObject[])collection.toArray(new DynamicObject[0]), costAdjustHeadField, (String[])costAdj_entry_detail);
        String collectionStr = SerializationUtils.toJsonString((Object)billFieldValueMaps);
        jobParams.put("costAdjustBillList", collectionStr);
        jobParams.put(SUMTYPE, this.getPageCache().get(SUMTYPE));
        jobParams.put("userId", userId);
        jobParams.put("calorgId", calorgId);
        jobParams.put("costaccountId", costAccount.getLong("id"));
        DynamicObject periodFilter = (DynamicObject)this.getModel().getValue(PERIOD);
        int period = periodFilter.getInt("periodyear") * 100 + periodFilter.getInt("periodnumber");
        jobParams.put("period", period);
        JobInfo job = new JobInfo();
        String OpName = content = String.format(ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u51fa\u5355-\u51fa\u5355:%1$s", (String)"ExceCostSummaryBillPlugin_33", (String)"fi-cal-formplugin", (Object[])new Object[0]), "11110000");
        job.setName(OpName);
        job.setTaskDefineId("2TEEVQD2PH05");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.cal.formplugin.summary.ExceExportBillTask");
        JobClient.dispatch((JobInfo)job);
        if (!StringUtils.isEmpty((String)msg_detail)) {
            String msg_error = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5176\u4f59\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u5728\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b\u5904\u7406\u7ed3\u679c\uff01", (String)"CalculateInCostPlugin_53", (String)"fi-cal-formplugin", (Object[])new Object[0]), msg_detail);
            this.getView().showMessage(msg_error);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u5728\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b\u5904\u7406\u7ed3\u679c\u3002", (String)"CalculateInCostPlugin_60", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Map<String, Object>> addMapRow(DataSet balanceDataSet, List<Map<String, Object>> list, boolean costElementByCostAccount) {
        HashMap<String, Object> mapRow = new HashMap<String, Object>(16);
        Row row = balanceDataSet.next();
        mapRow.put("id", row.get("id"));
        mapRow.put("storageorgunit", row.get("storageorgunit"));
        mapRow.put("material", row.get("material"));
        mapRow.put("assist", row.get("assist"));
        mapRow.put("lot", row.get("lot"));
        mapRow.put("warehouse", row.get("warehouse"));
        mapRow.put("location", row.get("location"));
        mapRow.put("ownertype", row.get("ownertype"));
        mapRow.put("owner", row.get("owner"));
        mapRow.put("baseunit", row.get("baseunit"));
        mapRow.put("project", row.get("project"));
        mapRow.put("invtype", row.get("invtype"));
        mapRow.put("invstatus", row.get("invstatus"));
        mapRow.put("configuredcode", row.get("configuredcode"));
        mapRow.put("tracknumber", row.get("tracknumber"));
        mapRow.put("periodendqty", row.get("periodendqty"));
        mapRow.put("periodendactualcost", row.get("periodendactualcost"));
        if (costElementByCostAccount) {
            mapRow.put("balanceids", row.get("balanceids"));
        }
        MainEntityType balanceEntityType = MetadataServiceHelper.getDataEntityType((String)CAL_BALANCE);
        Set exFields = CommonSettingHelper.getExFieldSet();
        exFields.retainAll(balanceEntityType.getAllFields().keySet());
        for (String item : exFields) {
            mapRow.put(item, row.get(item));
        }
        list.add(mapRow);
        return list;
    }

    private void doDeleteBillOperation() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(CALORG);
        Long orgId = (Long)org.getPkValue();
        Long userId = Long.valueOf(this.getPageCache().get("userId"));
        this.chkExportBillPermission(orgId, userId, DELETE_BILL, ResManager.loadKDString((String)"\u5220\u5355", (String)"ExceCostSummaryBillPlugin_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        EntryGrid billEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = billEntryGrid.getSelectRows();
        if (selectRows.length < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExceCostSummaryBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        boolean costElementByCostAccount = false;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DynamicObject accountDyc = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (isNewBalance && accountDyc != null) {
            costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)((Long)accountDyc.getPkValue()));
        }
        this.checkCalingBill();
        ArrayList<Long> costadjustbillids = new ArrayList<Long>(16);
        ArrayList<Long> balanceids = new ArrayList<Long>(16);
        String sumType = this.getPageCache().get(SUMTYPE);
        for (int i : selectRows) {
            String[] rowBalanceIds;
            DynamicObjectCollection entryentitys = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            DynamicObject entryentity = (DynamicObject)entryentitys.get(i);
            if (SumTypeEnum.DETAILED.getValue().equals(sumType)) {
                costadjustbillids.add(entryentity.getLong("costadjustbillid"));
                balanceids.add(entryentity.getLong("balanceid"));
                continue;
            }
            costadjustbillids.add(entryentity.getLong("costadjustbillid"));
            if (costElementByCostAccount) {
                HashSet balIds = new HashSet();
                List balanceids_tags = (List)JSONObject.parseObject((String)entryentity.getString("balanceids_tag"), List.class);
                for (Object balanceids_tag : balanceids_tags) {
                    List balanceids_tag_list = (List)JSONObject.parseObject((String)balanceids_tag.toString(), List.class);
                    for (String tag : balanceids_tag_list) {
                        Stream.of(tag).filter(s -> !StringUtils.isEmpty((String)s)).forEach(s -> {
                            String[] balId_eid_sid_qty_amt = s.split("#");
                            balIds.add(Long.parseLong(balId_eid_sid_qty_amt[0]));
                        });
                    }
                }
                balanceids.addAll(balIds);
                continue;
            }
            for (String string : rowBalanceIds = entryentity.getString("balanceids_tag").split(",")) {
                if (!StringUtils.isNotEmpty((String)string)) continue;
                balanceids.add(Long.valueOf(string));
            }
        }
        this.doDeleteBillJob(balanceids, costadjustbillids, userId);
    }

    private void doDeleteBillJob(List<Long> balanceids, List<Long> costadjustbillids, Long userId) {
        String content;
        DynamicObject calorg = this.getModel().getDataEntity().getDynamicObject(CALORG);
        long calorgid = calorg.getLong("id");
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        jobParams.put("balanceids", balanceids);
        jobParams.put("costadjustbillids", costadjustbillids);
        jobParams.put("SUMTYPE", this.getPageCache().get(SUMTYPE));
        jobParams.put("userId", userId);
        jobParams.put("calorgId", calorgid);
        jobParams.put("costaccountId", costAccount.getLong("id"));
        JobInfo job = new JobInfo();
        String OpName = content = String.format(ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u51fa\u5355-\u5220\u5355:%1$s", (String)"ExceCostSummaryBillPlugin_34", (String)"fi-cal-formplugin", (Object[])new Object[0]), "00001111");
        job.setName(OpName);
        job.setTaskDefineId("2TEEYV6GH2DP");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setTaskClassname("kd.fi.cal.formplugin.summary.ExceDeleteBillTask");
        job.setRunByLang(Lang.get());
        JobClient.dispatch((JobInfo)job);
        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u5728\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b\u5904\u7406\u7ed3\u679c\u3002", (String)"CalculateInCostPlugin_60", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBalanceDataByFilter(QFilter[] filters, Long costAccountId) {
        DynamicObject calorg = (DynamicObject)this.getModel().getValue(CALORG);
        Long orgId = calorg.getLong("id");
        String biztype = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"costsumbiztype");
        DynamicObject billtype = (DynamicObject)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"costsumbilltype");
        if (biztype == null || billtype == null) {
            this.getPageCache().put("biztype", "B");
            QFilter q = new QFilter("number", "=", (Object)"im_SalOutBill_STD_BT_S");
            Long billtypeId = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id", (QFilter[])q.toArray()).getLong("id");
            this.getPageCache().put("billtype", String.valueOf(billtypeId));
        } else {
            this.getPageCache().put("biztype", biztype);
            this.getPageCache().put("billtype", String.valueOf(billtype.getLong("id")));
        }
        String sumType = this.getPageCache().get(SUMTYPE);
        Object balanceDataset = null;
        Object balanceDataset2 = null;
        Object balanceCostadjustDataset = null;
        Object costadjustBillDataset = null;
        Object groupDataset = null;
        Object oneGroupDataset = null;
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        JobSession session = AlgoX.createSession((String)"cal.ExceCostSummaryBillPlugin");
        try {
            this.setProgress(0);
            this.getPageCache().put(BAR_KEY, "0");
            bar.start();
            DynamicObject costAccountInfo = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT);
            if (costAccountInfo == null) {
                return;
            }
            if (SumTypeEnum.DETAILED.getValue().equals(sumType)) {
                ThreadPools.executeOnceIncludeRequestContext((String)"fi-cal-ExceCostSummaryBillPlugin-Detail", () -> {
                    try {
                        DataSetX detailDataSetX = this.getDetailDataSetX(filters, sumType, null, session, costAccountId);
                        RowMeta resultMeta = detailDataSetX.getRowMeta();
                        DataSetOutput resultSet = new DataSetOutput(resultMeta);
                        String resultId = resultSet.getId();
                        detailDataSetX.output((Output)resultSet);
                        session.commit(10, TimeUnit.HOURS);
                        DataSet detailDataSet = session.readDataSet(resultId);
                        bar.setPercent(75);
                        CacheHint cacheHint = new CacheHint();
                        cacheHint.setTimeout(3600L, TimeUnit.SECONDS);
                        CachedDataSet cache = detailDataSet.cache(cacheHint);
                        String cacheId = cache.getCacheId();
                        logger.info("input cacheId is : " + cacheId);
                        this.getPageCache().put("cacheId", cacheId);
                    }
                    catch (Exception e) {
                        this.getPageCache().put("cacheId", Exception.class.getName() + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                        logger.info("exceCostSummaryBillPlugin before asynchronized1 error : ", (Object)e);
                        throw new KDBizException(e.getMessage());
                    }
                });
            } else if (SumTypeEnum.HUAFENYIJU.getValue().equals(sumType)) {
                ThreadPools.executeOnceIncludeRequestContext((String)"fi-cal-ExceCostSummaryBillPlugin-hufenyiju", () -> {
                    try {
                        HashSet<String> allField = new HashSet<String>(16);
                        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_excebalancesumlist");
                        EntryProp entryProp = (EntryProp)entitytype.getProperty("entryentity");
                        for (IDataEntityProperty pro : entryProp.getDynamicCollectionItemPropertyType().getProperties()) {
                            if (pro instanceof AmountProp || pro instanceof QtyProp || pro instanceof LongProp) continue;
                            allField.add(pro.getName());
                        }
                        allField.remove("balanceids");
                        ArrayList<String> selectFields = new ArrayList<String>(32);
                        selectFields.addAll(allField);
                        selectFields.add("periodendqty");
                        selectFields.add("periodendactualcost");
                        selectFields.add("margin");
                        ArrayList<Long> moreThanOne = new ArrayList<Long>(16);
                        ArrayList<Long> equalOne = new ArrayList<Long>(16);
                        ArrayList<Long> equalZero = new ArrayList<Long>(16);
                        HashSet<String> maxDimensionFields = new HashSet<String>(16);
                        HashSet<String> maxDivideContainer = new HashSet<String>(16);
                        HashMap<Long, String> calDimension = new HashMap<Long, String>(16);
                        HashMap<String, List<Long>> divideAndCalRangeId = new HashMap<String, List<Long>>(16);
                        this.getDimension(maxDimensionFields, calDimension);
                        DataSet oneEntryDataSet = this.splitCalRange(costAccountInfo.getPkValue(), divideAndCalRangeId, moreThanOne, equalOne, equalZero, maxDivideContainer);
                        if (maxDivideContainer.size() == 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u6ca1\u6709\u53ef\u7528\u7684\u6838\u7b97\u8303\u56f4\u3002", (String)"ExceCostSummaryBillPlugin_50", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                        }
                        ArrayList<Object> allFieldContainer = new ArrayList<Object>(16);
                        allFieldContainer.add(maxDivideContainer);
                        allFieldContainer.add(maxDimensionFields);
                        DataSetX detailDataSetX = this.getDetailDataSetX(filters, sumType, allFieldContainer, session, costAccountId);
                        ArrayList<DataSetX> allDataSetX = new ArrayList<DataSetX>(16);
                        if (detailDataSetX != null) {
                            for (Map.Entry entry : divideAndCalRangeId.entrySet()) {
                                QFilter q;
                                HashSet<String> divides;
                                List calRangeIds;
                                String divide = (String)entry.getKey();
                                if (divide.equals(NOTEMPTY_GROUPFIELD)) {
                                    calRangeIds = (List)divideAndCalRangeId.get(NOTEMPTY_GROUPFIELD);
                                    divides = new HashSet(16);
                                    divides.add(NOTEMPTY_GROUPFIELD);
                                    q = new QFilter(NOTEMPTY_GROUPFIELD, "in", (Object)calRangeIds);
                                    this.groupByDivideAndDimension(calDimension, detailDataSetX, divides, q, allDataSetX, costAccountId);
                                    continue;
                                }
                                calRangeIds = (List)divideAndCalRangeId.get(divide);
                                divides = new HashSet<String>();
                                divides.addAll(Arrays.asList(divide.split(",")));
                                q = new QFilter(NOTEMPTY_GROUPFIELD, "in", (Object)calRangeIds);
                                this.groupByDivideAndDimension(calDimension, detailDataSetX, divides, q, allDataSetX, costAccountId);
                            }
                        }
                        ArrayList<Object> allResult = new ArrayList<Object>(16);
                        ArrayList<String> resultIds = new ArrayList<String>(16);
                        for (DataSetX dataSetX : allDataSetX) {
                            RowMeta resultMeta = dataSetX.getRowMeta();
                            DataSetOutput dataSetOutput = new DataSetOutput(resultMeta);
                            dataSetX.output((Output)dataSetOutput);
                            String resultId = dataSetOutput.getId();
                            resultIds.add(resultId);
                        }
                        session.commit(10, TimeUnit.HOURS);
                        for (String curResultId : resultIds) {
                            Object resultDataSet = session.readDataSet(curResultId);
                            Field[] fieldArray = resultDataSet.getRowMeta().getFields();
                            ArrayList<String> removeFields = new ArrayList<String>(fieldArray.length);
                            for (Field field : fieldArray) {
                                removeFields.add(field.getName());
                            }
                            ArrayList<String> newAll = new ArrayList<String>(16);
                            newAll.addAll(selectFields);
                            newAll.removeAll(removeFields);
                            StringBuilder sbField = new StringBuilder(String.join((CharSequence)",", removeFields));
                            for (String string : newAll) {
                                sbField.append(",NULL as ").append(string);
                            }
                            resultDataSet = resultDataSet.select(sbField.toString());
                            allResult.add(resultDataSet);
                        }
                        logger.info("DataSetX -> DataSet success");
                        logger.info("input dataSet is prepared");
                        selectFields.add("expsortflag");
                        selectFields.add("costadjusstbillid");
                        selectFields.add("costadjustbillno");
                        selectFields.add("costadjustbillids");
                        selectFields.add("costadjustbillids_tag");
                        DataSet totalSet = null;
                        String[] sameOrderFields = null;
                        for (DataSet dataSet : allResult) {
                            if (totalSet == null) {
                                sameOrderFields = dataSet.copy().getRowMeta().getFieldNames();
                                totalSet = dataSet;
                                continue;
                            }
                            DataSet dataSet2 = dataSet.select(sameOrderFields);
                            totalSet = totalSet.union(dataSet2);
                        }
                        boolean isexcedata = this.getModel().getDataEntity().getBoolean(ISEXCEDATA);
                        if (isexcedata && totalSet != null) {
                            totalSet = this.filterFinalDisplayDataSet(totalSet);
                        }
                        logger.info("input dataSet is prepared");
                        bar.setPercent(75);
                        CacheHint cacheHint = new CacheHint();
                        cacheHint.setTimeout(3600L, TimeUnit.SECONDS);
                        CachedDataSet cache = totalSet.cache(cacheHint);
                        String cacheId = cache.getCacheId();
                        logger.info("input cacheId is : " + cacheId);
                        this.getPageCache().put("cacheId", cacheId);
                    }
                    catch (Exception e) {
                        this.getPageCache().put("cacheId", Exception.class.getName() + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                        logger.info("exceCostSummaryBillPlugin before asynchronized1 error : ", (Object)e);
                        throw new KDBizException(e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("exceCostSummaryBillPlugin before asynchronized error : ", (Object)e);
            String errorMsg = ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u6c47\u62a5\u8868\u67e5\u8be2\u5f02\u5e38\u62a5\u9519\u3002", (String)"ExceCostSummaryBillPlugin_31", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            String errorContent = e.getMessage();
            if (!StringUtils.isEmpty((String)errorContent) && errorContent.length() > 250) {
                errorContent = errorContent.substring(0, 251);
            }
            this.setProgress(100);
            bar.stop();
            this.getView().showErrorNotification(errorMsg + errorContent);
        }
        finally {
            if (balanceDataset != null) {
                balanceDataset.close();
            }
            if (balanceCostadjustDataset != null) {
                balanceCostadjustDataset.close();
            }
            if (costadjustBillDataset != null) {
                costadjustBillDataset.close();
            }
            if (balanceDataset2 != null) {
                balanceDataset2.close();
            }
            if (groupDataset != null) {
                groupDataset.close();
            }
        }
    }

    private DataSet filterFinalDisplayDataSet(DataSet dataSet) {
        boolean costElementByCostAccount = false;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DynamicObject accountDyc = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (isNewBalance && accountDyc != null) {
            costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)((Long)accountDyc.getPkValue()));
        }
        if (costElementByCostAccount) {
            return dataSet.filter("(periodendqty = 0 AND periodendactualcost != 0) OR (periodendqty != 0 AND periodendactualcost = 0) OR (periodendqty < 0 AND periodendactualcost > 0) OR (periodendqty > 0 AND periodendactualcost < 0) OR (periodendqty = 0 AND periodendactualcost = 0)");
        }
        return dataSet.filter("(periodendqty = 0 AND periodendactualcost != 0) OR (periodendqty != 0 AND periodendactualcost = 0) OR (periodendqty < 0 AND periodendactualcost > 0) OR (periodendqty > 0 AND periodendactualcost < 0)");
    }

    private void getDimension(Set<String> maxDimensionFields, Map<Long, String> calDimension) {
        String dimensionQueryFields = "id,caldimension";
        try (DataSet totalDimensionFields = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_caldimension", (String)dimensionQueryFields, null, null);){
            for (Row row : totalDimensionFields) {
                String[] calDimensions;
                Long calDimensionId = row.getLong("id");
                String calDimensionStr = row.getString("caldimension");
                calDimension.put(calDimensionId, calDimensionStr);
                for (String calDimensionField : calDimensions = calDimensionStr.split(",")) {
                    if (calDimensionField == null || calDimensionField.length() == 0) continue;
                    maxDimensionFields.add(calDimensionField);
                }
            }
        }
        calDimension.put(0L, "");
    }

    private Set<String> combineCalBalanceDimension(Set<String> divide) {
        divide.add("calorg");
        divide.add("costaccount");
        divide.add("material");
        divide.add("baseunit");
        return divide;
    }

    private void groupByDivideAndDimension(Map<Long, String> calDimension, DataSetX totalDataSetX, Set<String> dividesFields, QFilter q, List<DataSetX> allDataSetX, Long costAccountId) {
        dividesFields = this.combineCalBalanceDimension(dividesFields);
        HashSet<String> finalContainer = new HashSet<String>(16);
        finalContainer.addAll(Arrays.asList(special));
        for (String field : dividesFields) {
            if (field == null || field.length() == 0) continue;
            finalContainer.add(field);
        }
        String[] beginGroupFields = finalContainer.toArray(new String[0]);
        RowMeta rowMeta = totalDataSetX.getRowMeta();
        DataSetX calDimensionData = totalDataSetX.filter(q.toString()).groupBy(beginGroupFields).reduceGroup((GroupReduceFunction)new ExceCostSummaryReduceFunction(rowMeta, calDimension));
        String[] finalGroupFields = new String[beginGroupFields.length + 1];
        System.arraycopy(beginGroupFields, 0, finalGroupFields, 0, beginGroupFields.length);
        finalGroupFields[beginGroupFields.length] = "caldimensionvalue";
        String[] fieldNames = calDimensionData.getRowMeta().getFieldNames();
        String[] resultFields = new String[fieldNames.length + 1];
        System.arraycopy(fieldNames, 0, resultFields, 0, fieldNames.length);
        resultFields[fieldNames.length] = "balanceids_tag";
        DataSetX oneDimensionData = calDimensionData.groupBy(finalGroupFields).reduceGroup((GroupReduceFunction)new ExceCostSummaryGroupFunction(calDimensionData.getRowMeta())).select(resultFields);
        oneDimensionData = oneDimensionData.flatMap((FlatMapFunction)new MatchCalRangeDataXFunction(oneDimensionData.getRowMeta(), costAccountId, new String[]{NOTEMPTY_GROUPFIELD, "caldimension", "mal_group_longnumber", "material"}));
        boolean costElementByCostAccount = false;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DynamicObject accountDyc = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (isNewBalance && accountDyc != null) {
            costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)((Long)accountDyc.getPkValue()));
        }
        oneDimensionData = oneDimensionData.filter((FilterFunction)new ExceCostSummaryFilterFunction(oneDimensionData.getRowMeta(), costElementByCostAccount, this.getModel().getDataEntity().getBoolean(ISEXCEDATA)));
        allDataSetX.add(oneDimensionData);
    }

    private DataSet getBalanceAndCostAdjust(QFilter[] filters, String sumType, List<Object> container, DynamicObject accountInfo, boolean fromPage, boolean costElementByCostAccount) {
        String isExportBill;
        if (fromPage) {
            this.getPageCache().put(BAR_KEY, "15");
        }
        DataSet balanceDataset = SumTypeEnum.DETAILED.getValue().equals(sumType) ? ExceCostHelper.buildBalanceData((QFilter)filters[0], (boolean)costElementByCostAccount) : this.getDefaultEmptyDataSet();
        if (fromPage) {
            this.getPageCache().put(BAR_KEY, "25");
        }
        if (fromPage) {
            this.getPageCache().put(BAR_KEY, "50");
        }
        QFilter qf = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        Set balDimFields = ExceCostHelper.getBalDimFields((String)sumType, (boolean)false);
        DataSet costAdjustDataSet = ExceCostHelper.createCostAdjust_matched_BALEND((boolean)costElementByCostAccount, (Set)balDimFields, (QFilter[])new QFilter[]{filters[1]}, (Long)((Long)accountInfo.getPkValue()), null, (boolean)fromPage);
        JoinDataSet joinDataSet = balanceDataset.leftJoin(costAdjustDataSet);
        for (String dim : balDimFields) {
            joinDataSet.on(dim, dim);
        }
        DataSet dataSet = joinDataSet.select(balanceDataset.getRowMeta().getFieldNames(), new String[]{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak", "margin"}).finish();
        DataSet detailDataset = dataSet.groupBy((String[])ArrayUtils.concatAll((Object[])balanceDataset.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak"}})).sum("margin").finish();
        detailDataset = detailDataset.where("periodendqty <> 0 or periodendactualcost <> 0 or exportflag = 'C'");
        if (fromPage) {
            this.getPageCache().put(BAR_KEY, "75");
        }
        if ("B".equals(isExportBill = (String)this.getModel().getValue(ISEXPORTBILL))) {
            detailDataset = detailDataset.where("exportflag = null or exportflag = 'B'");
        } else if ("C".equals(isExportBill)) {
            detailDataset = detailDataset.where("exportflag = 'C'");
        } else if ("D".equals(isExportBill)) {
            detailDataset = detailDataset.where("exportflag = 'D'");
        } else if ("E".equals(isExportBill)) {
            detailDataset = detailDataset.where("exportflag = 'E'");
        }
        return detailDataset;
    }

    private Input[] createBalanceData(Map<Integer, Set<Long>> materialIdMap, List<Object> container, QFilter[] filters, String sumType, String balName, boolean costElementByCostAccount, boolean isNewBalance) {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        ArrayList<DataSetInput> inputList_compression = new ArrayList<DataSetInput>();
        logger.info("ExceCostSummaryBillPlugin\uff1a\u6838\u7b97\u4f59\u989d\u8868\u5f00\u59cb\u5e76\u884c\u53d6\u6570,\u5171" + materialIdMap.size() + "\u6279");
        for (Map.Entry<Integer, Set<Long>> entry : materialIdMap.entrySet()) {
            QFilter filter = new QFilter("material", "in", entry.getValue());
            inputList.add(new OrmInput(((Object)((Object)this)).getClass().getName(), balName, this.getBalSelectFields(container, sumType, costElementByCostAccount) + ",period", new QFilter[]{filters[0], filter}));
        }
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        if (balCompress && isNewBalance) {
            HashSet<String> otherFields = new HashSet<String>();
            otherFields.add("material.group.longnumber");
            otherFields.add("caldimension");
            otherFields.add("calrange");
            ArrayList<QFilter> q = new ArrayList<QFilter>();
            q.add(filters[0]);
            DataSet balancDataSetDetail = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)false, otherFields, q).select(this.getBalSelectFields(container, sumType, costElementByCostAccount) + ",period");
            if (SumTypeEnum.DETAILED.getValue().equals(sumType) && filters.length == 2 && filters[2] != null) {
                balancDataSetDetail = balancDataSetDetail.filter(filters[2].toString());
            }
            inputList_compression.add(new DataSetInput(balancDataSetDetail));
            return inputList_compression.toArray(new Input[inputList.size()]);
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    private Input[] createBalCostAdjustDataNew(boolean costElementByCostAccount, Set<String> dims, QFilter[] qFilter) {
        ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
        Long costAccountId = (Long)((DynamicObject)this.getModel().getValue(COSTACCOUNT)).getPkValue();
        Long periodId = (Long)((DynamicObject)this.getModel().getValue(PERIOD)).getPkValue();
        DataSet costAdjustBill = ExceCostHelper.createCostAdjust_matched_BALEND((boolean)costElementByCostAccount, dims, (QFilter[])new QFilter[]{qFilter[1]}, (Long)costAccountId, (Long)periodId, (boolean)true);
        inputList.add(new DataSetInput(costAdjustBill));
        return inputList.toArray(new Input[inputList.size()]);
    }

    private QFilter getCurPeriodAdjFilter() {
        Set<Object> pkSet;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject calOrgFilter = dataEntity.getDynamicObject(CALORG);
        DynamicObject costAccountFilter = dataEntity.getDynamicObject(COSTACCOUNT);
        DynamicObject periodFilter = dataEntity.getDynamicObject(PERIOD);
        DynamicObjectCollection storageorgunitFilter = dataEntity.getDynamicObjectCollection(STORAGEORG);
        DynamicObjectCollection warehouseFilter = dataEntity.getDynamicObjectCollection(WAREHOUSE);
        DynamicObjectCollection locationFilter = dataEntity.getDynamicObjectCollection(LOCATION);
        String lotFilter = dataEntity.getString(LOT);
        DynamicObjectCollection projectFilter = dataEntity.getDynamicObjectCollection(PROJECT);
        DynamicObjectCollection configuredcodeFilter = dataEntity.getDynamicObjectCollection(CONFIGUREDCODE);
        QFilter filter = this.getBaseFilter(calOrgFilter.getLong("id"), costAccountFilter.getLong("id"));
        if (null != storageorgunitFilter && storageorgunitFilter.size() > 0) {
            pkSet = this.getMulDataPK(storageorgunitFilter);
            filter.and(new QFilter("entryentity.storageorgunit", "in", pkSet));
        }
        if (null != warehouseFilter && warehouseFilter.size() > 0) {
            pkSet = this.getMulDataPK(warehouseFilter);
            filter.and(new QFilter("entryentity.warehouse", "in", pkSet));
        }
        if (null != locationFilter && locationFilter.size() > 0) {
            pkSet = this.getMulDataPK(locationFilter);
            filter.and(new QFilter("entryentity.location", "in", pkSet));
        }
        if (null != periodFilter) {
            filter.and("period", "=", periodFilter.getPkValue());
        }
        if (StringUtils.isNotEmpty((String)lotFilter)) {
            String[] split = lotFilter.split(";");
            HashSet<String> lotSet = new HashSet<String>(split.length);
            lotSet.addAll(Arrays.asList(split));
            filter.and("entryentity.lot", "in", lotSet);
        }
        if (null != projectFilter && projectFilter.size() > 0) {
            pkSet = this.getMulDataPK(projectFilter);
            filter.and("entryentity.project", "in", pkSet);
        }
        if (null != configuredcodeFilter && configuredcodeFilter.size() > 0) {
            pkSet = this.getMulDataPK(configuredcodeFilter);
            filter.and("entryentity.configuredcode", "in", pkSet);
        }
        DynamicObjectCollection materialFrom = this.getModel().getDataEntity().getDynamicObjectCollection(MATERIALFROM);
        DynamicObject materialTo = this.getModel().getDataEntity().getDynamicObject(MATERIALTO);
        String matProp = "entryentity.material";
        QFilter matFilter = new MatFromToFilter().getMatFilter(materialFrom, materialTo, matProp);
        filter.and(matFilter);
        return filter;
    }

    private String getBalSelectFields(List<Object> container, String sumType, boolean costElementByCostAccount) {
        String selectFields;
        String fields = ExceCostHelper.getBalanceFields((boolean)false, (boolean)true, (boolean)costElementByCostAccount);
        if (SumTypeEnum.DETAILED.getValue().equals(sumType)) {
            StringBuilder sb = new StringBuilder();
            String[] f = fields.split(",");
            for (int i = 0; i < f.length; ++i) {
                if ("currency".equals(f[i])) continue;
                if (i != f.length - 1) {
                    sb.append(f[i]).append(",");
                    continue;
                }
                sb.append(f[i]);
            }
            fields = sb.toString();
            return fields + ",material.group.longnumber as mal_group_longnumber,id as balanceid";
        }
        Set divideContainer = (Set)container.get(0);
        Set dimension = (Set)container.get(1);
        HashSet divide = new HashSet(16);
        if (divideContainer != null && divideContainer.size() > 0) {
            divide.addAll(divideContainer);
        }
        String[] calBalanceDimensionFields = fields.split(",");
        HashSet<String> calBalanceDimension = new HashSet<String>(16);
        calBalanceDimension.addAll(Arrays.asList(calBalanceDimensionFields));
        calBalanceDimension.removeAll(divide);
        calBalanceDimension.removeAll(dimension);
        calBalanceDimension.remove("currency");
        StringBuilder calBalBuilder = new StringBuilder();
        for (String calBalDimension : calBalanceDimension) {
            calBalBuilder.append(calBalDimension).append(",");
        }
        String calBalFields = calBalBuilder.toString().substring(0, calBalBuilder.length() - 1);
        ArrayList divideArray = new ArrayList(divide);
        ArrayList dimensionArray = new ArrayList(dimension);
        if (divideArray.size() != 0) {
            int i;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < divideArray.size(); ++i) {
                if (i != divide.size() - 1) {
                    sb.append((String)divideArray.get(i)).append(",");
                    continue;
                }
                sb.append((String)divideArray.get(i));
            }
            if (!divideArray.isEmpty()) {
                sb.append(",");
            }
            for (i = 0; i < dimensionArray.size(); ++i) {
                if (i != dimensionArray.size() - 1) {
                    sb.append((String)dimensionArray.get(i)).append(",");
                    continue;
                }
                sb.append((String)dimensionArray.get(i));
            }
            selectFields = sb.append(",").append(calBalFields).append(",material.group.longnumber as mal_group_longnumber,calrange as calrangeid,caldimension,id as balanceid").toString();
        } else {
            selectFields = fields + ",material.group.longnumber as mal_group_longnumber,id as balanceid";
        }
        return selectFields;
    }

    private String getBalCostAdjustFields() {
        StringBuilder fields = new StringBuilder();
        fields.append("balanceid,");
        fields.append("costadjustbillid,");
        fields.append("costadjustbillno,");
        fields.append("adjustamt as margin");
        return fields.toString();
    }

    private DataSet getDefaultEmptyDataSet() {
        String balName = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balName = "cal_bal";
        }
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)balName, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)0)}, null);
    }

    private DataSet splitCalRange(Object costAccountId, Map<String, List<Long>> divideAndCalRangeId, List<Long> moreThanOne, List<Long> equalOne, List<Long> entryEqualZero, Set<String> maxDivideContainer) {
        Long calRangeId;
        HashMap calRangeIdAndEntryId = new HashMap(16);
        QFilter qCalRange = new QFilter("costaccount", "=", costAccountId);
        qCalRange.and("status", "=", (Object)"C");
        qCalRange.and("enable", "=", (Object)true);
        String calRangeSelectFields = "id,dividebasis.dividebasis,entry.id,entry.calorg,entry.owner,entry.location,entry.storageorgunit,entry.warehouse";
        DataSet calRangeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_calrange", (String)calRangeSelectFields, (QFilter[])new QFilter[]{qCalRange}, null);
        DataSet standby = calRangeDataSet.copy();
        HashSet<Long> equalZero = new HashSet<Long>(16);
        for (Object row : calRangeDataSet) {
            List<Long> entryIds;
            List<Object> calIds;
            String string = row.getString("dividebasis.dividebasis");
            calRangeId = row.getLong("id");
            Long entryId = row.getLong("entry.id");
            if (calRangeId == null) continue;
            maxDivideContainer.addAll(Arrays.asList(string.split(",")));
            if (entryId == 0L) {
                equalZero.add(calRangeId);
                if (!divideAndCalRangeId.containsKey(string)) {
                    calIds = new ArrayList(16);
                    calIds.add(calRangeId);
                    divideAndCalRangeId.put(string, calIds);
                } else {
                    calIds = divideAndCalRangeId.get(string);
                    calIds.add(calRangeId);
                }
            } else if (!divideAndCalRangeId.containsKey(NOTEMPTY_GROUPFIELD)) {
                calIds = new ArrayList(16);
                calIds.add(calRangeId);
                divideAndCalRangeId.put(NOTEMPTY_GROUPFIELD, calIds);
            } else {
                calIds = divideAndCalRangeId.get(NOTEMPTY_GROUPFIELD);
                calIds.add(calRangeId);
            }
            if (!calRangeIdAndEntryId.containsKey(calRangeId)) {
                entryIds = new ArrayList(16);
                entryIds.add(entryId);
                calRangeIdAndEntryId.put(calRangeId, entryIds);
                continue;
            }
            entryIds = (List)calRangeIdAndEntryId.get(calRangeId);
            entryIds.add(entryId);
        }
        HashSet<Long> entryEqualOne = new HashSet<Long>(16);
        for (Map.Entry entry : calRangeIdAndEntryId.entrySet()) {
            if (((List)entry.getValue()).size() <= 0) continue;
            if (((List)entry.getValue()).size() == 1 && !equalZero.contains(calRangeId = (Long)entry.getKey())) {
                entryEqualOne.add(calRangeId);
            }
            if (equalZero.contains(entry.getKey())) continue;
            moreThanOne.add((Long)entry.getKey());
        }
        entryEqualZero.addAll(equalZero);
        if (entryEqualOne.size() != 0) {
            equalOne.addAll(entryEqualOne);
            StringBuilder selectFields = new StringBuilder();
            selectFields.append("id,entry.id,");
            for (String field : maxDivideContainer) {
                selectFields.append("entry.").append(field).append(",");
            }
            String string = selectFields.substring(0, selectFields.length() - 1);
            standby = standby.where(new QFilter("id", "in", entryEqualOne).toString()).select(string);
            return standby;
        }
        return null;
    }

    private DataSet doDetailJoinOperation(DataSet balanceDataset, DataSet balanceCostadjustDataset) {
        DataSet dataSet = balanceDataset.join(balanceCostadjustDataset, JoinType.LEFT).on("id", "balanceid").select(balanceDataset.getRowMeta().getFieldNames(), (String[])ArrayUtils.concatAll((Object[])fields2, (Object[][])new String[][]{{"exportflagbak"}})).finish().groupBy((String[])ArrayUtils.concatAll((Object[])balanceDataset.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"balanceid", "costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak"}})).sum("margin").finish();
        return dataSet;
    }

    private void loadDetailRowData(DataSet resultDataset) {
        boolean costElementByCostAccount = false;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DynamicObject accountDyc = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (isNewBalance && accountDyc != null) {
            costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)((Long)accountDyc.getPkValue()));
        }
        this.getModel().deleteEntryData("entryentity");
        BigDecimal qtyFrom = (BigDecimal)this.getModel().getValue("qtyfrom");
        BigDecimal qtyTo = (BigDecimal)this.getModel().getValue("qtyto");
        BigDecimal amtFrom = (BigDecimal)this.getModel().getValue("amtfrom");
        BigDecimal amtTo = (BigDecimal)this.getModel().getValue("amtto");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String[] fields = ExceCostHelper.getBalanceFields((boolean)true, (boolean)false, (boolean)costElementByCostAccount).split(",");
        Set<String> cur = Stream.of(fields).collect(Collectors.toSet());
        cur.add("costadjustbillids");
        cur.add("costadjustbillids_tag");
        fields = cur.toArray(new String[0]);
        ArrayList<String> fieldsList = new ArrayList<String>(16);
        for (String string : fields) {
            if (costElementByCostAccount) {
                if ("id".equals(string) || "mversion".equals(string) || "currency".equals(string) || "costelement".equals(string) || "costsubelement".equals(string)) continue;
                fieldsList.add(string);
                continue;
            }
            if ("id".equals(string) || "mversion".equals(string) || "currency".equals(string)) continue;
            fieldsList.add(string);
        }
        if (!fieldsList.contains("costadjustbillids")) {
            fieldsList.add("costadjustbillids");
        }
        if (!fieldsList.contains("costadjustbillids_tag")) {
            fieldsList.add("costadjustbillids_tag");
        }
        if (costElementByCostAccount) {
            fieldsList.add("balanceids_tag");
            List<String> collect = Arrays.stream(fields).collect(Collectors.toList());
            collect.add("balanceids_tag");
            fields = collect.toArray(new String[0]);
        }
        model.beginInit();
        TableValueSetter vs = this.getDetailTableValueSetter(fields);
        boolean isexcedata = this.getModel().getDataEntity().getBoolean(ISEXCEDATA);
        for (Row row : resultDataset) {
            int rowCount;
            BigDecimal quantity = (BigDecimal)row.get("periodendqty");
            BigDecimal amount = (BigDecimal)row.get("periodendactualcost");
            boolean isQuantityZERO = quantity.compareTo(BigDecimal.ZERO) == 0;
            boolean isAmountZERO = amount.compareTo(BigDecimal.ZERO) == 0;
            boolean isQuantityLargeZERO = quantity.compareTo(BigDecimal.ZERO) > 0;
            boolean isAmountLargeZERO = amount.compareTo(BigDecimal.ZERO) > 0;
            boolean isQuantityLessZERO = quantity.compareTo(BigDecimal.ZERO) < 0;
            boolean isAmountLessZERO = amount.compareTo(BigDecimal.ZERO) < 0;
            boolean isQuantityNotZERO = quantity.compareTo(BigDecimal.ZERO) != 0;
            boolean isAmountNotZERO = amount.compareTo(BigDecimal.ZERO) != 0;
            boolean isExce1 = isQuantityZERO && isAmountNotZERO;
            boolean isExce2 = isQuantityNotZERO && isAmountZERO;
            boolean isExce3 = isQuantityLessZERO && isAmountLargeZERO;
            boolean isExce4 = isQuantityLargeZERO && isAmountLessZERO;
            boolean isExce5 = false;
            if (costElementByCostAccount) {
                boolean hasSubElementAmtLargeZero = false;
                String balanceids_tag = (String)row.get("balanceids_tag_tmp");
                List balId_eid_sid_qty_amts = (List)JSONObject.parseObject((String)balanceids_tag, List.class);
                for (String s : balId_eid_sid_qty_amts) {
                    String[] balId_eid_sid_qty_amt = s.split("#");
                    if (BigDecimal.ZERO.compareTo(new BigDecimal(balId_eid_sid_qty_amt[4])) <= 0) continue;
                    hasSubElementAmtLargeZero = true;
                    break;
                }
                isExce5 = isQuantityZERO && isAmountZERO && hasSubElementAmtLargeZero;
            }
            String quantityFilter = this.getModel().getDataEntity().getString(QUANTITY);
            String amountFilter = this.getModel().getDataEntity().getString(AMOUNT);
            boolean flag1 = false;
            boolean flag2 = false;
            if ("A".equals(quantityFilter) || StringUtils.isEmpty((String)quantityFilter)) {
                flag1 = true;
            } else if ("B".equals(quantityFilter) && isQuantityZERO) {
                flag1 = true;
            } else if ("C".equals(quantityFilter) && isQuantityNotZERO) {
                flag1 = true;
            } else if ("D".equals(quantityFilter) && isQuantityLargeZERO) {
                flag1 = true;
            } else if ("E".equals(quantityFilter) && isQuantityLessZERO) {
                flag1 = true;
            } else if ("F".equals(quantityFilter)) {
                flag1 = true;
                if (qtyFrom != null) {
                    boolean bl = flag1 = quantity.compareTo(qtyFrom) >= 0;
                }
                if (qtyTo != null) {
                    boolean bl = flag1 = flag1 && quantity.compareTo(qtyTo) <= 0;
                }
            }
            if ("A".equals(amountFilter) || StringUtils.isEmpty((String)amountFilter)) {
                flag2 = true;
            } else if ("B".equals(amountFilter) && isAmountZERO) {
                flag2 = true;
            } else if ("C".equals(amountFilter) && isAmountNotZERO) {
                flag2 = true;
            } else if ("D".equals(amountFilter) && isAmountLargeZERO) {
                flag2 = true;
            } else if ("E".equals(amountFilter) && isAmountLessZERO) {
                flag2 = true;
            } else if ("F".equals(amountFilter)) {
                flag2 = true;
                if (amtFrom != null) {
                    boolean bl = flag2 = amount.compareTo(amtFrom) >= 0;
                }
                if (amtTo != null) {
                    boolean bl = flag2 = flag2 && amount.compareTo(amtTo) <= 0;
                }
            }
            if (flag1 && flag2) {
                if (isexcedata) {
                    if (costElementByCostAccount) {
                        if (isExce1 || isExce2 || isExce3 || isExce4 || isExce5) {
                            vs.addRow(this.getDetailVsRowArray(row, fieldsList));
                        }
                    } else if (isExce1 || isExce2 || isExce3 || isExce4) {
                        vs.addRow(this.getDetailVsRowArray(row, fieldsList));
                    }
                } else {
                    vs.addRow(this.getDetailVsRowArray(row, fieldsList));
                }
            }
            if ((rowCount = vs.getCount()) < 1000) continue;
            model.batchCreateNewEntryRow("entryentity", vs);
            vs = this.getDetailTableValueSetter(fields);
        }
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            model.batchCreateNewEntryRow("entryentity", vs);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private TableValueSetter getDetailTableValueSetter(String[] fields) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("model", new Object[0]);
        vs.addField("periodnum", new Object[0]);
        vs.addField(EXPORTFLAG, new Object[0]);
        vs.addField("biztype", new Object[0]);
        vs.addField("billtype", new Object[0]);
        vs.addField("currency", new Object[0]);
        for (String string : fields) {
            if ("id".equals(string) || "mversion".equals(string) || "currency".equals(string) || "costelement".equals(string) || "costsubelement".equals(string)) continue;
            vs.addField(string, new Object[0]);
        }
        vs.addField(AFTERAMOUNT, new Object[0]);
        vs.addField("margin", new Object[0]);
        vs.addField("balanceid", new Object[0]);
        vs.addField("costadjustbillid", new Object[0]);
        vs.addField("costadjustbillno", new Object[0]);
        vs.addField("costadjustbillids", new Object[0]);
        vs.addField("costadjustbillids_tag", new Object[0]);
        return vs;
    }

    private Object[] getDetailVsRowArray(Row row, List<String> fieldsList) {
        Object[] resultArrays = new Object[11 + fieldsList.size()];
        resultArrays[0] = "";
        resultArrays[1] = this.getPageCache().get(PERIOD);
        Object flag = row.get(EXPORTFLAG);
        if (flag == null) {
            flag = "B";
        }
        resultArrays[2] = flag;
        resultArrays[3] = this.getPageCache().get("biztype");
        resultArrays[4] = this.getPageCache().get("billtype");
        resultArrays[5] = this.getPageCache().get(CURRENCY);
        int i = 6;
        for (String field : fieldsList) {
            resultArrays[i] = row.get(field);
            ++i;
        }
        BigDecimal periodendactualcost = row.getBigDecimal("periodendactualcost");
        resultArrays[fieldsList.size() + 6] = BigDecimal.ZERO;
        resultArrays[fieldsList.size() + 7] = BigDecimal.ZERO.subtract(periodendactualcost);
        resultArrays[fieldsList.size() + 8] = row.get("id");
        resultArrays[fieldsList.size() + 9] = row.get("costadjustbillid");
        resultArrays[fieldsList.size() + 10] = row.get("costadjustbillno");
        return resultArrays;
    }

    private void loadGroupByRowData(List<DataSet> allDataSet, List<String> fields) {
        int rowCount;
        this.getModel().deleteEntryData("entryentity");
        BigDecimal qtyFrom = (BigDecimal)this.getModel().getValue("qtyfrom");
        BigDecimal qtyTo = (BigDecimal)this.getModel().getValue("qtyto");
        BigDecimal amtFrom = (BigDecimal)this.getModel().getValue("amtfrom");
        BigDecimal amtTo = (BigDecimal)this.getModel().getValue("amtto");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (!fields.contains("costadjustbillids")) {
            fields.add("costadjustbillids");
        }
        if (!fields.contains("costadjustbillids_tag")) {
            fields.add("costadjustbillids_tag");
        }
        ArrayList<String> fieldsList = new ArrayList<String>(16);
        for (String string : fields) {
            if ("id".equals(string) || "mversion".equals(string) || "currency".equals(string) || "margin".equals(string) || "periodnum".equals(string) || AFTERAMOUNT.equals(string) || "biztype".equals(string) || "billtype".equals(string)) continue;
            fieldsList.add(string);
        }
        if (!fieldsList.contains("costadjustbillids")) {
            fieldsList.add("costadjustbillids");
        }
        if (!fieldsList.contains("costadjustbillids_tag")) {
            fieldsList.add("costadjustbillids_tag");
        }
        model.beginInit();
        TableValueSetter vs = this.getGroupTableValueSetter(fields);
        boolean isexcedata = this.getModel().getDataEntity().getBoolean(ISEXCEDATA);
        boolean costElementByCostAccount = false;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DynamicObject accountDyc = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (isNewBalance && accountDyc != null) {
            costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)((Long)accountDyc.getPkValue()));
        }
        int count = 0;
        int partitionSize = this.getModel().getDataEntity().getInt(PARTITIONSIZE);
        boolean search = true;
        block1: for (DataSet resultDataset : allDataSet) {
            if (!search) break;
            resultDataset = resultDataset.orderBy(new String[]{NOTEMPTY_GROUPFIELD, "material"});
            for (Row row : resultDataset) {
                int rowCount2;
                BigDecimal quantity = (BigDecimal)row.get("periodendqty");
                BigDecimal amount = (BigDecimal)row.get("periodendactualcost");
                boolean isQuantityZERO = quantity.compareTo(BigDecimal.ZERO) == 0;
                boolean isAmountZERO = amount.compareTo(BigDecimal.ZERO) == 0;
                boolean isQuantityLargeZERO = quantity.compareTo(BigDecimal.ZERO) > 0;
                boolean isAmountLargeZERO = amount.compareTo(BigDecimal.ZERO) > 0;
                boolean isQuantityLessZERO = quantity.compareTo(BigDecimal.ZERO) < 0;
                boolean isAmountLessZERO = amount.compareTo(BigDecimal.ZERO) < 0;
                boolean isQuantityNotZERO = quantity.compareTo(BigDecimal.ZERO) != 0;
                boolean isAmountNotZERO = amount.compareTo(BigDecimal.ZERO) != 0;
                boolean isExce1 = isQuantityZERO && isAmountNotZERO;
                boolean isExce2 = isQuantityNotZERO && isAmountZERO;
                boolean isExce3 = isQuantityLessZERO && isAmountLargeZERO;
                boolean isExce4 = isQuantityLargeZERO && isAmountLessZERO;
                boolean isExce5 = false;
                if (costElementByCostAccount) {
                    boolean hasSubElementAmtLargeZero = false;
                    String balanceids_tag = (String)row.get("balanceids_tag");
                    List list = (List)JSONObject.parseObject((String)balanceids_tag, List.class);
                    block3: for (Object o : list) {
                        List balId_eid_sid_qty_amts = (List)JSONObject.parseObject((String)o.toString(), List.class);
                        for (String str : balId_eid_sid_qty_amts) {
                            String[] balId_eid_sid_qty_amt = str.split("#");
                            if (BigDecimal.ZERO.compareTo(new BigDecimal(balId_eid_sid_qty_amt[4])) <= 0) continue;
                            hasSubElementAmtLargeZero = true;
                            continue block3;
                        }
                    }
                    isExce5 = isQuantityZERO && isAmountZERO && hasSubElementAmtLargeZero;
                }
                String quantityFilter = this.getModel().getDataEntity().getString(QUANTITY);
                String amountFilter = this.getModel().getDataEntity().getString(AMOUNT);
                boolean flag1 = false;
                boolean flag2 = false;
                if ("A".equals(quantityFilter) || StringUtils.isEmpty((String)quantityFilter)) {
                    flag1 = true;
                } else if ("B".equals(quantityFilter) && isQuantityZERO) {
                    flag1 = true;
                } else if ("C".equals(quantityFilter) && isQuantityNotZERO) {
                    flag1 = true;
                } else if ("D".equals(quantityFilter) && isQuantityLargeZERO) {
                    flag1 = true;
                } else if ("E".equals(quantityFilter) && isQuantityLessZERO) {
                    flag1 = true;
                } else if ("F".equals(quantityFilter)) {
                    flag1 = true;
                    if (qtyFrom != null) {
                        boolean bl = flag1 = quantity.compareTo(qtyFrom) >= 0;
                    }
                    if (qtyTo != null) {
                        boolean bl = flag1 = flag1 && quantity.compareTo(qtyTo) <= 0;
                    }
                }
                if ("A".equals(amountFilter) || StringUtils.isEmpty((String)amountFilter)) {
                    flag2 = true;
                } else if ("B".equals(amountFilter) && isAmountZERO) {
                    flag2 = true;
                } else if ("C".equals(amountFilter) && isAmountNotZERO) {
                    flag2 = true;
                } else if ("D".equals(amountFilter) && isAmountLargeZERO) {
                    flag2 = true;
                } else if ("E".equals(amountFilter) && isAmountLessZERO) {
                    flag2 = true;
                } else if ("F".equals(amountFilter)) {
                    flag2 = true;
                    if (amtFrom != null) {
                        boolean bl = flag2 = amount.compareTo(amtFrom) >= 0;
                    }
                    if (amtTo != null) {
                        boolean bl = flag2 = flag2 && amount.compareTo(amtTo) <= 0;
                    }
                }
                if (flag1 && flag2) {
                    if (isexcedata) {
                        if (costElementByCostAccount) {
                            if (isExce1 || isExce2 || isExce3 || isExce4 || isExce5) {
                                vs.addRow(this.getGroupVsRowArray(row, fieldsList));
                            }
                        } else if (isExce1 || isExce2 || isExce3 || isExce4) {
                            vs.addRow(this.getGroupVsRowArray(row, fieldsList));
                        }
                    } else {
                        vs.addRow(this.getGroupVsRowArray(row, fieldsList));
                    }
                }
                if ((rowCount2 = vs.getCount()) >= 1000) {
                    model.batchCreateNewEntryRow("entryentity", vs);
                    vs = this.getGroupTableValueSetter(fields);
                }
                if (partitionSize == 0 || ++count < partitionSize) continue;
                search = false;
                continue block1;
            }
        }
        if ((rowCount = vs.getCount()) != 0) {
            model.batchCreateNewEntryRow("entryentity", vs);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private TableValueSetter getGroupTableValueSetter(List<String> fields) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String string : fields) {
            if ("id".equals(string) || "mversion".equals(string) || "currency".equals(string) || "margin".equals(string) || "periodnum".equals(string) || AFTERAMOUNT.equals(string) || "biztype".equals(string) || "billtype".equals(string)) continue;
            vs.addField(string, new Object[0]);
        }
        vs.addField("periodnum", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField(AFTERAMOUNT, new Object[0]);
        vs.addField("margin", new Object[0]);
        vs.addField("biztype", new Object[0]);
        vs.addField("billtype", new Object[0]);
        return vs;
    }

    private DataSet buildBalanceCostadjustData(DataSet balanceDataset, QFilter filters, boolean costElementByCostAccount) {
        ArrayList<Long> balanceids = new ArrayList<Long>(16);
        for (Row row : balanceDataset.copy()) {
            if (costElementByCostAccount) {
                String cur_balanceIds = row.getString("balanceids");
                for (String s : cur_balanceIds.split(",")) {
                    if (StringUtils.isEmpty((String)s)) continue;
                    balanceids.add(Long.parseLong(s));
                }
                continue;
            }
            balanceids.add(row.getLong("id"));
        }
        DynamicObject periodFilter = (DynamicObject)this.getModel().getValue(PERIOD);
        int period = periodFilter.getInt("periodyear") * 100 + periodFilter.getInt("periodnumber");
        String balEntity = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balEntity = "cal_bal";
        }
        QFilter curPeriodFilter = new QFilter("id", "in", balanceids);
        curPeriodFilter.and("period", "=", (Object)period);
        ArrayList<Long> curPeriodBalId = new ArrayList<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)balEntity, (String)"id", (QFilter[])curPeriodFilter.toArray(), null);){
            for (Row row : dataSet) {
                curPeriodBalId.add(row.getLong("id"));
            }
        }
        QFilter curPeriBalIdFilter = new QFilter("balanceid", "in", curPeriodBalId);
        DataSet balAdjDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance_costadjust", (String)this.getBalCostAdjustFields(), (QFilter[])new QFilter[]{filters, curPeriBalIdFilter}, (String)"");
        balAdjDs = this.balAdjJoinCurCostAdjDs(balAdjDs);
        return balAdjDs;
    }

    private DataSet balAdjJoinCurCostAdjDs(DataSet balAdjDs) {
        DataSet curPeriodDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)"id,billstatus,calstatus", (QFilter[])this.getCurPeriodAdjFilter().toArray(), null);
        String[] fieldNames = balAdjDs.getRowMeta().getFieldNames();
        String flag = "case when billstatus = 'C' and calstatus = 'A' then 'C' when billstatus = 'B' and calstatus = 'C' then 'D' when billstatus = 'C' and calstatus = 'C' then 'E' else 'B' end as ";
        balAdjDs = balAdjDs.join(curPeriodDs).on("costadjustbillid", "id").select(fieldNames, new String[]{flag + " exportflag", flag + " exportflagbak"}).finish();
        return balAdjDs;
    }

    private Object[] getGroupVsRowArray(Row row, List<String> fieldsList) {
        int size = fieldsList.size();
        Object[] resultArrays = new Object[6 + size];
        int i = 0;
        for (String field : fieldsList) {
            Object value = row.get(field);
            if (EXPORTFLAG.equals(field) && value == null) {
                value = "B";
            }
            resultArrays[i] = value;
            ++i;
        }
        resultArrays[size + 0] = this.getPageCache().get(PERIOD);
        resultArrays[size + 1] = this.getPageCache().get(CURRENCY);
        resultArrays[size + 2] = BigDecimal.ZERO;
        BigDecimal periodendactualcost = row.getBigDecimal("periodendactualcost");
        resultArrays[size + 3] = BigDecimal.ZERO.subtract(periodendactualcost);
        resultArrays[size + 4] = this.getPageCache().get("biztype");
        resultArrays[size + 5] = this.getPageCache().get("billtype");
        return resultArrays;
    }

    private void chkInputBeforeQuery() {
        Object calOrg = this.getModel().getValue(CALORG);
        Object costaccount = this.getModel().getValue(COSTACCOUNT);
        DynamicObject period = (DynamicObject)this.getModel().getValue(PERIOD);
        Object sumType = this.getModel().getValue(SUMTYPE);
        Object partitionSize = this.getModel().getValue(PARTITIONSIZE);
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ExceCostSummaryBillPlugin_21", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"ExceCostSummaryBillPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"ExceCostSummaryBillPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (sumType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6c47\u603b\u4f9d\u636e\u3002", (String)"ExceCostSummaryBillPlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (partitionSize == null || (Integer)partitionSize == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u9875\u6761\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExceCostSummaryBillPlugin_36", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(SUMTYPE, sumType.toString());
        this.getPageCache().put(PERIOD, period.getPkValue().toString());
    }

    private void loadCurrencyData(String policyID) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
        DynamicObject currency = obj.getDynamicObject("currency");
        Long currencyid = obj.getDynamicObject("currency").getLong("id");
        this.getPageCache().put(CURRENCY, currencyid.toString());
        this.getPageCache().put(AMT_PRECISION, String.valueOf(currency.getInt("amtprecision")));
        this.getModel().setValue(CURRENCY, (Object)currencyid);
        this.getView().updateView(CURRENCY);
    }

    private QFilter[] buildBalanceFilter(DynamicObject dataEntity, boolean fromButton) {
        Set<Object> pkSet;
        DynamicObject calOrgFilter = dataEntity.getDynamicObject(CALORG);
        DynamicObject costAccountFilter = dataEntity.getDynamicObject(COSTACCOUNT);
        DynamicObject periodFilter = dataEntity.getDynamicObject(PERIOD);
        DynamicObjectCollection storageorgunitFilter = dataEntity.getDynamicObjectCollection(STORAGEORG);
        DynamicObjectCollection warehouseFilter = dataEntity.getDynamicObjectCollection(WAREHOUSE);
        DynamicObjectCollection locationFilter = dataEntity.getDynamicObjectCollection(LOCATION);
        String lotFilter = dataEntity.getString(LOT);
        DynamicObjectCollection projectFilter = dataEntity.getDynamicObjectCollection(PROJECT);
        DynamicObjectCollection configuredcodeFilter = dataEntity.getDynamicObjectCollection(CONFIGUREDCODE);
        DynamicObjectCollection calRangeFilter = dataEntity.getDynamicObjectCollection(CALRANGE);
        QFilter filter = this.getBaseFilter(calOrgFilter.getLong("id"), costAccountFilter.getLong("id"));
        QFilter filter_costAdj = this.getBaseFilter(calOrgFilter.getLong("id"), costAccountFilter.getLong("id"));
        if (null != storageorgunitFilter && storageorgunitFilter.size() > 0) {
            pkSet = this.getMulDataPK(storageorgunitFilter);
            filter.and(new QFilter("storageorgunit", "in", pkSet));
            filter_costAdj.and(new QFilter("entryentity.storageorgunit", "in", pkSet));
        }
        if (null != warehouseFilter && warehouseFilter.size() > 0) {
            pkSet = this.getMulDataPK(warehouseFilter);
            filter.and(new QFilter("warehouse", "in", pkSet));
            filter_costAdj.and(new QFilter("entryentity.warehouse", "in", pkSet));
        }
        if (null != locationFilter && locationFilter.size() > 0) {
            pkSet = this.getMulDataPK(locationFilter);
            filter.and(new QFilter("location", "in", pkSet));
            filter_costAdj.and(new QFilter("entryentity.location", "in", pkSet));
        }
        if (null != periodFilter) {
            int period = periodFilter.getInt("periodyear") * 100 + periodFilter.getInt("periodnumber");
            filter.and("period", "<=", (Object)period);
            filter.and("endperiod", ">", (Object)period);
            filter_costAdj.and("period", "=", periodFilter.getPkValue());
        }
        if (StringUtils.isNotEmpty((String)lotFilter)) {
            String[] split = lotFilter.split(";");
            HashSet<String> lotSet = new HashSet<String>(split.length);
            lotSet.addAll(Arrays.asList(split));
            filter.and("lot", "in", lotSet);
            filter_costAdj.and("entryentity.lot", "in", lotSet);
        }
        if (null != projectFilter && projectFilter.size() > 0) {
            Set<Object> pkSet2 = this.getMulDataPK(projectFilter);
            filter.and("project", "in", pkSet2);
            filter_costAdj.and("entryentity.project", "in", pkSet2);
        }
        if (null != configuredcodeFilter && configuredcodeFilter.size() > 0) {
            Set<Object> pkSet3 = this.getMulDataPK(configuredcodeFilter);
            filter.and("configuredcode", "in", pkSet3);
            filter_costAdj.and("entryentity.configuredcode", "in", pkSet3);
        }
        if (null != calRangeFilter && calRangeFilter.size() > 0) {
            Set<Object> pkSet4 = this.getMulDataPK(calRangeFilter);
            filter.and("calrange", "in", pkSet4);
            filter_costAdj.and("entryentity.calrange", "in", pkSet4);
        }
        String periodEndActualCostField = "periodendactualcost";
        String periodEndQtyField = "periodendqty";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            periodEndActualCostField = "actualcost_bal";
            periodEndQtyField = "baseqty_bal";
        }
        filter.and(new QFilter("accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue()));
        filter_costAdj.and(new QFilter("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue()));
        QFilter qty_amt_filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (fromButton) {
            String quantityFilter = dataEntity.getString(QUANTITY);
            String amountFilter = dataEntity.getString(AMOUNT);
            String sumType = this.getPageCache().get(SUMTYPE);
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            if (SumTypeEnum.DETAILED.getValue().equals(sumType) && isNewBalance && !balCompress) {
                if ("B".equals(amountFilter)) {
                    filter.and(new QFilter(periodEndActualCostField, "=", (Object)0));
                    qty_amt_filter.and(new QFilter(periodEndActualCostField, "=", (Object)0));
                } else if ("C".equals(amountFilter)) {
                    filter.and(new QFilter(periodEndActualCostField, "!=", (Object)0));
                    qty_amt_filter.and(new QFilter(periodEndActualCostField, "!=", (Object)0));
                } else if ("D".equals(amountFilter)) {
                    filter.and(new QFilter(periodEndActualCostField, ">", (Object)0));
                    qty_amt_filter.and(new QFilter(periodEndActualCostField, ">", (Object)0));
                } else if ("E".equals(amountFilter)) {
                    filter.and(new QFilter(periodEndActualCostField, "<", (Object)0));
                    qty_amt_filter.and(new QFilter(periodEndActualCostField, "<", (Object)0));
                }
                if ("B".equals(quantityFilter)) {
                    filter.and(new QFilter(periodEndQtyField, "=", (Object)0));
                    qty_amt_filter.and(new QFilter(periodEndQtyField, "=", (Object)0));
                } else if ("C".equals(quantityFilter)) {
                    filter.and(new QFilter(periodEndQtyField, "!=", (Object)0));
                    qty_amt_filter.and(new QFilter(periodEndQtyField, "!=", (Object)0));
                } else if ("D".equals(quantityFilter)) {
                    filter.and(new QFilter(periodEndQtyField, ">", (Object)0));
                    qty_amt_filter.and(new QFilter(periodEndQtyField, ">", (Object)0));
                } else if ("E".equals(quantityFilter)) {
                    filter.and(new QFilter(periodEndQtyField, "<", (Object)0));
                    qty_amt_filter.and(new QFilter(periodEndQtyField, "<", (Object)0));
                }
            }
        }
        DynamicObjectCollection materialFrom = this.getModel().getDataEntity().getDynamicObjectCollection(MATERIALFROM);
        DynamicObject materialTo = this.getModel().getDataEntity().getDynamicObject(MATERIALTO);
        String matProp = "material";
        QFilter matFilter = new MatFromToFilter().getMatFilter(materialFrom, materialTo, matProp);
        filter.and(matFilter);
        matProp = "entryentity.material";
        QFilter matFilter_adj = new MatFromToFilter().getMatFilter(materialFrom, materialTo, matProp);
        filter_costAdj.and(matFilter_adj);
        return new QFilter[]{filter, filter_costAdj, qty_amt_filter};
    }

    private QFilter getBaseFilter(long orgID, long costAccountID) {
        QFilter filter = new QFilter("calorg", "=", (Object)orgID);
        filter.and(new QFilter("costaccount", "=", (Object)costAccountID));
        return filter;
    }

    private Set<Object> getMulDataPK(DynamicObjectCollection mulColls) {
        int size = mulColls.size();
        HashSet<Object> pkSet = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object pk = ((DynamicObject)mulColls.get(i)).getDynamicObject("fbasedataid").getPkValue();
            pkSet.add(pk);
        }
        return pkSet;
    }

    private void materialFromChange() {
        DynamicObjectCollection materialFrom = this.getModel().getDataEntity().getDynamicObjectCollection(MATERIALFROM);
        int size = materialFrom.size();
        this.getModel().beginInit();
        if (size > 1) {
            this.getModel().setValue(MATERIALTO, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{MATERIALTO});
        } else {
            if (materialFrom.size() == 1) {
                this.getModel().setValue(MATERIALTO, ((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getPkValue());
            } else {
                this.getModel().setValue(MATERIALTO, null);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{MATERIALTO});
        }
        this.getModel().endInit();
        this.getView().updateView(MATERIALTO);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject costAccountInfo;
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (CALORG.equals(sourceID)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_excebalancesumlist", (String)"47150e89000000ac");
            if (calorgList != null) {
                QFilter qf = new QFilter("id", "in", (Object)calorgList);
                showParameter.getListFilterParameter().setFilter(qf);
            }
        } else if (COSTACCOUNT.equals(sourceID)) {
            DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(CALORG);
            if (calOrg == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ExceCostSummaryBillPlugin_25", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            QFilter qf = new QFilter("calorg", "=", calOrg.getPkValue());
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (STORAGEORG.equals(sourceID)) {
            DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(CALORG);
            List storageOrgIdList = new ArrayList();
            if (null != calOrg) {
                storageOrgIdList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            }
            QFilter qf = new QFilter("id", "in", storageOrgIdList);
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (WAREHOUSE.equals(sourceID)) {
            DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue(STORAGEORG);
            DynamicObject calOrg = (DynamicObject)this.getModel().getValue(CALORG);
            QFilter q = new QFilter("id", "=", (Object)-1L);
            Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg);
            if (set.size() > 0) {
                q = new QFilter("id", "in", (Object)set);
            }
            showParameter.setUseOrgId(0L);
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.clear();
            qFilters.add(q);
        } else if (LOCATION.equals(sourceID)) {
            DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue(WAREHOUSE);
            QFilter q = new QFilter("id", "=", (Object)-1L);
            if (warehouses != null && warehouses.size() > 0) {
                HashSet<Long> set = new HashSet<Long>(16);
                for (DynamicObject info : warehouses) {
                    set.add(info.getDynamicObject("fbasedataid").getLong("id"));
                }
                q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
            }
            showParameter.getListFilterParameter().setFilter(q);
        } else if (PERIOD.equals(sourceID)) {
            DynamicObject costAccountInfo2 = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT);
            QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccountInfo2);
            if (q == null) {
                q = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            }
            showParameter.getListFilterParameter().setFilter(q);
        } else if ("billtype".equals(sourceID)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String biztype = (String)this.getModel().getValue("biztype", rowIndex);
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection billTypes = null;
            if (biztype != null) {
                if (biztype.equals("A")) {
                    billTypes = setting.getDynamicObjectCollection("calinbilltypes");
                } else if (biztype.equals("B")) {
                    billTypes = setting.getDynamicObjectCollection("caloutbilltypes");
                }
                HashSet<Long> billTypeIds = new HashSet<Long>(16);
                if (billTypes != null) {
                    DynamicObject billType = null;
                    for (int i = 0; i < billTypes.size(); ++i) {
                        billType = (DynamicObject)billTypes.get(i);
                        if (billType.getDynamicObject("fbasedataid") == null) continue;
                        billTypeIds.add((Long)billType.getDynamicObject("fbasedataid").getPkValue());
                    }
                }
                QFilter q = new QFilter("id", "in", billTypeIds);
                showParameter.getListFilterParameter().setFilter(q);
            }
        } else if (MATERIALFROM.equals(sourceID) || MATERIALTO.equals(sourceID)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)event);
        } else if (CALRANGE.equals(sourceID) && (costAccountInfo = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT)) != null) {
            QFilter q = new QFilter("costaccount", "=", costAccountInfo.getPkValue());
            showParameter.getListFilterParameter().setFilter(q);
        }
    }

    private DynamicObject createCostAdjustHead(String biztype, Long billtype, boolean costElementByCostAccount) {
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject(COSTACCOUNT);
        DynamicObject calorg = this.getModel().getDataEntity().getDynamicObject(CALORG);
        DynamicObject costAdjustBill = costElementByCostAccount ? BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity") : BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjustbill");
        costAdjustBill.set("currency", (Object)this.getPageCache().get(CURRENCY));
        Date perioddate = PeriodHelper.getCurrentPeriodenddate((Long)costAccount.getLong("id"));
        costAdjustBill.set("bizdate", (Object)perioddate);
        costAdjustBill.set("bookdate", (Object)perioddate);
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("createtype", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
        costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue());
        costAdjustBill.set("costaccount", (Object)costAccount.getLong("id"));
        costAdjustBill.set("calorg", (Object)calorg.getLong("id"));
        costAdjustBill.set("creator", (Object)this.getPageCache().get("userId"));
        costAdjustBill.set("createtime", (Object)DateUtils.getCurrentSystemDate());
        costAdjustBill.set("biztype", (Object)biztype);
        costAdjustBill.set("billtype", (Object)billtype);
        if ("A".equals(biztype)) {
            costAdjustBill.set("cstype", (Object)"bd_supplier");
        } else {
            costAdjustBill.set("cstype", (Object)"bd_customer");
        }
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjustBill, (String)calorg.getPkValue().toString());
        costAdjustBill.set("billno", (Object)number);
        return costAdjustBill;
    }

    private DynamicObject createCostAdjustEntry(DynamicObject costAdjustBill, DynamicObject entryentity, DynamicObject dy, DynamicObject[] dys, String biztype, Integer seq, String sumType, boolean costElementByCostAccount, Map<Long, Long> balanceId_elementId, Map<Long, Long> balanceId_subElementId, Map<Long, BigDecimal> balanceId_subAmt, Map<Long, BigDecimal> balanceId_detail_calsubamt, List<Long[]> costAllSubElements, Set<String> subElement_disabled_error, Set<Long> subElement_delete_error, Map<String, String> dupSet) {
        DynamicObject costAdjustEntry = costAdjustBill.getDynamicObjectCollection("entryentity").addNew();
        costAdjustEntry.set("seq", (Object)seq);
        if (costElementByCostAccount) {
            dy = dys[0];
        }
        costAdjustEntry.set("storageorgunit", (Object)dy.getLong("storageorgunit.id"));
        costAdjustEntry.set("material", (Object)dy.getLong("material.id"));
        costAdjustEntry.set("assist", (Object)dy.getLong("assist.id"));
        costAdjustEntry.set("lot", (Object)dy.getString("lot"));
        BigDecimal margin = entryentity.getBigDecimal("margin");
        if ("B".equals(biztype)) {
            margin = margin.multiply(new BigDecimal(-1));
        }
        costAdjustEntry.set("adjustamt", (Object)margin);
        costAdjustEntry.set("warehouse", (Object)dy.getLong("warehouse.id"));
        costAdjustEntry.set("location", (Object)dy.getLong("location.id"));
        costAdjustEntry.set("ownertype", dy.get("ownertype"));
        costAdjustEntry.set("owner", (Object)dy.getLong("owner.id"));
        costAdjustEntry.set("assist", (Object)dy.getLong("assist.id"));
        costAdjustEntry.set("baseunit", (Object)dy.getLong("baseunit.id"));
        costAdjustEntry.set("project", (Object)dy.getLong("project.id"));
        costAdjustEntry.set("invtype", (Object)dy.getLong("invtype.id"));
        costAdjustEntry.set("invstatus", (Object)dy.getLong("invstatus.id"));
        costAdjustEntry.set("tracknumber", (Object)dy.getLong("tracknumber.id"));
        costAdjustEntry.set("configuredcode", (Object)dy.getLong("configuredcode.id"));
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        String balName = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balName = "cal_bal";
        }
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)balName);
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        CommonSettingHelper.setExFieldValue((Set)exFieldSet, (MainEntityType)costAdjustEntityType, (MainEntityType)costRecordEntityType, (DynamicObject)costAdjustEntry, (DynamicObject)dy);
        if (costElementByCostAccount) {
            String balanceIds_tag;
            if (SumTypeEnum.DETAILED.getValue().equals(sumType)) {
                StringBuilder balanceIds_builder = new StringBuilder();
                for (DynamicObject cur_dy : dys) {
                    balanceIds_builder.append(",").append(cur_dy.getLong("id"));
                }
                balanceIds_tag = balanceIds_builder.toString();
            } else {
                balanceIds_tag = dy.getString("balanceids");
            }
            BigDecimal qty = dy.getBigDecimal("periodendqty");
            this.createCostAdjDetail(balanceId_elementId, balanceId_subElementId, balanceId_subAmt, balanceId_detail_calsubamt, costAllSubElements, costAdjustEntry, dy.getLong("material.id"), costAdjustBill.getLong("currency"), balanceIds_tag, margin, qty, biztype.equals("B"), sumType, subElement_disabled_error, subElement_delete_error, dupSet);
        }
        return costAdjustBill;
    }

    private DynamicObject createGroupCostAdjustEntry(DynamicObject costAdjustBill, Row row, BigDecimal margin, boolean negative, Integer seq, String sumType, boolean costElementByCostAccount, Map<Long, Long> balanceId_elementId, Map<Long, Long> balanceId_subElementId, Map<Long, BigDecimal> balanceId_subAmt, Map<Long, BigDecimal> balanceId_detail_calsubamt, List<Long[]> costAllSubElements, Set<String> subElement_disabled_error, Set<Long> subElement_delete_error, Map<String, String> dupSet) {
        DynamicObject costAdjustEntry = costAdjustBill.getDynamicObjectCollection("entryentity").addNew();
        costAdjustEntry.set("seq", (Object)seq);
        costAdjustEntry.set("storageorgunit", row.get("storageorgunit"));
        costAdjustEntry.set("material", row.get("material"));
        costAdjustEntry.set("assist", row.get("assist"));
        costAdjustEntry.set("lot", row.get("lot"));
        costAdjustEntry.set("warehouse", row.get("warehouse"));
        costAdjustEntry.set("location", row.get("location"));
        costAdjustEntry.set("ownertype", row.get("ownertype"));
        costAdjustEntry.set("owner", row.get("owner"));
        costAdjustEntry.set("assist", row.get("assist"));
        costAdjustEntry.set("baseunit", row.get("baseunit"));
        costAdjustEntry.set("project", row.get("project"));
        costAdjustEntry.set("invtype", row.get("invtype"));
        costAdjustEntry.set("invstatus", row.get("invstatus"));
        costAdjustEntry.set("configuredcode", row.get("configuredcode"));
        costAdjustEntry.set("tracknumber", row.get("tracknumber"));
        costAdjustEntry.set("adjustamt", (Object)margin);
        String balName = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balName = "cal_bal";
        }
        MainEntityType balanceEntityType = MetadataServiceHelper.getDataEntityType((String)balName);
        Set exFields = CommonSettingHelper.getExFieldSet();
        exFields.retainAll(balanceEntityType.getAllFields().keySet());
        for (String item : exFields) {
            costAdjustEntry.set(item, row.get(item));
        }
        BigDecimal qty = row.getBigDecimal("periodendqty");
        if (costElementByCostAccount) {
            this.createCostAdjDetail(balanceId_elementId, balanceId_subElementId, balanceId_subAmt, balanceId_detail_calsubamt, costAllSubElements, costAdjustEntry, row.get("material"), costAdjustBill.get("currency"), row.getString("balanceids"), margin, qty, negative, sumType, subElement_disabled_error, subElement_delete_error, dupSet);
        }
        return costAdjustBill;
    }

    private DynamicObject createGroupCostAdjustEntryDivide(DynamicObject costAdjustBill, Map<String, Object> map, BigDecimal margin, boolean negative, Integer seq, String sumType, boolean costElementByCostAccount, Map<Long, Long> balanceId_elementId, Map<Long, Long> balanceId_subElementId, Map<Long, BigDecimal> balanceId_subAmt, Map<Long, BigDecimal> balanceId_detail_calsubamt, List<Long[]> costAllSubElements, Set<String> subElement_disabled_error, Set<Long> subElement_delete_error, Map<String, String> dupSet) {
        BigDecimal qty;
        DynamicObject costAdjustEntry = costAdjustBill.getDynamicObjectCollection("entryentity").addNew();
        costAdjustEntry.set("seq", (Object)seq);
        costAdjustEntry.set("storageorgunit", map.get("storageorgunit"));
        costAdjustEntry.set("material", map.get("material"));
        costAdjustEntry.set("assist", map.get("assist"));
        costAdjustEntry.set("lot", map.get("lot"));
        costAdjustEntry.set("warehouse", map.get("warehouse"));
        costAdjustEntry.set("location", map.get("location"));
        costAdjustEntry.set("ownertype", map.get("ownertype"));
        costAdjustEntry.set("owner", map.get("owner"));
        costAdjustEntry.set("assist", map.get("assist"));
        costAdjustEntry.set("baseunit", map.get("baseunit"));
        costAdjustEntry.set("project", map.get("project"));
        costAdjustEntry.set("invtype", map.get("invtype"));
        costAdjustEntry.set("invstatus", map.get("invstatus"));
        costAdjustEntry.set("configuredcode", map.get("configuredcode"));
        costAdjustEntry.set("adjustamt", (Object)margin);
        costAdjustEntry.set("tracknumber", map.get("tracknumber"));
        String balName = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balName = "cal_bal";
        }
        MainEntityType balanceEntityType = MetadataServiceHelper.getDataEntityType((String)balName);
        Set exFields = CommonSettingHelper.getExFieldSet();
        exFields.retainAll(balanceEntityType.getAllFields().keySet());
        for (String item : exFields) {
            costAdjustEntry.set(item, map.get(item));
        }
        BigDecimal bigDecimal = qty = map.get("periodendqty") == null ? BigDecimal.ZERO : (BigDecimal)map.get("periodendqty");
        if (costElementByCostAccount) {
            this.createCostAdjDetail(balanceId_elementId, balanceId_subElementId, balanceId_subAmt, balanceId_detail_calsubamt, costAllSubElements, costAdjustEntry, map.get("material"), costAdjustBill.get("currency"), (String)map.get("balanceids"), margin, qty, negative, sumType, subElement_disabled_error, subElement_delete_error, dupSet);
        }
        return costAdjustBill;
    }

    private void createCostAdjDetail(Map<Long, Long> balanceId_elementId, Map<Long, Long> balanceId_subElementId, Map<Long, BigDecimal> balanceId_subAmt, Map<Long, BigDecimal> balanceId_detail_calsubamt, List<Long[]> costAllSubElements, DynamicObject costAdjustEntry, Object material, Object currency, String balanceids, BigDecimal adjustAmt, BigDecimal qty, boolean negative, String sumType, Set<String> subElement_disabled_error, Set<Long> subElement_delete_error, Map<String, String> dupSet) {
        Object subelementid;
        int amtPrecision = Integer.parseInt(this.getPageCache().get(AMT_PRECISION));
        TreeSet<Info> balId_eid_sid_subAmt = new TreeSet<Info>((a, b) -> a.amt.abs().compareTo(b.amt.abs()) == 0 ? a.balid.compareTo(b.balid) : a.amt.abs().compareTo(b.amt.abs()));
        HashMap<String, BigDecimal> keycol_adjMap = new HashMap<String, BigDecimal>();
        HashMap<String, Object> keycol_no_adjMap = new HashMap<String, Object>();
        HashMap eid_sid_keycol_adj = new HashMap();
        HashMap eid_sid_keycol_no_adj = new HashMap();
        HashSet<String> exist_element_keys = new HashSet<String>();
        boolean allSubAmtZero = true;
        BigDecimal curSubAmt = BigDecimal.ZERO;
        BigDecimal absSubAmt = BigDecimal.ZERO;
        for (String s : balanceids.split("\\,")) {
            Object subAmt;
            if (StringUtils.isEmpty((String)s)) continue;
            Long balanceid = Long.parseLong(s);
            Long elementid = balanceId_elementId.get(balanceid);
            subelementid = balanceId_subElementId.get(balanceid);
            BigDecimal curAmt = balanceId_subAmt.get(balanceid);
            if (curAmt == null) {
                curAmt = BigDecimal.ZERO;
            }
            Object object = subAmt = negative ? curAmt : curAmt.negate();
            if (BigDecimal.ZERO.compareTo((BigDecimal)subAmt) != 0) {
                allSubAmtZero = false;
                exist_element_keys.add(subelementid + "|" + elementid);
            }
            curSubAmt = curSubAmt.add((BigDecimal)subAmt);
            String keyCol = balanceid + "#" + elementid + "#" + subelementid;
            balId_eid_sid_subAmt.add(new Info(balanceid, elementid, (Long)subelementid, (BigDecimal)subAmt));
            absSubAmt = absSubAmt.add(((BigDecimal)subAmt).abs());
            keycol_no_adjMap.put(keyCol, subAmt);
            String eid_sid = elementid + "#" + subelementid;
            eid_sid_keycol_no_adj.putIfAbsent(eid_sid, new ArrayList());
            List keyCols = (List)eid_sid_keycol_no_adj.get(eid_sid);
            keyCols.add(keyCol);
        }
        HashSet<Object> disable = new HashSet();
        HashSet<String> enable = new HashSet<String>();
        HashSet<String> curKeys = new HashSet<String>(dupSet.keySet());
        if (curKeys.size() != costAllSubElements.size()) {
            disable = new HashSet<String>(dupSet.keySet());
            for (Long[] costAllSubElement : costAllSubElements) {
                enable.add(costAllSubElement[0] + "|" + costAllSubElement[1]);
            }
            disable.retainAll(enable);
        }
        for (String exist_element_key : exist_element_keys) {
            String[] split = exist_element_key.split("\\|");
            if (dupSet.containsKey(exist_element_key) || split[1] != null) {
                // empty if block
            }
            if (disable.isEmpty() || !disable.contains(exist_element_key)) continue;
            subelementid = dupSet.get(exist_element_key);
        }
        if (!subElement_delete_error.isEmpty() || !subElement_disabled_error.isEmpty()) {
            return;
        }
        BigDecimal diff = adjustAmt.subtract(curSubAmt);
        if (allSubAmtZero && BigDecimal.ZERO.compareTo(curSubAmt) == 0 && BigDecimal.ZERO.compareTo(qty) != 0) {
            diff = BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(diff) != 0) {
            BigDecimal avg_amt = adjustAmt.divide(absSubAmt, 10, RoundingMode.HALF_UP);
            int size = 0;
            String lastKeyCol = null;
            BigDecimal pre = BigDecimal.ZERO;
            for (Info cur : balId_eid_sid_subAmt) {
                Long balid = Long.parseLong(cur.balid.toString());
                if (cur.eid == null) {
                    ++size;
                    continue;
                }
                Long eid = Long.parseLong(cur.eid.toString());
                Long sid = Long.parseLong(cur.sid.toString());
                BigDecimal subAmt = new BigDecimal(cur.amt.toString());
                String keyCol = balid + "#" + eid + "#" + sid;
                String eid_sid = eid + "#" + sid;
                eid_sid_keycol_adj.putIfAbsent(eid_sid, new ArrayList());
                List keyCols = (List)eid_sid_keycol_adj.get(eid_sid);
                keyCols.add(keyCol);
                if (++size == balId_eid_sid_subAmt.size()) {
                    lastKeyCol = keyCol;
                    continue;
                }
                BigDecimal curAdjAmt = subAmt.abs().multiply(avg_amt).setScale(amtPrecision, RoundingMode.HALF_UP);
                keycol_adjMap.put(keyCol, curAdjAmt);
                pre = pre.add(curAdjAmt);
            }
            keycol_adjMap.put(lastKeyCol, adjustAmt.subtract(pre));
        }
        int seq = 1;
        for (Long[] costAllSubElement : costAllSubElements) {
            DynamicObject detail;
            String[] balId_eid_sid;
            BigDecimal subAmt;
            List keyCols;
            if (costAllSubElement[0] == null || costAllSubElement[1] == null) continue;
            String curKey = costAllSubElement[1] + "#" + costAllSubElement[0];
            if (BigDecimal.ZERO.compareTo(diff) == 0) {
                if (eid_sid_keycol_no_adj.containsKey(curKey)) {
                    keyCols = (List)eid_sid_keycol_no_adj.get(curKey);
                    for (String keyCol : keyCols) {
                        Long[] defaultMaterialElements;
                        String defaultKey;
                        subAmt = (BigDecimal)keycol_no_adjMap.get(keyCol);
                        balId_eid_sid = keyCol.split("#");
                        if (BigDecimal.ZERO.compareTo(qty) != 0 && BigDecimal.ZERO.compareTo(curSubAmt) == 0 && allSubAmtZero && curKey.equals(defaultKey = (defaultMaterialElements = CostElementHelper.getDefaultMaterialElements())[1] + "#" + defaultMaterialElements[0])) {
                            subAmt = adjustAmt;
                        }
                        detail = costAdjustEntry.getDynamicObjectCollection("subentryentity").addNew();
                        detail.set("sub_material", material);
                        detail.set("sub_currency", currency);
                        detail.set("sub_adjustamt", (Object)subAmt);
                        detail.set("costelement", (Object)balId_eid_sid[1]);
                        detail.set("costsubelement", (Object)balId_eid_sid[2]);
                        detail.set("seq", (Object)seq++);
                        balanceId_detail_calsubamt.put(Long.parseLong(balId_eid_sid[0]), subAmt);
                    }
                    continue;
                }
                detail = costAdjustEntry.getDynamicObjectCollection("subentryentity").addNew();
                detail.set("sub_material", material);
                detail.set("sub_currency", currency);
                detail.set("sub_adjustamt", (Object)BigDecimal.ZERO);
                detail.set("costelement", (Object)costAllSubElement[1]);
                detail.set("costsubelement", (Object)costAllSubElement[0]);
                detail.set("seq", (Object)seq++);
                continue;
            }
            if (eid_sid_keycol_adj.containsKey(curKey)) {
                keyCols = (List)eid_sid_keycol_adj.get(curKey);
                for (String keyCol : keyCols) {
                    subAmt = (BigDecimal)keycol_adjMap.get(keyCol);
                    balId_eid_sid = keyCol.split("#");
                    detail = costAdjustEntry.getDynamicObjectCollection("subentryentity").addNew();
                    detail.set("sub_material", material);
                    detail.set("sub_currency", currency);
                    detail.set("sub_adjustamt", (Object)subAmt);
                    detail.set("costelement", (Object)balId_eid_sid[1]);
                    detail.set("costsubelement", (Object)balId_eid_sid[2]);
                    detail.set("seq", (Object)seq++);
                    balanceId_detail_calsubamt.put(Long.parseLong(balId_eid_sid[0]), subAmt);
                }
                continue;
            }
            detail = costAdjustEntry.getDynamicObjectCollection("subentryentity").addNew();
            detail.set("sub_material", material);
            detail.set("sub_currency", currency);
            detail.set("sub_adjustamt", (Object)BigDecimal.ZERO);
            detail.set("costelement", (Object)costAllSubElement[1]);
            detail.set("costsubelement", (Object)costAllSubElement[0]);
            detail.set("seq", (Object)seq++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(ProgressEvent progressEvent) {
        block35: {
            String cacheId = this.getPageCache().get("cacheId");
            String process = this.getPageCache().get(BAR_KEY);
            if (process != null && process.length() != 0) {
                int p = Integer.parseInt(process);
                progressEvent.setProgress(p);
            }
            if (!StringUtils.isEmpty((String)cacheId)) {
                try (AlgoContext ctx = Algo.newContext();){
                    if (cacheId.startsWith(Exception.class.getName())) {
                        throw new KDBizException(cacheId);
                    }
                    ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                    bar.stop();
                    if (cacheId.startsWith(Exception.class.getName())) {
                        throw new KDBizException(cacheId);
                    }
                    String sumType = this.getPageCache().get(SUMTYPE);
                    if (SumTypeEnum.DETAILED.getValue().equals(sumType)) {
                        logger.info("output cacheId is : " + cacheId);
                        progressEvent.setProgress(80);
                        bar.setPercent(80);
                        DataSet detailDataset = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), true);
                        int partitionSize = this.getModel().getDataEntity().getInt(PARTITIONSIZE);
                        if (partitionSize != 0) {
                            detailDataset = detailDataset.top(partitionSize);
                        }
                        progressEvent.setProgress(90);
                        bar.setPercent(90);
                        this.loadDetailRowData(detailDataset.orderBy(new String[]{"calorg", "storageorgunit", "warehouse", "material"}));
                    } else if (SumTypeEnum.HUAFENYIJU.getValue().equals(sumType)) {
                        HashSet<String> allField = new HashSet<String>(16);
                        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_excebalancesumlist");
                        EntryProp entryProp = (EntryProp)entitytype.getProperty("entryentity");
                        for (IDataEntityProperty pro : entryProp.getDynamicCollectionItemPropertyType().getProperties()) {
                            if (pro instanceof AmountProp || pro instanceof QtyProp || pro instanceof LongProp) continue;
                            allField.add(pro.getName());
                        }
                        allField.remove("balanceids");
                        logger.info("output cacheId is : " + cacheId);
                        DataSet detailDataSet = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), true).orderBy(new String[]{NOTEMPTY_GROUPFIELD, "material"});
                        logger.info("dataSet out put is finished");
                        progressEvent.setProgress(80);
                        bar.setPercent(80);
                        ArrayList<DataSet> list = new ArrayList<DataSet>(16);
                        list.add(detailDataSet);
                        ArrayList<String> fields = new ArrayList<String>(32);
                        fields.addAll(allField);
                        fields.add("periodendqty");
                        fields.add("periodendactualcost");
                        fields.add("margin");
                        this.loadGroupByRowData(list, fields);
                        progressEvent.setProgress(90);
                        bar.setPercent(90);
                    }
                }
                catch (Exception e) {
                    try {
                        logger.info("exceCostSummaryBillPlugin after asynchronized error : ", (Object)e);
                        String errorMsg = ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u6c47\u62a5\u8868\u67e5\u8be2\u5f02\u5e38\u62a5\u9519\u3002", (String)"ExceCostSummaryBillPlugin_31", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                        String errorContent = e.getMessage();
                        if (!StringUtils.isEmpty((String)errorContent) && errorContent.length() > 250) {
                            errorContent = errorContent.substring(0, 251);
                        }
                        this.getView().showErrorNotification(errorMsg + errorContent);
                        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                        bar.stop();
                    }
                    catch (Throwable throwable) {
                        this.getPageCache().remove("cacheId");
                        this.getPageCache().remove(BAR_KEY);
                        progressEvent.setProgress(100);
                        if (progressEvent.getProgress() == 100) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e2) {
                                logger.error((Throwable)e2);
                            }
                            this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
                        }
                        throw throwable;
                    }
                    this.getPageCache().remove("cacheId");
                    this.getPageCache().remove(BAR_KEY);
                    progressEvent.setProgress(100);
                    if (progressEvent.getProgress() != 100) break block35;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e3) {
                        logger.error((Throwable)e3);
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
                }
                this.getPageCache().remove("cacheId");
                this.getPageCache().remove(BAR_KEY);
                progressEvent.setProgress(100);
                if (progressEvent.getProgress() == 100) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Throwable)e);
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
                }
            }
        }
    }

    public void setProgress(int process) {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.setPercent(process);
    }

    private DataSetX getDetailDataSetX(QFilter[] filters, String sumType, List<Object> container, JobSession session, Long costAccountId) {
        boolean costElementByCostAccount = false;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DynamicObject accountDyc = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
        if (isNewBalance && accountDyc != null) {
            costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)((Long)accountDyc.getPkValue()));
        }
        DynamicObject periodObject = this.getModel().getDataEntity().getDynamicObject(PERIOD);
        int period = periodObject.getInt("periodyear") * 100 + periodObject.getInt("periodnumber");
        this.getPageCache().put(BAR_KEY, "15");
        DataSetX balanceDatasetX = SumTypeEnum.DETAILED.getValue().equals(sumType) || SumTypeEnum.HUAFENYIJU.getValue().equals(sumType) ? this.buildBalanceDataXNew(filters, sumType, session, container, costElementByCostAccount) : this.getDefaultEmptyDataSetX(session);
        this.getPageCache().put(BAR_KEY, "25");
        Set dimList = ExceCostHelper.getBalDimFields((String)sumType, (boolean)true);
        DataSetX costAdjustDataSetx = session.fromInput(this.createBalCostAdjustDataNew(costElementByCostAccount, dimList, filters));
        this.getPageCache().put(BAR_KEY, "50");
        JoinDataSetX joinDataSetX = balanceDatasetX.leftJoin(costAdjustDataSetx);
        for (String dim : dimList) {
            joinDataSetX.on(dim, dim);
        }
        joinDataSetX = joinDataSetX.select(balanceDatasetX.getRowMeta().getFieldNames(), new String[]{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak", "margin"});
        DataSetX detailDatasetX = joinDataSetX.groupBy((String[])ArrayUtils.concatAll((Object[])balanceDatasetX.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak"}})).sum("margin");
        ArrayList<Field> billnos = new ArrayList<Field>(16);
        ArrayList<String> billnosValue = new ArrayList<String>(16);
        billnos.add(new Field("costadjustbillids", (DataType)DataType.StringType));
        billnos.add(new Field("costadjustbillids_tag", (DataType)DataType.StringType));
        billnosValue.add("");
        billnosValue.add("");
        detailDatasetX = detailDatasetX.addFields(billnos.toArray(new Field[0]), billnosValue.toArray());
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        if (!isNewBalance || !balCompress) {
            detailDatasetX = detailDatasetX.filter((FilterFunction)new ExceCostSummaryFilterFunction(detailDatasetX.getRowMeta(), false, this.getModel().getDataEntity().getBoolean(ISEXCEDATA)));
        }
        if (costElementByCostAccount) {
            ArrayList<String> balanceList = new ArrayList<String>(Arrays.asList(balanceDatasetX.getRowMeta().getFieldNames()));
            balanceList.retainAll(dimList);
            Object[] dimFields = balanceList.toArray(new String[balanceList.size()]);
            Set filedNameSet = Arrays.stream(detailDatasetX.getRowMeta().getFieldNames()).collect(Collectors.toSet());
            if (!filedNameSet.contains("balanceids_tag_tmp")) {
                ArrayList<Field> fields = new ArrayList<Field>(16);
                ArrayList<String> values = new ArrayList<String>(16);
                fields.add(new Field("balanceids_tag_tmp", (DataType)DataType.StringType));
                values.add("");
                detailDatasetX = detailDatasetX.addFields(fields.toArray(new Field[0]), values.toArray());
            }
            Set<String> dims = Stream.of(dimFields).collect(Collectors.toSet());
            dims.remove("costelement");
            dims.remove("costsubelement");
            dimFields = dims.toArray(new String[0]);
            detailDatasetX = detailDatasetX.groupBy((String[])ArrayUtils.concatAll((Object[])dimFields, (Object[][])new String[][]{{"costadjustbillid", "costadjustbillno", "costadjustbillids", "costadjustbillids_tag", EXPORTFLAG, "exportflagbak"}})).reduceGroup((GroupReduceFunction)new ExceCostDetailGroupFunction(detailDatasetX.getRowMeta()));
            if (SumTypeEnum.DETAILED.getValue().equals(sumType)) {
                ArrayList<Field> fields = new ArrayList<Field>(16);
                ArrayList<String> values = new ArrayList<String>(16);
                fields.add(new Field("balanceids_tag", (DataType)DataType.StringType));
                values.add("");
                detailDatasetX = detailDatasetX.addFields(fields.toArray(new Field[0]), values.toArray());
                detailDatasetX = detailDatasetX.map((MapFunction)new ExceCostDetailFieldFunction(detailDatasetX.getRowMeta()));
            }
        }
        detailDatasetX = detailDatasetX.filter((FilterFunction)new ExceCostSummaryFilterFunction(detailDatasetX.getRowMeta(), costElementByCostAccount, this.getModel().getDataEntity().getBoolean(ISEXCEDATA)));
        this.getPageCache().put(BAR_KEY, "75");
        String isExportBill = (String)this.getModel().getValue(ISEXPORTBILL);
        if ("B".equals(isExportBill)) {
            detailDatasetX = detailDatasetX.filter("exportflag = null or exportflag = 'B'");
        } else if ("C".equals(isExportBill)) {
            detailDatasetX = detailDatasetX.filter("exportflag = 'C'");
        } else if ("D".equals(isExportBill)) {
            detailDatasetX = detailDatasetX.filter("exportflag = 'D'");
        } else if ("E".equals(isExportBill)) {
            detailDatasetX = detailDatasetX.filter("exportflag = 'E'");
        }
        return detailDatasetX;
    }

    private DataSetX getDefaultEmptyDataSetX(JobSession session) {
        ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
        DataSet defaultEmptyDataSetX = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)0)}, (String)"");
        inputList.add(new DataSetInput(defaultEmptyDataSetX));
        return session.fromInput(inputList.toArray(new Input[0]));
    }

    private DataSetX buildBalanceDataXNew(QFilter[] filters, String sumType, JobSession session, List<Object> container, boolean costElementByCostAccount) {
        String balName = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balName = "cal_bal";
        }
        DataSet material = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)balName, (String)"material", (QFilter[])new QFilter[]{filters[0]}, (String)"").distinct();
        HashMap<Integer, Set<Long>> materialIdMap = new HashMap<Integer, Set<Long>>(16);
        int lot = 0;
        int size = this.getBatchSize();
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        for (Row row : material) {
            materialIdSet.add(row.getLong("material"));
            if (materialIdSet.size() != size) continue;
            HashSet idSet = new HashSet(materialIdSet);
            materialIdMap.put(++lot, idSet);
            materialIdSet.clear();
        }
        if (lot == 0) {
            materialIdMap.put(lot, materialIdSet);
        } else {
            materialIdMap.put(++lot, materialIdSet);
        }
        return session.fromInput(this.createBalanceData(materialIdMap, container, filters, sumType, balName, costElementByCostAccount, isNewBalance));
    }

    private int getBatchSize() {
        DBRoute dbRoute = new DBRoute("scm");
        int defaultSize = 5000;
        String strSql = "SELECT FVALUE FROM T_IM_INVDBPARAM WHERE FID = 1361471785928782848 AND FKEY = 'exceCostSize'";
        DataSet batSizeData = DB.queryDataSet((String)"kd.fi.calx.mservice.DiffAllocServiceImpl.getBatchSize", (DBRoute)dbRoute, (String)strSql);
        Iterator it = batSizeData.iterator();
        if (it.hasNext()) {
            defaultSize = Integer.parseInt(((Row)it.next()).get("FVALUE").toString());
        }
        return defaultSize;
    }

    private static class Info {
        Long balid;
        Long eid;
        Long sid;
        BigDecimal amt;

        public Info(Long balid, Long eid, Long sid, BigDecimal amt) {
            this.balid = balid;
            this.eid = eid;
            this.sid = sid;
            this.amt = amt;
        }
    }
}

