/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.summary;

import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class ExceCostSummaryReduceFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private RowMeta resultMeta;
    private Map<Long, String> calDimension;

    ExceCostSummaryReduceFunction(RowMeta rowMeta, Map<Long, String> calDimension) {
        this.rowMeta = rowMeta;
        this.resultMeta = this.buildResultMeta();
        this.calDimension = calDimension;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX row : iterable) {
            Field[] fields = this.getResultRowMeta().getFields();
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length - 1; ++i) {
                values[i] = row.get(this.resultMeta.getFieldIndex(fields[i].getName()));
            }
            Long caldimensionId = row.getLong(this.resultMeta.getFieldIndex("caldimension"));
            String[] caldimensionValue = this.calDimension.get(caldimensionId).split(",");
            StringBuilder caldimensionsStr = new StringBuilder();
            for (String caldimension : caldimensionValue) {
                if (!StringUtils.isNotEmpty((String)caldimension)) continue;
                caldimensionsStr.append(row.get(this.resultMeta.getFieldIndex(caldimension)));
                caldimensionsStr.append("_");
            }
            if (caldimensionsStr.length() > 0) {
                caldimensionsStr.deleteCharAt(caldimensionsStr.length() - 1);
            }
            values[fields.length - 1] = caldimensionsStr.toString();
            RowX rowX = new RowX(values);
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    private RowMeta buildResultMeta() {
        Field[] fields = this.rowMeta.getFields();
        Field[] resultFields = new Field[fields.length + 1];
        for (int i = 0; i < resultFields.length; ++i) {
            resultFields[i] = i == fields.length ? new Field("caldimensionvalue", (DataType)DataType.StringType) : fields[i];
        }
        return new RowMeta(resultFields);
    }
}

