/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.summary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.business.helper.ExceCostHelper;
import kd.fi.cal.common.util.ArrayUtils;

public class ExceDeleteBillTask
extends AbstractTask {
    private String DLOCK_KEY = "fi-cal-excebalancesumlist";
    private static final Log logger = LogFactory.getLog(ExceDeleteBillTask.class);
    private static final String NOTEMPTY_GROUPFIELD = "calrangeid";
    private static final String EXPORTFLAG = "exportflag";

    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        long starttime = TimeServiceHelper.now().getTime();
        String sumType = (String)paramMap.get("SUMTYPE");
        long userId = Long.parseLong(paramMap.get("userId").toString());
        long calorgId = Long.parseLong(paramMap.get("calorgId").toString());
        long costaccountId = (Long)paramMap.get("costaccountId");
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(userId);
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setTitle(ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u6c47\u62a5\u8868", (String)"ExceExportBillTask_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)costaccountId).toArray());
        String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5220\u5355\u5168\u90e8\u6210\u529f\u3002", (String)"ExceDeleteBillTask_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("name"));
        msgInfo.setContent(content);
        String key = this.DLOCK_KEY + calorgId + costaccountId;
        try (DLock lock = DLock.create((String)key, (String)"fi-cal-excebalancesumlist-deletebill");){
            boolean isLockSuccess = lock.tryLock();
            if (!isLockSuccess) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u51fa\u5355\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExceExportBillTask_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            List balanceids = (List)paramMap.get("balanceids");
            List costadjustbillids = (List)paramMap.get("costadjustbillids");
            if (balanceids.size() == 0 || costadjustbillids.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u5220\u5355\u6570\u636e\u5931\u8d25\u3002", (String)"ExceDeleteBillTask_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            costadjustbillids.clear();
            QFilter qFilter = new QFilter("id", "in", (Object)balanceids);
            Set balDimFields = ExceCostHelper.getBalDimFields((String)sumType, (boolean)false);
            DataSet balDataSet = ExceCostHelper.buildBalanceData((QFilter)qFilter, (boolean)ExceCostHelper.getCostElementByCostAccount((Long)costaccountId));
            DataSet costAdjust_matched_balend = ExceCostHelper.createCostAdjust_matched_BALEND((boolean)ExceCostHelper.getCostElementByCostAccount((Long)costaccountId), (Set)balDimFields, (QFilter[])new QFilter[0], (Long)costaccountId, null, (boolean)false);
            JoinDataSet joinDataSet = balDataSet.join(costAdjust_matched_balend);
            for (String balDimField : balDimFields) {
                joinDataSet.on(balDimField, balDimField);
            }
            DataSet dataSet = joinDataSet.select(balDataSet.getRowMeta().getFieldNames(), new String[]{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak", "margin"}).finish();
            DataSet detailDatasetX = dataSet.groupBy((String[])ArrayUtils.concatAll((Object[])balDataSet.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak"}})).sum("margin").finish();
            HashSet<Long> dbAdjustBillId = new HashSet<Long>(16);
            for (Row datasetX : detailDatasetX) {
                Long costadjustbillid = datasetX.getLong("costadjustbillid");
                dbAdjustBillId.add(costadjustbillid);
            }
            costadjustbillids.addAll(dbAdjustBillId);
            if (costadjustbillids.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5220\u5355\u5931\u8d25\uff0c\u6570\u636e\u5df2\u5220\u5355\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExceDeleteBillTask_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    ArrayList<Long> waitToDelete = new ArrayList<Long>(16);
                    String errorMessage = this.doUnAuditOperation(costadjustbillids, waitToDelete);
                    Set deleteIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_costadjust_subentity", waitToDelete);
                    ArrayList<Long> deleteIdList = new ArrayList<Long>(deleteIds);
                    this.deleteCostadjustBillByIds("cal_costadjust_subentity", deleteIdList);
                    this.deleteBillByAdjustbillIds("cal_balance_costadjust", deleteIdList);
                    if (errorMessage != null && errorMessage.trim().length() != 0) {
                        msgInfo.setContent(errorMessage);
                    }
                    logger.info("\u5f00\u59cb\u524d\u8017\u65f6\uff1a" + (TimeServiceHelper.now().getTime() - starttime));
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        catch (KDBizException e) {
            msgInfo.setContent(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            msgInfo.setContent(e.getMessage());
            throw e;
        }
        finally {
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
    }

    private void deleteCostadjustBillByIds(String entityName, List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{filter});
    }

    private void deleteBillByAdjustbillIds(String entityName, List<Long> ids) {
        QFilter filter = new QFilter("costadjustbillid", "in", ids);
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{filter});
    }

    private void deleteBillByBalanceids(String entityName, List<Long> ids) {
        QFilter filter = new QFilter("balanceid", "in", ids);
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{filter});
    }

    private String doUnAuditOperation(List<Long> ids, List<Long> container) {
        DynamicObject[] unCostAdjusts;
        HashMap<String, HashSet<Long>> billStatusAndIds = new HashMap<String, HashSet<Long>>(16);
        for (DynamicObject dy : unCostAdjusts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"))) {
            String billstatus = dy.getString("billstatus");
            long billId = dy.getLong("id");
            HashSet<Long> billIds = (HashSet<Long>)billStatusAndIds.get(billstatus);
            if (billIds == null) {
                billIds = new HashSet<Long>(16);
                billIds.add(billId);
                billStatusAndIds.put(billstatus, billIds);
                continue;
            }
            billIds.add(billId);
        }
        if (billStatusAndIds != null && billStatusAndIds.size() > 0) {
            StringBuilder errorInfo = new StringBuilder();
            for (Map.Entry billStatusAndIdEntry : billStatusAndIds.entrySet()) {
                List errors;
                String billStatus = (String)billStatusAndIdEntry.getKey();
                Set list = (Set)billStatusAndIdEntry.getValue();
                if (!"C".equals(billStatus) || list.isEmpty()) continue;
                DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
                OperateOption op = OperateOption.create();
                op.setVariableValue("unwriteoff", "true");
                op.setVariableValue("ishasright", "true");
                OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)op);
                if (result.isSuccess() || (errors = result.getAllErrorOrValidateInfo()) == null || errors.isEmpty()) continue;
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    String msg = String.format(ResManager.loadKDString((String)"\u5220\u5355\u5931\u8d25\uff1a%1$s", (String)"ExceCostSummaryBillPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]), operror.getMessage());
                    errorInfo.append(msg);
                }
            }
            QFilter q = new QFilter("id", "in", ids);
            q.and("billstatus", "!=", (Object)"C");
            DataSet adjustInitialState = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjust_subentity", (String)"id", (QFilter[])new QFilter[]{q}, null);
            for (Row row : adjustInitialState) {
                if (container.contains(row.getLong("id"))) continue;
                container.add(row.getLong("id"));
            }
            return errorInfo.toString();
        }
        return null;
    }
}

