/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.summary;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cal.common.enums.SumTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.util.DynamicObjectUtils;

public class ExceExportBillTask
extends AbstractTask {
    private String sumType;
    private String DLOCK_KEY = "fi-cal-excebalancesumlist";
    private static final Log logger = LogFactory.getLog(ExceExportBillTask.class);

    /*
     * WARNING - void declaration
     */
    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        long starttime = TimeServiceHelper.now().getTime();
        this.sumType = (String)paramMap.get("sumType");
        Object userIdValue = paramMap.get("userId");
        String userIdStr = userIdValue == null ? "0" : userIdValue.toString();
        long userId = Long.parseLong(userIdStr);
        Object calorgIdValue = paramMap.get("calorgId");
        String calorgIdStr = calorgIdValue == null ? "0" : calorgIdValue.toString();
        long calorgId = Long.parseLong(calorgIdStr);
        Object costaccountIdValue = paramMap.get("costaccountId");
        String costaccountIdStr = costaccountIdValue == null ? "0" : costaccountIdValue.toString();
        long costaccountId = Long.parseLong(costaccountIdStr);
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(userId);
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setTitle(ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u6c47\u62a5\u8868", (String)"ExceExportBillTask_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)costaccountId).toArray());
        String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u51fa\u5355\u5168\u90e8\u6210\u529f\u3002", (String)"ExceExportBillTask_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("name"));
        msgInfo.setContent(content);
        String shortErrorShow = "";
        String key = this.DLOCK_KEY + calorgId + costaccountId;
        try (DLock lock = DLock.create((String)key, (String)"fi-cal-excebalancesumlist-exportbill");){
            DynamicObject[] costAdjustBillLists;
            String[] costAdj_entry_detail;
            String costAdj;
            boolean isLockSuccess = lock.tryLock();
            if (!isLockSuccess) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u51fa\u5355\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExceExportBillTask_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            ArrayList<DynamicObject> costAdjustBillList = new ArrayList<DynamicObject>(16);
            boolean costElementByCostAccount = false;
            boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
            if (isNewBalance) {
                costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)costaccountId);
            }
            if (costElementByCostAccount) {
                costAdj = "cal_costadjust_subentity";
                costAdj_entry_detail = new String[]{"subentryentity"};
            } else {
                costAdj = "cal_costadjustbill";
                costAdj_entry_detail = new String[]{"entryentity"};
            }
            HashSet costAdjustHeadField = new HashSet(EntityMetadataCache.getDataEntityType((String)costAdj).getAllFields().keySet());
            List billFieldValueMaps = (List)SerializationUtils.fromJsonString((String)((String)paramMap.get("costAdjustBillList")), List.class);
            for (DynamicObject adjustBillList : costAdjustBillLists = DynamicObjectUtils.mapsToDycs((List)billFieldValueMaps, (String)costAdj, costAdjustHeadField, (String[])costAdj_entry_detail)) {
                costAdjustBillList.add(adjustBillList);
            }
            List balanceids = (List)paramMap.get("balanceids");
            if (balanceids.size() == 0 || costAdjustBillList.size() == 0) {
                shortErrorShow = ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff0c\u9009\u4e2d\u6570\u636e\u672a\u751f\u6210\u6210\u672c\u8c03\u6574\u5355\u3002", (String)"ExceExportBillTask_5", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(shortErrorShow);
            }
            HashMap<Long, Set<Long>> adjustIdAndEntryId = new HashMap<Long, Set<Long>>(32);
            HashMap<Long, Set<Long>> adjustEntryIdAndDetailId = new HashMap<Long, Set<Long>>(32);
            HashMap<Long, Set<Long>> adjustIdAndEntryIdFail = new HashMap<Long, Set<Long>>(32);
            ArrayList<Long> totalFail = new ArrayList<Long>(16);
            boolean needRestart = false;
            StringBuilder messageBuilder = new StringBuilder();
            Throwable throwable = null;
            try (Object tx = TX.requiresNew();){
                try {
                    this.createAndCollectId(costAdjustBillList, adjustIdAndEntryId, adjustEntryIdAndDetailId, costElementByCostAccount);
                    String paceOneErrMsg = this.insertCostAdjustBill(balanceids, costAdjustBillList, adjustIdAndEntryIdFail);
                    if (!StringUtils.isEmpty((String)paceOneErrMsg)) {
                        messageBuilder.append(paceOneErrMsg);
                    }
                    if (!adjustIdAndEntryIdFail.isEmpty()) {
                        for (Map.Entry entry : adjustIdAndEntryId.entrySet()) {
                            Long costAdjustId = (Long)entry.getKey();
                            Set total = (Set)entry.getValue();
                            Set fails = (Set)adjustIdAndEntryIdFail.get(costAdjustId);
                            total.removeAll(fails);
                            if (!total.isEmpty()) continue;
                            totalFail.add(costAdjustId);
                        }
                        needRestart = true;
                        tx.markRollback();
                    }
                    logger.info("\u5f00\u59cb\u524d\u8017\u65f6\uff1a" + (TimeServiceHelper.now().getTime() - starttime));
                }
                catch (Exception e) {
                    String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    logger.info("ExceExportBillTask first period : " + exceptionStackTraceMessage);
                    tx.markRollback();
                    throw new KDBizException(exceptionStackTraceMessage);
                }
                catch (Throwable e) {
                    String message = e.getMessage();
                    logger.info("ExceExportBillTask first period : " + message);
                    tx.markRollback();
                    throw new KDBizException(message);
                }
            }
            catch (Throwable e) {
                Throwable throwable2 = e;
                throw e;
            }
            for (Long l : totalFail) {
                adjustIdAndEntryId.remove(l);
            }
            if (needRestart && !adjustIdAndEntryId.isEmpty()) {
                tx = TX.requiresNew();
                Throwable throwable3 = null;
                try {
                    try {
                        void var45_72;
                        Set legalKeys = adjustIdAndEntryId.keySet();
                        ArrayList<DynamicObject> legalCostAdjust = new ArrayList<DynamicObject>();
                        adjustIdAndEntryIdFail.clear();
                        for (DynamicObject dynamicObject : costAdjustBillList) {
                            long id = dynamicObject.getLong("id");
                            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
                            if (!legalKeys.contains(id)) continue;
                            Set legalEntryIds = (Set)adjustIdAndEntryId.get(id);
                            Iterator iterator = entrys.iterator();
                            while (iterator.hasNext()) {
                                DynamicObject curEntry = (DynamicObject)iterator.next();
                                long curEntryId = curEntry.getLong("id");
                                if (legalEntryIds.contains(curEntryId)) continue;
                                iterator.remove();
                            }
                            legalCostAdjust.add(dynamicObject);
                        }
                        Object var45_70 = null;
                        if (!legalCostAdjust.isEmpty()) {
                            String string = this.insertCostAdjustBill(balanceids, legalCostAdjust, adjustIdAndEntryIdFail);
                        }
                        if (!StringUtils.isEmpty((String)var45_72)) {
                            tx.markRollback();
                        }
                        logger.info("\u5f00\u59cb\u524d\u8017\u65f6\uff1a" + (TimeServiceHelper.now().getTime() - starttime));
                    }
                    catch (Exception e) {
                        String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                        logger.info("ExceExportBillTask second period : " + exceptionStackTraceMessage);
                        tx.markRollback();
                        throw new KDBizException(exceptionStackTraceMessage);
                    }
                    catch (Throwable e) {
                        String message = e.getMessage();
                        logger.info("ExceExportBillTask second period : " + message);
                        tx.markRollback();
                        throw new KDBizException(message);
                    }
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable3 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable6) {
                                throwable3.addSuppressed(throwable6);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            if (needRestart) {
                String msg;
                String string = msg = String.format(ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff1a\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25%1$s", (String)"ExceExportBillTask_8", (String)"fi-cal-formplugin", (Object[])new Object[0]), messageBuilder.length() == 0 ? "" : messageBuilder.toString());
                msgInfo.setContent(string);
            }
        }
        catch (KDBizException e) {
            logger.error("ExceExportBillTask error : ", (Throwable)e);
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)e));
            if (!StringUtils.isEmpty((String)shortErrorShow)) {
                msgInfo.setContent(shortErrorShow);
            } else {
                msgInfo.setContent(exceptionStackTraceMessage);
            }
            throw new KDBizException(exceptionStackTraceMessage);
        }
        catch (Exception e) {
            logger.error("ExceExportBillTask error : ", (Throwable)e);
            logger.info("ExceExportBillTask error param: {}", paramMap);
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            msgInfo.setContent(exceptionStackTraceMessage);
            throw e;
        }
        catch (Throwable throwable) {
            logger.error("ExceExportBillTask error : ", throwable);
            logger.info("ExceExportBillTask error param: {}", paramMap);
            String message = throwable.getMessage();
            msgInfo.setContent(message);
            throw throwable;
        }
        finally {
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
    }

    private void createAndCollectId(Collection<DynamicObject> costAdjustBillList, Map<Long, Set<Long>> idAndEntryId, Map<Long, Set<Long>> adjustEntryIdAndDetailId, boolean costElementByCostAccount) {
        IDGenerator idCreator = new IDGenerator("cal_costadjustbill");
        IDGenerator entryIdCreator = new IDGenerator("cal_costadjust_subentity");
        IDGenerator detailIdCreator = null;
        if (costElementByCostAccount) {
            detailIdCreator = new IDGenerator("cal_costadjust_detail");
        }
        for (DynamicObject costAdjust : costAdjustBillList) {
            costAdjust.set("id", (Object)idCreator.getId());
            Long id = costAdjust.getLong("id");
            DynamicObjectCollection entrys = costAdjust.getDynamicObjectCollection("entryentity");
            for (DynamicObject costAdjustEntry : entrys) {
                Set<Object> entryIds;
                costAdjustEntry.set("id", (Object)entryIdCreator.getId());
                Long entryId = costAdjustEntry.getLong("id");
                if (!idAndEntryId.containsKey(id)) {
                    entryIds = new HashSet<Long>();
                    entryIds.add(entryId);
                    idAndEntryId.put(id, entryIds);
                } else {
                    entryIds = idAndEntryId.get(id);
                    entryIds.add(entryId);
                }
                if (!costElementByCostAccount) continue;
                DynamicObjectCollection subentryentity = costAdjustEntry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subentry : subentryentity) {
                    if (detailIdCreator != null) {
                        subentry.set("id", (Object)detailIdCreator.getId());
                    }
                    long detailid = subentry.getLong("id");
                    adjustEntryIdAndDetailId.putIfAbsent(entryId, new HashSet());
                    Set<Long> details = adjustEntryIdAndDetailId.get(entryId);
                    details.add(detailid);
                }
            }
        }
    }

    private String insertCostAdjustBill(List<Object> balanceids, Collection<DynamicObject> costAdjustBillList, Map<Long, Set<Long>> failCostAdjustEntryIds) {
        DynamicObject[] array = costAdjustBillList.toArray(new DynamicObject[costAdjustBillList.size()]);
        SaveServiceHelper.save((DynamicObject[])array);
        HashSet<Long> ids = new HashSet<Long>(costAdjustBillList.size());
        for (DynamicObject info : costAdjustBillList) {
            ids.add(info.getLong("id"));
        }
        return this.doAuditOperation(ids, failCostAdjustEntryIds, balanceids);
    }

    private String doAuditOperation(Set<Long> ids, Map<Long, Set<Long>> failCostAdjustEntryIds, List<Object> balanceids) {
        String recallMessage;
        block7: {
            DynamicObject[] costAdjusts;
            block8: {
                OperationResult result;
                OperateOption op;
                block6: {
                    costAdjusts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
                    op = OperateOption.create();
                    op.setVariableValue("cal_balance_costadjust", "true");
                    op.setVariableValue("cal_balance_costadjust_ids", JSONObject.toJSONString(balanceids));
                    if (SumTypeEnum.HUAFENYIJU.getValue().equals(this.sumType)) {
                        op.setVariableValue("checkBalQtyAmtDc", "true");
                    }
                    op.setVariableValue("ishasright", "true");
                    result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)op);
                    recallMessage = "";
                    if (!result.isSuccess() || op.getVariables() == null) break block6;
                    Map r = op.getVariables();
                    Map errorCostAdjEntryidMap = (Map)SerializationUtils.fromJsonString((String)((String)r.get("errorcostadjentryidmap")), Map.class);
                    if (errorCostAdjEntryidMap == null || errorCostAdjEntryidMap.isEmpty()) break block7;
                    for (Map.Entry errEntry : errorCostAdjEntryidMap.entrySet()) {
                        long key = errEntry.getKey() == null ? 0L : Long.parseLong((String)errEntry.getKey());
                        HashSet value = new HashSet(16);
                        value.addAll((Collection)errEntry.getValue());
                        failCostAdjustEntryIds.put(key, value);
                    }
                    break block7;
                }
                recallMessage = result.getMessage();
                Map r = op.getVariables();
                if (r == null || r.isEmpty() || r.get("errorcostadjentryidmap") == null) break block8;
                Map errorCostAdjEntryidMap = (Map)SerializationUtils.fromJsonString((String)((String)r.get("errorcostadjentryidmap")), Map.class);
                if (errorCostAdjEntryidMap == null || errorCostAdjEntryidMap.isEmpty()) break block7;
                for (Map.Entry errEntry : errorCostAdjEntryidMap.entrySet()) {
                    long key = errEntry.getKey() == null ? 0L : Long.parseLong((String)errEntry.getKey());
                    HashSet value = new HashSet(16);
                    value.addAll((Collection)errEntry.getValue());
                    failCostAdjustEntryIds.put(key, value);
                }
                break block7;
            }
            for (DynamicObject costAdjust : costAdjusts) {
                long id = costAdjust.getLong("id");
                DynamicObjectCollection entrys = costAdjust.getDynamicObjectCollection("entryentity");
                for (DynamicObject costAdjustEntry : entrys) {
                    Set<Object> entryIds;
                    Long entryId = costAdjustEntry.getLong("id");
                    if (!failCostAdjustEntryIds.containsKey(id)) {
                        entryIds = new HashSet<Long>();
                        entryIds.add(entryId);
                        failCostAdjustEntryIds.put(id, entryIds);
                        continue;
                    }
                    entryIds = failCostAdjustEntryIds.get(id);
                    entryIds.add(entryId);
                }
            }
        }
        return recallMessage;
    }
}

