/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.summary.newplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.helper.ExceCostHelper;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.SumTypeEnum;
import kd.fi.cal.common.util.ArrayUtils;

public class ExceCostExportBillCheck {
    private IDataModel model;
    private IFormView view;
    private IPageCache pageCache;
    private static final String CALORG = "calorgfilter";
    private static final String COSTACCOUNT = "costaccountfilter";
    private static final String CURRENCY = "currencyfilter";
    private static final String AMT_PRECISION = "amtPrecision";
    private static final String PERIOD = "periodfilter";
    private static final String EXPORTFLAG = "exportflag";
    private static final String EXPORT_BILL = "08Q=15+7DA21";
    Set<Long> allBalanceIdsForChosen = new HashSet<Long>(16);
    Set<Integer> billtype_empty_index = new HashSet<Integer>();
    Set<Integer> afteramt_index_error = new HashSet<Integer>();
    Set<Integer> errorIndex_detail = new HashSet<Integer>();
    Set<Integer> errorIndex_amtZero = new HashSet<Integer>();
    Set<Integer> errorIndex_qtyZero = new HashSet<Integer>();

    public ExceCostExportBillCheck(IDataModel model, IFormView view, IPageCache pageCache) {
        this.model = model;
        this.view = view;
        this.pageCache = pageCache;
    }

    public int[] doCheck() {
        StringBuilder sb;
        DynamicObject costAccountInfo;
        String sumType = (String)this.model.getValue("sumtype");
        DynamicObject calOrg = (DynamicObject)this.model.getValue(CALORG);
        long calOrgId = calOrg.getLong("id");
        EntryGrid billEntryGrid = (EntryGrid)this.view.getControl("entryentity");
        int[] selectRows = billEntryGrid.getSelectRows();
        Integer maxnumberentries = (Integer)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calOrgId, (Long)0L, (String)"maxnumberentries");
        if (selectRows.length < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExceCostSummaryBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (selectRows.length > maxnumberentries) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u6761\u6570\u4e0d\u80fd\u8d85\u8fc7\u53c2\u6570\u8bbe\u7f6e\u7684\u5206\u5f55\u6570\u3002", (String)"ExceCostSummaryBillPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.checkCalingBill();
        this.chkExportBillPermission(calOrgId, Long.valueOf(this.pageCache.get("userId")), EXPORT_BILL, ResManager.loadKDString((String)"\u51fa\u5355", (String)"ExceCostSummaryBillPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        String currency = this.pageCache.get(CURRENCY);
        if ((null == currency || "".equals(currency)) && (costAccountInfo = this.model.getDataEntity().getDynamicObject(COSTACCOUNT)) != null) {
            String policyID = costAccountInfo.getString("calpolicy.id");
            this.loadCurrencyData(policyID);
        }
        DynamicObject accountDyc = this.model.getDataEntity().getDynamicObject(COSTACCOUNT);
        boolean costElementByCostAccount = ExceCostHelper.getCostElementByCostAccount((Long)accountDyc.getLong("id"));
        DynamicObjectCollection total = (DynamicObjectCollection)this.model.getValue("entryentity");
        int[] row_state = new int[total.size()];
        for (int i : selectRows) {
            row_state[i] = 1;
            String balanceidsTag = ((DynamicObject)total.get(i)).getString("balanceids_tag");
            if (costElementByCostAccount) {
                List list = (List)JSONObject.parseObject((String)balanceidsTag, List.class);
                for (Object s : list) {
                    List balid_eid_sid_qty_amts = (List)JSONObject.parseObject((String)s.toString(), List.class);
                    for (String cur : balid_eid_sid_qty_amts) {
                        String[] balid_eid_sid_qty_amt = cur.split("#");
                        Long balanceId = StringUtils.isEmpty((String)balid_eid_sid_qty_amt[0]) ? 0L : Long.parseLong(balid_eid_sid_qty_amt[0]);
                        if (balanceId == 0L) continue;
                        this.allBalanceIdsForChosen.add(balanceId);
                    }
                }
            } else {
                String[] balanceIds = balanceidsTag.split(",");
                for (String balanceIdStr : balanceIds) {
                    Long balanceId = StringUtils.isEmpty((String)balanceIdStr) ? 0L : Long.parseLong(balanceIdStr);
                    if (balanceId == 0L) continue;
                    this.allBalanceIdsForChosen.add(balanceId);
                }
            }
            BigDecimal periodendqtyTotal = ((DynamicObject)total.get(i)).getBigDecimal("periodendqty");
            BigDecimal periodendactualcost = ((DynamicObject)total.get(i)).getBigDecimal("periodendactualcost");
            BigDecimal periodendqty = ((DynamicObject)total.get(i)).getBigDecimal("periodendqty");
            BigDecimal afteramount = ((DynamicObject)total.get(i)).getBigDecimal("afteramount");
            BigDecimal marginTotal = ((DynamicObject)total.get(i)).getBigDecimal("margin");
            Object billtype = ((DynamicObject)total.get(i)).get("billtype");
            if (SumTypeEnum.HUAFENYIJU.getValue().equals(sumType)) {
                String balanceids_tag;
                if (costElementByCostAccount && BigDecimal.ZERO.compareTo(afteramount) != 0 && BigDecimal.ZERO.compareTo(periodendactualcost) != 0 && BigDecimal.ZERO.compareTo(periodendqtyTotal) == 0 && row_state[i] == 1) {
                    this.errorIndex_detail.add(i);
                    row_state[i] = -1;
                }
                if (costElementByCostAccount && BigDecimal.ZERO.compareTo(periodendactualcost) == 0 && BigDecimal.ZERO.compareTo(periodendqtyTotal) != 0 && BigDecimal.ZERO.compareTo(afteramount) == 0 && row_state[i] == 1) {
                    this.errorIndex_amtZero.add(i);
                    row_state[i] = -2;
                }
                if (!costElementByCostAccount && BigDecimal.ZERO.compareTo(periodendactualcost) == 0 && BigDecimal.ZERO.compareTo(periodendqtyTotal) != 0 && BigDecimal.ZERO.compareTo(afteramount) == 0 && row_state[i] == 1) {
                    this.errorIndex_amtZero.add(i);
                    row_state[i] = -2;
                }
                if (costElementByCostAccount && BigDecimal.ZERO.compareTo(periodendqtyTotal) == 0 && BigDecimal.ZERO.compareTo(periodendactualcost) == 0 && !StringUtils.isEmpty((String)(balanceids_tag = ((DynamicObject)total.get(i)).getString("balanceids_tag")))) {
                    List group = (List)JSONObject.parseObject((String)balanceids_tag, List.class);
                    boolean breakFlag = false;
                    block4: for (List list : group) {
                        if (!breakFlag) {
                            for (String s : list) {
                                String[] split = s.split("#");
                                if (StringUtils.isEmpty((String)split[3]) || BigDecimal.ZERO.compareTo(new BigDecimal(split[3])) == 0) continue;
                                this.errorIndex_qtyZero.add(i);
                                row_state[i] = -3;
                                breakFlag = true;
                                continue block4;
                            }
                            continue;
                        }
                        break;
                    }
                }
            } else {
                if (marginTotal.compareTo(BigDecimal.ZERO) == 0 && SumTypeEnum.DETAILED.getValue().equals(sumType) && !costElementByCostAccount) {
                    this.errorIndex_amtZero.add(i);
                    row_state[i] = -2;
                }
                Boolean isExce1 = periodendqtyTotal.compareTo(BigDecimal.ZERO) < 0 && afteramount.compareTo(BigDecimal.ZERO) > 0;
                Boolean isExce2 = periodendqtyTotal.compareTo(BigDecimal.ZERO) > 0 && afteramount.compareTo(BigDecimal.ZERO) < 0;
                if (isExce1.booleanValue() || isExce2.booleanValue()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u91cf\u4e0e\u8c03\u6574\u540e\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\u4e0d\u5141\u8bb8\u51fa\u5355\u3002", (String)"ExceCostSummaryBillPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
                    throw new KDBizException(msg);
                }
            }
            if (billtype == null) {
                this.billtype_empty_index.add(i);
                row_state[i] = -4;
            }
            if (periodendqty != null && BigDecimal.ZERO.compareTo(periodendqty) == 0 && afteramount != null && BigDecimal.ZERO.compareTo(afteramount) != 0) {
                this.afteramt_index_error.add(i);
                row_state[i] = -5;
            }
            if (afteramount == null || BigDecimal.ZERO.compareTo(afteramount) != 0 || periodendqtyTotal == null || BigDecimal.ZERO.compareTo(periodendqtyTotal) == 0 || row_state[i] != 1 || costElementByCostAccount) continue;
            row_state[i] = 2;
        }
        if (!this.allBalanceIdsForChosen.isEmpty()) {
            DynamicObject costaccount = this.model.getDataEntity().getDynamicObject(COSTACCOUNT);
            DynamicObject periodObject = this.model.getDataEntity().getDynamicObject(PERIOD);
            QFilter balFilter = new QFilter("id", "in", this.allBalanceIdsForChosen);
            DataSet balanceDataSet = ExceCostHelper.buildBalanceData((QFilter)balFilter, (boolean)ExceCostHelper.getCostElementByCostAccount((Long)costaccount.getLong("id")));
            Set balDimFields = ExceCostHelper.getBalDimFields((String)sumType, (boolean)false);
            DataSet costAdjust_matched = ExceCostHelper.createCostAdjust_matched_BALEND((boolean)ExceCostHelper.getCostElementByCostAccount((Long)costaccount.getLong("id")), (Set)balDimFields, (QFilter[])new QFilter[0], (Long)((Long)costaccount.getPkValue()), (Long)((Long)periodObject.getPkValue()), (boolean)false);
            JoinDataSet joinDataSet = balanceDataSet.join(costAdjust_matched);
            for (String balDimField : balDimFields) {
                joinDataSet.on(balDimField, balDimField);
            }
            DataSet dataSet = joinDataSet.select(balanceDataSet.getRowMeta().getFieldNames(), new String[]{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak", "margin"}).finish();
            DataSet detailDatasetX = dataSet.groupBy((String[])ArrayUtils.concatAll((Object[])balanceDataSet.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak"}})).sum("margin").finish();
            if (!detailDatasetX.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff0c\u6570\u636e\u5df2\u51fa\u5355\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExceExportBillTask_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
        if (!this.billtype_empty_index.isEmpty()) {
            sb = new StringBuilder();
            for (Integer index : this.billtype_empty_index) {
                sb.append(index + 1).append("\u3001");
            }
            String errIndex = sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
            String msg_detail = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355", (String)"ExceCostSummaryBillPlugin_38", (String)"fi-cal-formplugin", (Object[])new Object[0]), errIndex);
            throw new KDBizException(msg_detail);
        }
        if (!this.afteramt_index_error.isEmpty()) {
            sb = new StringBuilder();
            for (Integer index : this.afteramt_index_error) {
                sb.append(index + 1).append("\u3001");
            }
            String errIndex = sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
            String msg_detail = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u91cf=0\uff0c\u8c03\u6574\u540e\u7684\u91d1\u989d\u4e0d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355\u8c03\u6574", (String)"ExceCostSummaryBillPlugin_39", (String)"fi-cal-formplugin", (Object[])new Object[0]), errIndex);
            throw new KDBizException(msg_detail);
        }
        if (!this.errorIndex_amtZero.isEmpty() && SumTypeEnum.HUAFENYIJU.getValue().equals(sumType)) {
            sb = new StringBuilder();
            for (int selectRow : this.errorIndex_amtZero) {
                sb.append(selectRow + 1).append("\u3001");
            }
            String infoMsg = sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5dee\u989d=0\u4e0d\u5141\u8bb8\u51fa\u5355\u3002  ", (String)"ExceCostSummaryBillPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), infoMsg);
            throw new KDBizException(msg);
        }
        if (!this.errorIndex_qtyZero.isEmpty() && SumTypeEnum.HUAFENYIJU.getValue().equals(sumType)) {
            sb = new StringBuilder();
            Object infoMsg = this.errorIndex_amtZero.iterator();
            while (infoMsg.hasNext()) {
                int selectRow;
                selectRow = infoMsg.next();
                sb.append(selectRow + 1).append("\u3001");
            }
            infoMsg = sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
            String msg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u6570\u91cf\u4e0d\u4e3a0\u5dee\u989d=0\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355\uff01", (String)"ExceCostSummaryBillPlugin_53", (String)"fi-cal-formplugin", (Object[])new Object[0]), infoMsg);
            throw new KDBizException(msg);
        }
        return row_state;
    }

    private void checkCalingBill() {
        DynamicObject calOrg = this.model.getDataEntity().getDynamicObject(CALORG);
        DynamicObject accountDyc = this.model.getDataEntity().getDynamicObject(COSTACCOUNT);
        if (calOrg == null || accountDyc == null) {
            return;
        }
        QFilter filter = new QFilter("calorg", "=", (Object)calOrg.getLong("id"));
        filter.and(new QFilter("costaccount", "=", (Object)accountDyc.getLong("id")));
        filter.and(new QFilter("calstatus", "=", (Object)"C"));
        filter.and(new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue()));
        boolean isCaling = QueryServiceHelper.exists((String)"cal_costadjustbill", (QFilter[])filter.toArray());
        if (isCaling) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6838\u7b97\u5904\u7406\u72b6\u6001\u4e3a\u5904\u7406\u4e2d\u7684\u6210\u672c\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u51fa\u5355\u6216\u5220\u5355\u3002", (String)"ExceCostSummaryBillPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void chkExportBillPermission(Long orgId, Long userId, String flag, String opName) {
        int checkPermission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"/KIUHEXROK3D", (String)"cal_excebalancesumlist", (String)flag);
        if (checkPermission <= 0) {
            String content = String.format(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709%1$s\u64cd\u4f5c\u7684\u6743\u9650\u3002", (String)"ExceCostSummaryBillPlugin_32", (String)"fi-cal-formplugin", (Object[])new Object[0]), opName);
            throw new KDBizException(content);
        }
    }

    private void loadCurrencyData(String policyID) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
        DynamicObject currency = obj.getDynamicObject("currency");
        Long currencyid = obj.getDynamicObject("currency").getLong("id");
        this.pageCache.put(CURRENCY, currencyid.toString());
        this.pageCache.put(AMT_PRECISION, String.valueOf(currency.getInt("amtprecision")));
        this.model.setValue(CURRENCY, (Object)currencyid);
        this.view.updateView(CURRENCY);
    }
}

