/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.summary.newplugin.func;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.business.helper.ExceCostHelper;
import kd.fi.cal.formplugin.summary.newplugin.func.ExceCostDetailFunc;
import kd.fi.cal.formplugin.summary.newplugin.func.ExceExportOperationFunc;

public class ExceCostEntryFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Long costaccountid;
    private String sumType;
    private RowMeta resultMeta;

    public ExceCostEntryFunc(RowMeta rowMeta, RowMeta resultMeta, Long costaccountid, String sumType) {
        this.rowMeta = rowMeta;
        this.costaccountid = costaccountid;
        this.sumType = sumType;
        this.resultMeta = resultMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashMap<String, DynamicObject> costAdjustBillMap = new HashMap<String, DynamicObject>();
        HashSet<Long> balanceIds = new HashSet<Long>();
        for (RowX row : iterable) {
            String bizType = row.getString(this.rowMeta.getFieldIndex("biztype"));
            Long billType = row.getLong(this.rowMeta.getFieldIndex("billtype"));
            balanceIds.add(row.getLong(this.rowMeta.getFieldIndex("balanceid")));
            String typeKey = bizType + "_" + billType;
            if (costAdjustBillMap.containsKey(typeKey)) {
                DynamicObject costAdjustBill = ExceCostHelper.getCostElementByCostAccount((Long)this.costaccountid) ? BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity") : BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjustbill");
                if (!costAdjustBillMap.containsKey(typeKey)) {
                    costAdjustBillMap.put(typeKey, costAdjustBill);
                }
            }
            this.calculateEntry(costAdjustBillMap, row);
        }
        if (ExceCostHelper.getCostElementByCostAccount((Long)this.costaccountid)) {
            new ExceCostDetailFunc();
        }
        ExceExportOperationFunc exceExportFunc = new ExceExportOperationFunc(this.costaccountid, this.sumType);
        Map<String, String> errMap = exceExportFunc.saveAndAudit(new ArrayList<Object>(balanceIds), costAdjustBillMap.values().stream().collect(Collectors.toList()));
        for (Map.Entry<String, String> entry : errMap.entrySet()) {
            RowX result = new RowX(this.resultMeta.getFieldCount());
            result.set(this.resultMeta.getFieldIndex("materialnumber"), (Object)entry.getKey());
            result.set(this.resultMeta.getFieldIndex("materialname"), (Object)entry.getValue());
            collector.collect(result);
        }
    }

    private void calculateEntry(Map<String, DynamicObject> costAdjustBillMap, RowX rowX) {
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }
}

