/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.summary.newplugin.func;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.helper.ExceCostHelper;
import kd.fi.cal.common.enums.SumTypeEnum;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.WriteLogHelper;

public class ExceExportOperationFunc {
    private static final Log logger = LogFactory.getLog(ExceExportOperationFunc.class);
    private Long costaccountid;
    private String sumType;

    public ExceExportOperationFunc(Long costaccountid, String sumType) {
        this.costaccountid = costaccountid;
        this.sumType = sumType;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> saveAndAudit(List<Object> balanceids, List<DynamicObject> costAdjustBillList) {
        long starttime = System.currentTimeMillis();
        HashMap<Long, Set<Long>> adjustIdAndEntryId = new HashMap<Long, Set<Long>>(32);
        HashMap<Long, Set<Long>> adjustEntryIdAndDetailId = new HashMap<Long, Set<Long>>(32);
        HashMap<Long, Set<Long>> adjustIdAndEntryIdFail = new HashMap<Long, Set<Long>>(32);
        ArrayList<Long> totalFail = new ArrayList<Long>(16);
        boolean needRestart = false;
        StringBuilder messageBuilder = new StringBuilder();
        Object tx = TX.requiresNew();
        Object object = null;
        try {
            try {
                this.createAndCollectId(costAdjustBillList, adjustIdAndEntryId, adjustEntryIdAndDetailId, ExceCostHelper.getCostElementByCostAccount((Long)this.costaccountid));
                String paceOneErrMsg = this.insertCostAdjustBill(balanceids, costAdjustBillList, adjustIdAndEntryIdFail);
                if (!StringUtils.isEmpty((String)paceOneErrMsg)) {
                    messageBuilder.append(paceOneErrMsg);
                }
                if (!adjustIdAndEntryIdFail.isEmpty()) {
                    for (Map.Entry entry : adjustIdAndEntryId.entrySet()) {
                        Long costAdjustId = (Long)entry.getKey();
                        Set total = (Set)entry.getValue();
                        Set fails = (Set)adjustIdAndEntryIdFail.get(costAdjustId);
                        total.removeAll(fails);
                        if (!total.isEmpty()) continue;
                        totalFail.add(costAdjustId);
                    }
                    needRestart = true;
                    tx.markRollback();
                }
                WriteLogHelper.writeErrorLog((Log)logger, (String)("ExceExportBillTask time cost\uff1a" + (TimeServiceHelper.now().getTime() - starttime)), (Object[])new Object[0]);
            }
            catch (Exception e) {
                String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                WriteLogHelper.writeErrorLog((Log)logger, (String)("ExceExportBillTask first period : " + exceptionStackTraceMessage), (Object[])new Object[0]);
                tx.markRollback();
                throw new KDBizException(exceptionStackTraceMessage);
            }
            catch (Throwable e) {
                String message = e.getMessage();
                WriteLogHelper.writeErrorLog((Log)logger, (String)("ExceExportBillTask first period : " + message), (Object[])new Object[0]);
                tx.markRollback();
                throw new KDBizException(message);
            }
        }
        catch (Throwable e) {
            object = e;
            throw e;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)object).addSuppressed(e);
                    }
                } else {
                    tx.close();
                }
            }
        }
        for (Long costAdjustId : totalFail) {
            adjustIdAndEntryId.remove(costAdjustId);
        }
        if (needRestart && !adjustIdAndEntryId.isEmpty()) {
            tx = TX.requiresNew();
            object = null;
            try {
                try {
                    void var15_28;
                    Set legalKeys = adjustIdAndEntryId.keySet();
                    ArrayList<DynamicObject> legalCostAdjust = new ArrayList<DynamicObject>();
                    adjustIdAndEntryIdFail.clear();
                    for (DynamicObject dynamicObject : costAdjustBillList) {
                        long id = dynamicObject.getLong("id");
                        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
                        if (!legalKeys.contains(id)) continue;
                        Set legalEntryIds = (Set)adjustIdAndEntryId.get(id);
                        Iterator iterator = entrys.iterator();
                        while (iterator.hasNext()) {
                            DynamicObject curEntry = (DynamicObject)iterator.next();
                            long curEntryId = curEntry.getLong("id");
                            if (legalEntryIds.contains(curEntryId)) continue;
                            iterator.remove();
                        }
                        legalCostAdjust.add(dynamicObject);
                    }
                    Object var15_26 = null;
                    if (!legalCostAdjust.isEmpty()) {
                        String string = this.insertCostAdjustBill(balanceids, legalCostAdjust, adjustIdAndEntryIdFail);
                    }
                    if (!StringUtils.isEmpty((String)var15_28)) {
                        tx.markRollback();
                    }
                    WriteLogHelper.writeErrorLog((Log)logger, (String)("ExceExportBillTask time cost second period\uff1a" + (TimeServiceHelper.now().getTime() - starttime)), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    WriteLogHelper.writeErrorLog((Log)logger, (String)("ExceExportBillTask second period : " + exceptionStackTraceMessage), (Object[])new Object[0]);
                    tx.markRollback();
                    throw new KDBizException(exceptionStackTraceMessage);
                }
                catch (Throwable e) {
                    String message = e.getMessage();
                    WriteLogHelper.writeErrorLog((Log)logger, (String)("ExceExportBillTask second period : " + message), (Object[])new Object[0]);
                    tx.markRollback();
                    throw new KDBizException(message);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        if (needRestart) {
            String msg = String.format(ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff1a\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25%1$s", (String)"ExceExportBillTask_8", (String)"fi-cal-formplugin", (Object[])new Object[0]), messageBuilder.length() == 0 ? "" : messageBuilder.toString());
            object = msg;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        return result;
    }

    private void createAndCollectId(Collection<DynamicObject> costAdjustBillList, Map<Long, Set<Long>> idAndEntryId, Map<Long, Set<Long>> adjustEntryIdAndDetailId, boolean costElementByCostAccount) {
        IDGenerator idCreator = new IDGenerator("cal_costadjustbill");
        IDGenerator entryIdCreator = new IDGenerator("cal_costadjust_subentity");
        IDGenerator detailIdCreator = null;
        if (costElementByCostAccount) {
            detailIdCreator = new IDGenerator("cal_costadjust_detail");
        }
        for (DynamicObject costAdjust : costAdjustBillList) {
            costAdjust.set("id", (Object)idCreator.getId());
            Long id = costAdjust.getLong("id");
            DynamicObjectCollection entrys = costAdjust.getDynamicObjectCollection("entryentity");
            for (DynamicObject costAdjustEntry : entrys) {
                Set<Object> entryIds;
                costAdjustEntry.set("id", (Object)entryIdCreator.getId());
                Long entryId = costAdjustEntry.getLong("id");
                if (!idAndEntryId.containsKey(id)) {
                    entryIds = new HashSet<Long>();
                    entryIds.add(entryId);
                    idAndEntryId.put(id, entryIds);
                } else {
                    entryIds = idAndEntryId.get(id);
                    entryIds.add(entryId);
                }
                if (!costElementByCostAccount) continue;
                DynamicObjectCollection subentryentity = costAdjustEntry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subentry : subentryentity) {
                    if (detailIdCreator != null) {
                        subentry.set("id", (Object)detailIdCreator.getId());
                    }
                    long detailid = subentry.getLong("id");
                    adjustEntryIdAndDetailId.putIfAbsent(entryId, new HashSet());
                    Set<Long> details = adjustEntryIdAndDetailId.get(entryId);
                    details.add(detailid);
                }
            }
        }
    }

    private String insertCostAdjustBill(List<Object> balanceids, Collection<DynamicObject> costAdjustBillList, Map<Long, Set<Long>> failCostAdjustEntryIds) {
        DynamicObject[] array = costAdjustBillList.toArray(new DynamicObject[costAdjustBillList.size()]);
        SaveServiceHelper.save((DynamicObject[])array);
        HashSet<Long> ids = new HashSet<Long>(costAdjustBillList.size());
        for (DynamicObject info : costAdjustBillList) {
            ids.add(info.getLong("id"));
        }
        return this.doAuditOperation(ids, failCostAdjustEntryIds, balanceids);
    }

    private String doAuditOperation(Set<Long> ids, Map<Long, Set<Long>> failCostAdjustEntryIds, List<Object> balanceids) {
        String recallMessage;
        block7: {
            DynamicObject[] costAdjusts;
            block8: {
                OperationResult result;
                OperateOption op;
                block6: {
                    costAdjusts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
                    op = OperateOption.create();
                    op.setVariableValue("cal_balance_costadjust", "true");
                    op.setVariableValue("cal_balance_costadjust_ids", JSONObject.toJSONString(balanceids));
                    if (SumTypeEnum.HUAFENYIJU.getValue().equals(this.sumType)) {
                        op.setVariableValue("checkBalQtyAmtDc", "true");
                    }
                    op.setVariableValue("ishasright", "true");
                    result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)op);
                    recallMessage = "";
                    if (!result.isSuccess() || op.getVariables() == null) break block6;
                    Map r = op.getVariables();
                    Map errorCostAdjEntryidMap = (Map)SerializationUtils.fromJsonString((String)((String)r.get("errorcostadjentryidmap")), Map.class);
                    if (errorCostAdjEntryidMap == null || errorCostAdjEntryidMap.isEmpty()) break block7;
                    for (Map.Entry errEntry : errorCostAdjEntryidMap.entrySet()) {
                        long key = errEntry.getKey() == null ? 0L : Long.parseLong((String)errEntry.getKey());
                        HashSet value = new HashSet(16);
                        value.addAll((Collection)errEntry.getValue());
                        failCostAdjustEntryIds.put(key, value);
                    }
                    break block7;
                }
                recallMessage = result.getMessage();
                Map r = op.getVariables();
                if (r == null || r.isEmpty() || r.get("errorcostadjentryidmap") == null) break block8;
                Map errorCostAdjEntryidMap = (Map)SerializationUtils.fromJsonString((String)((String)r.get("errorcostadjentryidmap")), Map.class);
                if (errorCostAdjEntryidMap == null || errorCostAdjEntryidMap.isEmpty()) break block7;
                for (Map.Entry errEntry : errorCostAdjEntryidMap.entrySet()) {
                    long key = errEntry.getKey() == null ? 0L : Long.parseLong((String)errEntry.getKey());
                    HashSet value = new HashSet(16);
                    value.addAll((Collection)errEntry.getValue());
                    failCostAdjustEntryIds.put(key, value);
                }
                break block7;
            }
            for (DynamicObject costAdjust : costAdjusts) {
                long id = costAdjust.getLong("id");
                DynamicObjectCollection entrys = costAdjust.getDynamicObjectCollection("entryentity");
                for (DynamicObject costAdjustEntry : entrys) {
                    Set<Object> entryIds;
                    Long entryId = costAdjustEntry.getLong("id");
                    if (!failCostAdjustEntryIds.containsKey(id)) {
                        entryIds = new HashSet<Long>();
                        entryIds.add(entryId);
                        failCostAdjustEntryIds.put(id, entryIds);
                        continue;
                    }
                    entryIds = failCostAdjustEntryIds.get(id);
                    entryIds.add(entryId);
                }
            }
        }
        return recallMessage;
    }
}

