/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.writeoff;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.BillUnitAndQtytHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.WriteOffServerHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;

public class CalWfManualPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        String key = e.getItemKey();
        if ("btnautowf".equals(key) || "btnmanualwf".equals(key)) {
            Long orgid = 0L;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                orgid = org.getLong("id");
            }
            if (!WriteOffServerHelper.isWriteOffPlan((Long)orgid)) {
                String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
                if ("CGHX001".equals(wfType)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6838\u9500\u5e73\u53f0\uff0c\u8bf7\u5728\u5e94\u4ed8-\u624b\u5de5\u6838\u9500\u4e2d\u6267\u884c\u6838\u9500\u3002", (String)"CalWfManualPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6838\u9500\u5e73\u53f0\uff0c\u8bf7\u5728\u5e94\u6536-\u9500\u552e\u6536\u5165\u624b\u5de5\u6838\u9500\u4e2d\u6267\u884c\u6838\u9500\u3002", (String)"CalWfManualPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialControl = (BasedataEdit)this.getControl("material");
        materialControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCalOrg();
        this.setCurrencyByOrg();
        this.setDateRange();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadAsstactFieldVisiable();
        this.loadEntryFieldVisiable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "wfmanual": {
                this.checkSelectRows();
                this.checkAsstactAndCur();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String key = event.getOperateKey();
        if ("query".equals(key)) {
            this.dealEntryData("entry_a");
            this.dealEntryData("entry_b");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("writeofftype".equals(name)) {
            this.writeOffTypeChange();
        } else if ("org".equals(name)) {
            this.setCurrencyByOrg();
        } else if (name.contains("e_unverifybaseqty_cur") || name.contains("unverifybaseqty_cur")) {
            this.unverifybaseqtyChange(name, e);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName;
        switch (proName = e.getProperty().getName()) {
            case "org": {
                this.beforeF7Org(e);
                break;
            }
            case "material": {
                ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
                break;
            }
        }
    }

    private void beforeF7Org(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_wfmanual", (String)"47150e89000000ac");
        String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
        String entityNum = "CGHX001".equals(wfType) ? "ap_init" : "ar_init";
        QFilter initQ = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
        if (list != null) {
            initQ.and("org", "in", (Object)list);
        }
        DynamicObjectCollection ApInitColl = QueryServiceHelper.query((String)entityNum, (String)"id,org", (QFilter[])initQ.toArray());
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject org : ApInitColl) {
            ids.add(org.getLong("org"));
        }
        QFilter q = new QFilter("id", "in", ids);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void writeOffTypeChange() {
        this.getModel().deleteEntryData("entry_a");
        this.getModel().deleteEntryData("entry_b");
        MainEntityType entity = MetadataServiceHelper.getDataEntityType((String)"cal_wfmanual");
        Map allFields = entity.getAllFields();
        HashSet proNames = new HashSet(16);
        for (Map.Entry filed : allFields.entrySet()) {
            IDataEntityProperty fieldProperty = (IDataEntityProperty)filed.getValue();
            if (!(fieldProperty.getParent() instanceof EntryType)) continue;
            proNames.add(filed.getKey());
        }
        this.getView().setVisible(Boolean.FALSE, proNames.toArray(new String[0]));
        this.getView().setVisible(Boolean.FALSE, new String[]{"e_materialname_a", "materialname_a", "e_model_a", "model_a", "e_materialname_b", "materialname_b", "e_model_b", "model_b", "arbaseunit_a", "arbaseunit_b"});
        this.loadEntryFieldVisiable();
    }

    private void setEntryFiledsVisiable(String[] fields) {
        if (fields != null) {
            this.getView().setVisible(Boolean.valueOf(true), fields);
        }
    }

    private void loadEntryFieldVisiable() {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        Long wfTypeId = wfType.getLong("id");
        wfType = BusinessDataServiceHelper.loadSingle((Object)wfTypeId, (String)"msmod_writeofftype");
        DynamicObjectCollection wfTypeEntrys = wfType.getDynamicObjectCollection("writeoffbillentry");
        String mainBillEntityNum = ((DynamicObject)wfTypeEntrys.get(0)).getDynamicObject("writeoffbilltype").getString("number");
        String assistBillEntityNum = ((DynamicObject)wfTypeEntrys.get(1)).getDynamicObject("writeoffbilltype").getString("number");
        this.getPageCache().put("mainBillEntityNum", mainBillEntityNum);
        this.getPageCache().put("assistBillEntityNum", assistBillEntityNum);
        String[] mainFields = this.getEntryFieldsByEntityNum(mainBillEntityNum, "A");
        String[] assistFields = this.getEntryFieldsByEntityNum(assistBillEntityNum, "B");
        this.setEntryFiledsVisiable(mainFields);
        this.setEntryFiledsVisiable(assistFields);
    }

    private void loadAsstactFieldVisiable() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"supplier", "customer"});
        String asstacTtype = this.getAsstactTypeByView(this.getView());
        if ("supplier".equals(asstacTtype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"supplier"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"customer"});
        }
    }

    private String getAsstactTypeByView(IFormView view) {
        String wfType = (String)view.getFormShowParameter().getCustomParam("wfGroupNum");
        if ("CGHX001".equals(wfType)) {
            return "supplier";
        }
        return "customer";
    }

    private String[] getEntryFieldsByEntityNum(String entityNum, String type) {
        String[] filednames = null;
        String asstactName = "";
        asstactName = "ap_finapbill".equals(entityNum) || "ar_revcfmbill".equals(entityNum) ? "asstact" : ("im_saloutbill".equals(entityNum) ? "settlecustomer" : "invoicesupplier");
        if ("A".equals(type)) {
            asstactName = asstactName + "_a";
            filednames = "ap_finapbill".equals(entityNum) ? new String[]{"billno_a", "bookdate_a", "currency_a_x", "exchangerate_a", "basecurrency_a", "material_a", "materialname_a", "model_a", "e_assistantattr_a", "measureunit_a", "e_baseunit_a", "quantity_a", "e_baseunitqty_a", "price_a_x", "unverifyquantity_a", "e_unverifybaseqty_a", "e_unverifyamount_a", "e_unverifyamount_cur_a", "unverifyquantity_cur_a", "e_unverifybaseqty_cur_a", asstactName} : ("ar_revcfmbill".equals(entityNum) ? new String[]{"billno_a", "bookdate_a", "currency_a_x", "exchangerate_a", "basecurrency_a", "e_material_a", "e_materialname_a", "e_model_a", "e_assistantattr_a", "e_measureunit_a", "arbaseunit_a", "e_quantity_a", "e_baseunitqty_a", "e_unitprice_a", "e_unverifyqty_a", "e_unverifybaseqty_a", "e_unverifyamt_a", "e_unverifyamt_cur_a", "e_unverifyqty_cur_a", "e_unverifybaseqty_cur_a", asstactName} : new String[]{"billno_a", "bookdate_a", "settlecurrency_a", "exchangerate_a", "currency_a", "material_a", "materialname_a", "model_a", "auxpty_a", "configuredcode_a", "lotnumber_a", "tracknumber_a", "unit_a", "baseunit_a", "qty_a", "baseqty_a", "price_a", "unverifyqty_a", "unverifybaseqty_a", "unverifyqty_cur_a", "unverifybaseqty_cur_a", asstactName});
        } else if ("B".equals(type)) {
            asstactName = asstactName + "_b";
            filednames = "ap_finapbill".equals(entityNum) ? new String[]{"billno_b", "bookdate_b", "currency_b_x", "exchangerate_b", "basecurrency_b", "material_b", "materialname_b", "model_b", "e_assistantattr_b_x", "measureunit_b", "e_baseunit_b", "quantity_b", "e_baseunitqty_b", "price_b_x", "unverifyquantity_b", "e_unverifybaseqty_b", "e_unverifyamount_b", "e_unverifyamount_cur_b", "unverifyquantity_cur_b", "e_unverifybaseqty_cur_b", asstactName} : ("ar_revcfmbill".equals(entityNum) ? new String[]{"billno_b", "bookdate_b", "currency_b_x", "exchangerate_b", "basecurrency_b", "e_material_b", "e_materialname_b", "e_model_b", "e_assistantattr_b", "e_measureunit_b", "arbaseunit_b", "e_quantity_b", "e_baseunitqty_b", "e_unitprice_b", "e_unverifyqty_b", "e_unverifybaseqty_b", "e_unverifyamt_b", "e_unverifyamt_cur_b", "e_unverifyqty_cur_b", "e_unverifybaseqty_cur_b", asstactName} : new String[]{"billno_b", "bookdate_b", "settlecurrency_b", "exchangerate_b", "currency_b", "material_b", "materialname_b", "model_b", "auxpty_b", "configuredcode_b", "lotnumber_b", "tracknumber_b", "unit_b", "baseunit_b", "qty_b", "baseqty_b", "price_b", "unverifyqty_b", "unverifybaseqty_b", "unverifyqty_cur_b", "unverifybaseqty_cur_b", asstactName});
        }
        return filednames;
    }

    private void dealEntryData(String entryName) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryName);
        int rowIndex = 0;
        String arapMatName = this.getArApMatName(entryName);
        Map<String, String> arApWFQtyMap = this.getArApWFQtyMap();
        for (DynamicObject entry : entryEntity) {
            DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
            for (IDataEntityProperty field : properties) {
                Set<String> baseQtyFieldSet;
                String fieldName = field.getName();
                if (arApWFQtyMap.containsKey(fieldName)) {
                    this.getModel().setValue(arApWFQtyMap.get(fieldName), (Object)entry.getBigDecimal(fieldName), rowIndex);
                }
                if ((baseQtyFieldSet = this.getBaseQtyFields()).contains(fieldName)) {
                    Integer precision = entry.getInt(arapMatName + ".baseunit.precision");
                    this.getModel().setValue(fieldName, (Object)entry.getBigDecimal(fieldName).setScale((int)precision, 4), rowIndex);
                }
                if (!fieldName.endsWith("_x")) continue;
                String sameFieldName = fieldName.substring(0, fieldName.lastIndexOf("_x"));
                Object fieldValue = entry.get(fieldName);
                Object sameFieldValue = entry.get(sameFieldName);
                if (field instanceof BasedataProp) {
                    if (fieldValue != null) {
                        this.getModel().setValue(sameFieldName, (Object)((DynamicObject)fieldValue).getLong("id"), rowIndex);
                        continue;
                    }
                    if (sameFieldValue == null) continue;
                    this.getModel().setValue(fieldName, (Object)((DynamicObject)sameFieldValue).getLong("id"), rowIndex);
                    continue;
                }
                if (!(field instanceof DecimalProp)) continue;
                if (((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) != 0) {
                    this.getModel().setValue(sameFieldName, fieldValue, rowIndex);
                    continue;
                }
                if (((BigDecimal)sameFieldValue).compareTo(BigDecimal.ZERO) == 0) continue;
                this.getModel().setValue(fieldName, sameFieldValue, rowIndex);
            }
            ++rowIndex;
        }
    }

    public void dealFieldsValueByBiz(TableValueSetter tableValueSetter, String entryKey) {
        String matName = "";
        matName = "entry_a".equals(entryKey) ? "material_a" : "material_b";
        int count = tableValueSetter.getCount();
        HashSet<Long> masterIdSet = new HashSet<Long>(16);
        for (int i = 0; i < count; ++i) {
            Long matId = (Long)tableValueSetter.get(matName, i);
            masterIdSet.add(matId);
        }
        if (masterIdSet.isEmpty()) {
            return;
        }
        HashMap<Long, Long> matInfoAndMasterIdMap = new HashMap<Long, Long>(16);
        DynamicObjectCollection matInfo = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"id,masterid", (QFilter[])new QFilter("id", "in", masterIdSet).toArray());
        for (DynamicObject mat : matInfo) {
            matInfoAndMasterIdMap.put(mat.getLong("id"), mat.getLong("masterid"));
        }
        if (matInfoAndMasterIdMap.isEmpty()) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Long matId = (Long)tableValueSetter.get(matName, i);
            Long masterId = (Long)matInfoAndMasterIdMap.get(matId);
            if (masterId == null) continue;
            tableValueSetter.set(matName, (Object)masterId, i);
        }
    }

    private void checkAsstactAndCur() {
        Map<String, Set<Long>> mainAsstactAndCurMap = this.getAsstactAndCurByType("A");
        Map<String, Set<Long>> assistAsstactAndCurMap = this.getAsstactAndCurByType("B");
        boolean isDiffAsstact = this.getIsDiffValue(mainAsstactAndCurMap, assistAsstactAndCurMap, "asstact");
        boolean isDiffCurrency = this.getIsDiffValue(mainAsstactAndCurMap, assistAsstactAndCurMap, "currency");
        if (isDiffAsstact || isDiffCurrency) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u4e0e\u6838\u9500\u7684\u4e3b\u8f85\u65b9\u5355\u636e\u5f80\u6765\u6237\u4e0d\u540c/\u53c2\u4e0e\u6838\u9500\u7684\u4e3b\u8f85\u65b9\u5355\u636e\u5e01\u79cd\u4e0d\u540c\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u6838\u9500\u3002", (String)"CalWfManualPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkSelectRows() {
        EntryGrid entryGridA = (EntryGrid)this.getControl("entry_a");
        EntryGrid entryGridB = (EntryGrid)this.getControl("entry_b");
        if (entryGridA.getSelectRows().length <= 0 || entryGridB.getSelectRows().length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u5404\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"CalWfManualPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean getIsDiffValue(Map<String, Set<Long>> mainAsstactAndCurMap, Map<String, Set<Long>> assistAsstactAndCurMap, String fieldName) {
        boolean isDiffValue = false;
        Set<Long> mainbillSet = mainAsstactAndCurMap.get(fieldName);
        Set<Long> assistbillSet = assistAsstactAndCurMap.get(fieldName);
        if (mainbillSet.size() != assistbillSet.size()) {
            isDiffValue = true;
        } else {
            for (Long mainBillId : mainbillSet) {
                if (assistbillSet.contains(mainBillId)) continue;
                isDiffValue = true;
            }
            for (Long assistBillId : assistbillSet) {
                if (mainbillSet.contains(assistBillId)) continue;
                isDiffValue = true;
            }
        }
        return isDiffValue;
    }

    private Map<String, Set<Long>> getAsstactAndCurByType(String type) {
        HashMap<String, Set<Long>> asstactAndCurrencyMap = new HashMap<String, Set<Long>>(16);
        IDataModel model = this.getModel();
        String entryName = null;
        String billIdFieldName = null;
        String entityNum = null;
        String asstactName = null;
        String currencyName = null;
        if ("A".equals(type)) {
            entryName = "entry_a";
            billIdFieldName = "billid_a";
            entityNum = this.getPageCache().get("mainBillEntityNum");
        } else {
            entryName = "entry_b";
            billIdFieldName = "billid_b";
            entityNum = this.getPageCache().get("assistBillEntityNum");
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        for (int index : selectedRowIndexs) {
            Long billId = (Long)model.getValue(billIdFieldName, index);
            billIdSet.add(billId);
        }
        if ("ap_finapbill".equals(entityNum) || "ar_revcfmbill".equals(entityNum)) {
            asstactName = "asstact";
            currencyName = "currency";
        } else if ("im_saloutbill".equals(entityNum)) {
            asstactName = "billentry.settlecustomer";
            currencyName = "settlecurrency";
        } else {
            asstactName = "billentry.invoicesupplier";
            currencyName = "settlecurrency";
        }
        String selectFiled = asstactName + "," + currencyName;
        DataSet scmBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNum, (String)selectFiled, (QFilter[])new QFilter("id", "in", billIdSet).toArray(), null);
        billIdSet.clear();
        for (Row bill : scmBillDataSet) {
            Long asstactId = bill.getLong(asstactName);
            Long currencyId = bill.getLong(currencyName);
            HashSet<Long> asstactIdSet = (HashSet<Long>)asstactAndCurrencyMap.get("asstact");
            HashSet<Long> currencyIdSet = (HashSet<Long>)asstactAndCurrencyMap.get("currency");
            if (asstactIdSet == null) {
                asstactIdSet = new HashSet<Long>(16);
            }
            if (currencyIdSet == null) {
                currencyIdSet = new HashSet<Long>(16);
            }
            asstactIdSet.add(asstactId);
            currencyIdSet.add(currencyId);
            asstactAndCurrencyMap.put("asstact", asstactIdSet);
            asstactAndCurrencyMap.put("currency", currencyIdSet);
        }
        Set asstactIdSet = (Set)asstactAndCurrencyMap.get("asstact");
        if (asstactIdSet != null) {
            DataSet asstactDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.getView().getPageCache().get("asstactNum"), (String)"masterid", (QFilter[])new QFilter("id", "in", (Object)asstactIdSet).toArray(), null);
            asstactIdSet.clear();
            for (Row row : asstactDataSet) {
                asstactIdSet.add(row.getLong("masterid"));
            }
            asstactAndCurrencyMap.put("asstact", asstactIdSet);
        }
        return asstactAndCurrencyMap;
    }

    private void setCalOrg() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_wfmanual");
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_wfmanual", (String)"47150e89000000ac");
        if (list != null) {
            String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
            String entityNum = "CGHX001".equals(wfType) ? "ap_init" : "ar_init";
            DynamicObjectCollection ApInitColl = QueryServiceHelper.query((String)entityNum, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE), new QFilter("org", "in", (Object)list)});
            list.clear();
            for (DynamicObject org : ApInitColl) {
                list.add(org.getLong("org"));
            }
        }
        if (list != null && !list.isEmpty()) {
            if (calOrgId != null && calOrgId != 0L) {
                if (list.contains(calOrgId)) {
                    this.getModel().setValue("org", (Object)calOrgId);
                } else {
                    this.getModel().setValue("org", list.get(0));
                }
            } else {
                this.getModel().setValue("org", list.get(0));
            }
        }
    }

    private void setDateRange() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(5, 1);
        endDate.set(5, endDate.getActualMaximum(5));
        this.getModel().setValue("startdate", (Object)sdf.format(startDate.getTime()));
        this.getModel().setValue("enddate", (Object)sdf.format(endDate.getTime()));
    }

    private void setCurrencyByOrg() {
        DynamicObjectCollection orgAndCurrencyObj;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            model.setValue("currency", null);
            return;
        }
        Long orgId = org.getLong("id");
        String entityNum = "ar_init";
        String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
        if ("CGHX001".equals(wfType)) {
            entityNum = "ap_init";
        }
        if ((orgAndCurrencyObj = QueryServiceHelper.query((String)entityNum, (String)"standardcurrency", (QFilter[])new QFilter("org", "=", (Object)orgId).toArray())).isEmpty()) {
            return;
        }
        Long currencyId = ((DynamicObject)orgAndCurrencyObj.get(0)).getLong("standardcurrency");
        model.setValue("currency", (Object)currencyId);
    }

    private void unverifybaseqtyChange(String name, PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal unverifybaseqty = (BigDecimal)e.getChangeSet()[0].getNewValue();
        BigDecimal convertrate = null;
        String unverifyqtyName = null;
        Long matId = null;
        Long unitId = null;
        Long baseUnitId = null;
        String mainBillEntityNum = this.getPageCache().get("mainBillEntityNum");
        String assistBillEntityNum = this.getPageCache().get("assistBillEntityNum");
        String matName = null;
        DynamicObject entryRow = null;
        Integer precision = null;
        switch (name) {
            case "e_unverifybaseqty_cur_a": {
                if (mainBillEntityNum.equals("ap_finapbill")) {
                    convertrate = (BigDecimal)model.getValue("e_unitconvertrate_a", rowIndex);
                    unverifyqtyName = "unverifyquantity_cur_a";
                    matName = "material_a";
                } else {
                    convertrate = (BigDecimal)model.getValue("e_unitcoefficient_a", rowIndex);
                    unverifyqtyName = "e_unverifyqty_cur_a";
                    matName = "e_material_a";
                }
                entryRow = (DynamicObject)this.getModel().getEntryEntity("entry_a").get(rowIndex);
                precision = entryRow.getInt(matName + ".baseunit.precision");
                if (precision == null) break;
                model.beginInit();
                model.setValue(name, (Object)entryRow.getBigDecimal(name).setScale((int)precision, 4), rowIndex);
                model.endInit();
                this.getView().updateView(name, rowIndex);
                break;
            }
            case "e_unverifybaseqty_cur_b": {
                if (assistBillEntityNum.equals("ap_finapbill")) {
                    convertrate = (BigDecimal)model.getValue("e_unitconvertrate_b", rowIndex);
                    unverifyqtyName = "unverifyquantity_cur_b";
                    matName = "material_b";
                } else {
                    convertrate = (BigDecimal)model.getValue("e_unitcoefficient_b", rowIndex);
                    unverifyqtyName = "e_unverifyqty_cur_b";
                    matName = "e_material_b";
                }
                entryRow = (DynamicObject)this.getModel().getEntryEntity("entry_b").get(rowIndex);
                precision = entryRow.getInt(matName + ".baseunit.precision");
                if (precision == null) break;
                model.beginInit();
                model.setValue(name, (Object)entryRow.getBigDecimal(name).setScale((int)precision, 4), rowIndex);
                model.endInit();
                this.getView().updateView(name, rowIndex);
                break;
            }
            case "unverifybaseqty_cur_a": {
                matId = ((DynamicObject)model.getValue("material_a", rowIndex)).getLong("id");
                unitId = ((DynamicObject)model.getValue("unit_a", rowIndex)).getLong("id");
                baseUnitId = ((DynamicObject)model.getValue("material_a", rowIndex)).getDynamicObject("baseunit").getLong("id");
                convertrate = BillUnitAndQtytHelper.getUnitRateConv((Long)matId, (Long)unitId, (Long)baseUnitId);
                unverifyqtyName = "unverifyqty_cur_a";
                break;
            }
            case "unverifybaseqty_cur_b": {
                matId = ((DynamicObject)model.getValue("material_b", rowIndex)).getLong("id");
                unitId = ((DynamicObject)model.getValue("unit_b", rowIndex)).getLong("id");
                baseUnitId = ((DynamicObject)model.getValue("material_b", rowIndex)).getDynamicObject("baseunit").getLong("id");
                convertrate = BillUnitAndQtytHelper.getUnitRateConv((Long)matId, (Long)unitId, (Long)baseUnitId);
                unverifyqtyName = "unverifyqty_cur_b";
                break;
            }
        }
        model.setValue(unverifyqtyName, (Object)unverifybaseqty.divide(convertrate, 10, 4), rowIndex);
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        IFormView view = (IFormView)pageDataMap.get("view");
        DynamicObject org = (DynamicObject)model.getValue("org");
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject material = (DynamicObject)model.getValue("material");
        DynamicObject asstact = null;
        if ("supplier".equals(this.getAsstactTypeByView(view))) {
            asstact = (DynamicObject)model.getValue("supplier");
            view.getPageCache().put("asstactNum", "bd_supplier");
        } else {
            asstact = (DynamicObject)model.getValue("customer");
            view.getPageCache().put("asstactNum", "bd_customer");
        }
        String orgName = "";
        String currencyName = "";
        String asstactName = "";
        String materialName = "";
        if ("ap_finapbill".equals(entityNumber) || "ar_revcfmbill".equals(entityNumber)) {
            orgName = "org";
            currencyName = "currency";
            materialName = "entry.e_material";
            asstactName = "asstact";
            if ("ap_finapbill".equals(entityNumber)) {
                materialName = "detailentry.material";
            }
        } else {
            orgName = "billentry.entrysettleorg";
            currencyName = "settlecurrency";
            materialName = "billentry.material.masterid";
            asstactName = "im_saloutbill".equals(entityNumber) ? "billentry.settlecustomer" : "billentry.invoicesupplier";
        }
        QFilter billQ = new QFilter(orgName, "=", (Object)org.getLong("id"));
        billQ.and("billstatus", "=", (Object)"C");
        billQ.and("bookdate", ">=", (Object)startDate);
        billQ.and("bookdate", "<", (Object)DateUtils.getDayEndTime((Date)endDate));
        billQ.and(currencyName, "=", (Object)currency.getLong("id"));
        if (asstact != null) {
            billQ.and(asstactName, "in", (Object)asstact.getLong("id"));
        }
        if (material != null) {
            billQ.and(materialName, "=", (Object)material.getLong("id"));
        }
        billFilters.add(billQ);
    }

    private Set<String> getBaseQtyFields() {
        HashSet<String> baseQtyFieldSet = new HashSet<String>(16);
        baseQtyFieldSet.add("e_baseunitqty_a");
        baseQtyFieldSet.add("e_unverifybaseqty_a");
        baseQtyFieldSet.add("e_unverifybaseqty_cur_a");
        baseQtyFieldSet.add("e_baseunitqty_b");
        baseQtyFieldSet.add("e_unverifybaseqty_b");
        baseQtyFieldSet.add("e_unverifybaseqty_cur_b");
        return baseQtyFieldSet;
    }

    private String getArApMatName(String entryName) {
        String mainBillEntityNum = this.getPageCache().get("mainBillEntityNum");
        String assistBillEntityNum = this.getPageCache().get("assistBillEntityNum");
        String arapMatName = null;
        arapMatName = "entry_a".equals(entryName) ? (mainBillEntityNum.equals("ap_finapbill") ? "material_a" : "e_material_a") : (assistBillEntityNum.equals("ap_finapbill") ? "material_b" : "e_material_b");
        return arapMatName;
    }

    private Map<String, String> getArApWFQtyMap() {
        HashMap<String, String> arApWFQtyMap = new HashMap<String, String>(16);
        arApWFQtyMap.put("unverifyquantity_a", "unverifyquantity_cur_a");
        arApWFQtyMap.put("e_unverifyamount_a", "e_unverifyamount_cur_a");
        arApWFQtyMap.put("e_unverifyqty_a", "e_unverifyqty_cur_a");
        arApWFQtyMap.put("e_unverifyamt_a", "e_unverifyamt_cur_a");
        arApWFQtyMap.put("unverifyquantity_b", "unverifyquantity_cur_b");
        arApWFQtyMap.put("e_unverifyamount_b", "e_unverifyamount_cur_b");
        arApWFQtyMap.put("e_unverifyqty_b", "e_unverifyqty_cur_b");
        arApWFQtyMap.put("e_unverifyamt_b", "e_unverifyamt_cur_b");
        return arApWFQtyMap;
    }
}

