/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.writeoff;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;

public class OsWfManualPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCalOrg();
        this.setDateRange();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName;
        switch (proName = e.getProperty().getName()) {
            case "org": {
                this.beforeF7Org(e);
                break;
            }
        }
    }

    private void beforeF7Org(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_oswfmanual", (String)"47150e89000000ac");
        if (list != null) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", (Object)list));
        }
    }

    private void setCalOrg() {
        Long userOrgId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)(userOrgId = Long.valueOf(RequestContext.get().getOrgId())), (String)"cal_oswfmanual");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("org", (Object)calOrgId);
        }
    }

    private void setDateRange() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(5, 1);
        endDate.set(5, endDate.getActualMaximum(5));
        this.getModel().setValue("startdate", (Object)sdf.format(startDate.getTime()));
        this.getModel().setValue("enddate", (Object)sdf.format(endDate.getTime()));
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        DynamicObject org = (DynamicObject)model.getValue("org");
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        QFilter billQ = new QFilter("org", "=", (Object)org.getLong("id"));
        billQ.and("billstatus", "=", (Object)"C");
        billQ.and("bookdate", ">=", (Object)startDate);
        billQ.and("bookdate", "<", (Object)DateUtils.getDayEndTime((Date)endDate));
        if (supplier != null) {
            billQ.and("supplier", "=", (Object)supplier.getLong("id"));
        }
        billFilters.add(billQ);
    }
}

