/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.writeoff;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;

public class PurOmWfManualPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "org");
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCalOrg();
        this.setDateRange();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName;
        switch (proName = e.getProperty().getName()) {
            case "org": {
                this.beforeF7Org(e);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("btnmanualwf".equals(key)) {
            String billEntityNum = ((DynamicObject)((DynamicObject)this.getModel().getValue("writeofftype")).getDynamicObjectCollection("writeoffbillentry").get(0)).getDynamicObject("writeoffbilltype").getString("number");
            if ("im_osmaterialreqoutbill".equals(billEntityNum)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5355\u5411\u6838\u9500\u59d4\u5916\u91c7\u8d2d\u9886\u6599\u5355\u3002", (String)"PurOmWfManualPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            int[] selectRows = ((EntryGrid)this.getView().getControl("entry_a")).getSelectRows();
            if (selectRows.length <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5355\u5411\u6838\u9500\u7684\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355\u3002", (String)"PurOmWfManualPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            this.getModel().beginInit();
            this.getModel().setValue("single", (Object)Boolean.TRUE);
            this.getModel().endInit();
        } else if ("btnautowf".equals(key)) {
            this.getModel().beginInit();
            this.getModel().setValue("single", (Object)Boolean.FALSE);
            this.getModel().endInit();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if ("wfmanual".equals(key)) {
            this.getModel().beginInit();
            this.getModel().setValue("single", (Object)Boolean.FALSE);
            this.getModel().endInit();
        }
    }

    private void beforeF7Org(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_puromwfmanual", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void setCalOrg() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_wfmanual");
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_wfmanual", (String)"47150e89000000ac");
        if (list != null && !list.isEmpty()) {
            if (calOrgId != null && calOrgId != 0L) {
                if (list.contains(calOrgId)) {
                    this.getModel().setValue("org", (Object)calOrgId);
                } else {
                    this.getModel().setValue("org", list.get(0));
                }
            } else {
                this.getModel().setValue("org", list.get(0));
            }
        }
    }

    private void setDateRange() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(5, 1);
        endDate.set(5, endDate.getActualMaximum(5));
        this.getModel().setValue("startdate", (Object)sdf.format(startDate.getTime()));
        this.getModel().setValue("enddate", (Object)sdf.format(endDate.getTime()));
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        DynamicObject org = (DynamicObject)model.getValue("org");
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        String orgName = "";
        orgName = "im_ospurinbill".equals(entityNumber) ? "billentry.entrysettleorg" : "settleorg";
        QFilter billQ = new QFilter(orgName, "=", (Object)org.getLong("id"));
        billQ.and("billstatus", "=", (Object)"C");
        billQ.and("bookdate", ">=", (Object)startDate);
        billQ.and("bookdate", "<", (Object)DateUtils.getDayEndTime((Date)endDate));
        billQ.and("supplier", "=", (Object)supplier.getLong("id"));
        billFilters.add(billQ);
    }
}

