/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.upgradeservice.CostPriceSourceSpecificationUpgradeService;

public abstract class BaseCalCostrecordUpgradeServiceImpl
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(BaseCalCostrecordUpgradeServiceImpl.class);
    public static int BATCH_EXEC_NUMS = 1000000;
    private static int BATCH_INTERVAL = 3;
    private static int THREAD_NUMS = 1;
    private static int MAX_ERROR_TIMES = 3;
    protected UpgradeResult result;
    protected DBRoute route;
    protected String servicename;

    public BaseCalCostrecordUpgradeServiceImpl() {
        BATCH_EXEC_NUMS = this.getCalBatchExecNums();
        THREAD_NUMS = this.getCalThreadNums();
    }

    protected Map<Integer, Object[]> getExecSqlParams(String splitTablename, String idcol) {
        if (DB.isSharded((String)splitTablename)) {
            return Collections.singletonMap(1, new Object[]{Long.MIN_VALUE, Long.MAX_VALUE});
        }
        String countSql = "select count(1) as count,min(" + idcol + ") as minid,max(" + idcol + ") as maxid from " + splitTablename;
        long count = 0L;
        long minid = 0L;
        long maxid = 0L;
        try (DataSet countSet = DB.queryDataSet((String)BaseCalCostrecordUpgradeServiceImpl.class.getName(), (DBRoute)this.route, (String)countSql);){
            for (Row row : countSet) {
                count = row.getLong("count");
                if (count <= 0L) continue;
                minid = row.getLong("minid");
                maxid = row.getLong("maxid");
                break;
            }
        }
        if (count <= 0L) {
            return Collections.emptyMap();
        }
        if (count <= (long)BATCH_EXEC_NUMS) {
            return Collections.singletonMap(1, new Object[]{minid, maxid + 1L});
        }
        int batchs = new BigDecimal(count).divide(new BigDecimal(BATCH_EXEC_NUMS), RoundingMode.CEILING).intValue();
        HashMap<Integer, Object[]> params = new HashMap<Integer, Object[]>(batchs);
        HashMap<Integer, Object[]> paramsReorder = new HashMap<Integer, Object[]>(batchs);
        long idFrom = minid;
        long idTo = 0L;
        String nextIdSql = "select top 1," + BATCH_EXEC_NUMS + " " + idcol + " as id from " + splitTablename + " where " + idcol + " >= ?" + " order by " + idcol;
        for (int i = 1; i <= batchs; ++i) {
            Object[] param2 = new Object[2];
            if (i == batchs) {
                idTo = maxid + 1L;
            } else {
                try (DataSet nextIdtoSet = DB.queryDataSet((String)BaseCalCostrecordUpgradeServiceImpl.class.getName(), (DBRoute)this.route, (String)nextIdSql, (Object[])new Object[]{idFrom});){
                    if (nextIdtoSet.hasNext()) {
                        Row row = nextIdtoSet.next();
                        idTo = row.getLong("id");
                    }
                }
            }
            param2[0] = idFrom;
            param2[1] = idTo;
            params.put(i, param2);
            idFrom = idTo;
        }
        StringBuilder paramBuilder = new StringBuilder(this.servicename).append(':');
        params.values().forEach(param -> paramBuilder.append(Arrays.toString(param)));
        logger.info(paramBuilder.toString());
        int index = 1;
        for (int i = 1; i <= BATCH_INTERVAL; ++i) {
            for (int j = i; j <= batchs; j += BATCH_INTERVAL) {
                Object[] param3 = (Object[])params.get(j);
                paramsReorder.put(index, param3);
                ++index;
            }
        }
        return paramsReorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSplitSql(String splitUpdateSql, Map<Integer, Object[]> params) {
        int size = params.size();
        logger.info("BaseCalCostrecordUpgradeServiceImpl executeSplitSql batchSize=" + size);
        try (ThreadPool pool = null;){
            String tenantId = "Default";
            RequestContextInfo rci = RequestContextInfo.get();
            if (rci != null) {
                tenantId = rci.getTenantId();
            }
            String poolname = tenantId + '.' + this.servicename;
            Date date = new Date();
            poolname = poolname + String.valueOf(date.getTime());
            pool = ThreadPools.newCachedThreadPool((String)poolname, (int)THREAD_NUMS, (int)(THREAD_NUMS * 2));
            HashSet<Integer> execIndexes = new HashSet<Integer>(THREAD_NUMS);
            int errtimes = 0;
            while (!params.isEmpty()) {
                if (errtimes >= MAX_ERROR_TIMES) {
                    StringBuilder errlogBuilder = new StringBuilder(this.servicename).append(" error:");
                    params.values().forEach(param -> errlogBuilder.append(Arrays.toString(param)));
                    errlogBuilder.append(splitUpdateSql);
                    String errlog = errlogBuilder.toString();
                    this.result.setLog(errlog);
                    this.result.setErrorInfo(errlog);
                    WriteLogHelper.writeErrorLog((Log)logger, (String)(poolname + " BaseCalCostrecordUpgradeServiceImpl executeSplitSql " + errlog), (Object[])new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                execIndexes.clear();
                int firstIndex = 0;
                for (int i = 1; i <= 2; ++i) {
                    for (int j = 1; j <= size && (i != 2 || j < firstIndex); ++j) {
                        if (params.containsKey(j)) {
                            if (firstIndex == 0) {
                                firstIndex = j;
                            }
                            execIndexes.add(j);
                        }
                        if (execIndexes.size() != THREAD_NUMS) continue;
                        this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                        execIndexes.clear();
                        firstIndex = 0;
                    }
                }
                if (execIndexes.size() > 0) {
                    this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                }
                ++errtimes;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void concurrentHandleSql(ThreadPool pool, final String sql, Map<Integer, Object[]> params, Set<Integer> execIndexes) {
        HashMap<Integer, Future> execFutureMap = new HashMap<Integer, Future>(THREAD_NUMS);
        final CountDownLatch latch = new CountDownLatch(execIndexes.size());
        Iterator<Object> iterator = execIndexes.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            final Object[] param = params.get(n);
            Future future = pool.submit((Callable)new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    try (TXHandle tx = TX.requiresNew();){
                        StringBuilder execBuilder = new StringBuilder(BaseCalCostrecordUpgradeServiceImpl.this.servicename).append(" exec:").append(Arrays.toString(param)).append(sql);
                        logger.info(execBuilder.toString());
                        DB.execute((DBRoute)BaseCalCostrecordUpgradeServiceImpl.this.route, (String)sql, (Object[])param);
                    }
                    finally {
                        latch.countDown();
                    }
                    return true;
                }
            });
            execFutureMap.put(n, future);
        }
        for (Map.Entry entry : execFutureMap.entrySet()) {
            int index = (Integer)entry.getKey();
            try {
                if (!((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                params.remove(index);
            }
            catch (InterruptedException | ExecutionException e) {
                WriteLogHelper.writeInfoLog((Log)logger, (String)e.toString(), (Object[])new Object[0]);
                for (StackTraceElement trace : e.getStackTrace()) {
                    WriteLogHelper.writeInfoLog((Log)logger, (String)trace.toString(), (Object[])new Object[0]);
                }
            }
        }
    }

    private int getCalBatchExecNums() {
        this.route = new DBRoute("cal");
        int defaultBatchExecSize = BATCH_EXEC_NUMS;
        String BAL_UPDATE_BATCH_SIZE = "select top 1 fvalue from t_cal_dbparam where fkey = 'balupdate_cal_batchsize'";
        try (DataSet batchSizeDataSet = DB.queryDataSet((String)CostPriceSourceSpecificationUpgradeService.class.getName(), (DBRoute)this.route, (String)BAL_UPDATE_BATCH_SIZE);){
            for (Row batchSize : batchSizeDataSet) {
                defaultBatchExecSize = batchSize.getInteger("fvalue");
            }
        }
        logger.info("getCalBatchExecNums balupdatecalbatchsize:" + defaultBatchExecSize);
        return defaultBatchExecSize;
    }

    private int getCalThreadNums() {
        this.route = new DBRoute("cal");
        int defaultThreadSize = THREAD_NUMS;
        String BAL_UPDATE_THREADNUM = "select top 1 fvalue from t_cal_dbparam where fkey = 'balupdate_cal_threadnum'";
        try (DataSet threadNumDataSet = DB.queryDataSet((String)CostPriceSourceSpecificationUpgradeService.class.getName(), (DBRoute)this.route, (String)BAL_UPDATE_THREADNUM);){
            for (Row batchSize : threadNumDataSet) {
                defaultThreadSize = batchSize.getInteger("fvalue");
            }
        }
        logger.info("getCalThreadNums balupdatecalthreadnum:" + defaultThreadSize);
        return defaultThreadSize;
    }
}

