/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.cal.upgradeservice.CalBillGroupSettingInterUpgradeService;

public class CalBillGroupDeleteObNumUpgradeService
implements IUpgradeService {
    private static final String COMMON_SQL = "SELECT fid,fbillfilterstr_tag,frbillfilterstr_tag FROM t_cal_billgroupsetting WHERE fenable = '1' and fid = 749860901644933120";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        try (DataSet dataSet = DB.queryDataSet((String)CalBillGroupSettingInterUpgradeService.class.getName(), (DBRoute)route, (String)COMMON_SQL);){
            for (Row row : dataSet) {
                String fieldName;
                Long fid = row.getLong("fid");
                String aimFilterStr = row.getString("fbillfilterstr_tag");
                String sourcefilterStr = row.getString("frbillfilterstr_tag");
                if (!aimFilterStr.endsWith("}") || !sourcefilterStr.endsWith("}")) continue;
                FilterCondition aimFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)aimFilterStr, FilterCondition.class);
                FilterCondition sourceFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)sourcefilterStr, FilterCondition.class);
                List aimFilterRow = aimFilterCondition.getFilterRow();
                List sourceFilterRow = sourceFilterCondition.getFilterRow();
                for (SimpleFilterRow aimitem : aimFilterRow) {
                    fieldName = aimitem.getFieldName();
                    if (!"bizentityobject.number".equals(fieldName)) continue;
                    this.setBizentityobjectName(sqlParams, fid, aimFilterCondition, sourceFilterCondition, aimitem, true);
                }
                for (SimpleFilterRow sourceitem : sourceFilterRow) {
                    fieldName = sourceitem.getFieldName();
                    if (!"bizentityobject.number".equals(fieldName)) continue;
                    this.setBizentityobjectName(sqlParams, fid, aimFilterCondition, sourceFilterCondition, sourceitem, false);
                }
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_billgroupsetting set fbillfilterstr_tag = ?,frbillfilterstr_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }

    private void setBizentityobjectName(List<Object[]> sqlParams, Long fid, FilterCondition aimFilterCondition, FilterCondition sourceFilterCondition, SimpleFilterRow aimitem, boolean isAim) {
        ArrayList values = new ArrayList(16);
        values.addAll(aimitem.getValue());
        aimitem.getValue().clear();
        for (FilterValue value : values) {
            String valueStr = String.valueOf(value.getValue());
            if (StringUtils.isEmpty((CharSequence)valueStr)) continue;
            if (isAim) {
                if ("im_mdc_omreturnbill".equals(valueStr)) continue;
                aimitem.getValue().add(value);
                continue;
            }
            if ("im_mdc_omoutbill".equals(valueStr)) continue;
            aimitem.getValue().add(value);
        }
        String aimFilterStr = SerializationUtils.toJsonString((Object)aimFilterCondition);
        String sourcefilterStr = SerializationUtils.toJsonString((Object)sourceFilterCondition);
        sqlParams.add(new Object[]{aimFilterStr, sourcefilterStr, fid});
    }
}

