/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.cal.upgradeservice.CalRuleUpgradeHelper;

public class CalBillGroupSettingAddInspectBillService
implements IUpgradeService {
    private DBRoute route = new DBRoute("cal");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        CalRuleUpgradeHelper ruleHelper = new CalRuleUpgradeHelper();
        ArrayList<String> numbers = new ArrayList<String>(16);
        numbers.add("CZ-YS-001");
        Map<String, DynamicObject> numBillRuleDycMap = ruleHelper.getNumGroupSettingDycMap(numbers);
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        this.updateYs001GroupSetting(numBillRuleDycMap, sqlParams);
        return result;
    }

    private void updateYs001GroupSetting(Map<String, DynamicObject> numBillRuleDycMap, List<Object[]> sqlParams) {
        CalRuleUpgradeHelper ruleHelper = new CalRuleUpgradeHelper();
        DynamicObject ys001GroupDyc = numBillRuleDycMap.get("CZ-YS-001");
        if (ys001GroupDyc == null) {
            return;
        }
        Object fid = ys001GroupDyc.get("fid");
        String filterStr = ys001GroupDyc.getString("fbillfilterstr_tag");
        String rfilterStr = ys001GroupDyc.getString("frbillfilterstr_tag");
        if (!filterStr.endsWith("}") || !rfilterStr.endsWith("}")) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        FilterCondition rfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rfilterStr, FilterCondition.class);
        FilterValue newValue = new FilterValue();
        newValue.setValue((Object)"im_invinspectbill");
        SimpleFilterRow tgtBizObjRow = ruleHelper.getSimpleFilterRow(filterCondition, "bizentityobject.number");
        SimpleFilterRow srcBizObjRow = ruleHelper.getSimpleFilterRow(rfilterCondition, "bizentityobject.number");
        if (srcBizObjRow != null && !ruleHelper.isContainValue(srcBizObjRow.getValue(), "im_invinspectbill")) {
            srcBizObjRow.getValue().add(0, newValue);
            srcBizObjRow.getBaseDataIds().add(0, newValue);
        }
        if (tgtBizObjRow != null && !ruleHelper.isContainValue(tgtBizObjRow.getValue(), "im_invinspectbill")) {
            tgtBizObjRow.getValue().add(0, newValue);
            tgtBizObjRow.getBaseDataIds().add(0, newValue);
        }
        filterStr = SerializationUtils.toJsonString((Object)filterCondition);
        rfilterStr = SerializationUtils.toJsonString((Object)rfilterCondition);
        sqlParams.add(new Object[]{filterStr, rfilterStr, fid});
        DB.executeBatch((DBRoute)this.route, (String)"update t_cal_billgroupsetting set fbillfilterstr_tag = ?,frbillfilterstr_tag = ? where fid = ?", sqlParams);
    }
}

