/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class CalBillGroupSettingChargeOffUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        String sql = "SELECT fid,fnumber,fbillfilterstr_tag,frbillfilterstr_tag FROM t_cal_billgroupsetting  WHERE fnumber in ('CZ-YS-015')";
        try (DataSet dataSet = DB.queryDataSet((String)CalBillGroupSettingChargeOffUpgradeService.class.getName(), (DBRoute)route, (String)sql);){
            for (Row row : dataSet) {
                boolean isContainsTransOutBill;
                Long fid = row.getLong("fid");
                String number = row.getString("fnumber");
                String filterStr = row.getString("fbillfilterstr_tag");
                String srcfilterStr = row.getString("frbillfilterstr_tag");
                if (!filterStr.endsWith("}") || !srcfilterStr.endsWith("}")) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                FilterCondition srcFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)srcfilterStr, FilterCondition.class);
                List filterRow = filterCondition.getFilterRow();
                if ("CZ-YS-015".equals(number)) {
                    for (SimpleFilterRow item : filterRow) {
                        if (!"bizentityobject.number".equals(item.getFieldName())) continue;
                        List baseDataIds = item.getBaseDataIds();
                        isContainsTransOutBill = false;
                        for (FilterValue baseDataId : baseDataIds) {
                            if (!"im_transoutbill".equals(baseDataId.getValue())) continue;
                            isContainsTransOutBill = true;
                            break;
                        }
                        if (isContainsTransOutBill) continue;
                        this.addTransOutBill(item, baseDataIds);
                        break;
                    }
                }
                List srcfilterRow = srcFilterCondition.getFilterRow();
                if ("CZ-YS-015".equals(number)) {
                    for (SimpleFilterRow item : srcfilterRow) {
                        if (!"bizentityobject.number".equals(item.getFieldName())) continue;
                        isContainsTransOutBill = false;
                        List baseDataIds = item.getBaseDataIds();
                        for (FilterValue baseDataId : baseDataIds) {
                            if (!"im_transoutbill".equals(baseDataId.getValue())) continue;
                            isContainsTransOutBill = true;
                            break;
                        }
                        if (isContainsTransOutBill) continue;
                        this.addTransOutBill(item, baseDataIds);
                        break;
                    }
                }
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                srcfilterStr = SerializationUtils.toJsonString((Object)srcFilterCondition);
                sqlParams.add(new Object[]{filterStr, srcfilterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_billgroupsetting set fbillfilterstr_tag = ?,frbillfilterstr_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }

    private void addTransOutBill(SimpleFilterRow item, List<FilterValue> baseDataIds) {
        FilterValue filterValue = new FilterValue();
        filterValue.setValue((Object)"im_transoutbill");
        FilterValue baseDataId = new FilterValue();
        baseDataId.setValue((Object)"im_transoutbill");
        item.getValue().add(0, filterValue);
        baseDataIds.add(0, filterValue);
    }
}

