/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;

public class CalBillGroupSettingInterUpgradeService
implements IUpgradeService {
    private static final String COMMON_SQL = "SELECT fid,fbillfilterstr_tag,frbillfilterstr_tag FROM t_cal_billgroupsetting WHERE fenable = '1'";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        try (DataSet dataSet = DB.queryDataSet((String)CalBillGroupSettingInterUpgradeService.class.getName(), (DBRoute)route, (String)COMMON_SQL);){
            for (Row row : dataSet) {
                String fieldName;
                Long fid = row.getLong("fid");
                String aimFilterStr = row.getString("fbillfilterstr_tag");
                String sourcefilterStr = row.getString("frbillfilterstr_tag");
                if (!aimFilterStr.endsWith("}") || !sourcefilterStr.endsWith("}")) continue;
                FilterCondition aimFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)aimFilterStr, FilterCondition.class);
                FilterCondition sourceFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)sourcefilterStr, FilterCondition.class);
                List aimFilterRow = aimFilterCondition.getFilterRow();
                List sourceFilterRow = sourceFilterCondition.getFilterRow();
                for (SimpleFilterRow aimitem : aimFilterRow) {
                    fieldName = aimitem.getFieldName();
                    if ("bizentityobject.name".equals(fieldName)) {
                        this.setBizentityobjectName(sqlParams, fid, aimFilterCondition, sourceFilterCondition, aimitem);
                    }
                    if (!"biztype.name".equals(fieldName)) continue;
                    this.setBiztypeName(sqlParams, fid, aimFilterCondition, sourceFilterCondition, aimitem);
                }
                for (SimpleFilterRow sourceitem : sourceFilterRow) {
                    fieldName = sourceitem.getFieldName();
                    if ("bizentityobject.name".equals(fieldName)) {
                        this.setBizentityobjectName(sqlParams, fid, aimFilterCondition, sourceFilterCondition, sourceitem);
                    }
                    if (!"biztype.name".equals(fieldName)) continue;
                    this.setBiztypeName(sqlParams, fid, aimFilterCondition, sourceFilterCondition, sourceitem);
                }
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_billgroupsetting set fbillfilterstr_tag = ?,frbillfilterstr_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }

    private void setBizentityobjectName(List<Object[]> sqlParams, Long fid, FilterCondition aimFilterCondition, FilterCondition sourceFilterCondition, SimpleFilterRow aimitem) {
        aimitem.setFieldName("bizentityobject.number");
        ArrayList values = new ArrayList(16);
        values.addAll(aimitem.getValue());
        aimitem.getValue().clear();
        for (int i = 0; i < values.size(); ++i) {
            QFilter qFilter = new QFilter("name", "=", ((FilterValue)values.get(i)).getValue());
            qFilter.and("modeltype", "=", (Object)"BillFormModel");
            DynamicObjectCollection bizentityobjecttypes = QueryServiceHelper.query((String)"bos_entityobject", (String)"number", (QFilter[])qFilter.toArray());
            if (null == bizentityobjecttypes || bizentityobjecttypes.size() == 0) {
                FilterValue filterValue = new FilterValue();
                filterValue.setValue(((FilterValue)values.get(i)).getValue());
                aimitem.getValue().add(filterValue);
                continue;
            }
            for (DynamicObject bizentityobject : bizentityobjecttypes) {
                String bizentityobjectNumber = bizentityobject.getString("number");
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)bizentityobjectNumber);
                aimitem.getValue().add(filterValue);
            }
        }
        String aimFilterStr = SerializationUtils.toJsonString((Object)aimFilterCondition);
        String sourcefilterStr = SerializationUtils.toJsonString((Object)sourceFilterCondition);
        sqlParams.add(new Object[]{aimFilterStr, sourcefilterStr, fid});
    }

    private void setBiztypeName(List<Object[]> sqlParams, Long fid, FilterCondition aimFilterCondition, FilterCondition sourceFilterCondition, SimpleFilterRow sourceitem) {
        sourceitem.setFieldName("biztype.number");
        ArrayList values = new ArrayList(16);
        values.addAll(sourceitem.getValue());
        sourceitem.getValue().clear();
        for (int i = 0; i < values.size(); ++i) {
            QFilter qFilter = new QFilter("name", "=", ((FilterValue)values.get(i)).getValue());
            DynamicObjectCollection biztypes = QueryServiceHelper.query((String)"bd_biztype", (String)"number", (QFilter[])qFilter.toArray());
            if (null == biztypes || biztypes.size() == 0) {
                FilterValue filterValue = new FilterValue();
                filterValue.setValue(((FilterValue)values.get(i)).getValue());
                sourceitem.getValue().add(filterValue);
                continue;
            }
            for (DynamicObject biztype : biztypes) {
                String biztypeNumber = biztype.getString("number");
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)biztypeNumber);
                sourceitem.getValue().add(filterValue);
            }
        }
        String aimFilterStr = SerializationUtils.toJsonString((Object)aimFilterCondition);
        String sourcefilterStr = SerializationUtils.toJsonString((Object)sourceFilterCondition);
        sqlParams.add(new Object[]{aimFilterStr, sourcefilterStr, fid});
    }
}

