/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.cal.upgradeservice.CalBillGroupSettingChargeOffUpgradeService;

public class CalBillGroupSettingTargetFilterUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        String sql = "SELECT fid,fnumber,fbillfilterstr_tag FROM t_cal_billgroupsetting  WHERE fnumber in ('CZ-YS-008')";
        try (DataSet dataSet = DB.queryDataSet((String)CalBillGroupSettingChargeOffUpgradeService.class.getName(), (DBRoute)route, (String)sql);){
            for (Row row : dataSet) {
                Long fid = row.getLong("fid");
                String number = row.getString("fnumber");
                String filterStr = row.getString("fbillfilterstr_tag");
                if (!filterStr.endsWith("}")) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                List filterRow = filterCondition.getFilterRow();
                if ("CZ-YS-008".equals(number)) {
                    for (SimpleFilterRow item : filterRow) {
                        if (!"customer.internal_company.number".equals(item.getFieldName())) continue;
                        filterRow.remove(item);
                        break;
                    }
                }
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                sqlParams.add(new Object[]{filterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_billgroupsetting set fbillfilterstr_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }
}

