/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class CalBillGroupSettingVMIBackUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        String sql = "SELECT fid,fnumber,fbillfilterstr_tag,frbillfilterstr_tag FROM t_cal_billgroupsetting  WHERE fnumber in ('CZ-YS-007')";
        try (DataSet dataSet = DB.queryDataSet((String)CalBillGroupSettingVMIBackUpgradeService.class.getName(), (DBRoute)route, (String)sql);){
            for (Row row : dataSet) {
                Long fid = row.getLong("fid");
                String number = row.getString("fnumber");
                String filterStr = row.getString("fbillfilterstr_tag");
                String srcfilterStr = row.getString("frbillfilterstr_tag");
                if (!filterStr.endsWith("}") || !srcfilterStr.endsWith("}")) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                FilterCondition srcFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)srcfilterStr, FilterCondition.class);
                List filterRow = filterCondition.getFilterRow();
                if ("CZ-YS-007".equals(number)) {
                    List value;
                    for (SimpleFilterRow item : filterRow) {
                        if (!"mainbillentity".equals(item.getFieldName())) continue;
                        value = item.getValue();
                        FilterValue mainBillOutFilterValue = null;
                        for (FilterValue filterValue : value) {
                            if (!"im_materialreqoutbill".equals(filterValue.getValue())) continue;
                            mainBillOutFilterValue = filterValue;
                            break;
                        }
                        if (mainBillOutFilterValue == null) continue;
                        value.remove(mainBillOutFilterValue);
                        break;
                    }
                    for (SimpleFilterRow item : filterRow) {
                        if (!"srcbillentity".equals(item.getFieldName())) continue;
                        value = item.getValue();
                        FilterValue srcMatOutFilterValue = null;
                        for (FilterValue filterValue : value) {
                            if (!"im_materialreqoutbill".equals(filterValue.getValue())) continue;
                            srcMatOutFilterValue = filterValue;
                            break;
                        }
                        if (srcMatOutFilterValue != null) continue;
                        FilterValue filterValue = new FilterValue();
                        filterValue.setValue((Object)"im_materialreqoutbill");
                        value.add(filterValue);
                        break;
                    }
                }
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                srcfilterStr = SerializationUtils.toJsonString((Object)srcFilterCondition);
                sqlParams.add(new Object[]{filterStr, srcfilterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_billgroupsetting set fbillfilterstr_tag = ?,frbillfilterstr_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }
}

