/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class CalBillGroupSettingVMIUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        String sql = "SELECT fid,fnumber,fbillfilterstr_tag,frbillfilterstr_tag FROM t_cal_billgroupsetting  WHERE fnumber in ('CZ-YS-007', 'CZ-YS-012')";
        try (DataSet dataSet = DB.queryDataSet((String)CalBillGroupSettingVMIUpgradeService.class.getName(), (DBRoute)route, (String)sql);){
            for (Row row : dataSet) {
                Long fid = row.getLong("fid");
                String number = row.getString("fnumber");
                String filterStr = row.getString("fbillfilterstr_tag");
                String srcfilterStr = row.getString("frbillfilterstr_tag");
                if (!filterStr.endsWith("}") || !srcfilterStr.endsWith("}")) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                FilterCondition srcFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)srcfilterStr, FilterCondition.class);
                List filterRow = filterCondition.getFilterRow();
                List srcFilterRow = srcFilterCondition.getFilterRow();
                if ("CZ-YS-007".equals(number)) {
                    List value;
                    for (SimpleFilterRow item : filterRow) {
                        if (!"mainbillentity".equals(item.getFieldName())) continue;
                        value = item.getValue();
                        boolean flag = false;
                        for (FilterValue filterValue : value) {
                            if (!"im_materialreqoutbill".equals(filterValue.getValue())) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        FilterValue filterValue = new FilterValue();
                        filterValue.setValue((Object)"im_materialreqoutbill");
                        value.add(filterValue);
                        break;
                    }
                    for (SimpleFilterRow item : filterRow) {
                        if (!"srcbillentity".equals(item.getFieldName())) continue;
                        value = item.getValue();
                        FilterValue srcMatOutFilterValue = null;
                        for (FilterValue filterValue : value) {
                            if (!"im_materialreqoutbill".equals(filterValue.getValue())) continue;
                            srcMatOutFilterValue = filterValue;
                            break;
                        }
                        if (srcMatOutFilterValue == null) continue;
                        value.remove(srcMatOutFilterValue);
                        break;
                    }
                } else if ("CZ-YS-012".equals(number)) {
                    this.addDirBIll(filterRow);
                    this.addDirBIll(srcFilterRow);
                }
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                srcfilterStr = SerializationUtils.toJsonString((Object)srcFilterCondition);
                sqlParams.add(new Object[]{filterStr, srcfilterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_billgroupsetting set fbillfilterstr_tag = ?,frbillfilterstr_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }

    private void addDirBIll(List<SimpleFilterRow> filterRow) {
        String dirBillName = ResManager.loadKDString((String)"\u76f4\u63a5\u8c03\u62e8\u5355", (String)"CalBillGroupSettingVMIUpgradeService_1", (String)"fi-cal-upgradeservice", (Object[])new Object[0]);
        for (SimpleFilterRow item : filterRow) {
            if (!"bizentityobject.name".equals(item.getFieldName())) continue;
            List value = item.getValue();
            boolean flag = false;
            for (FilterValue filterValue : value) {
                if (!dirBillName.equals(filterValue.getValue().toString())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)dirBillName);
            value.add(0, filterValue);
            boolean isContainSalOutBill = false;
            for (FilterValue baseDataId : item.getBaseDataIds()) {
                if (!"im_saloutbill".equals(baseDataId.getValue())) continue;
                isContainSalOutBill = true;
                break;
            }
            if (!isContainSalOutBill) {
                FilterValue salOutBaseDataValue = new FilterValue();
                salOutBaseDataValue.setValue((Object)"im_saloutbill");
                item.getBaseDataIds().add(0, salOutBaseDataValue);
            }
            FilterValue baseDataValue = new FilterValue();
            baseDataValue.setValue((Object)"im_transdirbill");
            item.getBaseDataIds().add(0, baseDataValue);
            break;
        }
    }
}

