/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class CalBizRuleLineTypeFilterUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        HashSet<String> entitys = new HashSet<String>(16);
        entitys.add("im_purinbill");
        entitys.add("im_otherinbill");
        entitys.add("im_productinbill");
        entitys.add("im_saloutbill");
        entitys.add("im_otheroutbill");
        entitys.add("im_materialreqoutbill");
        entitys.add("im_transdirbill");
        entitys.add("im_transoutbill");
        entitys.add("im_transinbill");
        entitys.add("im_locationtransfer");
        entitys.add("im_mdc_mftproorder");
        entitys.add("im_mdc_mftfeedorder");
        entitys.add("im_mdc_mftreturnorder");
        entitys.add("im_mdc_mftmanuinbill");
        entitys.add("im_mdc_mftreturnbill");
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        try (DataSet dataSet = DB.queryDataSet((String)CalBizRuleLineTypeFilterUpgradeService.class.getName(), (DBRoute)route, (String)"select fid,fsourcebillid,ffilter_tag from t_cal_calbillrule where fenable = '1' and fcalbillid <> 'cal_initbill'");){
            for (Row row : dataSet) {
                Object fid = row.get("fid");
                String filterStr = row.getString("ffilter_tag");
                if (filterStr.contains("linetype.number") || !entitys.contains(row.getString("fsourcebillid"))) continue;
                FilterCondition filterCondition = new FilterCondition();
                if (filterStr != null && !filterStr.isEmpty()) {
                    filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                }
                SimpleFilterRow lineTypeRow = new SimpleFilterRow();
                lineTypeRow.setCompareType(CompareTypeEnum.IN.getId());
                lineTypeRow.setFieldName("linetype.number");
                lineTypeRow.setLogic("0");
                lineTypeRow.setLeftBracket("");
                lineTypeRow.setRightBracket("");
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)"010");
                lineTypeRow.getValue().add(filterValue);
                filterCondition.getFilterRow().add(lineTypeRow);
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                sqlParams.add(new Object[]{filterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_calbillrule set ffilter_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }
}

