/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class CalBizRuleVMIDirBillFilterUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        List<String> vmiSchemeNums = Arrays.asList("317", "3171");
        HashMap<String, String> vmiSchemeNumIdMap = new HashMap<String, String>(16);
        vmiSchemeNumIdMap.put("317", "1357073854719067136");
        vmiSchemeNumIdMap.put("3171", "1357075170841329664");
        HashSet<String> vmiSchemeNumSet = null;
        SimpleFilterRow filterRow = null;
        try (DataSet dataSet = DB.queryDataSet((String)CalBizRuleVMIDirBillFilterUpgradeService.class.getName(), (DBRoute)route, (String)"select fid,fsourcebillid,ffilter_tag from t_cal_calbillrule  where fenable = '1' and fsourcebillid = 'im_transdirbill'");){
            for (Row row : dataSet) {
                filterRow = null;
                vmiSchemeNumSet = new HashSet<String>(vmiSchemeNums);
                Object fid = row.get("fid");
                String filterStr = row.getString("ffilter_tag");
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                List filterRows = filterCondition.getFilterRow();
                String fieldKey = "invscheme.number";
                for (SimpleFilterRow item : filterRows) {
                    boolean isNotIn = CompareTypeEnum.NOTIN.getId().equals(item.getCompareType());
                    if (!fieldKey.equals(item.getFieldName()) || !isNotIn) continue;
                    for (FilterValue filterValue : item.getValue()) {
                        boolean iscontainVMINum = vmiSchemeNumSet.remove(filterValue.getValue());
                        if (!iscontainVMINum || item.getBaseDataIds().size() >= 2) continue;
                        FilterValue vmiBlueId = new FilterValue();
                        vmiBlueId.setValue(vmiSchemeNumIdMap.get(filterValue.getValue()));
                        item.getBaseDataIds().add(vmiBlueId);
                    }
                    filterRow = item;
                    break;
                }
                if (filterRow == null) {
                    filterRow = new SimpleFilterRow();
                    filterRow.setCompareType(CompareTypeEnum.NOTIN.getId());
                    filterRow.setFieldName(fieldKey);
                    filterRow.setLogic("0");
                    filterRow.setLeftBracket("");
                    filterRow.setRightBracket("");
                    filterCondition.getFilterRow().add(filterRow);
                }
                for (String vmdSchemeNum : vmiSchemeNumSet) {
                    FilterValue vmiBlueNum = new FilterValue();
                    vmiBlueNum.setValue((Object)vmdSchemeNum);
                    filterRow.getValue().add(vmiBlueNum);
                    FilterValue vmiBlueId = new FilterValue();
                    vmiBlueId.setValue(vmiSchemeNumIdMap.get(vmdSchemeNum));
                    filterRow.getBaseDataIds().add(vmiBlueId);
                }
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                sqlParams.add(new Object[]{filterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_calbillrule set ffilter_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }
}

