/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class CalCostAdjustBillBackupService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CalCostAdjustBillBackupService.class);
    public static final String T_CAL_COSTADJUSTBILL_BAK = "T_CAL_COSTADJUSTBILL_back";
    public static final String CREATE_T_CAL_COSTADJUSTBILL = "/*dialect*/create table T_CAL_COSTADJUSTBILL_back(FID BIGINT DEFAULT 0 NOT NULL,FCREATETYPE VARCHAR(5) DEFAULT ' ' NOT NULL,FDIFFTYPE CHAR(1) DEFAULT 'B' NOT NULL,PRIMARY KEY (`FID`))";
    public static final String CREATE_T_CAL_COSTADJUSTBILLENTRY = "/*dialect*/create table T_CAL_COSTADJUSTBILLENTRY_back(fentryid BIGINT DEFAULT 0 NOT NULL,FADJUSTAMT DECIMAL(23,10) DEFAULT 0 NOT NULL,PRIMARY KEY (`fentryid`))";
    public static final String CREATE_T_CAL_COSTADJUSTBILL_DETAIL = "/*dialect*/create table T_CAL_COSTADJUST_DETAIL_back(fdetailid BIGINT DEFAULT 0 NOT NULL,FADJUSTAMT DECIMAL(23,10) DEFAULT 0 NOT NULL,PRIMARY KEY (`fdetailid`))";
    public static final String COPY_T_CAL_COSTADJUSTBILL = "/*dialect*/insert into T_CAL_COSTADJUSTBILL_back select fid,fcreatetype,fdifftype from T_CAL_COSTADJUSTBILL";
    public static final String COPY_T_CAL_COSTADJUSTBILLENTRY = "/*dialect*/insert into T_CAL_COSTADJUSTBILLENTRY_back select fentryid,fadjustamt from T_CAL_COSTADJUSTBILLENTRY";
    public static final String COPY_T_CAL_COSTADJUSTBILL_DETAIL = "/*dialect*/insert into T_CAL_COSTADJUST_DETAIL_back select fdetailid,fadjustamt from T_CAL_COSTADJUST_DETAIL";
    public static final String COPY_T_CAL_COSTADJUSTBILL_PG = "/*dialect*/create table T_CAL_COSTADJUSTBILL_back as select fid,fcreatetype,fdifftype from T_CAL_COSTADJUSTBILL";
    public static final String COPY_T_CAL_COSTADJUSTBILLENTRY_PG = "select fentryid,fadjustamt into T_CAL_COSTADJUSTBILLENTRY_back from T_CAL_COSTADJUSTBILLENTRY";
    public static final String COPY_T_CAL_COSTADJUSTBILL_DETAIL_PG = "select fdetailid,fadjustamt into T_CAL_COSTADJUST_DETAIL_back from T_CAL_COSTADJUST_DETAIL";
    public static final String UPDATE_ENTRY_ADJUSTAMT = "UPDATE T_CAL_COSTADJUSTBILLENTRY SET fadjustamt = 0-fadjustamt WHERE FID IN (SELECT FID FROM T_CAL_COSTADJUSTBILL WHERE FBILLSRCTYPE <> 'D' AND FCREATETYPE  = 'M')";
    public static final String UPDATE_SUBENTRY_ADJUSTAMT = "UPDATE T_CAL_COSTADJUST_DETAIL SET fadjustamt = 0-fadjustamt WHERE fadjustamt <> 0 AND FENTRYID IN (SELECT FENTRYID FROM T_CAL_COSTADJUSTBILLENTRY WHERE FID IN (SELECT FID FROM T_CAL_COSTADJUSTBILL WHERE FBILLSRCTYPE <> 'D' AND FCREATETYPE  = 'M'))";
    public static final String UPDATE_CREATETYPE = "UPDATE T_CAL_COSTADJUSTBILL SET FDIFFTYPE = 'M', FCREATETYPE = 'C1' WHERE FBILLSRCTYPE <> 'D' AND FCREATETYPE  = 'M'";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        if (DB.exitsTable((DBRoute)route, (String)T_CAL_COSTADJUSTBILL_BAK)) {
            return result;
        }
        DBType dbType = DB.getDBType((DBRoute)route);
        if (dbType.equals((Object)DBType.MySQL)) {
            DB.execute((DBRoute)route, (String)CREATE_T_CAL_COSTADJUSTBILL);
            DB.execute((DBRoute)route, (String)CREATE_T_CAL_COSTADJUSTBILLENTRY);
            DB.execute((DBRoute)route, (String)CREATE_T_CAL_COSTADJUSTBILL_DETAIL);
            DB.execute((DBRoute)route, (String)COPY_T_CAL_COSTADJUSTBILL);
            DB.execute((DBRoute)route, (String)COPY_T_CAL_COSTADJUSTBILLENTRY);
            DB.execute((DBRoute)route, (String)COPY_T_CAL_COSTADJUSTBILL_DETAIL);
            DB.execute((DBRoute)route, (String)UPDATE_ENTRY_ADJUSTAMT);
            DB.execute((DBRoute)route, (String)UPDATE_SUBENTRY_ADJUSTAMT);
            DB.execute((DBRoute)route, (String)UPDATE_CREATETYPE);
        } else if (dbType.equals((Object)DBType.Oracle) || dbType.equals((Object)DBType.PostgreSQL)) {
            try (TXHandle h = TX.requiresNew();){
                DB.execute((DBRoute)route, (String)COPY_T_CAL_COSTADJUSTBILL_PG);
                DB.execute((DBRoute)route, (String)COPY_T_CAL_COSTADJUSTBILLENTRY_PG);
                DB.execute((DBRoute)route, (String)COPY_T_CAL_COSTADJUSTBILL_DETAIL_PG);
                DB.execute((DBRoute)route, (String)UPDATE_ENTRY_ADJUSTAMT);
                DB.execute((DBRoute)route, (String)UPDATE_SUBENTRY_ADJUSTAMT);
                DB.execute((DBRoute)route, (String)UPDATE_CREATETYPE);
            }
            catch (Throwable e) {
                logger.error("\u521b\u5efa\u7c7b\u578b\u5dee\u5f02\u7c7b\u578b\u5347\u7ea7\uff0c\u5907\u4efd\u6210\u672c\u8c03\u6574\u5355\u6570\u636e\u5931\u8d25", e);
                throw new KDBizException(e.getMessage());
            }
        }
        return result;
    }
}

