/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.cal.upgradeservice.CalGroupSettingFilterUpgradeService;

public class CalGroupSettingChargeOffUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        String sql = "SELECT fid,fnumber,frbillfilterstr_tag FROM t_cal_billgroupsetting  WHERE fnumber in ('CZ-YS-012')";
        try (DataSet dataSet = DB.queryDataSet((String)CalGroupSettingFilterUpgradeService.class.getName(), (DBRoute)route, (String)sql);){
            for (Row row : dataSet) {
                Object fid = row.get("fid");
                String rfilterStr = row.getString("frbillfilterstr_tag");
                if (rfilterStr.contains("ischargeoff") || !rfilterStr.endsWith("}")) continue;
                FilterCondition rfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rfilterStr, FilterCondition.class);
                SimpleFilterRow rchargeoffLine = this.getChargeoffLine();
                rfilterCondition.getFilterRow().add(rchargeoffLine);
                rfilterStr = SerializationUtils.toJsonString((Object)rfilterCondition);
                sqlParams.add(new Object[]{rfilterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_billgroupsetting set frbillfilterstr_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }

    private SimpleFilterRow getChargeoffLine() {
        SimpleFilterRow chargeoffLine = new SimpleFilterRow();
        chargeoffLine.setCompareType(CompareTypeEnum.CHECKBOXEQUAL.getId());
        chargeoffLine.setFieldName("ischargeoff");
        chargeoffLine.setLogic("0");
        chargeoffLine.setLeftBracket("");
        chargeoffLine.setRightBracket("");
        FilterValue filterValue = new FilterValue();
        filterValue.setValue((Object)"0");
        chargeoffLine.getValue().add(filterValue);
        return chargeoffLine;
    }
}

