/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class CalGroupSettingFilterUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        String sql = "SELECT fid,fbillfilterstr_tag,frbillfilterstr_tag FROM t_cal_billgroupsetting WHERE fid in (749860901644933120,1117917478471695360)";
        try (DataSet dataSet = DB.queryDataSet((String)CalGroupSettingFilterUpgradeService.class.getName(), (DBRoute)route, (String)sql);){
            for (Row row : dataSet) {
                Object fid = row.get("fid");
                String filterStr = row.getString("fbillfilterstr_tag");
                String rfilterStr = row.getString("frbillfilterstr_tag");
                if (filterStr.contains("ischargeoff") || rfilterStr.contains("ischargeoff") || !filterStr.endsWith("}") || !rfilterStr.endsWith("}")) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                FilterCondition rfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rfilterStr, FilterCondition.class);
                SimpleFilterRow chargeoffLine = this.getChargeoffLine();
                SimpleFilterRow rchargeoffLine = this.getChargeoffLine();
                filterCondition.getFilterRow().add(chargeoffLine);
                rfilterCondition.getFilterRow().add(rchargeoffLine);
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                rfilterStr = SerializationUtils.toJsonString((Object)rfilterCondition);
                sqlParams.add(new Object[]{filterStr, rfilterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_billgroupsetting set fbillfilterstr_tag = ?,frbillfilterstr_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }

    private SimpleFilterRow getChargeoffLine() {
        SimpleFilterRow chargeoffLine = new SimpleFilterRow();
        chargeoffLine.setCompareType(CompareTypeEnum.CHECKBOXEQUAL.getId());
        chargeoffLine.setFieldName("ischargeoff");
        chargeoffLine.setLogic("0");
        chargeoffLine.setLeftBracket("");
        chargeoffLine.setRightBracket("");
        FilterValue filterValue = new FilterValue();
        filterValue.setValue((Object)"0");
        chargeoffLine.getValue().add(filterValue);
        return chargeoffLine;
    }
}

