/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import kd.fi.cal.upgradeservice.CalBizRuleLineTypeFilterUpgradeService;

public class CalInventoryTransactionUpgradeService
implements IUpgradeService {
    private static final String INV_TX_CAL = "invscheme.isforwardamount";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<String> numbers = new ArrayList<String>();
        numbers.add("im_assembbill");
        numbers.add("im_disassemblebill");
        numbers.add("im_adjustbill");
        numbers.add("im_locationtransfer");
        numbers.add("im_initbill");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DBRoute route = new DBRoute("cal");
        this.addCalEngage(numbers, sqlParams, route);
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_calbillrule set ffilter_tag = ? where fid = ?", sqlParams);
        }
        sqlParams.clear();
        this.addInventoryTransaction(numbers, sqlParams, route);
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_calbillrule set ffilter_tag = ? where fid = ?", sqlParams);
        }
        sqlParams.clear();
        this.addSp(numbers, sqlParams, route);
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)"update t_cal_calbillrule set ffilter_tag = ? where fid = ?", sqlParams);
        }
        return result;
    }

    private void addCalEngage(List<String> numbers, List<Object[]> sqlParams, DBRoute route) {
        try (DataSet dataSet = DB.queryDataSet((String)CalBizRuleLineTypeFilterUpgradeService.class.getName(), (DBRoute)route, (String)"select fid,fnumber,fsourcebillid,ffilter_tag from t_cal_calbillrule where fenable = '1'");){
            for (Row row : dataSet) {
                if (numbers.contains(row.getString("fsourcebillid"))) continue;
                Long fid = row.getLong("fid");
                String filterStr = row.getString("ffilter_tag");
                if (StringUtils.isEmpty((String)filterStr)) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                this.addInvCal(sqlParams, fid, filterCondition);
            }
        }
    }

    private void addInventoryTransaction(List<String> numbers, List<Object[]> sqlParams, DBRoute route) {
        try (DataSet dataSet = DB.queryDataSet((String)CalBizRuleLineTypeFilterUpgradeService.class.getName(), (DBRoute)route, (String)"select fid,fnumber,fsourcebillid,fcalbillid,ffilter_tag from t_cal_calbillrule where fenable = '1'");){
            for (Row row : dataSet) {
                this.solveInventoryChange(row, sqlParams);
            }
        }
    }

    private void addSp(List<String> numbers, List<Object[]> sqlParams, DBRoute route) {
        try (DataSet dataSet = DB.queryDataSet((String)CalBizRuleLineTypeFilterUpgradeService.class.getName(), (DBRoute)route, (String)"select fid,fnumber,fsourcebillid,fcalbillid,ffilter_tag from t_cal_calbillrule where fenable = '1'");){
            for (Row row : dataSet) {
                this.solveSp(row, sqlParams);
            }
        }
    }

    private void addInvCal(List<Object[]> sqlParams, Long fid, FilterCondition filterCondition) {
        boolean exist = false;
        for (SimpleFilterRow simpleFilterRow : filterCondition.getFilterRow()) {
            String fieldName = simpleFilterRow.getFieldName();
            if (!INV_TX_CAL.equals(fieldName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            SimpleFilterRow lineTypeRow = new SimpleFilterRow();
            lineTypeRow.setCompareType("105");
            lineTypeRow.setFieldName(INV_TX_CAL);
            lineTypeRow.setLogic("0");
            lineTypeRow.setLeftBracket("");
            lineTypeRow.setRightBracket("");
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)Character.valueOf('1'));
            lineTypeRow.getValue().add(filterValue);
            filterCondition.getFilterRow().add(lineTypeRow);
            String filterStr = SerializationUtils.toJsonString((Object)filterCondition);
            sqlParams.add(new Object[]{filterStr, fid});
        }
    }

    private void solveInventoryChange(Row row, List<Object[]> sqlParams) {
        Long fid = row.getLong("fid");
        String filterStr = row.getString("ffilter_tag");
        String sourceBill = row.getString("fsourcebillid");
        String calBill = row.getString("fcalbillid");
        if (StringUtils.isEmpty((String)sourceBill) || StringUtils.isEmpty((String)calBill) || StringUtils.isEmpty((String)filterStr)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        List filterRow = filterCondition.getFilterRow();
        if ("cal_outcalbill".equals(calBill) && (sourceBill.contains("im_transoutbill") || sourceBill.contains("im_purinbill"))) {
            this.changeFieldName(sqlParams, fid, filterCondition, filterRow, "outkeepertype", "invscheme.outkeepertype");
        }
        if ("cal_incalbill".equals(calBill) && sourceBill.contains("im_materialreqoutbill")) {
            this.changeFieldName(sqlParams, fid, filterCondition, filterRow, "ownertype", "invscheme.ownertype");
        }
        if ("cal_incalbill".equals(calBill) && (sourceBill.contains("im_mdc_mftreturnbill") || sourceBill.contains("im_saloutbill") || sourceBill.contains("im_ospurinbill"))) {
            this.changeFieldName(sqlParams, fid, filterCondition, filterRow, "ownertype", "invscheme.ownertype");
            this.changeFieldName(sqlParams, fid, filterCondition, filterRow, "invtype.number", "invscheme.invtype.number");
        }
        if ("cal_outcalbill".equals(calBill) && (sourceBill.contains("im_mdc_omreturnbill") || sourceBill.contains("im_mdc_omreturnorder") || sourceBill.contains("im_mdc_mftreturnorder"))) {
            this.changeFieldName(sqlParams, fid, filterCondition, filterRow, "outownertype", "invscheme.outownertype");
        }
        if ("cal_outcalbill".equals(calBill) && (sourceBill.contains("im_osmaterialreqoutbill") || sourceBill.contains("im_purinbill"))) {
            this.changeFieldName(sqlParams, fid, filterCondition, filterRow, "outownertype", "invscheme.outownertype");
            this.changeFieldName(sqlParams, fid, filterCondition, filterRow, "outinvtype.number", "invscheme.outinvtype.number");
        }
    }

    private void solveSp(Row row, List<Object[]> sqlParams) {
        Long fid = row.getLong("fid");
        String fnumber = row.getString("fnumber").toUpperCase();
        String filterStr = row.getString("ffilter_tag");
        String sourceBill = row.getString("fsourcebillid");
        String calBill = row.getString("fcalbillid");
        if (StringUtils.isEmpty((String)sourceBill) || StringUtils.isEmpty((String)calBill) || StringUtils.isEmpty((String)filterStr)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        List filterRow = filterCondition.getFilterRow();
        if (fnumber.contains("RIN-CAL-002")) {
            for (int i = 0; i < filterRow.size(); ++i) {
                SimpleFilterRow lineTypeRow = (SimpleFilterRow)filterRow.get(i);
                String fieldName = lineTypeRow.getFieldName();
                if (StringUtils.isEmpty((String)fieldName) || !"invscheme.outinvtype.number".equals(fieldName) && !"outinvtype.number".equals(fieldName)) continue;
                int index = -1;
                List valueList = lineTypeRow.getValue();
                for (int j = 0; j < valueList.size(); ++j) {
                    String curValue;
                    FilterValue filterValue;
                    Object valueObject;
                    Object value = valueList.get(j);
                    if (value == null || (valueObject = (filterValue = (FilterValue)value).getValue()) == null || StringUtils.isEmpty((String)(curValue = (String)valueObject)) || !"113".equals(curValue)) continue;
                    index = j;
                    break;
                }
                if (index != -1) {
                    ArrayList newValueList = new ArrayList();
                    for (int j = 0; j < valueList.size(); ++j) {
                        if (index == j) continue;
                        newValueList.add(valueList.get(j));
                    }
                    lineTypeRow.setValue(newValueList);
                }
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                sqlParams.add(new Object[]{filterStr, fid});
            }
        }
    }

    private void changeFieldName(List<Object[]> sqlParams, Long fid, FilterCondition filterCondition, List<SimpleFilterRow> filterRow, String targetFieldName, String orignalFieldName) {
        for (int i = 0; i < filterRow.size(); ++i) {
            SimpleFilterRow lineTypeRow = filterRow.get(i);
            String fieldName = lineTypeRow.getFieldName();
            if (StringUtils.isEmpty((String)fieldName) || !orignalFieldName.equals(fieldName)) continue;
            lineTypeRow.setFieldName(targetFieldName);
            String filterStr = SerializationUtils.toJsonString((Object)filterCondition);
            sqlParams.add(new Object[]{filterStr, fid});
        }
    }
}

