/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.cal.upgradeservice.CalRuleUpgradeHelper;

public class CalTransOutUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        this.billRuleUpdate();
        this.groupSettingUpdate();
        return result;
    }

    private void groupSettingUpdate() {
        CalRuleUpgradeHelper ruleHelper = new CalRuleUpgradeHelper();
        ArrayList<String> numbers = new ArrayList<String>(16);
        numbers.add("CZ-YS-001");
        numbers.add("CZ-YS-002");
        numbers.add("CZ-YS-005");
        numbers.add("CZ-YS-012");
        HashMap<String, String> invScheNumIdMap = new HashMap<String, String>(16);
        invScheNumIdMap.put("316", "1083856826895747072");
        invScheNumIdMap.put("1221", "1563815186807141376");
        invScheNumIdMap.put("3161", "1492629060147230720");
        Map<String, DynamicObject> numBillRuleDycMap = ruleHelper.getNumGroupSettingDycMap(numbers);
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        this.updateYs001GroupSetting(numBillRuleDycMap, sqlParams);
        this.updateYs002GroupSetting(numBillRuleDycMap, sqlParams, invScheNumIdMap);
        this.updateYs005GroupSetting(numBillRuleDycMap, sqlParams, invScheNumIdMap);
        this.updateYs012GroupSetting(numBillRuleDycMap, sqlParams, invScheNumIdMap);
        ruleHelper.updateGroup(sqlParams);
    }

    private void updateYs002GroupSetting(Map<String, DynamicObject> numBillRuleDycMap, List<Object[]> sqlParams, Map<String, String> invScheNumIdMap) {
        CalRuleUpgradeHelper ruleHelper = new CalRuleUpgradeHelper();
        DynamicObject ys002GroupDyc = numBillRuleDycMap.get("CZ-YS-002");
        if (ys002GroupDyc == null) {
            return;
        }
        Object fid = ys002GroupDyc.get("fid");
        String filterStr = ys002GroupDyc.getString("fbillfilterstr_tag");
        String rfilterStr = ys002GroupDyc.getString("frbillfilterstr_tag");
        if (!filterStr.endsWith("}") || !rfilterStr.endsWith("}")) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        FilterCondition rfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rfilterStr, FilterCondition.class);
        SimpleFilterRow tgtBizObjRow = ruleHelper.getSimpleFilterRow(filterCondition, "invscheme.number");
        if (tgtBizObjRow == null) {
            tgtBizObjRow = new SimpleFilterRow();
            tgtBizObjRow.setCompareType(CompareTypeEnum.NOTIN.getId());
            tgtBizObjRow.setFieldName("invscheme.number");
            tgtBizObjRow.setLogic("0");
            tgtBizObjRow.setLeftBracket("");
            tgtBizObjRow.setRightBracket("");
            filterCondition.getFilterRow().add(tgtBizObjRow);
        }
        String numValue316 = "316";
        if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), numValue316)) {
            FilterValue newInValue = new FilterValue();
            newInValue.setValue((Object)numValue316);
            FilterValue newInValueId = new FilterValue();
            newInValueId.setValue((Object)invScheNumIdMap.get(numValue316));
            tgtBizObjRow.getValue().add(0, newInValue);
            tgtBizObjRow.getBaseDataIds().add(0, newInValueId);
        }
        String numValue3161 = "3161";
        if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), numValue3161)) {
            FilterValue newInValue = new FilterValue();
            newInValue.setValue((Object)numValue3161);
            FilterValue newInValueId = new FilterValue();
            newInValueId.setValue((Object)invScheNumIdMap.get(numValue3161));
            tgtBizObjRow.getValue().add(0, newInValue);
            tgtBizObjRow.getBaseDataIds().add(0, newInValueId);
        }
        filterStr = SerializationUtils.toJsonString((Object)filterCondition);
        rfilterStr = SerializationUtils.toJsonString((Object)rfilterCondition);
        sqlParams.add(new Object[]{filterStr, rfilterStr, fid});
    }

    private void updateYs012GroupSetting(Map<String, DynamicObject> numBillRuleDycMap, List<Object[]> sqlParams, Map<String, String> invScheNumIdMap) {
        CalRuleUpgradeHelper ruleHelper = new CalRuleUpgradeHelper();
        DynamicObject ys012GroupDyc = numBillRuleDycMap.get("CZ-YS-012");
        if (ys012GroupDyc == null) {
            return;
        }
        Object fid = ys012GroupDyc.get("fid");
        String filterStr = ys012GroupDyc.getString("fbillfilterstr_tag");
        String rfilterStr = ys012GroupDyc.getString("frbillfilterstr_tag");
        if (!filterStr.endsWith("}") || !rfilterStr.endsWith("}")) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        FilterCondition rfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rfilterStr, FilterCondition.class);
        SimpleFilterRow tgtBizObjRow = ruleHelper.getSimpleFilterRow(filterCondition, "invscheme.number");
        if (tgtBizObjRow == null) {
            tgtBizObjRow = new SimpleFilterRow();
            tgtBizObjRow.setCompareType(CompareTypeEnum.NOTIN.getId());
            tgtBizObjRow.setFieldName("invscheme.number");
            tgtBizObjRow.setLogic("0");
            tgtBizObjRow.setLeftBracket("");
            tgtBizObjRow.setRightBracket("");
            filterCondition.getFilterRow().add(tgtBizObjRow);
        }
        String numValue1221 = "1221";
        if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), numValue1221)) {
            FilterValue newInValue = new FilterValue();
            newInValue.setValue((Object)numValue1221);
            FilterValue newInValueId = new FilterValue();
            newInValueId.setValue((Object)invScheNumIdMap.get(numValue1221));
            tgtBizObjRow.getValue().add(0, newInValue);
            tgtBizObjRow.getBaseDataIds().add(0, newInValueId);
        }
        String numValue3161 = "3161";
        if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), numValue3161)) {
            FilterValue newInValue = new FilterValue();
            newInValue.setValue((Object)numValue3161);
            FilterValue newInValueId = new FilterValue();
            newInValueId.setValue((Object)invScheNumIdMap.get(numValue3161));
            tgtBizObjRow.getValue().add(0, newInValue);
            tgtBizObjRow.getBaseDataIds().add(0, newInValueId);
        }
        filterStr = SerializationUtils.toJsonString((Object)filterCondition);
        rfilterStr = SerializationUtils.toJsonString((Object)rfilterCondition);
        sqlParams.add(new Object[]{filterStr, rfilterStr, fid});
    }

    private void updateYs005GroupSetting(Map<String, DynamicObject> numBillRuleDycMap, List<Object[]> sqlParams, Map<String, String> invScheNumIdMap) {
        CalRuleUpgradeHelper ruleHelper = new CalRuleUpgradeHelper();
        DynamicObject ys005GroupDyc = numBillRuleDycMap.get("CZ-YS-005");
        if (ys005GroupDyc == null) {
            return;
        }
        Object fid = ys005GroupDyc.get("fid");
        String filterStr = ys005GroupDyc.getString("fbillfilterstr_tag");
        String rfilterStr = ys005GroupDyc.getString("frbillfilterstr_tag");
        if (!filterStr.endsWith("}") || !rfilterStr.endsWith("}")) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        FilterCondition rfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rfilterStr, FilterCondition.class);
        SimpleFilterRow tgtBizObjRow = ruleHelper.getSimpleFilterRow(filterCondition, "invscheme.number");
        if (tgtBizObjRow == null) {
            tgtBizObjRow = new SimpleFilterRow();
            tgtBizObjRow.setCompareType(CompareTypeEnum.NOTIN.getId());
            tgtBizObjRow.setFieldName("invscheme.number");
            tgtBizObjRow.setLogic("0");
            tgtBizObjRow.setLeftBracket("");
            tgtBizObjRow.setRightBracket("");
            filterCondition.getFilterRow().add(tgtBizObjRow);
        }
        String numValue316 = "316";
        if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), numValue316)) {
            FilterValue newInValue = new FilterValue();
            newInValue.setValue((Object)numValue316);
            FilterValue newInValueId = new FilterValue();
            newInValueId.setValue((Object)invScheNumIdMap.get(numValue316));
            tgtBizObjRow.getValue().add(0, newInValue);
            tgtBizObjRow.getBaseDataIds().add(0, newInValueId);
        }
        String numValue1221 = "1221";
        if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), numValue1221)) {
            FilterValue newInValue = new FilterValue();
            newInValue.setValue((Object)numValue1221);
            FilterValue newInValueId = new FilterValue();
            newInValueId.setValue((Object)invScheNumIdMap.get(numValue1221));
            tgtBizObjRow.getValue().add(0, newInValue);
            tgtBizObjRow.getBaseDataIds().add(0, newInValueId);
        }
        String numValue3161 = "3161";
        if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), numValue3161)) {
            FilterValue newInValue = new FilterValue();
            newInValue.setValue((Object)numValue3161);
            FilterValue newInValueId = new FilterValue();
            newInValueId.setValue((Object)invScheNumIdMap.get(numValue3161));
            tgtBizObjRow.getValue().add(0, newInValue);
            tgtBizObjRow.getBaseDataIds().add(0, newInValueId);
        }
        filterStr = SerializationUtils.toJsonString((Object)filterCondition);
        rfilterStr = SerializationUtils.toJsonString((Object)rfilterCondition);
        sqlParams.add(new Object[]{filterStr, rfilterStr, fid});
    }

    private void updateYs001GroupSetting(Map<String, DynamicObject> numBillRuleDycMap, List<Object[]> sqlParams) {
        CalRuleUpgradeHelper ruleHelper = new CalRuleUpgradeHelper();
        DynamicObject ys001GroupDyc = numBillRuleDycMap.get("CZ-YS-001");
        if (ys001GroupDyc == null) {
            return;
        }
        Object fid = ys001GroupDyc.get("fid");
        String filterStr = ys001GroupDyc.getString("fbillfilterstr_tag");
        String rfilterStr = ys001GroupDyc.getString("frbillfilterstr_tag");
        if (!filterStr.endsWith("}") || !rfilterStr.endsWith("}")) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        FilterCondition rfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rfilterStr, FilterCondition.class);
        FilterValue newInValue = new FilterValue();
        newInValue.setValue((Object)"im_transinbill");
        FilterValue newOutValue = new FilterValue();
        newOutValue.setValue((Object)"im_transoutbill");
        SimpleFilterRow tgtBizObjRow = ruleHelper.getSimpleFilterRow(filterCondition, "bizentityobject.number");
        SimpleFilterRow srcBizObjRow = ruleHelper.getSimpleFilterRow(rfilterCondition, "bizentityobject.number");
        if (srcBizObjRow != null) {
            if (!ruleHelper.isContainValue(srcBizObjRow.getValue(), "im_transinbill")) {
                srcBizObjRow.getValue().add(0, newInValue);
                srcBizObjRow.getBaseDataIds().add(0, newInValue);
            }
            if (!ruleHelper.isContainValue(srcBizObjRow.getValue(), "im_transoutbill")) {
                srcBizObjRow.getValue().add(0, newOutValue);
                srcBizObjRow.getBaseDataIds().add(0, newOutValue);
            }
        }
        if (tgtBizObjRow != null) {
            if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), "im_transinbill")) {
                tgtBizObjRow.getValue().add(0, newInValue);
                tgtBizObjRow.getBaseDataIds().add(0, newInValue);
            }
            if (!ruleHelper.isContainValue(tgtBizObjRow.getValue(), "im_transoutbill")) {
                tgtBizObjRow.getValue().add(0, newOutValue);
                tgtBizObjRow.getBaseDataIds().add(0, newOutValue);
            }
        }
        filterStr = SerializationUtils.toJsonString((Object)filterCondition);
        rfilterStr = SerializationUtils.toJsonString((Object)rfilterCondition);
        sqlParams.add(new Object[]{filterStr, rfilterStr, fid});
    }

    private void billRuleUpdate() {
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        CalRuleUpgradeHelper ruleHelper = new CalRuleUpgradeHelper();
        String ruleNum = "SOUT-CAL-002";
        Map<String, DynamicObject> numRuleDycMap = ruleHelper.getNumBillRuleDycMap(Collections.singletonList(ruleNum));
        DynamicObject ruleDyc = numRuleDycMap.get(ruleNum);
        if (ruleDyc != null) {
            String filterStr = ruleDyc.getString("ffilter_tag");
            Object fid = ruleDyc.get("fid");
            if (!filterStr.endsWith("}")) {
                return;
            }
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            SimpleFilterRow filterRow = ruleHelper.getSimpleFilterRow(filterCondition, "keepertype");
            if (filterRow == null) {
                SimpleFilterRow newRow = new SimpleFilterRow();
                newRow.setCompareType(CompareTypeEnum.CHECKBOXEQUAL.getId());
                newRow.setFieldName("keepertype");
                newRow.setLogic("0");
                newRow.setLeftBracket("");
                newRow.setRightBracket("");
                FilterValue newFilterValue = new FilterValue();
                newFilterValue.setValue((Object)"bd_customer");
                newRow.getValue().add(newFilterValue);
                filterCondition.getFilterRow().add(newRow);
                filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                sqlParams.add(new Object[]{filterStr, fid});
            }
        }
        if (sqlParams.size() > 0) {
            ruleHelper.updateBillRule(sqlParams);
        }
    }
}

