/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.upgradeservice.BaseCalCostrecordUpgradeServiceImpl;

public class CalWeightUpgradeServiceImpl
extends BaseCalCostrecordUpgradeServiceImpl {
    public static final String CALFIELDMAP_SELECT = "select fid, fsourcefieldname, fsourcefield from t_cal_calfieldmap where fcalfield  =  'baseqty' and fid <> 950878686008183808";
    public static final String CALFIELDMAP_EXIST_SELECT = "select fid from t_cal_calfieldmap where fcalfield  =  'weight'";
    public static final String CALFIELDMAP_SELECTGROUP = "select FID,COUNT(1) SEQ from t_cal_calfieldmap GROUP BY FID";
    private String singleUpdateSql = "UPDATE %s tccs SET FWEIGHT = FBASEQTY WHERE FWEIGHT = 0";
    private String splitUpdateSql = "UPDATE %s tccs SET FWEIGHT = FBASEQTY WHERE tccs.fentryid >= ? AND tccs.fentryid < ? AND  FWEIGHT = 0";
    private String[] tables = new String[]{"t_cal_calcostrecordentry", "t_cal_incalentry", "t_cal_outcalentry"};
    private static final String INSERT_SQL = "INSERT INTO t_cal_calfieldmap(fid, fentryid, fseq, fcalfieldname, fcalfield, fsourcefieldname, fsourcefield, fisextendfield)VALUES(?, ?, ?, ?, ?, ?, ?, ?)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle tx = TX.requiresNew();){
            this.result = new UpgradeResult();
            this.route = new DBRoute("cal");
            this.servicename = CalWeightUpgradeServiceImpl.class.getName();
            DataSet existDS = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)this.route, (String)CALFIELDMAP_EXIST_SELECT);
            if (existDS.isEmpty()) {
                DataSet groupDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)this.route, (String)CALFIELDMAP_SELECTGROUP);
                HashMap<Long, Integer> seqMap = new HashMap<Long, Integer>(16);
                for (Row row : groupDs) {
                    Long fid = row.getLong("fid");
                    Integer seq = row.getInteger("seq");
                    seqMap.put(fid, seq);
                }
                IDGenerator idGenerator = new IDGenerator("t_cal_calfieldmap");
                DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)this.route, (String)CALFIELDMAP_SELECT);
                ArrayList<Object[]> insertParams = new ArrayList<Object[]>(16);
                for (Row row : dataSet) {
                    Long fid = row.getLong("fid");
                    String fsourcefieldname = row.getString("fsourcefieldname");
                    String fsourcefield = row.getString("fsourcefield");
                    Integer seq = (Integer)seqMap.get(fid);
                    seq = seq == null ? Integer.valueOf(0) : Integer.valueOf(seq + 1);
                    String name = ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u6743\u91cd", (String)"CalWeightUpgradeServiceImpl_0", (String)"fi-cal-upgradeservice", (Object[])new Object[0]);
                    insertParams.add(new Object[]{fid, idGenerator.getId(), seq, name, "weight", fsourcefieldname, fsourcefield, "0"});
                }
                if (!insertParams.isEmpty()) {
                    DB.executeBatch((DBRoute)this.route, (String)INSERT_SQL, insertParams);
                }
            }
            this.result.setSuccess(true);
            UpgradeResult upgradeResult = this.result;
            return upgradeResult;
        }
    }

    private void excuteSingleSql(String sql) {
        DB.execute((DBRoute)this.route, (String)sql);
    }
}

