/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.upgradeservice.BaseCalCostrecordUpgradeServiceImpl;

public class CostPriceSourceSpecificationUpgradeService
extends BaseCalCostrecordUpgradeServiceImpl {
    private static String SYSTEM_CTRLENTRY_SQL = "select  fcostaccountid, fcurrentperiodid from t_cal_systemctrlentry where fisenabled='1'";
    private static String COST_RECORD_SQL = "select tcce.fentryid as entryid,tcc.fid as id,tcc.fbizentityobjectid as bizentityobject,tcc.finvschemeid as invschemeid,tcce.funitmaterialcost as unitmaterialcost,tcce.funitactualcost as unitactualcost,tcce.fispresent as ispresent,tcce.fcostpricesource as costpricesource  from  t_cal_calcostrecord tcc INNER JOIN t_cal_calcostrecordentry tcce ON tcc.fid=tcce.fid where tcce.fentryid >= ? AND tcce.fentryid < ? AND tcc.fcostaccountid = ? AND tcc.fperiodid >= ?";
    private static String UPDATE_COST_RECORDENTRY_SQL = " update t_cal_calcostrecordentry set fcostpricesource = ?,fdesignatedcost = ? where fid = ? and fentryid = ? and fentrystatus='C'";
    private static String BAL_UPDATE_BATCH_SIZE = "select top 1 fvalue from t_cal_dbparam where fkey = 'balupdate_batchsize'";
    private static String BAL_UPDATE_BATCH_FLAG = "select top 1 fvalue from t_cal_dbparam where fkey = 'balupdate_batch_flag'";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle tx = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            result.setSuccess(true);
            this.route = new DBRoute("cal");
            this.servicename = CostPriceSourceSpecificationUpgradeService.class.getName();
            boolean updatebatchflag = true;
            try (DataSet batchFlagDataSet = DB.queryDataSet((String)CostPriceSourceSpecificationUpgradeService.class.getName(), (DBRoute)this.route, (String)BAL_UPDATE_BATCH_FLAG);){
                for (Row batchflag : batchFlagDataSet) {
                    Boolean batchSizeB = batchflag.getBoolean("fvalue");
                    if (batchSizeB == null || batchSizeB.booleanValue()) continue;
                    updatebatchflag = false;
                }
            }
            if (!updatebatchflag) {
                batchFlagDataSet = result;
                return batchFlagDataSet;
            }
            int batchSizeInt = 1000;
            DataSet batchSizeDataSet = DB.queryDataSet((String)CostPriceSourceSpecificationUpgradeService.class.getName(), (DBRoute)this.route, (String)BAL_UPDATE_BATCH_SIZE);
            Object object = null;
            try {
                for (Row batchSize : batchSizeDataSet) {
                    batchSizeInt = batchSize.getInteger("fvalue");
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (batchSizeDataSet != null) {
                    if (object != null) {
                        try {
                            batchSizeDataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        batchSizeDataSet.close();
                    }
                }
            }
            Map<Integer, Object[]> params = this.getExecSqlParams("t_cal_calcostrecordentry", "fentryid");
            DataSet systemDataSet = DB.queryDataSet((String)CostPriceSourceSpecificationUpgradeService.class.getName(), (DBRoute)this.route, (String)SYSTEM_CTRLENTRY_SQL);
            Object object2 = null;
            try {
                for (Row row : systemDataSet) {
                    if (params == null || params.size() <= 0) continue;
                    Long costaccountid = row.getLong("fcostaccountid");
                    Long currentperiodid = row.getLong("fcurrentperiodid");
                    for (Map.Entry<Integer, Object[]> entry : params.entrySet()) {
                        Object[] entryids = entry.getValue();
                        Long minentryid = Long.parseLong(String.valueOf(entryids[0]));
                        Long maxentryid = Long.parseLong(String.valueOf(entryids[1]));
                        DataSet costrecorddataSet = DB.queryDataSet((String)CostPriceSourceSpecificationUpgradeService.class.getName(), (DBRoute)this.route, (String)COST_RECORD_SQL, (Object[])new Object[]{minentryid, maxentryid, costaccountid, currentperiodid});
                        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
                        for (Row cerow : costrecorddataSet) {
                            String bizentityobject = cerow.getString("bizentityobject");
                            if (StringUtils.isEmpty((String)bizentityobject)) continue;
                            BigDecimal unitmaterialcost = cerow.getBigDecimal("unitmaterialcost");
                            BigDecimal unitactualcost = cerow.getBigDecimal("unitactualcost");
                            Long entryid = cerow.getLong("entryid");
                            Long id = cerow.getLong("id");
                            String costpricesource = cerow.getString("costpricesource");
                            boolean ispresent = cerow.getBoolean("ispresent");
                            if (StringUtils.isEmpty((String)costpricesource)) {
                                if ("im_purinbill".equals(bizentityobject)) {
                                    if (unitactualcost != null && unitactualcost.compareTo(BigDecimal.ZERO) != 0 || ispresent) {
                                        sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated(), id, entryid});
                                    }
                                } else if ("im_mdc_omcmplinbill".equals(bizentityobject)) {
                                    if (unitactualcost != null && unitactualcost.compareTo(BigDecimal.ZERO) != 0) {
                                        sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.COST_PAY_ABLE_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.COST_PAY_ABLE_SPECIFICATION.getDesignated(), id, entryid});
                                    }
                                } else if ("im_mdc_ominbill".equals(bizentityobject)) {
                                    if (unitmaterialcost != null && unitmaterialcost.compareTo(BigDecimal.ZERO) != 0) {
                                        sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getDesignated(), id, entryid});
                                    } else {
                                        if (!ispresent) continue;
                                        sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated(), id, entryid});
                                    }
                                } else if ("im_ospurinbill".equals(bizentityobject)) {
                                    if (unitmaterialcost != null && unitmaterialcost.compareTo(BigDecimal.ZERO) != 0) {
                                        sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getDesignated(), id, entryid});
                                    } else {
                                        if (!ispresent) continue;
                                        sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated(), id, entryid});
                                    }
                                } else {
                                    sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getDesignated(), id, entryid});
                                }
                            }
                            if (sqlParams.size() <= batchSizeInt) continue;
                            TXHandle txb = TX.requiresNew();
                            Throwable throwable = null;
                            try {
                                DB.executeBatch((DBRoute)this.route, (String)UPDATE_COST_RECORDENTRY_SQL, sqlParams);
                                sqlParams = new ArrayList(16);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (txb == null) continue;
                                if (throwable != null) {
                                    try {
                                        txb.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                txb.close();
                            }
                        }
                        if (sqlParams.size() <= 0) continue;
                        DB.executeBatch((DBRoute)this.route, (String)UPDATE_COST_RECORDENTRY_SQL, sqlParams);
                    }
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (systemDataSet != null) {
                    if (object2 != null) {
                        try {
                            systemDataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        systemDataSet.close();
                    }
                }
            }
            object = result;
            return object;
        }
    }
}

